/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.CalendarVariant;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoExtension;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.TimeLine;

public final class CalendarFamily<T extends CalendarVariant<T>>
extends Chronology<T> {
    private final Map<String, ? extends CalendarSystem<T>> calendars;

    private CalendarFamily(Class<T> clazz, ChronoMerger<T> chronoMerger, Map<ChronoElement<?>, ElementRule<T, ?>> map, List<ChronoExtension> list, Map<String, ? extends CalendarSystem<T>> map2) {
        super(clazz, chronoMerger, map, list);
        this.calendars = map2;
    }

    @Override
    public boolean hasCalendarSystem() {
        return true;
    }

    @Override
    public CalendarSystem<T> getCalendarSystem() {
        if (this.calendars.size() == 1) {
            return this.calendars.values().iterator().next();
        }
        throw new ChronoException("Cannot determine calendar system without variant.");
    }

    @Override
    public CalendarSystem<T> getCalendarSystem(String string) {
        if (string.isEmpty()) {
            return this.getCalendarSystem();
        }
        CalendarSystem<T> calendarSystem = this.calendars.get(string);
        if (calendarSystem == null) {
            return super.getCalendarSystem(string);
        }
        return calendarSystem;
    }

    public TimeLine<T> getTimeLine(String string) {
        return new CalendarTimeLine(this, string);
    }

    @Override
    public boolean isSupported(ChronoElement<?> chronoElement) {
        return super.isSupported(chronoElement) || chronoElement instanceof EpochDays;
    }

    private static class CalendarTimeLine<D extends CalendarVariant<D>>
    implements TimeLine<D>,
    Serializable {
        private final transient CalendarSystem<D> calsys;
        private final Class<D> chronoType;
        private final String variant;

        private CalendarTimeLine(Chronology<D> chronology, String string) {
            this.calsys = chronology.getCalendarSystem(string);
            this.chronoType = chronology.getChronoType();
            this.variant = string;
        }

        @Override
        public D stepForward(D d) {
            if (((CalendarVariant)d).getDaysSinceEpochUTC() == this.calsys.getMaximumSinceUTC()) {
                return null;
            }
            return ((CalendarVariant)d).plus(CalendarDays.ONE);
        }

        @Override
        public D stepBackwards(D d) {
            if (((CalendarVariant)d).getDaysSinceEpochUTC() == this.calsys.getMinimumSinceUTC()) {
                return null;
            }
            return ((CalendarVariant)d).minus(CalendarDays.ONE);
        }

        @Override
        public boolean isCalendrical() {
            return true;
        }

        @Override
        public int compare(D d, D d2) {
            return Long.compare(((CalendarVariant)d).getDaysSinceEpochUTC(), ((CalendarVariant)d2).getDaysSinceEpochUTC());
        }

        @Override
        public D getMinimum() {
            return (D)((CalendarVariant)this.calsys.transform(this.calsys.getMinimumSinceUTC()));
        }

        @Override
        public D getMaximum() {
            return (D)((CalendarVariant)this.calsys.transform(this.calsys.getMaximumSinceUTC()));
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof CalendarTimeLine) {
                CalendarTimeLine calendarTimeLine = (CalendarTimeLine)object;
                return this.chronoType == calendarTimeLine.chronoType && this.variant.equals(calendarTimeLine.variant);
            }
            return false;
        }

        public int hashCode() {
            return this.chronoType.hashCode() + 31 * this.variant.hashCode();
        }

        private Object readResolve() throws ObjectStreamException {
            Chronology<D> chronology = Chronology.lookup(this.chronoType);
            return new CalendarTimeLine<D>(chronology, this.variant);
        }
    }

    public static final class Builder<T extends CalendarVariant<T>>
    extends Chronology.Builder<T> {
        private final Map<String, ? extends CalendarSystem<T>> calendars;

        private Builder(Class<T> clazz, ChronoMerger<T> chronoMerger, Map<String, ? extends CalendarSystem<T>> map) {
            super(clazz, chronoMerger);
            if (map.isEmpty()) {
                throw new IllegalArgumentException("Missing calendar variants.");
            }
            this.calendars = map;
        }

        public static <T extends CalendarVariant<T>> Builder<T> setUp(Class<T> clazz, ChronoMerger<T> chronoMerger, Map<String, ? extends CalendarSystem<T>> map) {
            return new Builder<T>(clazz, chronoMerger, map);
        }

        @Override
        public <V> Builder<T> appendElement(ChronoElement<V> chronoElement, ElementRule<T, V> elementRule) {
            super.appendElement(chronoElement, elementRule);
            return this;
        }

        @Override
        public Builder<T> appendExtension(ChronoExtension chronoExtension) {
            super.appendExtension(chronoExtension);
            return this;
        }

        @Override
        public CalendarFamily<T> build() {
            CalendarFamily calendarFamily = new CalendarFamily(this.chronoType, this.merger, this.ruleMap, this.extensions, this.calendars);
            Chronology.register(calendarFamily);
            return calendarFamily;
        }
    }
}

