/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import net.time4j.DayPeriod;
import net.time4j.Duration;
import net.time4j.IsoUnit;
import net.time4j.Moment;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.engine.TimeSpan;
import net.time4j.format.internal.FormatUtils;

final class SPX
implements Externalizable {
    static final int DATE_TYPE = 1;
    static final int TIME_TYPE = 2;
    static final int WEEKMODEL_TYPE = 3;
    static final int MOMENT_TYPE = 4;
    static final int DURATION_TYPE = 6;
    static final int DAY_PERIOD_TYPE = 7;
    static final int TIMESTAMP_TYPE = 8;
    private static final long serialVersionUID = 1L;
    private transient Object obj;
    private transient int type;

    public SPX() {
    }

    SPX(Object object, int n) {
        this.obj = object;
        this.type = n;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        switch (this.type) {
            case 1: {
                this.writeDate(objectOutput);
                break;
            }
            case 2: {
                this.writeTime(objectOutput);
                break;
            }
            case 3: {
                this.writeWeekmodel(objectOutput);
                break;
            }
            case 4: {
                this.writeMoment(objectOutput);
                break;
            }
            case 6: {
                this.writeDuration(objectOutput);
                break;
            }
            case 7: {
                this.writeDayPeriod(objectOutput);
                break;
            }
            case 8: {
                this.writeTimestamp(objectOutput);
                break;
            }
            default: {
                throw new InvalidClassException("Unknown serialized type.");
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        switch ((by & 0xFF) >> 4) {
            case 1: {
                this.obj = this.readDate(objectInput, by);
                break;
            }
            case 2: {
                this.obj = this.readTime(objectInput);
                break;
            }
            case 3: {
                this.obj = this.readWeekmodel(objectInput, by);
                break;
            }
            case 4: {
                this.obj = this.readMoment(objectInput, by);
                break;
            }
            case 6: {
                this.obj = this.readDuration(objectInput, by);
                break;
            }
            case 7: {
                this.obj = this.readDayPeriod(objectInput, by);
                break;
            }
            case 8: {
                this.obj = this.readTimestamp(objectInput, by);
                break;
            }
            default: {
                throw new StreamCorruptedException("Unknown serialized type.");
            }
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return this.obj;
    }

    private void writeDate(DataOutput dataOutput) throws IOException {
        PlainDate plainDate = (PlainDate)this.obj;
        SPX.writeDate(plainDate, 1, dataOutput);
    }

    private static void writeDate(PlainDate plainDate, int n, DataOutput dataOutput) throws IOException {
        int n2 = plainDate.getYear();
        int n3 = n2 >= 1850 && n2 <= 2100 ? 1 : (Math.abs(n2) < 10000 ? 2 : 3);
        int n4 = n;
        n4 <<= 4;
        dataOutput.writeByte(n4 |= plainDate.getMonth());
        int n5 = n3;
        n5 <<= 5;
        dataOutput.writeByte(n5 |= plainDate.getDayOfMonth());
        if (n3 == 1) {
            dataOutput.writeByte(n2 - 1850 - 128);
        } else if (n3 == 2) {
            dataOutput.writeShort(n2);
        } else {
            dataOutput.writeInt(n2);
        }
    }

    private PlainDate readDate(DataInput dataInput, byte by) throws IOException {
        int n;
        int n2 = by & 0xF;
        byte by2 = dataInput.readByte();
        int n3 = by2 >> 5 & 3;
        int n4 = by2 & 0x1F;
        switch (n3) {
            case 1: {
                n = dataInput.readByte() + 1850 + 128;
                break;
            }
            case 2: {
                n = dataInput.readShort();
                break;
            }
            case 3: {
                n = dataInput.readInt();
                break;
            }
            default: {
                throw new StreamCorruptedException("Unknown year range.");
            }
        }
        return PlainDate.of(n, Month.valueOf(n2), n4);
    }

    private void writeTime(DataOutput dataOutput) throws IOException {
        PlainTime plainTime = (PlainTime)this.obj;
        dataOutput.writeByte(32);
        SPX.writeTime(plainTime, dataOutput);
    }

    private static void writeTime(PlainTime plainTime, DataOutput dataOutput) throws IOException {
        if (plainTime.getNanosecond() == 0) {
            if (plainTime.getSecond() == 0) {
                if (plainTime.getMinute() == 0) {
                    dataOutput.writeByte(~plainTime.getHour());
                } else {
                    dataOutput.writeByte(plainTime.getHour());
                    dataOutput.writeByte(~plainTime.getMinute());
                }
            } else {
                dataOutput.writeByte(plainTime.getHour());
                dataOutput.writeByte(plainTime.getMinute());
                dataOutput.writeByte(~plainTime.getSecond());
            }
        } else {
            dataOutput.writeByte(plainTime.getHour());
            dataOutput.writeByte(plainTime.getMinute());
            dataOutput.writeByte(plainTime.getSecond());
            dataOutput.writeInt(plainTime.getNanosecond());
        }
    }

    private PlainTime readTime(DataInput dataInput) throws IOException {
        byte by = dataInput.readByte();
        if (by < 0) {
            return PlainTime.of(~by);
        }
        int n = 0;
        int n2 = 0;
        int n3 = dataInput.readByte();
        if (n3 < 0) {
            n3 ^= 0xFFFFFFFF;
        } else {
            n = dataInput.readByte();
            if (n < 0) {
                n ^= 0xFFFFFFFF;
            } else {
                n2 = dataInput.readInt();
            }
        }
        return PlainTime.of(by, n3, n, n2);
    }

    private void writeWeekmodel(DataOutput dataOutput) throws IOException {
        Weekmodel weekmodel = (Weekmodel)this.obj;
        boolean bl = weekmodel.getStartOfWeekend() == Weekday.SATURDAY && weekmodel.getEndOfWeekend() == Weekday.SUNDAY;
        int n = 3;
        n <<= 4;
        if (!bl) {
            n |= 1;
        }
        dataOutput.writeByte(n);
        int n2 = weekmodel.getFirstDayOfWeek().getValue();
        n2 <<= 4;
        dataOutput.writeByte(n2 |= weekmodel.getMinimalDaysInFirstWeek());
        if (!bl) {
            n2 = weekmodel.getStartOfWeekend().getValue();
            n2 <<= 4;
            dataOutput.writeByte(n2 |= weekmodel.getEndOfWeekend().getValue());
        }
    }

    private Object readWeekmodel(DataInput dataInput, byte by) throws IOException {
        byte by2 = dataInput.readByte();
        Weekday weekday = Weekday.valueOf(by2 >> 4);
        int n = by2 & 0xF;
        Weekday weekday2 = Weekday.SATURDAY;
        Weekday weekday3 = Weekday.SUNDAY;
        if ((by & 0xF) == 1) {
            by2 = dataInput.readByte();
            weekday2 = Weekday.valueOf(by2 >> 4);
            weekday3 = Weekday.valueOf(by2 & 0xF);
        }
        return Weekmodel.of(weekday, n, weekday2, weekday3);
    }

    private void writeMoment(DataOutput dataOutput) throws IOException {
        Moment moment = (Moment)this.obj;
        moment.writeTimestamp(dataOutput);
    }

    private Object readMoment(DataInput dataInput, byte by) throws IOException {
        int n = by & 1;
        int n2 = (by & 2) >>> 1;
        boolean bl = n != 0;
        boolean bl2 = n2 != 0;
        return Moment.readTimestamp(dataInput, bl, bl2);
    }

    private void writeTimestamp(DataOutput dataOutput) throws IOException {
        PlainTimestamp plainTimestamp = (PlainTimestamp)this.obj;
        SPX.writeDate(plainTimestamp.getCalendarDate(), 8, dataOutput);
        SPX.writeTime(plainTimestamp.getWallTime(), dataOutput);
    }

    private Object readTimestamp(DataInput dataInput, byte by) throws IOException, ClassNotFoundException {
        PlainDate plainDate = this.readDate(dataInput, by);
        PlainTime plainTime = this.readTime(dataInput);
        return PlainTimestamp.of(plainDate, plainTime);
    }

    private void writeDuration(ObjectOutput objectOutput) throws IOException {
        int n;
        Duration duration = (Duration)Duration.class.cast(this.obj);
        int n2 = duration.getTotalLength().size();
        boolean bl = false;
        int n3 = Math.min(n2, 6);
        for (n = 0; n < n3; ++n) {
            if (duration.getTotalLength().get(n).getAmount() < 1000L) continue;
            bl = true;
            break;
        }
        n = 6;
        n <<= 4;
        if (bl) {
            n |= 1;
        }
        objectOutput.writeByte(n);
        objectOutput.writeInt(n2);
        for (n3 = 0; n3 < n2; ++n3) {
            TimeSpan.Item item = duration.getTotalLength().get(n3);
            if (bl) {
                objectOutput.writeLong(item.getAmount());
            } else {
                objectOutput.writeInt((int)item.getAmount());
            }
            objectOutput.writeObject(item.getUnit());
        }
        if (n2 > 0) {
            objectOutput.writeBoolean(duration.isNegative());
        }
    }

    private Object readDuration(ObjectInput objectInput, byte by) throws IOException, ClassNotFoundException {
        int n;
        boolean bl = (by & 0xF) == 1;
        int n2 = objectInput.readInt();
        if (n2 == 0) {
            return Duration.ofZero();
        }
        ArrayList arrayList = new ArrayList(n2);
        for (n = 0; n < n2; ++n) {
            long l = bl ? objectInput.readLong() : (long)objectInput.readInt();
            IsoUnit isoUnit = (IsoUnit)objectInput.readObject();
            arrayList.add(TimeSpan.Item.of(l, isoUnit));
        }
        n = objectInput.readBoolean() ? 1 : 0;
        return new Duration(arrayList, n != 0);
    }

    private void writeDayPeriod(ObjectOutput objectOutput) throws IOException {
        DayPeriod.Element element = (DayPeriod.Element)DayPeriod.Element.class.cast(this.obj);
        Locale locale = element.getLocale();
        int n = 7;
        n <<= 4;
        if (element.isFixed()) {
            n |= 1;
        }
        if (locale == null) {
            n |= 2;
        }
        objectOutput.writeByte(n);
        if (locale == null) {
            objectOutput.writeObject(element.getCodeMap());
        } else {
            String string = locale.getLanguage();
            String string2 = FormatUtils.getRegion(locale);
            if (!string2.isEmpty()) {
                string = string + "-" + string2;
            }
            objectOutput.writeUTF(string);
            objectOutput.writeUTF(element.getCalendarType());
        }
    }

    private Object readDayPeriod(ObjectInput objectInput, byte by) throws IOException, ClassNotFoundException {
        boolean bl;
        boolean bl2 = (by & 1) == 1;
        boolean bl3 = bl = (by & 2) == 2;
        if (bl) {
            Map map = (Map)objectInput.readObject();
            return new DayPeriod.Element(bl2, DayPeriod.of(map));
        }
        String string = objectInput.readUTF();
        String string2 = objectInput.readUTF();
        int n = string.indexOf("-");
        Locale locale = n == -1 ? new Locale(string) : new Locale(string.substring(0, n), string.substring(n + 1));
        return new DayPeriod.Element(bl2, locale, string2);
    }
}

