/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.CalendarUnit;
import net.time4j.ClockUnit;
import net.time4j.IsoUnit;
import net.time4j.base.ResourceLoader;
import net.time4j.format.PluralCategory;
import net.time4j.format.TextWidth;
import net.time4j.format.UnitPatternProvider;

final class UnitPatterns {
    private static final int MIN_LIST_INDEX = 2;
    private static final int MAX_LIST_INDEX = 7;
    private static final ConcurrentMap<Locale, UnitPatterns> CACHE = new ConcurrentHashMap<Locale, UnitPatterns>();
    private static final IsoUnit[] UNIT_IDS = new IsoUnit[]{CalendarUnit.YEARS, CalendarUnit.MONTHS, CalendarUnit.WEEKS, CalendarUnit.DAYS, ClockUnit.HOURS, ClockUnit.MINUTES, ClockUnit.SECONDS, ClockUnit.MILLIS, ClockUnit.MICROS, ClockUnit.NANOS};
    private static final UnitPatternProvider PROVIDER;
    private static final UnitPatternProvider FALLBACK;
    private final Locale locale;
    private final Map<IsoUnit, Map<TextWidth, Map<PluralCategory, String>>> patterns;
    private final Map<IsoUnit, Map<PluralCategory, String>> past;
    private final Map<IsoUnit, Map<PluralCategory, String>> future;
    private final Map<Integer, Map<TextWidth, String>> list;
    private final String now;

    /*
     * Could not resolve type clashes
     */
    private UnitPatterns(Locale locale) {
        String string;
        this.locale = locale;
        HashMap hashMap = new HashMap(10);
        HashMap hashMap2 = new HashMap(10);
        HashMap hashMap3 = new HashMap(10);
        HashMap hashMap4 = new HashMap(10);
        for (TextWidth[] textWidthArray : UNIT_IDS) {
            EnumMap enumMap = new EnumMap(TextWidth.class);
            for (TextWidth textWidth : TextWidth.values()) {
                Object object = new EnumMap<PluralCategory, String>(PluralCategory.class);
                for (PluralCategory pluralCategory : PluralCategory.values()) {
                    object.put(pluralCategory, UnitPatterns.lookup(locale, (IsoUnit)textWidthArray, textWidth, pluralCategory));
                }
                enumMap.put(textWidth, Collections.unmodifiableMap(object));
            }
            hashMap.put(textWidthArray, Collections.unmodifiableMap(enumMap));
            if (Character.isDigit(textWidthArray.getSymbol())) continue;
            EnumMap enumMap2 = new EnumMap(PluralCategory.class);
            for (Object object : PluralCategory.values()) {
                enumMap2.put((PluralCategory)((Object)object), UnitPatterns.lookup(locale, (IsoUnit)textWidthArray, false, object));
            }
            hashMap2.put(textWidthArray, Collections.unmodifiableMap(enumMap2));
            EnumMap enumMap3 = new EnumMap(PluralCategory.class);
            for (Object object : PluralCategory.values()) {
                enumMap3.put((PluralCategory)((Object)object), UnitPatterns.lookup(locale, (IsoUnit)textWidthArray, true, (PluralCategory)((Object)object)));
            }
            hashMap3.put(textWidthArray, Collections.unmodifiableMap(enumMap3));
        }
        for (int i = 2; i <= 7; ++i) {
            Integer n = i;
            EnumMap<TextWidth, String> enumMap = new EnumMap<TextWidth, String>(TextWidth.class);
            for (TextWidth textWidth : TextWidth.values()) {
                enumMap.put(textWidth, UnitPatterns.lookup(locale, textWidth, n));
            }
            hashMap4.put(n, Collections.unmodifiableMap(enumMap));
        }
        this.patterns = Collections.unmodifiableMap(hashMap);
        this.past = Collections.unmodifiableMap(hashMap2);
        this.future = Collections.unmodifiableMap(hashMap3);
        this.list = Collections.unmodifiableMap(hashMap4);
        try {
            string = PROVIDER.getNowWord(locale);
        }
        catch (MissingResourceException missingResourceException) {
            string = FALLBACK.getNowWord(locale);
        }
        this.now = string;
    }

    static UnitPatterns of(Locale locale) {
        UnitPatterns unitPatterns;
        if (locale == null) {
            throw new NullPointerException("Missing language.");
        }
        UnitPatterns unitPatterns2 = (UnitPatterns)CACHE.get(locale);
        if (unitPatterns2 == null && (unitPatterns = CACHE.putIfAbsent(locale, unitPatterns2 = new UnitPatterns(locale))) != null) {
            unitPatterns2 = unitPatterns;
        }
        return unitPatterns2;
    }

    String getPattern(TextWidth textWidth, PluralCategory pluralCategory, IsoUnit isoUnit) {
        UnitPatterns.checkNull(textWidth, pluralCategory);
        return this.patterns.get(isoUnit).get((Object)textWidth).get((Object)pluralCategory);
    }

    String getPatternInPast(PluralCategory pluralCategory, IsoUnit isoUnit) {
        UnitPatterns.checkNull(pluralCategory);
        return this.past.get(isoUnit).get((Object)pluralCategory);
    }

    String getPatternInFuture(PluralCategory pluralCategory, IsoUnit isoUnit) {
        UnitPatterns.checkNull(pluralCategory);
        return this.future.get(isoUnit).get((Object)pluralCategory);
    }

    String getNowWord() {
        return this.now;
    }

    String getListPattern(TextWidth textWidth, int n) {
        if (textWidth == null) {
            throw new NullPointerException("Missing width.");
        }
        if (n >= 2 && n <= 7) {
            return this.list.get(n).get((Object)textWidth);
        }
        return UnitPatterns.lookup(this.locale, textWidth, n);
    }

    private static void checkNull(PluralCategory pluralCategory) {
        if (pluralCategory == null) {
            throw new NullPointerException("Missing plural category.");
        }
    }

    private static void checkNull(TextWidth textWidth, PluralCategory pluralCategory) {
        if (textWidth == null) {
            throw new NullPointerException("Missing text width.");
        }
        UnitPatterns.checkNull(pluralCategory);
    }

    private static char getID(IsoUnit isoUnit) {
        char c = isoUnit.getSymbol();
        if (isoUnit == ClockUnit.MINUTES) {
            return 'N';
        }
        return c;
    }

    private static String lookup(Locale locale, IsoUnit isoUnit, TextWidth textWidth, PluralCategory pluralCategory) {
        try {
            return UnitPatterns.lookup(PROVIDER, locale, UnitPatterns.getID(isoUnit), textWidth, pluralCategory);
        }
        catch (MissingResourceException missingResourceException) {
            return UnitPatterns.lookup(FALLBACK, locale, UnitPatterns.getID(isoUnit), textWidth, pluralCategory);
        }
    }

    private static String lookup(UnitPatternProvider unitPatternProvider, Locale locale, char c, TextWidth textWidth, PluralCategory pluralCategory) {
        switch (c) {
            case 'Y': {
                return unitPatternProvider.getYearPattern(locale, textWidth, pluralCategory);
            }
            case 'M': {
                return unitPatternProvider.getMonthPattern(locale, textWidth, pluralCategory);
            }
            case 'W': {
                return unitPatternProvider.getWeekPattern(locale, textWidth, pluralCategory);
            }
            case 'D': {
                return unitPatternProvider.getDayPattern(locale, textWidth, pluralCategory);
            }
            case 'H': {
                return unitPatternProvider.getHourPattern(locale, textWidth, pluralCategory);
            }
            case 'N': {
                return unitPatternProvider.getMinutePattern(locale, textWidth, pluralCategory);
            }
            case 'S': {
                return unitPatternProvider.getSecondPattern(locale, textWidth, pluralCategory);
            }
            case '3': {
                return unitPatternProvider.getMilliPattern(locale, textWidth, pluralCategory);
            }
            case '6': {
                return unitPatternProvider.getMicroPattern(locale, textWidth, pluralCategory);
            }
            case '9': {
                return unitPatternProvider.getNanoPattern(locale, textWidth, pluralCategory);
            }
        }
        throw new UnsupportedOperationException("Unit-ID: " + c);
    }

    private static String lookup(Locale locale, IsoUnit isoUnit, boolean bl, PluralCategory pluralCategory) {
        try {
            return UnitPatterns.lookup(PROVIDER, locale, UnitPatterns.getID(isoUnit), bl, pluralCategory);
        }
        catch (MissingResourceException missingResourceException) {
            return UnitPatterns.lookup(FALLBACK, locale, UnitPatterns.getID(isoUnit), bl, pluralCategory);
        }
    }

    private static String lookup(UnitPatternProvider unitPatternProvider, Locale locale, char c, boolean bl, PluralCategory pluralCategory) {
        switch (c) {
            case 'Y': {
                return unitPatternProvider.getYearPattern(locale, bl, pluralCategory);
            }
            case 'M': {
                return unitPatternProvider.getMonthPattern(locale, bl, pluralCategory);
            }
            case 'W': {
                return unitPatternProvider.getWeekPattern(locale, bl, pluralCategory);
            }
            case 'D': {
                return unitPatternProvider.getDayPattern(locale, bl, pluralCategory);
            }
            case 'H': {
                return unitPatternProvider.getHourPattern(locale, bl, pluralCategory);
            }
            case 'N': {
                return unitPatternProvider.getMinutePattern(locale, bl, pluralCategory);
            }
            case 'S': {
                return unitPatternProvider.getSecondPattern(locale, bl, pluralCategory);
            }
        }
        throw new UnsupportedOperationException("Unit-ID: " + c);
    }

    private static String lookup(Locale locale, TextWidth textWidth, int n) {
        try {
            return PROVIDER.getListPattern(locale, textWidth, n);
        }
        catch (MissingResourceException missingResourceException) {
            return FALLBACK.getListPattern(locale, textWidth, n);
        }
    }

    static {
        FALLBACK = new FallbackProvider();
        UnitPatternProvider unitPatternProvider = null;
        Iterator<UnitPatternProvider> iterator = ResourceLoader.getInstance().services(UnitPatternProvider.class).iterator();
        if (iterator.hasNext()) {
            UnitPatternProvider unitPatternProvider2;
            unitPatternProvider = unitPatternProvider2 = iterator.next();
        }
        if (unitPatternProvider == null) {
            unitPatternProvider = FALLBACK;
        }
        PROVIDER = unitPatternProvider;
    }

    private static class FallbackProvider
    implements UnitPatternProvider {
        private FallbackProvider() {
        }

        @Override
        public String getYearPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getEnglishPattern("year", "yr", "y", textWidth, pluralCategory);
            }
            return FallbackProvider.getUnitPattern("y");
        }

        @Override
        public String getMonthPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getEnglishPattern("month", "mth", "m", textWidth, pluralCategory);
            }
            return FallbackProvider.getUnitPattern("m");
        }

        @Override
        public String getWeekPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getEnglishPattern("week", "wk", "w", textWidth, pluralCategory);
            }
            return FallbackProvider.getUnitPattern("w");
        }

        @Override
        public String getDayPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getEnglishPattern("day", "day", "d", textWidth, pluralCategory);
            }
            return FallbackProvider.getUnitPattern("d");
        }

        @Override
        public String getHourPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getEnglishPattern("hour", "hr", "h", textWidth, pluralCategory);
            }
            return FallbackProvider.getUnitPattern("h");
        }

        @Override
        public String getMinutePattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getEnglishPattern("minute", "min", "m", textWidth, pluralCategory);
            }
            return FallbackProvider.getUnitPattern("min");
        }

        @Override
        public String getSecondPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getEnglishPattern("second", "sec", "s", textWidth, pluralCategory);
            }
            return FallbackProvider.getUnitPattern("s");
        }

        @Override
        public String getYearPattern(Locale locale, boolean bl, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getRelativeEnglishPattern("year", bl, pluralCategory);
            }
            return FallbackProvider.getRelativePattern("y", bl);
        }

        @Override
        public String getMonthPattern(Locale locale, boolean bl, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getRelativeEnglishPattern("month", bl, pluralCategory);
            }
            return FallbackProvider.getRelativePattern("m", bl);
        }

        @Override
        public String getWeekPattern(Locale locale, boolean bl, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getRelativeEnglishPattern("week", bl, pluralCategory);
            }
            return FallbackProvider.getRelativePattern("w", bl);
        }

        @Override
        public String getDayPattern(Locale locale, boolean bl, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getRelativeEnglishPattern("day", bl, pluralCategory);
            }
            return FallbackProvider.getRelativePattern("d", bl);
        }

        @Override
        public String getHourPattern(Locale locale, boolean bl, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getRelativeEnglishPattern("hour", bl, pluralCategory);
            }
            return FallbackProvider.getRelativePattern("h", bl);
        }

        @Override
        public String getMinutePattern(Locale locale, boolean bl, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getRelativeEnglishPattern("minute", bl, pluralCategory);
            }
            return FallbackProvider.getRelativePattern("min", bl);
        }

        @Override
        public String getSecondPattern(Locale locale, boolean bl, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getRelativeEnglishPattern("second", bl, pluralCategory);
            }
            return FallbackProvider.getRelativePattern("s", bl);
        }

        @Override
        public String getNowWord(Locale locale) {
            return "now";
        }

        private static String getEnglishPattern(String string, String string2, String string3, TextWidth textWidth, PluralCategory pluralCategory) {
            switch (textWidth) {
                case WIDE: {
                    return FallbackProvider.getPluralPattern(string, pluralCategory);
                }
                case ABBREVIATED: 
                case SHORT: {
                    return FallbackProvider.getPluralPattern(string2, pluralCategory);
                }
                case NARROW: {
                    return "{0}" + string3;
                }
            }
            throw new UnsupportedOperationException(textWidth.name());
        }

        private static String getPluralPattern(String string, PluralCategory pluralCategory) {
            String string2 = pluralCategory == PluralCategory.ONE ? "" : "s";
            return "{0} " + string + string2;
        }

        private static String getUnitPattern(String string) {
            return "{0} " + string;
        }

        private static String getRelativeEnglishPattern(String string, boolean bl, PluralCategory pluralCategory) {
            String string2;
            String string3 = string2 = pluralCategory == PluralCategory.ONE ? "" : "s";
            if (bl) {
                return "in {0} " + string + string2;
            }
            return "{0} " + string + string2 + " ago";
        }

        private static String getRelativePattern(String string, boolean bl) {
            return (bl ? "+" : "-") + "{0} " + string;
        }

        @Override
        public String getListPattern(Locale locale, TextWidth textWidth, int n) {
            if (n < 2) {
                throw new IllegalArgumentException("Size must be greater than 1.");
            }
            StringBuilder stringBuilder = new StringBuilder(n * 5);
            for (int i = 0; i < n; ++i) {
                stringBuilder.append('{');
                stringBuilder.append(i);
                stringBuilder.append('}');
                if (i >= n - 1) continue;
                stringBuilder.append(", ");
            }
            return stringBuilder.toString();
        }

        @Override
        public String getMilliPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getEnglishPattern("millisecond", "msec", "ms", textWidth, pluralCategory);
            }
            return FallbackProvider.getUnitPattern("ms");
        }

        @Override
        public String getMicroPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getEnglishPattern("microsecond", "\u00b5sec", "\u00b5s", textWidth, pluralCategory);
            }
            return FallbackProvider.getUnitPattern("\u00b5s");
        }

        @Override
        public String getNanoPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getEnglishPattern("nanosecond", "nsec", "ns", textWidth, pluralCategory);
            }
            return FallbackProvider.getUnitPattern("ns");
        }
    }
}

