/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.ZonedDateTime;
import net.time4j.Moment;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.SI;
import net.time4j.TemporalType;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ThreetenAdapter;
import net.time4j.format.Attributes;
import net.time4j.format.RawValues;
import net.time4j.format.TemporalFormatter;
import net.time4j.scale.TimeScale;
import net.time4j.scale.UniversalTime;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

public final class ZonalDateTime
implements ChronoDisplay,
UniversalTime,
ThreetenAdapter {
    private final Moment moment;
    private final Timezone zone;
    private final transient PlainTimestamp timestamp;

    private ZonalDateTime(Moment moment, Timezone timezone) {
        this.zone = timezone;
        ZonalOffset zonalOffset = timezone.getOffset(moment);
        if (moment.isLeapSecond() && (zonalOffset.getFractionalAmount() != 0 || zonalOffset.getAbsoluteSeconds() % 60 != 0)) {
            throw new IllegalArgumentException("Leap second can only be represented  with timezone-offset in full minutes: " + zonalOffset);
        }
        this.moment = moment;
        this.timestamp = PlainTimestamp.from(moment, zonalOffset);
    }

    private ZonalDateTime(PlainTimestamp plainTimestamp, ZonalOffset zonalOffset) {
        this.moment = plainTimestamp.at(zonalOffset);
        this.zone = Timezone.of(zonalOffset);
        this.timestamp = plainTimestamp;
    }

    static ZonalDateTime of(Moment moment, Timezone timezone) {
        return new ZonalDateTime(moment, timezone);
    }

    static ZonalDateTime of(PlainTimestamp plainTimestamp, ZonalOffset zonalOffset) {
        return new ZonalDateTime(plainTimestamp, zonalOffset);
    }

    public int compareByMoment(ZonalDateTime zonalDateTime) {
        int n = this.moment.compareTo(zonalDateTime.moment);
        if (n == 0) {
            n = this.timestamp.compareTo(zonalDateTime.timestamp);
        }
        return n;
    }

    public int compareByLocalTimestamp(ZonalDateTime zonalDateTime) {
        int n = this.timestamp.compareTo(zonalDateTime.timestamp);
        if (n == 0) {
            n = this.moment.compareTo(zonalDateTime.moment);
        }
        return n;
    }

    @Override
    public boolean contains(ChronoElement<?> chronoElement) {
        return this.timestamp.contains(chronoElement) || this.moment.contains(chronoElement);
    }

    @Override
    public <V> V get(ChronoElement<V> chronoElement) {
        if (this.moment.isLeapSecond() && chronoElement == PlainTime.SECOND_OF_MINUTE) {
            return chronoElement.getType().cast(60);
        }
        if (this.timestamp.contains(chronoElement)) {
            return this.timestamp.get(chronoElement);
        }
        return this.moment.get(chronoElement);
    }

    @Override
    public int getInt(ChronoElement<Integer> chronoElement) {
        if (this.moment.isLeapSecond() && chronoElement == PlainTime.SECOND_OF_MINUTE) {
            return 60;
        }
        int n = this.timestamp.getInt(chronoElement);
        if (n == Integer.MIN_VALUE) {
            n = this.moment.getInt(chronoElement);
        }
        return n;
    }

    @Override
    public <V> V getMinimum(ChronoElement<V> chronoElement) {
        if (this.timestamp.contains(chronoElement)) {
            return this.timestamp.getMinimum(chronoElement);
        }
        return this.moment.getMinimum(chronoElement);
    }

    @Override
    public <V> V getMaximum(ChronoElement<V> chronoElement) {
        Moment moment;
        Moment moment2;
        PlainTimestamp plainTimestamp;
        V v = this.timestamp.contains(chronoElement) ? this.timestamp.getMaximum(chronoElement) : this.moment.getMaximum(chronoElement);
        if (chronoElement == PlainTime.SECOND_OF_MINUTE && this.timestamp.getYear() >= 1972 && !this.zone.isInvalid(plainTimestamp = (PlainTimestamp)this.timestamp.with(chronoElement, v), plainTimestamp) && (moment2 = (moment = plainTimestamp.in(this.zone)).plus(1L, SI.SECONDS)).isLeapSecond()) {
            return chronoElement.getType().cast(60);
        }
        return v;
    }

    @Override
    public boolean hasTimezone() {
        return true;
    }

    @Override
    public TZID getTimezone() {
        return this.zone.getID();
    }

    public ZonalOffset getOffset() {
        return this.zone.getOffset(this.moment);
    }

    public Moment toMoment() {
        return this.moment;
    }

    public PlainTimestamp toTimestamp() {
        return this.timestamp;
    }

    public static ZonalDateTime from(ZonedDateTime zonedDateTime) {
        return TemporalType.ZONED_DATE_TIME.translate(zonedDateTime);
    }

    @Override
    public long getElapsedTime(TimeScale timeScale) {
        return this.moment.getElapsedTime(timeScale);
    }

    @Override
    public int getNanosecond(TimeScale timeScale) {
        return this.moment.getNanosecond(timeScale);
    }

    @Override
    public boolean isLeapSecond() {
        return this.moment.isLeapSecond();
    }

    @Override
    public long getPosixTime() {
        return this.moment.getPosixTime();
    }

    @Override
    public int getNanosecond() {
        return this.moment.getNanosecond();
    }

    public String print(TemporalFormatter<Moment> temporalFormatter) {
        return temporalFormatter.withTimezone(this.getTimezone()).format(this.moment);
    }

    public static ZonalDateTime parse(String string, TemporalFormatter<Moment> temporalFormatter) throws ParseException {
        Timezone timezone;
        ParsePosition parsePosition = new ParsePosition(0);
        RawValues rawValues = new RawValues();
        Moment moment = temporalFormatter.parse(string, parsePosition, rawValues);
        if (moment == null) {
            moment = temporalFormatter.parse(string);
        }
        if (moment == null) {
            throw new ParseException("Cannot parse: " + string, parsePosition.getErrorIndex());
        }
        if (rawValues.get().hasTimezone()) {
            timezone = ZonalDateTime.toTimezone(rawValues.get().getTimezone(), string);
        } else if (temporalFormatter.getAttributes().contains(Attributes.TIMEZONE_ID)) {
            timezone = ZonalDateTime.toTimezone(temporalFormatter.getAttributes().get(Attributes.TIMEZONE_ID), string);
        } else {
            throw new ParseException("Missing timezone: " + string, 0);
        }
        return ZonalDateTime.of(moment, timezone);
    }

    public static ZonalDateTime parse(String string, TemporalFormatter<Moment> temporalFormatter, ParsePosition parsePosition) {
        Timezone timezone;
        RawValues rawValues = new RawValues();
        Moment moment = temporalFormatter.parse(string, parsePosition, rawValues);
        if (moment == null) {
            return null;
        }
        if (rawValues.get().hasTimezone()) {
            timezone = Timezone.of(rawValues.get().getTimezone());
        } else if (temporalFormatter.getAttributes().contains(Attributes.TIMEZONE_ID)) {
            timezone = Timezone.of(temporalFormatter.getAttributes().get(Attributes.TIMEZONE_ID));
        } else {
            parsePosition.setErrorIndex(0);
            return null;
        }
        return ZonalDateTime.of(moment, timezone);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ZonalDateTime) {
            ZonalDateTime zonalDateTime = (ZonalDateTime)object;
            return this.moment.equals(zonalDateTime.moment) && this.zone.equals(zonalDateTime.zone);
        }
        return false;
    }

    public int hashCode() {
        return this.moment.hashCode() ^ this.zone.hashCode();
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder(40);
        stringBuilder.append(this.timestamp.getCalendarDate());
        stringBuilder.append('T');
        int n2 = this.timestamp.getHour();
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
        stringBuilder.append(':');
        int n3 = this.timestamp.getMinute();
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        stringBuilder.append(':');
        if (this.isLeapSecond()) {
            stringBuilder.append("60");
        } else {
            n = this.timestamp.getSecond();
            if (n < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n);
        }
        n = this.timestamp.getNanosecond();
        if (n != 0) {
            PlainTime.printNanos(stringBuilder, n);
        }
        stringBuilder.append(this.getOffset());
        TZID tZID = this.getTimezone();
        boolean bl = tZID instanceof ZonalOffset;
        if (!bl) {
            stringBuilder.append('[');
            stringBuilder.append(tZID.canonical());
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    @Override
    public ZonedDateTime toTemporalAccessor() {
        return TemporalType.ZONED_DATE_TIME.from(this);
    }

    public void write(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.moment);
        objectOutput.writeObject(this.zone);
    }

    public static ZonalDateTime read(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Moment moment = (Moment)objectInput.readObject();
        Timezone timezone = (Timezone)objectInput.readObject();
        return new ZonalDateTime(moment, timezone);
    }

    private static Timezone toTimezone(TZID tZID, String string) throws ParseException {
        try {
            return Timezone.of(tZID);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ParseException parseException = new ParseException("Timezone error: " + string, 0);
            parseException.initCause(illegalArgumentException);
            throw parseException;
        }
    }
}

