/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.time4j.ClockUnit;
import net.time4j.FormatSupport;
import net.time4j.GeneralTimestamp;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.PrecisionElement;
import net.time4j.SI;
import net.time4j.SPX;
import net.time4j.SystemClock;
import net.time4j.TemporalType;
import net.time4j.ValueOperator;
import net.time4j.ZonalDateTime;
import net.time4j.ZonalElement;
import net.time4j.base.GregorianMath;
import net.time4j.base.TimeSource;
import net.time4j.base.UnixTime;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BridgeChronology;
import net.time4j.engine.CalendarFamily;
import net.time4j.engine.CalendarVariant;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.ChronoOperator;
import net.time4j.engine.Chronology;
import net.time4j.engine.Converter;
import net.time4j.engine.DisplayStyle;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.FlagElement;
import net.time4j.engine.RealTime;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.Temporal;
import net.time4j.engine.ThreetenAdapter;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimeLine;
import net.time4j.engine.TimePoint;
import net.time4j.engine.UnitRule;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.CalendarType;
import net.time4j.format.ChronoPattern;
import net.time4j.format.DisplayMode;
import net.time4j.format.Leniency;
import net.time4j.format.TemporalFormatter;
import net.time4j.scale.LeapSecondEvent;
import net.time4j.scale.LeapSeconds;
import net.time4j.scale.TimeScale;
import net.time4j.scale.UniversalTime;
import net.time4j.tz.OverlapResolver;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionStrategy;
import net.time4j.tz.ZonalOffset;

@CalendarType(value="iso8601")
public final class Moment
extends TimePoint<TimeUnit, Moment>
implements UniversalTime,
Temporal<UniversalTime>,
ThreetenAdapter {
    private static final long UTC_GPS_DELTA = 252892809L;
    private static final long POSIX_UTC_DELTA = 63072000L;
    private static final long POSIX_GPS_DELTA = 315964800L;
    private static final int MIO = 1000000;
    private static final int MRD = 1000000000;
    private static final int POSITIVE_LEAP_MASK = 0x40000000;
    private static final long MIN_LIMIT;
    private static final long MAX_LIMIT;
    private static final Moment MIN;
    private static final Moment MAX;
    private static final Moment START_LS_CHECK;
    private static final Set<ChronoElement<?>> HIGH_TIME_ELEMENTS;
    private static final Map<ChronoElement<?>, Integer> LOW_TIME_ELEMENTS;
    private static final Map<TimeUnit, Double> UNIT_LENGTHS;
    private static final TimeAxis<TimeUnit, Moment> ENGINE;
    public static final Moment UNIX_EPOCH;
    public static final ChronoElement<Long> POSIX_TIME;
    public static final ChronoElement<Integer> FRACTION;
    public static final ChronoElement<TimeUnit> PRECISION;
    private static final ChronoOperator<Moment> NEXT_LS;
    private static final long serialVersionUID = -3192884724477742274L;
    private final transient long posixTime;
    private final transient int fraction;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Moment(long l, int n, TimeScale timeScale) {
        if (timeScale == TimeScale.POSIX) {
            this.posixTime = l;
            this.fraction = n;
        } else {
            long l2;
            LeapSeconds leapSeconds = LeapSeconds.getInstance();
            if (!leapSeconds.isEnabled()) throw new IllegalStateException("Leap seconds are not supported by configuration.");
            if (timeScale == TimeScale.UTC) {
                l2 = l;
            } else if (timeScale == TimeScale.TAI) {
                l2 = Math.subtractExact(l, 10L);
                if (l2 < 0L) {
                    throw new IllegalArgumentException("TAI not supported before 1972-01-01: " + l);
                }
            } else {
                if (timeScale != TimeScale.GPS) throw new UnsupportedOperationException("Not yet implemented: " + timeScale.name());
                l2 = Math.addExact(l, 252892809L);
                if (l2 < 252892809L) {
                    throw new IllegalArgumentException("GPS not supported before 1980-01-06: " + l);
                }
            }
            long l3 = leapSeconds.strip(l2);
            long l4 = l2 - leapSeconds.enhance(l3);
            this.posixTime = l3;
            if (l4 == 0L || l3 == MAX_LIMIT) {
                this.fraction = n;
            } else {
                if (l4 != 1L) throw new IllegalStateException("Cannot handle leap shift of " + l + ".");
                this.fraction = n | 0x40000000;
            }
        }
        Moment.checkUnixTime(this.posixTime);
        Moment.checkFraction(n);
    }

    private Moment(int n, long l) {
        Moment.checkUnixTime(l);
        this.posixTime = l;
        this.fraction = n;
    }

    public static Moment of(long l, TimeScale timeScale) {
        return Moment.of(l, 0, timeScale);
    }

    public static Moment of(long l, int n, TimeScale timeScale) {
        if (l == 0L && n == 0 && timeScale == TimeScale.POSIX) {
            return UNIX_EPOCH;
        }
        return new Moment(l, n, timeScale);
    }

    public static Moment nowInSystemTime() {
        return SystemClock.INSTANCE.currentTime();
    }

    public static Moment from(UnixTime unixTime) {
        if (unixTime instanceof Moment) {
            return (Moment)Moment.class.cast(unixTime);
        }
        if (unixTime instanceof UniversalTime && LeapSeconds.getInstance().isEnabled()) {
            UniversalTime universalTime = (UniversalTime)UniversalTime.class.cast(unixTime);
            return Moment.of(universalTime.getElapsedTime(TimeScale.UTC), universalTime.getNanosecond(TimeScale.UTC), TimeScale.UTC);
        }
        return Moment.of(unixTime.getPosixTime(), unixTime.getNanosecond(), TimeScale.POSIX);
    }

    public static Moment from(Instant instant) {
        return TemporalType.INSTANT.translate(instant);
    }

    @Override
    public long getPosixTime() {
        return this.posixTime;
    }

    @Override
    public long getElapsedTime(TimeScale timeScale) {
        if (timeScale == TimeScale.POSIX) {
            return this.posixTime;
        }
        long l = this.getEpochTime();
        switch (timeScale) {
            case UTC: {
                return l;
            }
            case TAI: {
                if (l < 0L) {
                    throw new IllegalArgumentException("TAI not supported before 1972-01-01: " + this);
                }
                return l + 10L;
            }
            case GPS: {
                if (LeapSeconds.getInstance().strip(l) < 315964800L) {
                    throw new IllegalArgumentException("GPS not supported before 1980-01-06: " + this);
                }
                long l2 = LeapSeconds.getInstance().isEnabled() ? l : l + 9L;
                return l2 - 252892809L;
            }
        }
        throw new UnsupportedOperationException("Not yet implemented: " + (Object)((Object)timeScale));
    }

    @Override
    public int getNanosecond() {
        return this.fraction & 0xBFFFFFFF;
    }

    @Override
    public int getNanosecond(TimeScale timeScale) {
        switch (timeScale) {
            case UTC: 
            case POSIX: {
                return this.getNanosecond();
            }
            case TAI: {
                if (this.posixTime < 63072000L) {
                    throw new IllegalArgumentException("TAI not supported before 1972-01-01: " + this);
                }
                return this.getNanosecond();
            }
            case GPS: {
                long l = this.getEpochTime();
                if (LeapSeconds.getInstance().strip(l) < 315964800L) {
                    throw new IllegalArgumentException("GPS not supported before 1980-01-06: " + this);
                }
                return this.getNanosecond();
            }
        }
        throw new UnsupportedOperationException("Not yet implemented: " + (Object)((Object)timeScale));
    }

    @Override
    public boolean isLeapSecond() {
        return this.isPositiveLS() && LeapSeconds.getInstance().isEnabled();
    }

    public static ChronoOperator<Moment> nextLeapSecond() {
        return NEXT_LS;
    }

    public BigDecimal transform(TimeScale timeScale) {
        BigDecimal bigDecimal = new BigDecimal(this.getElapsedTime(timeScale)).setScale(9, RoundingMode.UNNECESSARY);
        BigDecimal bigDecimal2 = new BigDecimal(this.getNanosecond(timeScale));
        return bigDecimal.add(bigDecimal2.movePointLeft(9));
    }

    @Override
    public boolean isAfter(UniversalTime universalTime) {
        Moment moment = Moment.from(universalTime);
        return this.compareTo(moment) > 0;
    }

    @Override
    public boolean isBefore(UniversalTime universalTime) {
        Moment moment = Moment.from(universalTime);
        return this.compareTo(moment) < 0;
    }

    @Override
    public boolean isSimultaneous(UniversalTime universalTime) {
        Moment moment = Moment.from(universalTime);
        return this.compareTo(moment) == 0;
    }

    public PlainTimestamp toLocalTimestamp() {
        return this.in(Timezone.ofSystem());
    }

    public PlainTimestamp toZonalTimestamp(TZID tZID) {
        return this.in(Timezone.of(tZID));
    }

    public PlainTimestamp toZonalTimestamp(String string) {
        return this.in(Timezone.of(string));
    }

    public <C extends Calendrical<?, C>> GeneralTimestamp<C> toGeneralTimestamp(Chronology<C> chronology, TZID tZID, StartOfDay startOfDay) {
        PlainTimestamp plainTimestamp = this.toZonalTimestamp(tZID);
        PlainTime plainTime = plainTimestamp.getWallTime();
        int n = startOfDay.getDeviation(plainTimestamp.getCalendarDate(), tZID);
        plainTimestamp = plainTimestamp.minus((long)n, ClockUnit.SECONDS);
        C c = plainTimestamp.getCalendarDate().transform(chronology.getChronoType());
        return GeneralTimestamp.of(c, plainTime);
    }

    public <C extends CalendarVariant<C>> GeneralTimestamp<C> toGeneralTimestamp(CalendarFamily<C> calendarFamily, String string, TZID tZID, StartOfDay startOfDay) {
        PlainTimestamp plainTimestamp = this.toZonalTimestamp(tZID);
        PlainTime plainTime = plainTimestamp.getWallTime();
        int n = startOfDay.getDeviation(plainTimestamp.getCalendarDate(), tZID);
        plainTimestamp = plainTimestamp.minus((long)n, ClockUnit.SECONDS);
        Object t = plainTimestamp.getCalendarDate().transform(calendarFamily.getChronoType(), string);
        return GeneralTimestamp.of(t, plainTime);
    }

    public ZonalDateTime inLocalView() {
        return ZonalDateTime.of(this, Timezone.ofSystem());
    }

    public ZonalDateTime inZonalView(TZID tZID) {
        return ZonalDateTime.of(this, Timezone.of(tZID));
    }

    public ZonalDateTime inZonalView(String string) {
        return ZonalDateTime.of(this, Timezone.of(string));
    }

    @Override
    public Moment plus(long l, SI sI) {
        Moment moment;
        Moment.check1972(this);
        if (l == 0L) {
            return this;
        }
        try {
            switch (sI) {
                case SECONDS: {
                    if (LeapSeconds.getInstance().isEnabled()) {
                        moment = new Moment(Math.addExact(this.getEpochTime(), l), this.getNanosecond(), TimeScale.UTC);
                        break;
                    }
                    moment = Moment.of(Math.addExact(this.posixTime, l), this.getNanosecond(), TimeScale.POSIX);
                    break;
                }
                case NANOSECONDS: {
                    long l2 = Math.addExact((long)this.getNanosecond(), l);
                    int n = (int)Math.floorMod(l2, 1000000000L);
                    long l3 = Math.floorDiv(l2, 1000000000L);
                    if (LeapSeconds.getInstance().isEnabled()) {
                        moment = new Moment(Math.addExact(this.getEpochTime(), l3), n, TimeScale.UTC);
                        break;
                    }
                    moment = Moment.of(Math.addExact(this.posixTime, l3), n, TimeScale.POSIX);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ArithmeticException arithmeticException = new ArithmeticException("Result beyond boundaries of time axis.");
            arithmeticException.initCause(illegalArgumentException);
            throw arithmeticException;
        }
        if (l < 0L) {
            Moment.check1972(moment);
        }
        return moment;
    }

    @Override
    public Moment plus(RealTime<SI> realTime) {
        return this.plus(realTime.getSeconds(), SI.SECONDS).plus((long)realTime.getFraction(), SI.NANOSECONDS);
    }

    @Override
    public Moment minus(long l, SI sI) {
        return this.plus(Math.negateExact(l), sI);
    }

    @Override
    public Moment minus(RealTime<SI> realTime) {
        return this.minus(realTime.getSeconds(), SI.SECONDS).minus((long)realTime.getFraction(), SI.NANOSECONDS);
    }

    @Override
    public long until(Moment moment, SI sI) {
        return sI.between(this, moment);
    }

    public static <P extends ChronoPattern<P>> TemporalFormatter<Moment> localFormatter(String string, P p) {
        return FormatSupport.createFormatter(Moment.class, string, p, Locale.getDefault(), Timezone.ofSystem().getID());
    }

    public static TemporalFormatter<Moment> localFormatter(DisplayMode displayMode) {
        return Moment.formatter(displayMode, Locale.getDefault(), Timezone.ofSystem().getID());
    }

    public static <P extends ChronoPattern<P>> TemporalFormatter<Moment> formatter(String string, P p, Locale locale, TZID tZID) {
        return FormatSupport.createFormatter(Moment.class, string, p, locale, tZID);
    }

    public static TemporalFormatter<Moment> formatter(DisplayMode displayMode, Locale locale, TZID tZID) {
        String string = CalendarText.patternForMoment(displayMode, displayMode, locale);
        return FormatSupport.createFormatter(Moment.class, string, locale, tZID);
    }

    public static TemporalFormatter<Moment> formatterRFC1123() {
        return RFC1123.FORMATTER;
    }

    @Override
    public int compareTo(Moment moment) {
        long l;
        long l2 = this.getEpochTime();
        if (l2 < (l = moment.getEpochTime())) {
            return -1;
        }
        if (l2 > l) {
            return 1;
        }
        int n = this.getNanosecond() - moment.getNanosecond();
        return n > 0 ? 1 : (n < 0 ? -1 : 0);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Moment) {
            Moment moment = (Moment)object;
            if (this.posixTime != moment.posixTime) {
                return false;
            }
            if (LeapSeconds.getInstance().isEnabled()) {
                return this.fraction == moment.fraction;
            }
            return this.getNanosecond() == moment.getNanosecond();
        }
        return false;
    }

    @Override
    public int hashCode() {
        long l = this.posixTime ^ this.posixTime >>> 32;
        return 19 * (int)l + 37 * this.getNanosecond();
    }

    @Override
    public String toString() {
        PlainDate plainDate = this.getDateUTC();
        int n = Moment.getTimeOfDay(this);
        int n2 = n / 60;
        int n3 = n2 / 60;
        int n4 = n2 % 60;
        int n5 = n % 60;
        n5 += LeapSeconds.getInstance().getShift(this.getEpochTime());
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append(plainDate);
        stringBuilder.append('T');
        Moment.format(n3, 2, stringBuilder);
        stringBuilder.append(':');
        Moment.format(n4, 2, stringBuilder);
        stringBuilder.append(':');
        Moment.format(n5, 2, stringBuilder);
        int n6 = this.getNanosecond();
        if (n6 > 0) {
            stringBuilder.append(',');
            Moment.format(n6, 9, stringBuilder);
        }
        stringBuilder.append('Z');
        return stringBuilder.toString();
    }

    public String toString(TimeScale timeScale) {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append(timeScale.name());
        stringBuilder.append('-');
        switch (timeScale) {
            case POSIX: {
                stringBuilder.append(PlainTimestamp.from(this, ZonalOffset.UTC));
                stringBuilder.append('Z');
                break;
            }
            case UTC: {
                stringBuilder.append(this.toString());
                break;
            }
            case TAI: {
                Moment moment = this.transformForPrint(timeScale);
                stringBuilder.append(PlainTimestamp.from(moment, ZonalOffset.UTC));
                stringBuilder.append('Z');
                break;
            }
            case GPS: {
                Moment moment = this.transformForPrint(timeScale);
                stringBuilder.append(PlainTimestamp.from(moment, ZonalOffset.UTC));
                stringBuilder.append('Z');
                break;
            }
            default: {
                throw new UnsupportedOperationException(timeScale.name());
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public Instant toTemporalAccessor() {
        return TemporalType.INSTANT.from(this);
    }

    public static TimeAxis<TimeUnit, Moment> axis() {
        return ENGINE;
    }

    public static <S> Chronology<S> axis(Converter<S, Moment> converter) {
        return new BridgeChronology<S, Moment>(converter, ENGINE);
    }

    @Override
    protected TimeAxis<TimeUnit, Moment> getChronology() {
        return ENGINE;
    }

    @Override
    protected Moment getContext() {
        return this;
    }

    static void checkNegativeLS(long l, PlainTimestamp plainTimestamp) {
        LeapSeconds leapSeconds = LeapSeconds.getInstance();
        if (leapSeconds.supportsNegativeLS() && leapSeconds.strip(leapSeconds.enhance(l)) > l) {
            throw new ChronoException("Illegal local timestamp due to negative leap second: " + plainTimestamp);
        }
    }

    static void check1972(Moment moment) {
        if (moment.posixTime < 63072000L) {
            throw new UnsupportedOperationException("Cannot calculate SI-duration before 1972-01-01.");
        }
    }

    private long getEpochTime() {
        if (LeapSeconds.getInstance().isEnabled()) {
            long l = LeapSeconds.getInstance().enhance(this.posixTime);
            return this.isPositiveLS() ? l + 1L : l;
        }
        return this.posixTime - 63072000L;
    }

    private PlainDate getDateUTC() {
        return PlainDate.of(Math.floorDiv(this.posixTime, 86400L), EpochDays.UNIX);
    }

    private PlainTime getTimeUTC() {
        int n = Moment.getTimeOfDay(this);
        int n2 = n / 60;
        int n3 = n2 / 60;
        int n4 = n2 % 60;
        int n5 = n % 60;
        int n6 = this.getNanosecond();
        return PlainTime.of(n3, n4, n5, n6);
    }

    private boolean isPositiveLS() {
        return this.fraction >>> 30 != 0;
    }

    private boolean isNegativeLS() {
        LeapSeconds leapSeconds = LeapSeconds.getInstance();
        if (leapSeconds.supportsNegativeLS()) {
            long l = this.posixTime;
            return leapSeconds.strip(leapSeconds.enhance(l)) > l;
        }
        return false;
    }

    private static void checkUnixTime(long l) {
        if (l > MAX_LIMIT || l < MIN_LIMIT) {
            throw new IllegalArgumentException("UNIX time (UT1) out of supported range: " + l);
        }
    }

    private static void checkFraction(int n) {
        if (n >= 1000000000 || n < 0) {
            throw new IllegalArgumentException("Nanosecond out of range: " + n);
        }
    }

    private Moment transformForPrint(TimeScale timeScale) {
        switch (timeScale) {
            case POSIX: {
                if (this.isLeapSecond()) {
                    return new Moment(this.getNanosecond(), this.posixTime);
                }
                return this;
            }
            case UTC: {
                return this;
            }
            case TAI: {
                return new Moment(this.getNanosecond(), Math.addExact(this.getElapsedTime(TimeScale.TAI), 63072000L));
            }
            case GPS: {
                return new Moment(this.getNanosecond(), Math.addExact(this.getElapsedTime(TimeScale.GPS), 315964800L));
            }
        }
        throw new UnsupportedOperationException(timeScale.name());
    }

    private Moment transformForParse(TimeScale timeScale) {
        if (timeScale == TimeScale.UTC) {
            return this;
        }
        if (this.isLeapSecond()) {
            throw new IllegalArgumentException("Leap seconds do not exist on continuous time scale: " + (Object)((Object)timeScale));
        }
        switch (timeScale) {
            case POSIX: {
                return this;
            }
            case TAI: {
                return new Moment(Math.subtractExact(this.posixTime, 63072000L), this.getNanosecond(), timeScale);
            }
            case GPS: {
                return new Moment(Math.subtractExact(this.posixTime, 315964800L), this.getNanosecond(), timeScale);
            }
        }
        throw new UnsupportedOperationException(timeScale.name());
    }

    private static void format(int n, int n2, StringBuilder stringBuilder) {
        int n3 = 1;
        for (int i = 0; i < n2 - 1; ++i) {
            n3 *= 10;
        }
        while (n < n3 && n3 >= 10) {
            stringBuilder.append('0');
            n3 /= 10;
        }
        stringBuilder.append(String.valueOf(n));
    }

    private static int getTimeOfDay(Moment moment) {
        return (int)Math.floorMod(moment.posixTime, 86400L);
    }

    private static Moment moveEventuallyToLS(Moment moment) {
        PlainDate plainDate = moment.getDateUTC();
        PlainTime plainTime = moment.getTimeUTC();
        if (LeapSeconds.getInstance().getShift(plainDate) == 1 && plainTime.getHour() == 23 && plainTime.getMinute() == 59 && plainTime.getSecond() == 59) {
            return moment.plus(1L, SI.SECONDS);
        }
        return moment;
    }

    private PlainTimestamp in(Timezone timezone) {
        return PlainTimestamp.from(this, timezone.getOffset(this));
    }

    private static int getMaxSecondOfMinute(Moment moment) {
        int n = Moment.getTimeOfDay(moment) / 60;
        int n2 = 59;
        if (n / 60 == 23 && n % 60 == 59) {
            PlainDate plainDate = moment.getDateUTC();
            n2 += LeapSeconds.getInstance().getShift(plainDate);
        }
        return n2;
    }

    private Object writeReplace() {
        return new SPX(this, 4);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void writeTimestamp(DataOutput dataOutput) throws IOException {
        int n;
        int n2 = 4;
        n2 <<= 4;
        if (this.isPositiveLS()) {
            n2 |= 1;
        }
        if ((n = this.getNanosecond()) > 0) {
            n2 |= 2;
        }
        dataOutput.writeByte(n2);
        dataOutput.writeLong(this.posixTime);
        if (n > 0) {
            dataOutput.writeInt(n);
        }
    }

    static Moment readTimestamp(DataInput dataInput, boolean bl, boolean bl2) throws IOException {
        int n;
        long l = dataInput.readLong();
        int n2 = n = bl2 ? dataInput.readInt() : 0;
        if (l == 0L) {
            if (bl) {
                throw new InvalidObjectException("UTC epoch is no leap second.");
            }
            if (n == 0) {
                return UNIX_EPOCH;
            }
        }
        if (l == MIN_LIMIT && n == 0) {
            if (bl) {
                throw new InvalidObjectException("Minimum is no leap second.");
            }
            return MIN;
        }
        if (l == MAX_LIMIT && n == 999999999) {
            if (bl) {
                throw new InvalidObjectException("Maximum is no leap second.");
            }
            return MAX;
        }
        Moment.checkFraction(n);
        if (bl) {
            LeapSeconds leapSeconds = LeapSeconds.getInstance();
            if (!leapSeconds.isEnabled() || leapSeconds.isPositiveLS(leapSeconds.enhance(l) + 1L)) {
                n |= 0x40000000;
            } else {
                long l2 = GregorianMath.toPackedDate(l);
                int n3 = GregorianMath.readMonth(l2);
                int n4 = GregorianMath.readDayOfMonth(l2);
                throw new InvalidObjectException("Not registered as leap second event: " + GregorianMath.readYear(l2) + "-" + (n3 < 10 ? "0" : "") + n3 + (n4 < 10 ? "0" : "") + n4 + " [Please check leap second configurations " + "either of emitter vm or this target vm]");
            }
        }
        return new Moment(n, l);
    }

    static {
        long l = GregorianMath.toMJD(-999999999, 1, 1);
        long l2 = GregorianMath.toMJD(999999999, 12, 31);
        MIN_LIMIT = EpochDays.UNIX.transform(l, EpochDays.MODIFIED_JULIAN_DATE) * 86400L;
        MAX_LIMIT = EpochDays.UNIX.transform(l2, EpochDays.MODIFIED_JULIAN_DATE) * 86400L + 86399L;
        MIN = new Moment(MIN_LIMIT, 0, TimeScale.POSIX);
        MAX = new Moment(MAX_LIMIT, 999999999, TimeScale.POSIX);
        START_LS_CHECK = new Moment(63158400L, 0, TimeScale.POSIX);
        Object object = new HashSet<ZonalElement<Object>>();
        object.add(PlainTime.ISO_HOUR);
        object.add(PlainTime.DIGITAL_HOUR_OF_DAY);
        object.add(PlainTime.DIGITAL_HOUR_OF_AMPM);
        object.add(PlainTime.CLOCK_HOUR_OF_DAY);
        object.add(PlainTime.CLOCK_HOUR_OF_AMPM);
        object.add(PlainTime.AM_PM_OF_DAY);
        object.add(PlainTime.MINUTE_OF_HOUR);
        object.add(PlainTime.MINUTE_OF_DAY);
        HIGH_TIME_ELEMENTS = Collections.unmodifiableSet(object);
        TimeUnit[] timeUnitArray = new HashMap();
        timeUnitArray.put(PlainTime.SECOND_OF_MINUTE, 1);
        timeUnitArray.put(PlainTime.SECOND_OF_DAY, 1);
        timeUnitArray.put(PlainTime.MILLI_OF_SECOND, 1000);
        timeUnitArray.put(PlainTime.MILLI_OF_DAY, 1000);
        timeUnitArray.put(PlainTime.MICRO_OF_SECOND, 1000000);
        timeUnitArray.put(PlainTime.MICRO_OF_DAY, 1000000);
        timeUnitArray.put(PlainTime.NANO_OF_SECOND, 1000000000);
        timeUnitArray.put(PlainTime.NANO_OF_DAY, 1000000000);
        LOW_TIME_ELEMENTS = Collections.unmodifiableMap(timeUnitArray);
        EnumMap<TimeUnit, Double> enumMap = new EnumMap<TimeUnit, Double>(TimeUnit.class);
        enumMap.put(TimeUnit.DAYS, 86400.0);
        enumMap.put(TimeUnit.HOURS, 3600.0);
        enumMap.put(TimeUnit.MINUTES, 60.0);
        enumMap.put(TimeUnit.SECONDS, 1.0);
        enumMap.put(TimeUnit.MILLISECONDS, 0.001);
        enumMap.put(TimeUnit.MICROSECONDS, 1.0E-6);
        enumMap.put(TimeUnit.NANOSECONDS, 1.0E-9);
        UNIT_LENGTHS = Collections.unmodifiableMap(enumMap);
        object = TimeAxis.Builder.setUp(TimeUnit.class, Moment.class, new Merger(), MIN, MAX);
        for (TimeUnit timeUnit : TimeUnit.values()) {
            ((TimeAxis.Builder)object).appendUnit(timeUnit, new TimeUnitRule(timeUnit), UNIT_LENGTHS.get((Object)timeUnit), UNIT_LENGTHS.keySet());
        }
        ((TimeAxis.Builder)object).appendElement(LongElement.POSIX_TIME, LongElement.POSIX_TIME, TimeUnit.SECONDS);
        ((TimeAxis.Builder)object).appendElement(IntElement.FRACTION, IntElement.FRACTION, TimeUnit.NANOSECONDS);
        ((TimeAxis.Builder)object).appendElement((ChronoElement)PrecisionElement.TIME_PRECISION, (ElementRule)new PrecisionRule());
        ENGINE = ((TimeAxis.Builder)object).withTimeLine(new GlobalTimeLine()).build();
        UNIX_EPOCH = new Moment(0L, 0, TimeScale.POSIX);
        POSIX_TIME = LongElement.POSIX_TIME;
        FRACTION = IntElement.FRACTION;
        PRECISION = PrecisionElement.TIME_PRECISION;
        NEXT_LS = new NextLS();
    }

    private static class RFC1123 {
        static final TemporalFormatter<Moment> FORMATTER = FormatSupport.getDefaultFormatEngine().createRFC1123();

        private RFC1123() {
        }
    }

    private static class PrecisionRule
    implements ElementRule<Moment, TimeUnit> {
        private PrecisionRule() {
        }

        @Override
        public TimeUnit getValue(Moment moment) {
            int n = moment.getNanosecond();
            if (n != 0) {
                if (n % 1000000 == 0) {
                    return TimeUnit.MILLISECONDS;
                }
                if (n % 1000 == 0) {
                    return TimeUnit.MICROSECONDS;
                }
                return TimeUnit.NANOSECONDS;
            }
            long l = moment.posixTime;
            if (Math.floorMod(l, 86400L) == 0L) {
                return TimeUnit.DAYS;
            }
            if (Math.floorMod(l, 3600L) == 0L) {
                return TimeUnit.HOURS;
            }
            if (Math.floorMod(l, 60L) == 0L) {
                return TimeUnit.MINUTES;
            }
            return TimeUnit.SECONDS;
        }

        @Override
        public Moment withValue(Moment moment, TimeUnit timeUnit, boolean bl) {
            Moment moment2;
            if (timeUnit == null) {
                throw new IllegalArgumentException("Missing precision.");
            }
            switch (timeUnit) {
                case DAYS: {
                    long l = Math.floorDiv(moment.posixTime, 86400L) * 86400L;
                    return Moment.of(l, TimeScale.POSIX);
                }
                case HOURS: {
                    long l = Math.floorDiv(moment.posixTime, 3600L) * 3600L;
                    return Moment.of(l, TimeScale.POSIX);
                }
                case MINUTES: {
                    long l = Math.floorDiv(moment.posixTime, 60L) * 60L;
                    return Moment.of(l, TimeScale.POSIX);
                }
                case SECONDS: {
                    moment2 = Moment.of(moment.posixTime, 0, TimeScale.POSIX);
                    break;
                }
                case MILLISECONDS: {
                    int n = moment.getNanosecond() / 1000000 * 1000000;
                    moment2 = Moment.of(moment.posixTime, n, TimeScale.POSIX);
                    break;
                }
                case MICROSECONDS: {
                    int n = moment.getNanosecond() / 1000 * 1000;
                    moment2 = Moment.of(moment.posixTime, n, TimeScale.POSIX);
                    break;
                }
                case NANOSECONDS: {
                    return moment;
                }
                default: {
                    throw new UnsupportedOperationException(timeUnit.name());
                }
            }
            if (moment.isLeapSecond() && LeapSeconds.getInstance().isEnabled()) {
                return moment2.plus(1L, SI.SECONDS);
            }
            return moment2;
        }

        @Override
        public boolean isValid(Moment moment, TimeUnit timeUnit) {
            return timeUnit != null;
        }

        @Override
        public TimeUnit getMinimum(Moment moment) {
            return TimeUnit.DAYS;
        }

        @Override
        public TimeUnit getMaximum(Moment moment) {
            return TimeUnit.NANOSECONDS;
        }

        @Override
        public ChronoElement<?> getChildAtFloor(Moment moment) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(Moment moment) {
            return null;
        }
    }

    private static class NextLS
    implements ChronoOperator<Moment> {
        private NextLS() {
        }

        @Override
        public Moment apply(Moment moment) {
            long l;
            LeapSecondEvent leapSecondEvent;
            LeapSeconds leapSeconds = LeapSeconds.getInstance();
            if (leapSeconds.isEnabled() && (leapSecondEvent = leapSeconds.getNextEvent(l = moment.getElapsedTime(TimeScale.UTC))) != null) {
                PlainTimestamp plainTimestamp = PlainDate.from(leapSecondEvent.getDate()).atTime(23, 59, 59);
                return plainTimestamp.atUTC().plus((long)leapSecondEvent.getShift(), SI.SECONDS);
            }
            return null;
        }
    }

    private static class GlobalTimeLine
    implements TimeLine<Moment> {
        private GlobalTimeLine() {
        }

        @Override
        public Moment stepForward(Moment moment) {
            try {
                if (GlobalTimeLine.useSI(moment)) {
                    return moment.plus(1L, SI.NANOSECONDS);
                }
                return (Moment)moment.plus(1L, TimeUnit.NANOSECONDS);
            }
            catch (ArithmeticException arithmeticException) {
                return null;
            }
        }

        @Override
        public Moment stepBackwards(Moment moment) {
            try {
                if (GlobalTimeLine.useSI(moment)) {
                    return moment.minus(1L, SI.NANOSECONDS);
                }
                return (Moment)moment.minus(1L, TimeUnit.NANOSECONDS);
            }
            catch (ArithmeticException arithmeticException) {
                return null;
            }
        }

        @Override
        public Moment getMinimum() {
            return MIN;
        }

        @Override
        public Moment getMaximum() {
            return MAX;
        }

        @Override
        public int compare(Moment moment, Moment moment2) {
            return moment.compareTo(moment2);
        }

        private static boolean useSI(Moment moment) {
            return moment.posixTime > 63072000L && LeapSeconds.getInstance().isEnabled();
        }
    }

    private static class Merger
    implements ChronoMerger<Moment> {
        private Merger() {
        }

        @Override
        public String getFormatPattern(DisplayStyle displayStyle, Locale locale) {
            DisplayMode displayMode = DisplayMode.ofStyle(displayStyle.getStyleValue());
            return CalendarText.patternForMoment(displayMode, displayMode, locale);
        }

        @Override
        public Moment createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            return Moment.from(timeSource.currentTime());
        }

        @Override
        @Deprecated
        public Moment createFrom(TemporalAccessor temporalAccessor, AttributeQuery attributeQuery) {
            if (temporalAccessor.isSupported(ChronoField.INSTANT_SECONDS)) {
                long l = temporalAccessor.getLong(ChronoField.INSTANT_SECONDS);
                int n = 0;
                if (temporalAccessor.isSupported(ChronoField.NANO_OF_SECOND)) {
                    n = temporalAccessor.get(ChronoField.NANO_OF_SECOND);
                }
                Moment moment = Moment.of(l, n, TimeScale.POSIX);
                if (temporalAccessor.query(DateTimeFormatter.parsedLeapSecond()).booleanValue() && !(moment = moment.plus(1L, SI.SECONDS)).isLeapSecond()) {
                    throw new IllegalArgumentException("Parsed leap second is invalid.");
                }
                return moment;
            }
            PlainTimestamp plainTimestamp = (PlainTimestamp)PlainTimestamp.axis().createFrom(temporalAccessor, attributeQuery);
            if (plainTimestamp != null) {
                TZID tZID = null;
                if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                    tZID = attributeQuery.get(Attributes.TIMEZONE_ID);
                }
                if (tZID != null) {
                    if (attributeQuery.contains(Attributes.TRANSITION_STRATEGY)) {
                        TransitionStrategy transitionStrategy = attributeQuery.get(Attributes.TRANSITION_STRATEGY);
                        return plainTimestamp.in(Timezone.of(tZID).with(transitionStrategy));
                    }
                    return plainTimestamp.inTimezone(tZID);
                }
            }
            return null;
        }

        @Override
        @Deprecated
        public Moment createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
            boolean bl2 = attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax();
            return this.createFrom((ChronoEntity)chronoEntity, attributeQuery, bl2, bl);
        }

        @Override
        public Moment createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            Object object;
            ChronoElement<PlainTimestamp> chronoElement;
            PlainTimestamp plainTimestamp;
            TimeScale timeScale = attributeQuery.get(Attributes.TIME_SCALE, TimeScale.UTC);
            if (chronoEntity instanceof UnixTime) {
                return Moment.from((UnixTime)UnixTime.class.cast(chronoEntity)).transformForParse(timeScale);
            }
            if (chronoEntity.contains(LongElement.POSIX_TIME)) {
                long l = chronoEntity.get(LongElement.POSIX_TIME);
                int n = 0;
                if (chronoEntity.contains(IntElement.FRACTION)) {
                    n = chronoEntity.get(IntElement.FRACTION);
                }
                return Moment.of(l, n, TimeScale.POSIX).transformForParse(timeScale);
            }
            Object object2 = null;
            boolean bl3 = false;
            if (chronoEntity.contains(FlagElement.LEAP_SECOND)) {
                bl3 = true;
                chronoEntity.with((ChronoElement<Integer>)PlainTime.SECOND_OF_MINUTE, 60);
            }
            if ((plainTimestamp = chronoEntity.contains(chronoElement = PlainTimestamp.axis().element()) ? chronoEntity.get(chronoElement) : (PlainTimestamp)PlainTimestamp.axis().createFrom((ChronoEntity)chronoEntity, attributeQuery, bl, bl2)) == null) {
                return null;
            }
            TZID tZID = null;
            if (chronoEntity.hasTimezone()) {
                tZID = chronoEntity.getTimezone();
            } else if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                tZID = attributeQuery.get(Attributes.TIMEZONE_ID);
            }
            if (tZID != null) {
                if (chronoEntity.contains(FlagElement.DAYLIGHT_SAVING)) {
                    boolean bl4;
                    object = attributeQuery.get(Attributes.TRANSITION_STRATEGY, Timezone.DEFAULT_CONFLICT_STRATEGY).using((bl4 = chronoEntity.get(FlagElement.DAYLIGHT_SAVING).booleanValue()) ? OverlapResolver.EARLIER_OFFSET : OverlapResolver.LATER_OFFSET);
                    object2 = plainTimestamp.in(Timezone.of(tZID).with((TransitionStrategy)object));
                } else if (attributeQuery.contains(Attributes.TRANSITION_STRATEGY)) {
                    TransitionStrategy transitionStrategy = attributeQuery.get(Attributes.TRANSITION_STRATEGY);
                    object2 = plainTimestamp.in(Timezone.of(tZID).with(transitionStrategy));
                } else {
                    object2 = plainTimestamp.inTimezone(tZID);
                }
            }
            if (object2 == null) {
                return null;
            }
            if (bl3) {
                ZonalOffset zonalOffset = tZID instanceof ZonalOffset ? (ZonalOffset)tZID : Timezone.of(tZID).getOffset((UnixTime)object2);
                if (zonalOffset.getFractionalAmount() != 0 || zonalOffset.getAbsoluteSeconds() % 60 != 0) {
                    throw new IllegalArgumentException("Leap second is only allowed  with timezone-offset in full minutes: " + zonalOffset);
                }
                object = ((Moment)object2).getDateUTC().getYear() >= 1972 ? ((Moment)object2).plus(1L, SI.SECONDS) : new Moment(((Moment)object2).getNanosecond(), ((Moment)object2).getPosixTime() + 1L);
                if (bl) {
                    object2 = object;
                } else if (LeapSeconds.getInstance().isEnabled()) {
                    if (((Moment)object).isPositiveLS()) {
                        object2 = object;
                    } else {
                        throw new IllegalArgumentException("SECOND_OF_MINUTE parsed as invalid leapsecond before " + object);
                    }
                }
            }
            return ((Moment)object2).transformForParse(timeScale);
        }

        @Override
        public ChronoDisplay preformat(Moment moment, AttributeQuery attributeQuery) {
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                TZID tZID = attributeQuery.get(Attributes.TIMEZONE_ID);
                TimeScale timeScale = attributeQuery.get(Attributes.TIME_SCALE, TimeScale.UTC);
                return moment.transformForPrint(timeScale).inZonalView(tZID);
            }
            throw new IllegalArgumentException("Cannot print moment without timezone.");
        }

        @Override
        public Chronology<?> preparser() {
            return PlainTimestamp.axis();
        }
    }

    private static enum IntElement implements ChronoElement<Integer>,
    ElementRule<Moment, Integer>
    {
        FRACTION;


        @Override
        public Class<Integer> getType() {
            return Integer.class;
        }

        @Override
        public char getSymbol() {
            return '\u0000';
        }

        @Override
        public int compare(ChronoDisplay chronoDisplay, ChronoDisplay chronoDisplay2) {
            return chronoDisplay.get(this).compareTo(chronoDisplay2.get(this));
        }

        @Override
        public Integer getDefaultMinimum() {
            return 0;
        }

        @Override
        public Integer getDefaultMaximum() {
            return 999999999;
        }

        @Override
        public boolean isDateElement() {
            return false;
        }

        @Override
        public boolean isTimeElement() {
            return false;
        }

        @Override
        public boolean isLenient() {
            return false;
        }

        @Override
        public Integer getValue(Moment moment) {
            return moment.getNanosecond();
        }

        @Override
        public Integer getMinimum(Moment moment) {
            return this.getDefaultMinimum();
        }

        @Override
        public Integer getMaximum(Moment moment) {
            return this.getDefaultMaximum();
        }

        @Override
        public boolean isValid(Moment moment, Integer n) {
            if (n == null) {
                return false;
            }
            int n2 = n;
            return n2 >= 0 && n2 < 1000000000;
        }

        @Override
        public Moment withValue(Moment moment, Integer n, boolean bl) {
            if (n == null) {
                throw new IllegalArgumentException("Missing fraction value.");
            }
            if (LeapSeconds.getInstance().isEnabled()) {
                return Moment.of(moment.getElapsedTime(TimeScale.UTC), n, TimeScale.UTC);
            }
            return Moment.of(moment.getPosixTime(), n, TimeScale.POSIX);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(Moment moment) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(Moment moment) {
            return null;
        }
    }

    private static enum LongElement implements ChronoElement<Long>,
    ElementRule<Moment, Long>
    {
        POSIX_TIME;


        @Override
        public Class<Long> getType() {
            return Long.class;
        }

        @Override
        public char getSymbol() {
            return '\u0000';
        }

        @Override
        public int compare(ChronoDisplay chronoDisplay, ChronoDisplay chronoDisplay2) {
            return chronoDisplay.get(this).compareTo(chronoDisplay2.get(this));
        }

        @Override
        public Long getDefaultMinimum() {
            return MIN_LIMIT;
        }

        @Override
        public Long getDefaultMaximum() {
            return MAX_LIMIT;
        }

        @Override
        public boolean isDateElement() {
            return false;
        }

        @Override
        public boolean isTimeElement() {
            return false;
        }

        @Override
        public boolean isLenient() {
            return false;
        }

        @Override
        public Long getValue(Moment moment) {
            return moment.getPosixTime();
        }

        @Override
        public Long getMinimum(Moment moment) {
            return MIN_LIMIT;
        }

        @Override
        public Long getMaximum(Moment moment) {
            return MAX_LIMIT;
        }

        @Override
        public boolean isValid(Moment moment, Long l) {
            if (l == null) {
                return false;
            }
            long l2 = l;
            return l2 >= MIN_LIMIT && l2 <= MAX_LIMIT;
        }

        @Override
        public Moment withValue(Moment moment, Long l, boolean bl) {
            if (l == null) {
                throw new IllegalArgumentException("Missing elapsed seconds.");
            }
            return Moment.of(l, moment.getNanosecond(), TimeScale.POSIX);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(Moment moment) {
            return IntElement.FRACTION;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(Moment moment) {
            return IntElement.FRACTION;
        }
    }

    private static class TimeUnitRule
    implements UnitRule<Moment> {
        private final TimeUnit unit;

        TimeUnitRule(TimeUnit timeUnit) {
            this.unit = timeUnit;
        }

        @Override
        public Moment addTo(Moment moment, long l) {
            if (this.unit.compareTo(TimeUnit.SECONDS) >= 0) {
                long l2 = Math.multiplyExact(l, this.unit.toSeconds(1L));
                return Moment.of(Math.addExact(moment.getPosixTime(), l2), moment.getNanosecond(), TimeScale.POSIX);
            }
            long l3 = Math.multiplyExact(l, this.unit.toNanos(1L));
            long l4 = Math.addExact((long)moment.getNanosecond(), l3);
            int n = (int)Math.floorMod(l4, 1000000000L);
            long l5 = Math.floorDiv(l4, 1000000000L);
            return Moment.of(Math.addExact(moment.getPosixTime(), l5), n, TimeScale.POSIX);
        }

        @Override
        public long between(Moment moment, Moment moment2) {
            long l;
            if (this.unit.compareTo(TimeUnit.SECONDS) >= 0) {
                l = moment2.getPosixTime() - moment.getPosixTime();
                if (l < 0L) {
                    if (moment2.getNanosecond() > moment.getNanosecond()) {
                        ++l;
                    }
                } else if (l > 0L && moment2.getNanosecond() < moment.getNanosecond()) {
                    --l;
                }
            } else {
                l = Math.addExact(Math.multiplyExact(Math.subtractExact(moment2.getPosixTime(), moment.getPosixTime()), 1000000000L), (long)(moment2.getNanosecond() - moment.getNanosecond()));
            }
            switch (this.unit) {
                case DAYS: {
                    l /= 86400L;
                    break;
                }
                case HOURS: {
                    l /= 3600L;
                    break;
                }
                case MINUTES: {
                    l /= 60L;
                    break;
                }
                case SECONDS: {
                    break;
                }
                case MILLISECONDS: {
                    l /= 1000000L;
                    break;
                }
                case MICROSECONDS: {
                    l /= 1000L;
                    break;
                }
                case NANOSECONDS: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this.unit.name());
                }
            }
            return l;
        }
    }

    static final class Operator
    implements ChronoOperator<Moment> {
        private final ChronoOperator<PlainTimestamp> delegate;
        private final ChronoElement<?> element;
        private final int type;
        private final Timezone tz;

        Operator(ChronoOperator<PlainTimestamp> chronoOperator, ChronoElement<?> chronoElement, int n) {
            this.delegate = chronoOperator;
            this.element = chronoElement;
            this.type = n;
            this.tz = null;
        }

        Operator(ChronoOperator<PlainTimestamp> chronoOperator, ChronoElement<?> chronoElement, int n, Timezone timezone) {
            this.delegate = chronoOperator;
            this.element = chronoElement;
            this.type = n;
            this.tz = timezone;
        }

        @Override
        public Moment apply(Moment moment) {
            Timezone timezone;
            Timezone timezone2 = timezone = this.tz == null ? Timezone.ofSystem() : this.tz;
            if (moment.isLeapSecond() && Operator.isNonIsoOffset(timezone, moment)) {
                throw new IllegalArgumentException("Leap second can only be adjusted  with timezone-offset in full minutes: " + timezone.getOffset(moment));
            }
            if (moment.isAfter(START_LS_CHECK)) {
                if (this.element == PlainTime.SECOND_OF_MINUTE && this.type == -1 && this.extractValue() == 60L) {
                    if (moment.isLeapSecond()) {
                        return moment;
                    }
                    if (Operator.isNonIsoOffset(timezone, moment)) {
                        throw new IllegalArgumentException("Leap second can only be set  with timezone-offset in full minutes: " + timezone.getOffset(moment));
                    }
                    if (Moment.getMaxSecondOfMinute(moment) == 60) {
                        return moment.plus(Math.subtractExact(60L, this.extractOld(moment)), SI.SECONDS);
                    }
                    throw new IllegalArgumentException("Leap second invalid in context: " + moment);
                }
                if (LOW_TIME_ELEMENTS.containsKey(this.element) && (this.type == 2 || this.type == 3 || this.type == 6)) {
                    int n = (Integer)LOW_TIME_ELEMENTS.get(this.element);
                    long l = 1L;
                    if (this.type == 2) {
                        l = -1L;
                    } else if (this.type == 6) {
                        long l2 = this.extractOld(moment);
                        long l3 = this.extractValue();
                        l = Math.subtractExact(l3, l2);
                    }
                    switch (n) {
                        case 1: {
                            return moment.plus(l, SI.SECONDS);
                        }
                        case 1000: {
                            return moment.plus(Math.multiplyExact(1000000L, l), SI.NANOSECONDS);
                        }
                        case 1000000: {
                            return moment.plus(Math.multiplyExact(1000L, l), SI.NANOSECONDS);
                        }
                        case 1000000000: {
                            return moment.plus(l, SI.NANOSECONDS);
                        }
                    }
                    throw new AssertionError();
                }
            }
            PlainTimestamp plainTimestamp = moment.in(timezone).with(this.delegate);
            Moment moment2 = plainTimestamp.in(timezone);
            if (this.type == 4) {
                return moment2;
            }
            if (moment2.isNegativeLS()) {
                if (this.tz.getStrategy() == Timezone.STRICT_MODE) {
                    throw new ChronoException("Illegal local timestamp due to negative leap second: " + plainTimestamp);
                }
                return moment2;
            }
            if (this.element.isDateElement() || HIGH_TIME_ELEMENTS.contains(this.element)) {
                if (moment.isLeapSecond() || this.type == 5) {
                    return Moment.moveEventuallyToLS(moment2);
                }
            } else if (this.element == PlainTime.SECOND_OF_MINUTE) {
                if (this.type == 1 || this.type == 5) {
                    return Moment.moveEventuallyToLS(moment2);
                }
            } else if (this.element == PlainTime.MILLI_OF_SECOND || this.element == PlainTime.MICRO_OF_SECOND || this.element == PlainTime.NANO_OF_SECOND) {
                switch (this.type) {
                    case -1: 
                    case 0: 
                    case 1: 
                    case 5: {
                        if (!moment.isLeapSecond()) break;
                        moment2 = moment2.plus(1L, SI.SECONDS);
                        break;
                    }
                }
            }
            return moment2;
        }

        private long extractOld(Moment moment) {
            return ((Number)Number.class.cast(moment.getTimeUTC().get(this.element))).longValue();
        }

        private long extractValue() {
            Object object = ((ValueOperator)ValueOperator.class.cast(this.delegate)).getValue();
            if (object == null) {
                throw new IllegalArgumentException("Missing new element value.");
            }
            return ((Number)Number.class.cast(object)).longValue();
        }

        private static boolean isNonIsoOffset(Timezone timezone, Moment moment) {
            ZonalOffset zonalOffset = timezone.getOffset(moment);
            return zonalOffset.getFractionalAmount() != 0 || zonalOffset.getAbsoluteSeconds() % 60 != 0;
        }
    }
}

