/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.util.Locale;
import net.time4j.base.WallTime;
import net.time4j.engine.ChronoCondition;
import net.time4j.format.CalendarText;
import net.time4j.format.TextWidth;

public enum Meridiem implements ChronoCondition<WallTime>
{
    AM,
    PM;


    public static Meridiem ofHour(int n) {
        if (n >= 0 && n <= 24) {
            return n < 12 || n == 24 ? AM : PM;
        }
        throw new IllegalArgumentException("Hour of day out of range: " + n);
    }

    public String getDisplayName(Locale locale) {
        return CalendarText.getIsoInstance(locale).getMeridiems(TextWidth.WIDE).print(this);
    }

    @Override
    public boolean test(WallTime wallTime) {
        int n = wallTime.getHour();
        return this == AM ? n < 12 || n == 24 : n >= 12 && n < 24;
    }
}

