/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.scale;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import net.time4j.base.GregorianDate;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.base.ResourceLoader;
import net.time4j.base.UnixTime;
import net.time4j.scale.ExtendedLSE;
import net.time4j.scale.LeapSecondEvent;
import net.time4j.scale.LeapSecondProvider;

public final class LeapSeconds
implements Iterable<LeapSecondEvent>,
Comparator<LeapSecondEvent> {
    public static final boolean SUPPRESS_UTC_LEAPSECONDS = Boolean.getBoolean("net.time4j.scale.leapseconds.suppressed");
    public static final boolean FINAL_UTC_LEAPSECONDS = Boolean.getBoolean("net.time4j.scale.leapseconds.final");
    public static final String PATH_TO_LEAPSECONDS = System.getProperty("net.time4j.scale.leapseconds.path", "data/leapseconds.data");
    private static final ExtendedLSE[] EMPTY_ARRAY = new ExtendedLSE[0];
    private static final LeapSeconds INSTANCE = new LeapSeconds();
    private static final long UNIX_OFFSET = 63072000L;
    private static final long MJD_OFFSET = 40587L;
    private final LeapSecondProvider provider;
    private final List<ExtendedLSE> list;
    private final ExtendedLSE[] reverseFinal;
    private volatile ExtendedLSE[] reverseVolatile;
    private final boolean supportsNegativeLS;

    /*
     * WARNING - void declaration
     */
    private LeapSeconds() {
        LeapSecondProvider object = null;
        int n = 0;
        if (!SUPPRESS_UTC_LEAPSECONDS) {
            for (LeapSecondProvider object2 : ResourceLoader.getInstance().services(LeapSecondProvider.class)) {
                int bl2 = object2.getLeapSecondTable().size();
                if (bl2 <= n) continue;
                object = object2;
                n = bl2;
            }
        }
        if (object == null || n == 0) {
            this.provider = null;
            this.list = Collections.emptyList();
            this.reverseFinal = EMPTY_ARRAY;
            this.reverseVolatile = EMPTY_ARRAY;
            this.supportsNegativeLS = false;
        } else {
            TreeSet<LeapSecondEvent> treeSet = new TreeSet<LeapSecondEvent>(this);
            for (Map.Entry<GregorianDate, Integer> entry : object.getLeapSecondTable().entrySet()) {
                GregorianDate gregorianDate = entry.getKey();
                long l = LeapSeconds.toPosix(gregorianDate);
                treeSet.add(new SimpleLeapSecondEvent(gregorianDate, Long.MIN_VALUE, l + -62985600L - 1L, entry.getValue()));
            }
            LeapSeconds.extend((SortedSet<ExtendedLSE>)treeSet);
            this.list = FINAL_UTC_LEAPSECONDS ? Collections.unmodifiableList(new ArrayList(treeSet)) : new CopyOnWriteArrayList<ExtendedLSE>(treeSet);
            this.reverseFinal = this.initReverse();
            this.reverseVolatile = this.reverseFinal;
            this.provider = object;
            if (FINAL_UTC_LEAPSECONDS) {
                void var4_7;
                boolean bl = object.supportsNegativeLS();
                if (bl) {
                    boolean bl2;
                    boolean bl3 = false;
                    for (ExtendedLSE extendedLSE : this.list) {
                        if (extendedLSE.getShift() >= 0) continue;
                        bl2 = true;
                        break;
                    }
                    var4_7 = bl2;
                }
                this.supportsNegativeLS = var4_7;
            } else {
                this.supportsNegativeLS = true;
            }
        }
    }

    public static LeapSeconds getInstance() {
        return INSTANCE;
    }

    public boolean isEnabled() {
        return !this.list.isEmpty();
    }

    public boolean isExtensible() {
        return !FINAL_UTC_LEAPSECONDS && this.isEnabled();
    }

    public int getCount() {
        return this.getEventsInDescendingOrder().length;
    }

    public int getCount(UnixTime unixTime) {
        long l = unixTime.getPosixTime();
        return MathUtils.safeCast(this.enhance(l) + 63072000L - l);
    }

    public void registerPositiveLS(int n, int n2, int n3) {
        this.register(n, n2, n3, false);
    }

    public void registerNegativeLS(int n, int n2, int n3) {
        this.register(n, n2, n3, true);
    }

    public boolean supportsNegativeLS() {
        return this.supportsNegativeLS;
    }

    @Override
    public Iterator<LeapSecondEvent> iterator() {
        ExtendedLSE[] extendedLSEArray = this.getEventsInDescendingOrder();
        return Collections.unmodifiableList(Arrays.asList(extendedLSEArray)).iterator();
    }

    public Stream<LeapSecondEvent> stream() {
        return Arrays.stream(this.getEventsInDescendingOrder());
    }

    public int getShift(GregorianDate gregorianDate) {
        int n = gregorianDate.getYear();
        if (n >= 1972) {
            ExtendedLSE[] extendedLSEArray = this.getEventsInDescendingOrder();
            for (int i = 0; i < extendedLSEArray.length; ++i) {
                ExtendedLSE extendedLSE = extendedLSEArray[i];
                GregorianDate gregorianDate2 = extendedLSE.getDate();
                if (n != gregorianDate2.getYear() || gregorianDate.getMonth() != gregorianDate2.getMonth() || gregorianDate.getDayOfMonth() != gregorianDate2.getDayOfMonth()) continue;
                return extendedLSE.getShift();
            }
        }
        return 0;
    }

    public int getShift(long l) {
        if (l <= 0L) {
            return 0;
        }
        ExtendedLSE[] extendedLSEArray = this.getEventsInDescendingOrder();
        for (int i = 0; i < extendedLSEArray.length; ++i) {
            ExtendedLSE extendedLSE = extendedLSEArray[i];
            if (l > extendedLSE.utc()) {
                return 0;
            }
            long l2 = extendedLSE.utc() - (long)extendedLSE.getShift();
            if (l <= l2) continue;
            return (int)(l - l2);
        }
        return 0;
    }

    public LeapSecondEvent getNextEvent(long l) {
        ExtendedLSE extendedLSE;
        ExtendedLSE[] extendedLSEArray = this.getEventsInDescendingOrder();
        ExtendedLSE extendedLSE2 = null;
        for (int i = 0; i < extendedLSEArray.length && l < (extendedLSE = extendedLSEArray[i]).utc(); ++i) {
            extendedLSE2 = extendedLSE;
        }
        return extendedLSE2;
    }

    public long enhance(long l) {
        long l2 = l - 63072000L;
        if (l <= 0L) {
            return l2;
        }
        ExtendedLSE[] extendedLSEArray = this.getEventsInDescendingOrder();
        for (int i = 0; i < extendedLSEArray.length; ++i) {
            ExtendedLSE extendedLSE = extendedLSEArray[i];
            if (extendedLSE.raw() >= l2) continue;
            return Math.addExact(l2, extendedLSE.utc() - extendedLSE.raw());
        }
        return l2;
    }

    public long strip(long l) {
        if (l <= 0L) {
            return l + 63072000L;
        }
        ExtendedLSE[] extendedLSEArray = this.getEventsInDescendingOrder();
        boolean bl = this.supportsNegativeLS;
        for (int i = 0; i < extendedLSEArray.length; ++i) {
            ExtendedLSE extendedLSE = extendedLSEArray[i];
            if (extendedLSE.utc() - (long)extendedLSE.getShift() >= l && (!bl || extendedLSE.getShift() >= 0 || extendedLSE.utc() >= l)) continue;
            l = Math.addExact(l, extendedLSE.raw() - extendedLSE.utc());
            break;
        }
        return l + 63072000L;
    }

    public boolean isPositiveLS(long l) {
        if (l <= 0L) {
            return false;
        }
        ExtendedLSE[] extendedLSEArray = this.getEventsInDescendingOrder();
        for (int i = 0; i < extendedLSEArray.length; ++i) {
            long l2 = extendedLSEArray[i].utc();
            if (l2 == l) {
                return extendedLSEArray[i].getShift() == 1;
            }
            if (l2 < l) break;
        }
        return false;
    }

    public GregorianDate getDateOfExpiration() {
        if (!this.isEnabled()) {
            throw new IllegalStateException("Leap seconds not activated.");
        }
        return this.provider.getDateOfExpiration();
    }

    @Override
    public int compare(LeapSecondEvent leapSecondEvent, LeapSecondEvent leapSecondEvent2) {
        int n;
        int n2;
        int n3;
        GregorianDate gregorianDate = leapSecondEvent.getDate();
        GregorianDate gregorianDate2 = leapSecondEvent2.getDate();
        int n4 = gregorianDate.getYear();
        if (n4 < (n3 = gregorianDate2.getYear())) {
            return -1;
        }
        if (n4 > n3) {
            return 1;
        }
        int n5 = gregorianDate.getMonth();
        if (n5 < (n2 = gregorianDate2.getMonth())) {
            return -1;
        }
        if (n5 > n2) {
            return 1;
        }
        int n6 = gregorianDate.getDayOfMonth();
        return n6 < (n = gregorianDate2.getDayOfMonth()) ? -1 : (n6 == n ? 0 : 1);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(2048);
        stringBuilder.append("[PROVIDER=");
        stringBuilder.append(this.provider);
        if (this.provider != null) {
            stringBuilder.append(",EXPIRES=");
            stringBuilder.append(LeapSeconds.format(this.getDateOfExpiration()));
        }
        stringBuilder.append(",EVENTS=[");
        if (this.isEnabled()) {
            boolean bl = true;
            for (ExtendedLSE extendedLSE : this.list) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append('|');
                }
                stringBuilder.append(extendedLSE);
            }
        } else {
            stringBuilder.append("NOT SUPPORTED");
        }
        return stringBuilder.append("]]").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(int n, int n2, int n3, boolean bl) {
        if (FINAL_UTC_LEAPSECONDS) {
            throw new IllegalStateException("Leap seconds are final, change requires edit of system property \"time4j.utc.leapseconds.final\" and reboot of JVM.");
        }
        if (SUPPRESS_UTC_LEAPSECONDS) {
            throw new IllegalStateException("Leap seconds are not supported, change requires edit of system property \"time4j.utc.leapseconds.suppressed\" and reboot of JVM.");
        }
        LeapSeconds leapSeconds = this;
        synchronized (leapSeconds) {
            GregorianMath.checkDate(n, n2, n3);
            if (!this.isEnabled()) {
                throw new IllegalStateException("Leap seconds not activated.");
            }
            ExtendedLSE extendedLSE = this.reverseVolatile[0];
            GregorianDate gregorianDate = extendedLSE.getDate();
            boolean bl2 = false;
            if (n > gregorianDate.getYear()) {
                bl2 = true;
            } else if (n == gregorianDate.getYear()) {
                if (n2 > gregorianDate.getMonth()) {
                    bl2 = true;
                } else if (n2 == gregorianDate.getMonth() && n3 > gregorianDate.getDayOfMonth()) {
                    bl2 = true;
                }
            }
            if (!bl2) {
                throw new IllegalArgumentException("New leap second must be after last leap second.");
            }
            int n4 = bl ? -1 : 1;
            GregorianDate gregorianDate2 = this.provider.getDateOfEvent(n, n2, n3);
            this.list.add(LeapSeconds.createLSE(gregorianDate2, n4, extendedLSE));
            this.reverseVolatile = this.initReverse();
        }
    }

    private ExtendedLSE[] getEventsInDescendingOrder() {
        if (SUPPRESS_UTC_LEAPSECONDS || FINAL_UTC_LEAPSECONDS) {
            return this.reverseFinal;
        }
        return this.reverseVolatile;
    }

    private static void extend(SortedSet<ExtendedLSE> sortedSet) {
        ArrayList<ExtendedLSE> arrayList = new ArrayList<ExtendedLSE>(sortedSet.size());
        int n = 0;
        for (ExtendedLSE extendedLSE : sortedSet) {
            if (extendedLSE.utc() == Long.MIN_VALUE) {
                arrayList.add(new SimpleLeapSecondEvent(extendedLSE, n += extendedLSE.getShift()));
                continue;
            }
            arrayList.add(extendedLSE);
        }
        sortedSet.clear();
        sortedSet.addAll(arrayList);
    }

    private static ExtendedLSE createLSE(GregorianDate gregorianDate, int n, ExtendedLSE extendedLSE) {
        long l = LeapSeconds.toPosix(gregorianDate) + -62985600L - 1L;
        int n2 = (int)(extendedLSE.utc() - extendedLSE.raw() + (long)n);
        return new SimpleLeapSecondEvent(gregorianDate, l + (long)n2, l, n);
    }

    private static long toPosix(GregorianDate gregorianDate) {
        return Math.multiplyExact(Math.subtractExact(GregorianMath.toMJD(gregorianDate), 40587L), 86400L);
    }

    private ExtendedLSE[] initReverse() {
        ArrayList<ExtendedLSE> arrayList = new ArrayList<ExtendedLSE>(this.list.size());
        arrayList.addAll(this.list);
        Collections.reverse(arrayList);
        return arrayList.toArray(new ExtendedLSE[arrayList.size()]);
    }

    private static String format(GregorianDate gregorianDate) {
        return String.format("%1$04d-%2$02d-%3$02d", gregorianDate.getYear(), gregorianDate.getMonth(), gregorianDate.getDayOfMonth());
    }

    private static class SimpleLeapSecondEvent
    implements ExtendedLSE,
    Serializable {
        private static final long serialVersionUID = 5986185471610524587L;
        private final GregorianDate date;
        private final int shift;
        private final long _utc;
        private final long _raw;

        SimpleLeapSecondEvent(GregorianDate gregorianDate, long l, long l2, int n) {
            this.date = gregorianDate;
            this.shift = n;
            this._utc = l;
            this._raw = l2;
        }

        SimpleLeapSecondEvent(ExtendedLSE extendedLSE, int n) {
            this.date = extendedLSE.getDate();
            this.shift = extendedLSE.getShift();
            this._utc = extendedLSE.raw() + (long)n;
            this._raw = extendedLSE.raw();
        }

        @Override
        public GregorianDate getDate() {
            return this.date;
        }

        @Override
        public int getShift() {
            return this.shift;
        }

        @Override
        public long utc() {
            return this._utc;
        }

        @Override
        public long raw() {
            return this._raw;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append(LeapSecondEvent.class.getName());
            stringBuilder.append('[');
            stringBuilder.append(LeapSeconds.format(this.date));
            stringBuilder.append(": utc=");
            stringBuilder.append(this._utc);
            stringBuilder.append(", raw=");
            stringBuilder.append(this._raw);
            stringBuilder.append(" (shift=");
            stringBuilder.append(this.shift);
            stringBuilder.append(")]");
            return stringBuilder.toString();
        }
    }
}

