/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.ObjectStreamException;
import net.time4j.AbstractDateElement;
import net.time4j.CalendarUnit;
import net.time4j.ElementOperator;
import net.time4j.OrdinalWeekdayElement;
import net.time4j.PlainDate;
import net.time4j.PlainTimestamp;
import net.time4j.Weekday;
import net.time4j.base.GregorianMath;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoOperator;
import net.time4j.format.NumericalElement;

final class WeekdayInMonthElement
extends AbstractDateElement<Integer>
implements OrdinalWeekdayElement,
NumericalElement<Integer> {
    static final WeekdayInMonthElement INSTANCE = new WeekdayInMonthElement();
    private static final int LAST = Integer.MAX_VALUE;
    private static final long serialVersionUID = -2378018589067147278L;

    private WeekdayInMonthElement() {
        super("WEEKDAY_IN_MONTH");
    }

    @Override
    public Class<Integer> getType() {
        return Integer.class;
    }

    @Override
    public char getSymbol() {
        return 'F';
    }

    @Override
    public int numerical(Integer n) {
        return n;
    }

    @Override
    public Integer getDefaultMinimum() {
        return 1;
    }

    @Override
    public Integer getDefaultMaximum() {
        return 5;
    }

    @Override
    public boolean isDateElement() {
        return true;
    }

    @Override
    public boolean isTimeElement() {
        return false;
    }

    @Override
    public ElementOperator<PlainDate> setToFirst(Weekday weekday) {
        return this.setTo(1, weekday);
    }

    @Override
    public ElementOperator<PlainDate> setToSecond(Weekday weekday) {
        return this.setTo(2, weekday);
    }

    @Override
    public ElementOperator<PlainDate> setToThird(Weekday weekday) {
        return this.setTo(3, weekday);
    }

    @Override
    public ElementOperator<PlainDate> setToFourth(Weekday weekday) {
        return this.setTo(4, weekday);
    }

    @Override
    public ElementOperator<PlainDate> setToLast(Weekday weekday) {
        return this.setTo(Integer.MAX_VALUE, weekday);
    }

    @Override
    public ElementOperator<PlainDate> setTo(int n, Weekday weekday) {
        return new SpecialOperator(n, weekday);
    }

    @Override
    protected boolean isSingleton() {
        return true;
    }

    private Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }

    private static class SpecialOperator
    extends ElementOperator<PlainDate> {
        private final int ordinal;
        private final Weekday dayOfWeek;
        private final ChronoOperator<PlainTimestamp> specialTS;

        SpecialOperator(int n, Weekday weekday) {
            super(INSTANCE, 7);
            if (weekday == null) {
                throw new NullPointerException("Missing value.");
            }
            this.ordinal = n;
            this.dayOfWeek = weekday;
            this.specialTS = this::doApply;
        }

        @Override
        public PlainDate apply(PlainDate plainDate) {
            return this.doApply(plainDate);
        }

        @Override
        ChronoOperator<PlainTimestamp> onTimestamp() {
            return this.specialTS;
        }

        private <T extends ChronoEntity<T>> T doApply(T t) {
            if (t.contains(PlainDate.CALENDAR_DATE)) {
                int n;
                PlainDate plainDate = t.get(PlainDate.CALENDAR_DATE);
                Weekday weekday = plainDate.get(PlainDate.DAY_OF_WEEK);
                int n2 = this.dayOfWeek.getValue() - weekday.getValue();
                int n3 = plainDate.getDayOfMonth() + n2;
                if (this.ordinal == Integer.MAX_VALUE) {
                    n = (5 - (Math.floorDiv(n3 - 1, 7) + 1)) * 7 + n2;
                    int n4 = GregorianMath.getLengthOfMonth(plainDate.getYear(), plainDate.getMonth());
                    if (plainDate.getDayOfMonth() + n > n4) {
                        n -= 7;
                    }
                } else {
                    n = (this.ordinal - (Math.floorDiv(n3 - 1, 7) + 1)) * 7 + n2;
                }
                plainDate = plainDate.plus((long)n, CalendarUnit.DAYS);
                return t.with(PlainDate.CALENDAR_DATE, (PlainDate)plainDate);
            }
            throw new ChronoException("Rule not found for ordinal day of week in month: " + t);
        }
    }
}

