/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.ObjectStreamException;
import net.time4j.CalendarDateElement;
import net.time4j.CalendarOperator;
import net.time4j.ElementOperator;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.ZonalQuery;
import net.time4j.engine.BasicElement;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoFunction;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

final class DateElement
extends BasicElement<PlainDate>
implements CalendarDateElement {
    static final DateElement INSTANCE = new DateElement();
    private static final long serialVersionUID = -6519899440006935829L;

    private DateElement() {
        super("CALENDAR_DATE");
    }

    @Override
    public Class<PlainDate> getType() {
        return PlainDate.class;
    }

    @Override
    public PlainDate getDefaultMinimum() {
        return PlainDate.MIN;
    }

    @Override
    public PlainDate getDefaultMaximum() {
        return PlainDate.MAX;
    }

    @Override
    public int compare(ChronoDisplay chronoDisplay, ChronoDisplay chronoDisplay2) {
        return chronoDisplay.get(this).compareTo((Calendrical)chronoDisplay2.get(this));
    }

    @Override
    public boolean isDateElement() {
        return true;
    }

    @Override
    public boolean isTimeElement() {
        return false;
    }

    @Override
    public ElementOperator<PlainDate> firstDayOfNextMonth() {
        return CalendarOperator.FIRST_DAY_OF_NEXT_MONTH;
    }

    @Override
    public ElementOperator<PlainDate> firstDayOfNextQuarter() {
        return CalendarOperator.FIRST_DAY_OF_NEXT_QUARTER;
    }

    @Override
    public ElementOperator<PlainDate> firstDayOfNextYear() {
        return CalendarOperator.FIRST_DAY_OF_NEXT_YEAR;
    }

    @Override
    public ElementOperator<PlainDate> lastDayOfPreviousMonth() {
        return CalendarOperator.LAST_DAY_OF_PREVIOUS_MONTH;
    }

    @Override
    public ElementOperator<PlainDate> lastDayOfPreviousQuarter() {
        return CalendarOperator.LAST_DAY_OF_PREVIOUS_QUARTER;
    }

    @Override
    public ElementOperator<PlainDate> lastDayOfPreviousYear() {
        return CalendarOperator.LAST_DAY_OF_PREVIOUS_YEAR;
    }

    @Override
    public ChronoFunction<Moment, PlainDate> inStdTimezone() {
        return this.in(Timezone.ofSystem());
    }

    @Override
    public ChronoFunction<Moment, PlainDate> inTimezone(TZID tZID) {
        return this.in(Timezone.of(tZID));
    }

    @Override
    public ChronoFunction<Moment, PlainDate> in(Timezone timezone) {
        return new ZonalQuery<PlainDate>(this, timezone);
    }

    @Override
    public ChronoFunction<Moment, PlainDate> atUTC() {
        return this.at(ZonalOffset.UTC);
    }

    @Override
    public ChronoFunction<Moment, PlainDate> at(ZonalOffset zonalOffset) {
        return new ZonalQuery<PlainDate>(this, zonalOffset);
    }

    private Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }
}

