/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.text.DecimalFormatSymbols;
import java.util.Locale;

public interface NumberSymbolProvider {
    public static final NumberSymbolProvider DEFAULT = new NumberSymbolProvider(){

        @Override
        public Locale[] getAvailableLocales() {
            return DecimalFormatSymbols.getAvailableLocales();
        }

        @Override
        public char getZeroDigit(Locale locale) {
            return this.getSymbols(locale).getZeroDigit();
        }

        @Override
        public char getDecimalSeparator(Locale locale) {
            return this.getSymbols(locale).getDecimalSeparator();
        }

        @Override
        public String getPlusSign(Locale locale) {
            if (locale.getLanguage().equals("ar")) {
                return "\u200f+";
            }
            return String.valueOf('+');
        }

        @Override
        public String getMinusSign(Locale locale) {
            if (locale.getLanguage().equals("ar")) {
                return "\u200f-";
            }
            return String.valueOf(this.getSymbols(locale).getMinusSign());
        }

        private DecimalFormatSymbols getSymbols(Locale locale) {
            return DecimalFormatSymbols.getInstance(locale);
        }
    };

    public Locale[] getAvailableLocales();

    public char getZeroDigit(Locale var1);

    public char getDecimalSeparator(Locale var1);

    default public String getPlusSign(Locale locale) {
        return String.valueOf('+');
    }

    public String getMinusSign(Locale var1);
}

