/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import net.time4j.ElementOperator;
import net.time4j.PlainDate;
import net.time4j.PlainTimestamp;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoOperator;
import net.time4j.engine.TimeAxis;

final class NavigationOperator<V extends Enum<V>>
extends ElementOperator<PlainDate> {
    private final V value;
    private final int len;
    private final ChronoOperator<PlainTimestamp> navTS;

    NavigationOperator(ChronoElement<V> chronoElement, int n, V v) {
        super(chronoElement, n);
        if (v == null) {
            throw new NullPointerException("Missing value.");
        }
        this.value = v;
        this.len = ((Enum[])chronoElement.getType().getEnumConstants()).length;
        this.navTS = this::doApply;
    }

    @Override
    public PlainDate apply(PlainDate plainDate) {
        return this.doApply(plainDate);
    }

    @Override
    ChronoOperator<PlainTimestamp> onTimestamp() {
        return this.navTS;
    }

    private <T extends ChronoEntity<T>> T doApply(T t) {
        String string;
        if (t.contains(PlainDate.CALENDAR_DATE)) {
            PlainDate plainDate = t.get(PlainDate.CALENDAR_DATE);
            Object obj = plainDate.get(this.getElement());
            int n = ((Enum)Enum.class.cast(obj)).ordinal();
            int n2 = this.delta(n);
            if (n2 == n) {
                return t;
            }
            return t.with(PlainDate.CALENDAR_DATE, plainDate.plus(n2 - n, ((TimeAxis)plainDate.getChronology()).getBaseUnit(this.getElement())));
        }
        switch (this.getType()) {
            case 9: {
                string = "setToNext";
                break;
            }
            case 10: {
                string = "setToPrevious";
                break;
            }
            case 11: {
                string = "setToNextOrSame";
                break;
            }
            case 12: {
                string = "setToPreviousOrSame";
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown: " + this.getType()));
            }
        }
        throw new ChronoException(string + "()-operation not supported on: " + this.getElement().name());
    }

    private int delta(int n) {
        int n2 = ((Enum)this.value).ordinal();
        switch (this.getType()) {
            case 9: {
                if (n2 > n) break;
                n2 += this.len;
                break;
            }
            case 10: {
                if (n2 < n) break;
                n2 -= this.len;
                break;
            }
            case 11: {
                if (n2 >= n) break;
                n2 += this.len;
                break;
            }
            case 12: {
                if (n2 <= n) break;
                n2 -= this.len;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown: " + this.getType()));
            }
        }
        return n2;
    }
}

