/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.text.DateFormatSymbols;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.chrono.IsoEra;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalField;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.Chronology;
import net.time4j.format.CalendarType;
import net.time4j.format.OutputContext;
import net.time4j.format.TextAccessor;
import net.time4j.format.TextProvider;
import net.time4j.format.TextWidth;

public final class CalendarText {
    public static final String ISO_CALENDAR_TYPE = "iso8601";
    private static final ConcurrentMap<String, CalendarText> CACHE = new ConcurrentHashMap<String, CalendarText>();
    private final String provider;
    private final Map<TextWidth, Map<OutputContext, TextAccessor>> stdMonths;
    private final Map<TextWidth, Map<OutputContext, TextAccessor>> leapMonths;
    private final Map<TextWidth, Map<OutputContext, TextAccessor>> quarters;
    private final Map<TextWidth, Map<OutputContext, TextAccessor>> weekdays;
    private final Map<TextWidth, TextAccessor> eras;
    private final Map<TextWidth, TextAccessor> meridiems;
    private final ResourceBundle textForms;
    private final MissingResourceException mre;

    /*
     * WARNING - void declaration
     */
    private CalendarText(String string, Locale locale, TextProvider textProvider) {
        void var10_27;
        void var9_18;
        void var11_34;
        void var10_23;
        void object;
        this.provider = textProvider.toString();
        this.stdMonths = Collections.unmodifiableMap(CalendarText.getMonths(string, locale, textProvider, false));
        Map<TextWidth, Map<OutputContext, TextAccessor>> map = CalendarText.getMonths(string, locale, textProvider, true);
        this.leapMonths = map == null ? this.stdMonths : Collections.unmodifiableMap(map);
        EnumMap enumMap = new EnumMap(TextWidth.class);
        for (TextWidth textWidth : TextWidth.values()) {
            EnumMap<OutputContext, TextAccessor> enumMap2 = new EnumMap<OutputContext, TextAccessor>(OutputContext.class);
            for (OutputContext outputContext : OutputContext.values()) {
                enumMap2.put(outputContext, new TextAccessor(textProvider.quarters(string, locale, textWidth, outputContext), locale));
            }
            enumMap.put(textWidth, enumMap2);
        }
        this.quarters = Collections.unmodifiableMap(enumMap);
        EnumMap enumMap2 = new EnumMap(TextWidth.class);
        Object enumMap3 = TextWidth.values();
        int n = ((TextWidth[])enumMap3).length;
        boolean bl = false;
        while (object < n) {
            TextWidth textWidth = enumMap3[object];
            EnumMap<OutputContext, TextAccessor> enumMap4 = new EnumMap<OutputContext, TextAccessor>(OutputContext.class);
            for (OutputContext outputContext : OutputContext.values()) {
                enumMap4.put(outputContext, new TextAccessor(textProvider.weekdays(string, locale, textWidth, outputContext), locale));
            }
            enumMap2.put(textWidth, enumMap4);
            ++object;
        }
        this.weekdays = Collections.unmodifiableMap(enumMap2);
        enumMap3 = new EnumMap(TextWidth.class);
        Object enumMap4 = TextWidth.values();
        int n2 = ((TextWidth[])enumMap4).length;
        boolean bl2 = false;
        while (var10_23 < n2) {
            TextWidth textWidth = enumMap4[var10_23];
            enumMap3.put(textWidth, new TextAccessor(textProvider.eras(string, locale, textWidth), locale));
            ++var10_23;
        }
        this.eras = Collections.unmodifiableMap(enumMap3);
        enumMap4 = new EnumMap(TextWidth.class);
        TextWidth[] textWidthArray = TextWidth.values();
        int n3 = textWidthArray.length;
        boolean bl3 = false;
        while (var11_34 < n3) {
            TextWidth textWidth = textWidthArray[var11_34];
            enumMap4.put(textWidth, new TextAccessor(textProvider.meridiems(string, locale, textWidth), locale));
            ++var11_34;
        }
        this.meridiems = Collections.unmodifiableMap(enumMap4);
        Object var9_16 = null;
        Object var10_25 = null;
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("calendar/" + string, locale, CalendarText.getLoader(), textProvider.getControl());
        }
        catch (MissingResourceException missingResourceException) {
            MissingResourceException missingResourceException2 = missingResourceException;
        }
        this.textForms = var9_18;
        this.mre = var10_27;
    }

    public static CalendarText getInstance(Chronology<?> chronology, Locale locale) {
        return CalendarText.getInstance(CalendarText.extractCalendarType(chronology), locale);
    }

    public static CalendarText getInstance(String string, Locale locale) {
        String string2;
        Object object;
        if (string == null) {
            throw new NullPointerException("Missing calendar type.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(':');
        stringBuilder.append(locale.getLanguage());
        String string3 = locale.getCountry();
        if (!string3.isEmpty()) {
            stringBuilder.append('-');
            stringBuilder.append(string3);
        }
        if ((object = (CalendarText)CACHE.get(string2 = stringBuilder.toString())) == null) {
            Object object2 = null;
            ClassLoader classLoader = CalendarText.getLoader();
            Object object3 = ServiceLoader.load(TextProvider.class, classLoader).iterator();
            while (object3.hasNext()) {
                TextProvider textProvider = object3.next();
                if (!CalendarText.isCalendarTypeSupported(textProvider, string) || !CalendarText.isLocaleSupported(textProvider, locale)) continue;
                object2 = textProvider;
                break;
            }
            if (object2 == null) {
                object3 = new JDKTextProvider();
                if (CalendarText.isCalendarTypeSupported((TextProvider)object3, string) && CalendarText.isLocaleSupported((TextProvider)object3, locale)) {
                    object2 = object3;
                }
                if (object2 == null) {
                    object2 = new FallbackProvider();
                }
            }
            if ((object3 = CACHE.putIfAbsent(string2, (CalendarText)(object = new CalendarText(string, locale, (TextProvider)object2)))) != null) {
                object = object3;
            }
        }
        return object;
    }

    public TextAccessor getStdMonths(TextWidth textWidth, OutputContext outputContext) {
        return this.getMonths(textWidth, outputContext, false);
    }

    public TextAccessor getLeapMonths(TextWidth textWidth, OutputContext outputContext) {
        return this.getMonths(textWidth, outputContext, true);
    }

    public TextAccessor getQuarters(TextWidth textWidth, OutputContext outputContext) {
        return this.quarters.get((Object)textWidth).get((Object)outputContext);
    }

    public TextAccessor getWeekdays(TextWidth textWidth, OutputContext outputContext) {
        return this.weekdays.get((Object)textWidth).get((Object)outputContext);
    }

    public TextAccessor getEras(TextWidth textWidth) {
        return this.eras.get((Object)textWidth);
    }

    public TextAccessor getMeridiems(TextWidth textWidth) {
        return this.meridiems.get((Object)textWidth);
    }

    public <V extends Enum<V>> TextAccessor getTextForms(ChronoElement<V> chronoElement, String ... stringArray) {
        int n;
        if (this.textForms == null) {
            throw new MissingResourceException(this.mre.getMessage(), this.mre.getClassName(), this.mre.getKey());
        }
        Enum[] enumArray = (Enum[])chronoElement.getType().getEnumConstants();
        int n2 = enumArray.length;
        String[] stringArray2 = new String[n2];
        StringBuilder stringBuilder = new StringBuilder(chronoElement.name());
        if (stringArray != null && stringArray.length > 0) {
            boolean bl = true;
            for (n = 0; n < stringArray.length; ++n) {
                if (bl) {
                    stringBuilder.append('(');
                    bl = false;
                } else {
                    stringBuilder.append('|');
                }
                stringBuilder.append(stringArray[n]);
            }
            stringBuilder.append(')');
        }
        String string = stringBuilder.toString();
        for (n = 0; n < n2; ++n) {
            String string2;
            String string3 = CalendarText.toKey(string, n);
            stringArray2[n] = this.textForms.containsKey(string3) ? this.textForms.getString(string3) : (this.textForms.containsKey(string2 = CalendarText.toKey(chronoElement.name(), n)) ? this.textForms.getString(string2) : enumArray[n].name());
        }
        return new TextAccessor(stringArray2, this.textForms.getLocale());
    }

    public static String getGMTPrefix(Locale locale) {
        CalendarText calendarText = CalendarText.getInstance(ISO_CALENDAR_TYPE, locale);
        if (calendarText.textForms == null) {
            return "GMT";
        }
        return calendarText.textForms.getString("prefixGMTOffset");
    }

    public String toString() {
        return this.provider;
    }

    public static void clearCache() {
        CACHE.clear();
    }

    static String extractCalendarType(Chronology<?> chronology) {
        CalendarType calendarType = chronology.getChronoType().getAnnotation(CalendarType.class);
        return calendarType == null ? ISO_CALENDAR_TYPE : calendarType.value();
    }

    private TextAccessor getMonths(TextWidth textWidth, OutputContext outputContext, boolean bl) {
        if (bl) {
            return this.leapMonths.get((Object)textWidth).get((Object)outputContext);
        }
        return this.stdMonths.get((Object)textWidth).get((Object)outputContext);
    }

    private static Map<TextWidth, Map<OutputContext, TextAccessor>> getMonths(String string, Locale locale, TextProvider textProvider, boolean bl) {
        EnumMap<TextWidth, Map<OutputContext, TextAccessor>> enumMap = new EnumMap<TextWidth, Map<OutputContext, TextAccessor>>(TextWidth.class);
        boolean bl2 = false;
        for (TextWidth textWidth : TextWidth.values()) {
            EnumMap<OutputContext, TextAccessor> enumMap2 = new EnumMap<OutputContext, TextAccessor>(OutputContext.class);
            for (OutputContext outputContext : OutputContext.values()) {
                Object[] objectArray = textProvider.months(string, locale, textWidth, outputContext, bl);
                if (bl && !bl2) {
                    Object[] objectArray2 = textProvider.months(string, locale, textWidth, outputContext, false);
                    bl2 = !Arrays.equals(objectArray2, objectArray);
                }
                enumMap2.put(outputContext, new TextAccessor((String[])objectArray, locale));
            }
            enumMap.put(textWidth, enumMap2);
        }
        return !bl || bl2 ? enumMap : null;
    }

    private static boolean isCalendarTypeSupported(TextProvider textProvider, String string) {
        for (String string2 : textProvider.getSupportedCalendarTypes()) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private static boolean isLocaleSupported(TextProvider textProvider, Locale locale) {
        String string = locale.getLanguage();
        for (Locale locale2 : textProvider.getAvailableLocales()) {
            if (!string.equals(locale2.getLanguage())) continue;
            return true;
        }
        return false;
    }

    private static String toKey(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append('_');
        stringBuilder.append(n + 1);
        return stringBuilder.toString();
    }

    private static ClassLoader getLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = CalendarText.class.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    private static class FallbackProvider
    implements TextProvider {
        private FallbackProvider() {
        }

        @Override
        public String[] getSupportedCalendarTypes() {
            throw new UnsupportedOperationException("Never called.");
        }

        @Override
        public Locale[] getAvailableLocales() {
            throw new UnsupportedOperationException("Never called.");
        }

        @Override
        public String[] months(String string, Locale locale, TextWidth textWidth, OutputContext outputContext, boolean bl) {
            if (textWidth == TextWidth.WIDE) {
                return new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13"};
            }
            return new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13"};
        }

        @Override
        public String[] quarters(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
            if (textWidth == TextWidth.NARROW) {
                return new String[]{"1", "2", "3", "4"};
            }
            return new String[]{"Q1", "Q2", "Q3", "Q4"};
        }

        @Override
        public String[] weekdays(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
            return new String[]{"1", "2", "3", "4", "5", "6", "7"};
        }

        @Override
        public String[] eras(String string, Locale locale, TextWidth textWidth) {
            if (textWidth == TextWidth.NARROW) {
                return new String[]{"B", "A"};
            }
            return new String[]{"BC", "AD"};
        }

        @Override
        public String[] meridiems(String string, Locale locale, TextWidth textWidth) {
            if (textWidth == TextWidth.NARROW) {
                return new String[]{"A", "P"};
            }
            return new String[]{"AM", "PM"};
        }

        @Override
        public ResourceBundle.Control getControl() {
            return ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT);
        }

        public String toString() {
            return "FallbackProvider";
        }
    }

    private static class JDKTextProvider
    implements TextProvider {
        private JDKTextProvider() {
        }

        @Override
        public String[] getSupportedCalendarTypes() {
            return new String[]{CalendarText.ISO_CALENDAR_TYPE};
        }

        @Override
        public Locale[] getAvailableLocales() {
            return DateFormatSymbols.getAvailableLocales();
        }

        @Override
        public String[] months(String string, Locale locale, TextWidth textWidth, OutputContext outputContext, boolean bl) {
            TextStyle textStyle = JDKTextProvider.getStyle(textWidth, outputContext);
            String[] stringArray = new String[12];
            int n = 0;
            for (Month month : Month.values()) {
                stringArray[n] = month.getDisplayName(textStyle, locale);
                ++n;
            }
            return stringArray;
        }

        @Override
        public String[] quarters(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
            TextStyle textStyle = JDKTextProvider.getStyle(textWidth, outputContext);
            String[] stringArray = new String[4];
            for (int i = 0; i < 4; ++i) {
                LocalDate localDate = LocalDate.of(1970, i * 3 + 1, 1);
                stringArray[i] = new DateTimeFormatterBuilder().appendText(IsoFields.QUARTER_OF_YEAR, textStyle).toFormatter(locale).format(localDate);
            }
            return stringArray;
        }

        @Override
        public String[] weekdays(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
            TextStyle textStyle = JDKTextProvider.getStyle(textWidth, outputContext);
            String[] stringArray = new String[7];
            int n = 0;
            for (DayOfWeek dayOfWeek : DayOfWeek.values()) {
                stringArray[n] = dayOfWeek.getDisplayName(textStyle, locale);
                ++n;
            }
            return stringArray;
        }

        @Override
        public String[] eras(String string, Locale locale, TextWidth textWidth) {
            TextStyle textStyle = JDKTextProvider.getStyle(textWidth, OutputContext.FORMAT);
            String[] stringArray = new String[2];
            int n = 0;
            for (IsoEra isoEra : IsoEra.values()) {
                stringArray[n] = isoEra.getDisplayName(textStyle, locale);
                ++n;
            }
            return stringArray;
        }

        @Override
        public String[] meridiems(String string, Locale locale, TextWidth textWidth) {
            TextStyle textStyle = JDKTextProvider.getStyle(textWidth, OutputContext.FORMAT);
            String[] stringArray = new String[2];
            for (int i = 0; i < 2; ++i) {
                LocalTime localTime = LocalTime.of(i * 12, 0);
                stringArray[i] = new DateTimeFormatterBuilder().appendText((TemporalField)ChronoField.AMPM_OF_DAY, textStyle).toFormatter(locale).format(localTime);
            }
            return stringArray;
        }

        @Override
        public ResourceBundle.Control getControl() {
            return ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT);
        }

        public String toString() {
            return "JDKTextProvider";
        }

        private static TextStyle getStyle(TextWidth textWidth, OutputContext outputContext) {
            boolean bl = outputContext == OutputContext.STANDALONE;
            switch (textWidth) {
                case WIDE: {
                    return bl ? TextStyle.FULL_STANDALONE : TextStyle.FULL;
                }
                case ABBREVIATED: 
                case SHORT: {
                    return bl ? TextStyle.SHORT_STANDALONE : TextStyle.SHORT;
                }
                case NARROW: {
                    return bl ? TextStyle.NARROW_STANDALONE : TextStyle.NARROW;
                }
            }
            throw new UnsupportedOperationException(textWidth.name());
        }
    }
}

