/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import net.time4j.base.TimeSource;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BasicElement;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoExtension;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.ElementRule;
import net.time4j.engine.RuleNotFoundException;
import net.time4j.engine.TimePoint;

public class Chronology<T extends ChronoEntity<T>>
implements ChronoMerger<T> {
    private static final List<ChronoReference> CHRONOS = new CopyOnWriteArrayList<ChronoReference>();
    private static final ReferenceQueue<Chronology<?>> QUEUE = new ReferenceQueue();
    private final Class<T> chronoType;
    private final ChronoMerger<T> merger;
    private final Map<ChronoElement<?>, ElementRule<T, ?>> ruleMap;
    private final List<ChronoExtension> extensions;

    Chronology(Class<T> clazz, ChronoMerger<T> chronoMerger, Map<ChronoElement<?>, ElementRule<T, ?>> map, List<ChronoExtension> list) {
        if (clazz == null) {
            throw new NullPointerException("Missing chronological type.");
        }
        if (chronoMerger == null) {
            throw new NullPointerException("Missing chronological merger.");
        }
        this.chronoType = clazz;
        this.merger = chronoMerger;
        this.ruleMap = Collections.unmodifiableMap(map);
        this.extensions = Collections.unmodifiableList(list);
    }

    public Class<T> getChronoType() {
        return this.chronoType;
    }

    public Set<ChronoElement<?>> getRegisteredElements() {
        return this.ruleMap.keySet();
    }

    public boolean isRegistered(ChronoElement<?> chronoElement) {
        return chronoElement != null && this.ruleMap.containsKey(chronoElement);
    }

    public boolean isSupported(ChronoElement<?> chronoElement) {
        if (chronoElement == null) {
            return false;
        }
        return this.isRegistered(chronoElement) || this.getDerivedRule(chronoElement, false) != null;
    }

    @Override
    public T createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
        return (T)((ChronoEntity)this.merger.createFrom(timeSource, attributeQuery));
    }

    @Override
    public T createFrom(TemporalAccessor temporalAccessor, AttributeQuery attributeQuery) {
        return (T)((ChronoEntity)this.merger.createFrom(temporalAccessor, attributeQuery));
    }

    @Override
    public T createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
        return (T)((ChronoEntity)this.merger.createFrom(chronoEntity, attributeQuery, bl));
    }

    @Override
    public ChronoDisplay preformat(T t, AttributeQuery attributeQuery) {
        return this.merger.preformat(t, attributeQuery);
    }

    @Override
    public Chronology<?> preparser() {
        return this.merger.preparser();
    }

    public List<ChronoExtension> getExtensions() {
        return this.extensions;
    }

    public boolean hasCalendarSystem() {
        return false;
    }

    public CalendarSystem<T> getCalendarSystem() {
        throw new ChronoException("Calendar system is not available.");
    }

    public static <T extends ChronoEntity<T>> Chronology<T> lookup(Class<T> clazz) {
        try {
            Class.forName(clazz.getName(), true, clazz.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
        Chronology chronology = null;
        boolean bl = false;
        for (ChronoReference chronoReference : CHRONOS) {
            Chronology chronology2 = (Chronology)chronoReference.get();
            if (chronology2 == null) {
                bl = true;
                continue;
            }
            if (chronology2.getChronoType() != clazz) continue;
            chronology = chronology2;
            break;
        }
        if (bl) {
            Chronology.purgeQueue();
        }
        return (Chronology)Chronology.cast(chronology);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(Chronology<?> chronology) {
        List<ChronoReference> list = CHRONOS;
        synchronized (list) {
            Class<?> clazz = chronology.getChronoType();
            for (ChronoReference chronoReference : CHRONOS) {
                Chronology chronology2 = (Chronology)chronoReference.get();
                if (chronology2 == null || chronology2.getChronoType() != clazz) continue;
                throw new IllegalStateException(clazz.getName() + " is already installed.");
            }
            CHRONOS.add(new ChronoReference(chronology, QUEUE));
        }
    }

    <V> ElementRule<T, V> getRule(ChronoElement<V> chronoElement) {
        if (chronoElement == null) {
            throw new NullPointerException("Missing chronological element.");
        }
        ElementRule<T, Object> elementRule = this.ruleMap.get(chronoElement);
        if (elementRule == null && (elementRule = this.getDerivedRule(chronoElement, true)) == null) {
            throw new RuleNotFoundException(this, chronoElement);
        }
        return (ElementRule)Chronology.cast(elementRule);
    }

    private <V> ElementRule<T, V> getDerivedRule(ChronoElement<V> chronoElement, boolean bl) {
        if (chronoElement instanceof BasicElement) {
            String string;
            BasicElement basicElement = (BasicElement)chronoElement;
            String string2 = string = bl ? basicElement.getVeto(this) : null;
            if (string == null) {
                return basicElement.derive(this);
            }
            throw new RuleNotFoundException(string);
        }
        return null;
    }

    private static void purgeQueue() {
        ChronoReference chronoReference;
        block0: while ((chronoReference = (ChronoReference)QUEUE.poll()) != null) {
            for (ChronoReference chronoReference2 : CHRONOS) {
                if (!chronoReference2.name.equals(chronoReference.name)) continue;
                CHRONOS.remove(chronoReference2);
                continue block0;
            }
        }
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }

    private static class ChronoReference
    extends WeakReference<Chronology<?>> {
        private final String name;

        ChronoReference(Chronology<?> chronology, ReferenceQueue<Chronology<?>> referenceQueue) {
            super(chronology, referenceQueue);
            this.name = ((Chronology)chronology).chronoType.getName();
        }
    }

    public static class Builder<T extends ChronoEntity<T>> {
        final Class<T> chronoType;
        final ChronoMerger<T> merger;
        final Map<ChronoElement<?>, ElementRule<T, ?>> ruleMap;
        final List<ChronoExtension> extensions;

        Builder(Class<T> clazz, ChronoMerger<T> chronoMerger) {
            if (clazz == null) {
                throw new NullPointerException("Missing chronological type.");
            }
            if (chronoMerger == null) {
                throw new NullPointerException("Missing chronological merger.");
            }
            this.chronoType = clazz;
            this.merger = chronoMerger;
            this.ruleMap = new HashMap();
            this.extensions = new ArrayList<ChronoExtension>();
        }

        public static <T extends ChronoEntity<T>> Builder<T> setUp(Class<T> clazz, ChronoMerger<T> chronoMerger) {
            if (TimePoint.class.isAssignableFrom(clazz)) {
                throw new UnsupportedOperationException("This builder cannot construct a chronology with a time axis, use TimeAxis.Builder instead.");
            }
            return new Builder<T>(clazz, chronoMerger);
        }

        public <V> Builder<T> appendElement(ChronoElement<V> chronoElement, ElementRule<T, V> elementRule) {
            this.checkElementDuplicates(chronoElement);
            this.ruleMap.put(chronoElement, elementRule);
            return this;
        }

        public Builder<T> appendExtension(ChronoExtension chronoExtension) {
            if (chronoExtension == null) {
                throw new NullPointerException("Missing chronological extension.");
            }
            if (!this.extensions.contains(chronoExtension)) {
                this.extensions.add(chronoExtension);
            }
            return this;
        }

        public Chronology<T> build() {
            Chronology<T> chronology = new Chronology<T>(this.chronoType, this.merger, this.ruleMap, this.extensions);
            Chronology.register(chronology);
            return chronology;
        }

        private void checkElementDuplicates(ChronoElement<?> chronoElement) {
            if (chronoElement == null) {
                throw new NullPointerException("Static initialization problem: Check if given element statically refer to any chronology causing premature class loading.");
            }
            String string = chronoElement.name();
            for (ChronoElement<?> chronoElement2 : this.ruleMap.keySet()) {
                if (!chronoElement2.equals(chronoElement) && !chronoElement2.name().equals(string)) continue;
                throw new IllegalArgumentException("Element duplicate found: " + string);
            }
        }
    }
}

