/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.time4j.CalendarUnit;
import net.time4j.ClockUnit;
import net.time4j.DayCycles;
import net.time4j.Duration;
import net.time4j.ElementOperator;
import net.time4j.FormatSupport;
import net.time4j.IsoUnit;
import net.time4j.LeapsecondElement;
import net.time4j.LongElement;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.SPX;
import net.time4j.TemporalType;
import net.time4j.Weekmodel;
import net.time4j.YOWElement;
import net.time4j.base.GregorianDate;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.base.UnixTime;
import net.time4j.base.WallTime;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoExtension;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.Normalizer;
import net.time4j.engine.Temporal;
import net.time4j.engine.ThreetenAdapter;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimeMetric;
import net.time4j.engine.TimePoint;
import net.time4j.engine.TimeSpan;
import net.time4j.engine.UnitRule;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.ChronoPattern;
import net.time4j.format.Leniency;
import net.time4j.format.TemporalFormatter;
import net.time4j.scale.TimeScale;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionStrategy;
import net.time4j.tz.ZonalOffset;

@CalendarType(value="iso8601")
public final class PlainTimestamp
extends TimePoint<IsoUnit, PlainTimestamp>
implements GregorianDate,
WallTime,
Temporal<PlainTimestamp>,
ThreetenAdapter,
Normalizer<IsoUnit> {
    private static final int MRD = 1000000000;
    private static final PlainTimestamp MIN = new PlainTimestamp(PlainDate.MIN, PlainTime.MIN);
    private static final PlainTimestamp MAX = new PlainTimestamp(PlainDate.MAX, PlainTime.WALL_TIME.getDefaultMaximum());
    private static final Map<Object, ChronoElement<?>> CHILDREN;
    private static final TimeAxis<IsoUnit, PlainTimestamp> ENGINE;
    private static final TimeMetric<IsoUnit, Duration<IsoUnit>> STD_METRIC;
    private static final long serialVersionUID = 7458380065762437714L;
    private final transient PlainDate date;
    private final transient PlainTime time;

    private PlainTimestamp(PlainDate plainDate, PlainTime plainTime) {
        if (plainTime.getHour() == 24) {
            this.date = (PlainDate)plainDate.plus(1L, CalendarUnit.DAYS);
            this.time = PlainTime.MIN;
        } else {
            if (plainDate == null) {
                throw new NullPointerException("Missing date.");
            }
            this.date = plainDate;
            this.time = plainTime;
        }
    }

    public static PlainTimestamp of(PlainDate plainDate, PlainTime plainTime) {
        return new PlainTimestamp(plainDate, plainTime);
    }

    public static PlainTimestamp of(int n, int n2, int n3, int n4, int n5) {
        return PlainTimestamp.of(n, n2, n3, n4, n5, 0);
    }

    public static PlainTimestamp of(int n, int n2, int n3, int n4, int n5, int n6) {
        return PlainTimestamp.of(PlainDate.of(n, n2, n3), PlainTime.of(n4, n5, n6));
    }

    public static PlainTimestamp from(LocalDateTime localDateTime) {
        return TemporalType.LOCAL_DATE_TIME.translate(localDateTime);
    }

    public PlainDate getCalendarDate() {
        return this.date;
    }

    public PlainTime getWallTime() {
        return this.time;
    }

    @Override
    public int getYear() {
        return this.date.getYear();
    }

    @Override
    public int getMonth() {
        return this.date.getMonth();
    }

    @Override
    public int getDayOfMonth() {
        return this.date.getDayOfMonth();
    }

    @Override
    public int getHour() {
        return this.time.getHour();
    }

    @Override
    public int getMinute() {
        return this.time.getMinute();
    }

    @Override
    public int getSecond() {
        return this.time.getSecond();
    }

    @Override
    public int getNanosecond() {
        return this.time.getNanosecond();
    }

    @Override
    public PlainTimestamp with(ElementOperator<?> elementOperator) {
        return this.with(elementOperator.onTimestamp());
    }

    public PlainTimestamp with(PlainDate plainDate) {
        return (PlainTimestamp)this.with(PlainDate.CALENDAR_DATE, plainDate);
    }

    public PlainTimestamp with(PlainTime plainTime) {
        return (PlainTimestamp)this.with(PlainTime.WALL_TIME, plainTime);
    }

    @Override
    public boolean isBefore(PlainTimestamp plainTimestamp) {
        return this.compareTo(plainTimestamp) < 0;
    }

    @Override
    public boolean isAfter(PlainTimestamp plainTimestamp) {
        return this.compareTo(plainTimestamp) > 0;
    }

    @Override
    public boolean isSimultaneous(PlainTimestamp plainTimestamp) {
        return this.compareTo(plainTimestamp) == 0;
    }

    @Override
    public int compareTo(PlainTimestamp plainTimestamp) {
        if (this.date.isAfter(plainTimestamp.date)) {
            return 1;
        }
        if (this.date.isBefore(plainTimestamp.date)) {
            return -1;
        }
        return this.time.compareTo(plainTimestamp.time);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof PlainTimestamp) {
            PlainTimestamp plainTimestamp = (PlainTimestamp)object;
            return this.date.equals(plainTimestamp.date) && this.time.equals(plainTimestamp.time);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 13 * this.date.hashCode() + 37 * this.time.hashCode();
    }

    @Override
    public String toString() {
        return this.date.toString() + this.time.toString();
    }

    public static <P extends ChronoPattern<P>> TemporalFormatter<PlainTimestamp> localFormatter(String string, P p) {
        return FormatSupport.createFormatter(PlainTimestamp.class, string, p, Locale.getDefault());
    }

    public static <P extends ChronoPattern<P>> TemporalFormatter<PlainTimestamp> formatter(String string, P p, Locale locale) {
        return FormatSupport.createFormatter(PlainTimestamp.class, string, p, locale);
    }

    @Override
    public LocalDateTime toTemporalAccessor() {
        return TemporalType.LOCAL_DATE_TIME.from(this);
    }

    public static TimeAxis<IsoUnit, PlainTimestamp> axis() {
        return ENGINE;
    }

    public Moment atUTC() {
        return this.at(ZonalOffset.UTC);
    }

    public Moment at(ZonalOffset zonalOffset) {
        long l = MathUtils.safeMultiply(this.date.getDaysSinceUTC() + 730L, 86400L);
        l += (long)(this.time.getHour() * 3600);
        l += (long)(this.time.getMinute() * 60);
        int n = this.time.getNanosecond();
        long l2 = (l += (long)this.time.getSecond()) - (long)zonalOffset.getIntegralAmount();
        int n2 = n - zonalOffset.getFractionalAmount();
        if (n2 < 0) {
            n2 += 1000000000;
            --l2;
        } else if (n2 >= 1000000000) {
            n2 -= 1000000000;
            ++l2;
        }
        return Moment.of(l2, n2, TimeScale.POSIX);
    }

    public Moment inStdTimezone() {
        return this.in(Timezone.ofSystem());
    }

    public Moment inTimezone(TZID tZID) {
        return this.in(Timezone.of(tZID));
    }

    public Moment in(Timezone timezone) {
        if (timezone.isFixed()) {
            return this.at(timezone.getOffset(this.date, this.time));
        }
        TransitionStrategy transitionStrategy = timezone.getStrategy();
        long l = transitionStrategy.resolve(this.date, this.time, timezone);
        Moment moment = Moment.of(l, this.time.getNanosecond(), TimeScale.POSIX);
        if (transitionStrategy == Timezone.STRICT_MODE) {
            Moment.checkNegativeLS(l, this);
        }
        return moment;
    }

    public boolean isValid(TZID tZID) {
        if (tZID == null) {
            return false;
        }
        return !Timezone.of(tZID).isInvalid(this.date, this.time);
    }

    @Override
    public Duration<IsoUnit> normalize(TimeSpan<? extends IsoUnit> timeSpan) {
        return this.until(this.plus(timeSpan), STD_METRIC);
    }

    @Override
    protected TimeAxis<IsoUnit, PlainTimestamp> getChronology() {
        return ENGINE;
    }

    @Override
    protected PlainTimestamp getContext() {
        return this;
    }

    static PlainTimestamp from(UnixTime unixTime, ZonalOffset zonalOffset) {
        long l = unixTime.getPosixTime() + (long)zonalOffset.getIntegralAmount();
        int n = unixTime.getNanosecond() + zonalOffset.getFractionalAmount();
        if (n < 0) {
            n += 1000000000;
            --l;
        } else if (n >= 1000000000) {
            n -= 1000000000;
            ++l;
        }
        PlainDate plainDate = PlainDate.of(MathUtils.floorDivide(l, 86400), EpochDays.UNIX);
        int n2 = MathUtils.floorModulo(l, 86400);
        int n3 = n2 % 60;
        int n4 = n2 / 60;
        int n5 = n4 % 60;
        int n6 = n4 / 60;
        PlainTime plainTime = PlainTime.of(n6, n5, n3, n);
        return PlainTimestamp.of(plainDate, plainTime);
    }

    private static void registerCalendarUnits(TimeAxis.Builder<IsoUnit, PlainTimestamp> builder) {
        EnumSet<CalendarUnit> enumSet = EnumSet.range(CalendarUnit.MILLENNIA, CalendarUnit.MONTHS);
        EnumSet<CalendarUnit> enumSet2 = EnumSet.range(CalendarUnit.WEEKS, CalendarUnit.DAYS);
        for (CalendarUnit calendarUnit : CalendarUnit.values()) {
            builder.appendUnit(calendarUnit, new CompositeUnitRule(calendarUnit), calendarUnit.getLength(), calendarUnit.compareTo(CalendarUnit.WEEKS) < 0 ? enumSet : enumSet2);
        }
    }

    private static void registerClockUnits(TimeAxis.Builder<IsoUnit, PlainTimestamp> builder) {
        for (ClockUnit clockUnit : ClockUnit.values()) {
            builder.appendUnit(clockUnit, new CompositeUnitRule(clockUnit), clockUnit.getLength(), EnumSet.allOf(ClockUnit.class));
        }
    }

    private static void registerExtensions(TimeAxis.Builder<IsoUnit, PlainTimestamp> builder) {
        for (ChronoExtension chronoExtension : PlainDate.axis().getExtensions()) {
            builder.appendExtension(chronoExtension);
        }
        for (ChronoExtension chronoExtension : PlainTime.axis().getExtensions()) {
            builder.appendExtension(chronoExtension);
        }
    }

    private Object writeReplace() {
        return new SPX(this, 8);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        HashMap<ChronoElement<Object>, ChronoElement<PlainTime>> hashMap = new HashMap<ChronoElement<Object>, ChronoElement<PlainTime>>();
        hashMap.put(PlainDate.CALENDAR_DATE, PlainTime.WALL_TIME);
        hashMap.put(PlainDate.YEAR, PlainDate.MONTH_AS_NUMBER);
        hashMap.put(PlainDate.YEAR_OF_WEEKDATE, Weekmodel.ISO.weekOfYear());
        hashMap.put(PlainDate.QUARTER_OF_YEAR, PlainDate.DAY_OF_QUARTER);
        hashMap.put(PlainDate.MONTH_OF_YEAR, PlainDate.DAY_OF_MONTH);
        hashMap.put(PlainDate.MONTH_AS_NUMBER, PlainDate.DAY_OF_MONTH);
        hashMap.put(PlainDate.DAY_OF_MONTH, PlainTime.WALL_TIME);
        hashMap.put(PlainDate.DAY_OF_WEEK, PlainTime.WALL_TIME);
        hashMap.put(PlainDate.DAY_OF_YEAR, PlainTime.WALL_TIME);
        hashMap.put(PlainDate.DAY_OF_QUARTER, PlainTime.WALL_TIME);
        hashMap.put(PlainDate.WEEKDAY_IN_MONTH, PlainTime.WALL_TIME);
        hashMap.put(PlainTime.AM_PM_OF_DAY, PlainTime.DIGITAL_HOUR_OF_AMPM);
        hashMap.put(PlainTime.CLOCK_HOUR_OF_AMPM, PlainTime.MINUTE_OF_HOUR);
        hashMap.put(PlainTime.CLOCK_HOUR_OF_DAY, PlainTime.MINUTE_OF_HOUR);
        hashMap.put(PlainTime.DIGITAL_HOUR_OF_AMPM, PlainTime.MINUTE_OF_HOUR);
        hashMap.put(PlainTime.DIGITAL_HOUR_OF_DAY, PlainTime.MINUTE_OF_HOUR);
        hashMap.put(PlainTime.ISO_HOUR, PlainTime.MINUTE_OF_HOUR);
        hashMap.put(PlainTime.MINUTE_OF_HOUR, PlainTime.SECOND_OF_MINUTE);
        hashMap.put(PlainTime.MINUTE_OF_DAY, PlainTime.SECOND_OF_MINUTE);
        hashMap.put(PlainTime.SECOND_OF_MINUTE, PlainTime.NANO_OF_SECOND);
        hashMap.put(PlainTime.SECOND_OF_DAY, PlainTime.NANO_OF_SECOND);
        CHILDREN = Collections.unmodifiableMap(hashMap);
        Chronology.Builder builder = ((TimeAxis.Builder)((TimeAxis.Builder)((TimeAxis.Builder)((TimeAxis.Builder)TimeAxis.Builder.setUp(IsoUnit.class, PlainTimestamp.class, new Merger(), MIN, MAX).appendElement(PlainDate.CALENDAR_DATE, FieldRule.of(PlainDate.CALENDAR_DATE), CalendarUnit.DAYS).appendElement(PlainDate.YEAR, FieldRule.of(PlainDate.YEAR), CalendarUnit.YEARS).appendElement(PlainDate.YEAR_OF_WEEKDATE, FieldRule.of(PlainDate.YEAR_OF_WEEKDATE), YOWElement.YOWUnit.WEEK_BASED_YEARS).appendElement(PlainDate.QUARTER_OF_YEAR, FieldRule.of(PlainDate.QUARTER_OF_YEAR), CalendarUnit.QUARTERS).appendElement(PlainDate.MONTH_OF_YEAR, FieldRule.of(PlainDate.MONTH_OF_YEAR), CalendarUnit.MONTHS).appendElement(PlainDate.MONTH_AS_NUMBER, FieldRule.of(PlainDate.MONTH_AS_NUMBER), CalendarUnit.MONTHS).appendElement(PlainDate.DAY_OF_MONTH, FieldRule.of(PlainDate.DAY_OF_MONTH), CalendarUnit.DAYS).appendElement(PlainDate.DAY_OF_WEEK, FieldRule.of(PlainDate.DAY_OF_WEEK), CalendarUnit.DAYS).appendElement(PlainDate.DAY_OF_YEAR, FieldRule.of(PlainDate.DAY_OF_YEAR), CalendarUnit.DAYS).appendElement(PlainDate.DAY_OF_QUARTER, FieldRule.of(PlainDate.DAY_OF_QUARTER), CalendarUnit.DAYS).appendElement(PlainDate.WEEKDAY_IN_MONTH, FieldRule.of(PlainDate.WEEKDAY_IN_MONTH), CalendarUnit.WEEKS).appendElement((ChronoElement)PlainTime.WALL_TIME, (ElementRule)FieldRule.of(PlainTime.WALL_TIME))).appendElement((ChronoElement)PlainTime.AM_PM_OF_DAY, FieldRule.of(PlainTime.AM_PM_OF_DAY))).appendElement(PlainTime.CLOCK_HOUR_OF_AMPM, FieldRule.of(PlainTime.CLOCK_HOUR_OF_AMPM), ClockUnit.HOURS).appendElement(PlainTime.CLOCK_HOUR_OF_DAY, FieldRule.of(PlainTime.CLOCK_HOUR_OF_DAY), ClockUnit.HOURS).appendElement(PlainTime.DIGITAL_HOUR_OF_AMPM, FieldRule.of(PlainTime.DIGITAL_HOUR_OF_AMPM), ClockUnit.HOURS).appendElement(PlainTime.DIGITAL_HOUR_OF_DAY, FieldRule.of(PlainTime.DIGITAL_HOUR_OF_DAY), ClockUnit.HOURS).appendElement(PlainTime.ISO_HOUR, FieldRule.of(PlainTime.ISO_HOUR), ClockUnit.HOURS).appendElement(PlainTime.MINUTE_OF_HOUR, FieldRule.of(PlainTime.MINUTE_OF_HOUR), ClockUnit.MINUTES).appendElement(PlainTime.MINUTE_OF_DAY, FieldRule.of(PlainTime.MINUTE_OF_DAY), ClockUnit.MINUTES).appendElement(PlainTime.SECOND_OF_MINUTE, FieldRule.of(PlainTime.SECOND_OF_MINUTE), ClockUnit.SECONDS).appendElement(PlainTime.SECOND_OF_DAY, FieldRule.of(PlainTime.SECOND_OF_DAY), ClockUnit.SECONDS).appendElement(PlainTime.MILLI_OF_SECOND, FieldRule.of(PlainTime.MILLI_OF_SECOND), ClockUnit.MILLIS).appendElement(PlainTime.MICRO_OF_SECOND, FieldRule.of(PlainTime.MICRO_OF_SECOND), ClockUnit.MICROS).appendElement(PlainTime.NANO_OF_SECOND, FieldRule.of(PlainTime.NANO_OF_SECOND), ClockUnit.NANOS).appendElement(PlainTime.MILLI_OF_DAY, FieldRule.of(PlainTime.MILLI_OF_DAY), ClockUnit.MILLIS).appendElement(PlainTime.MICRO_OF_DAY, FieldRule.of(PlainTime.MICRO_OF_DAY), ClockUnit.MICROS).appendElement(PlainTime.NANO_OF_DAY, FieldRule.of(PlainTime.NANO_OF_DAY), ClockUnit.NANOS).appendElement((ChronoElement)PlainTime.DECIMAL_HOUR, (ElementRule)new DecimalRule(PlainTime.DECIMAL_HOUR))).appendElement((ChronoElement)PlainTime.DECIMAL_MINUTE, (ElementRule)new DecimalRule(PlainTime.DECIMAL_MINUTE))).appendElement((ChronoElement)PlainTime.DECIMAL_SECOND, (ElementRule)new DecimalRule(PlainTime.DECIMAL_SECOND));
        PlainTimestamp.registerCalendarUnits((TimeAxis.Builder<IsoUnit, PlainTimestamp>)builder);
        PlainTimestamp.registerClockUnits((TimeAxis.Builder<IsoUnit, PlainTimestamp>)builder);
        PlainTimestamp.registerExtensions((TimeAxis.Builder<IsoUnit, PlainTimestamp>)builder);
        ENGINE = ((TimeAxis.Builder)builder).build();
        IsoUnit[] isoUnitArray = new IsoUnit[]{CalendarUnit.YEARS, CalendarUnit.MONTHS, CalendarUnit.DAYS, ClockUnit.HOURS, ClockUnit.MINUTES, ClockUnit.SECONDS, ClockUnit.NANOS};
        STD_METRIC = Duration.in((IsoUnit[])isoUnitArray);
    }

    private static class CompositeUnitRule
    implements UnitRule<PlainTimestamp> {
        private final CalendarUnit calendarUnit;
        private final ClockUnit clockUnit;

        CompositeUnitRule(CalendarUnit calendarUnit) {
            this.calendarUnit = calendarUnit;
            this.clockUnit = null;
        }

        CompositeUnitRule(ClockUnit clockUnit) {
            this.calendarUnit = null;
            this.clockUnit = clockUnit;
        }

        @Override
        public PlainTimestamp addTo(PlainTimestamp plainTimestamp, long l) {
            PlainTime plainTime;
            PlainDate plainDate;
            if (this.calendarUnit != null) {
                plainDate = (PlainDate)plainTimestamp.date.plus(l, this.calendarUnit);
                plainTime = plainTimestamp.time;
            } else {
                DayCycles dayCycles = plainTimestamp.time.roll(l, this.clockUnit);
                plainDate = (PlainDate)plainTimestamp.date.plus(dayCycles.getDayOverflow(), CalendarUnit.DAYS);
                plainTime = dayCycles.getWallTime();
            }
            return PlainTimestamp.of(plainDate, plainTime);
        }

        @Override
        public long between(PlainTimestamp plainTimestamp, PlainTimestamp plainTimestamp2) {
            long l;
            if (this.calendarUnit != null) {
                l = this.calendarUnit.between(plainTimestamp.date, plainTimestamp2.date);
                if (l != 0L) {
                    TimePoint timePoint;
                    boolean bl;
                    if (this.calendarUnit == CalendarUnit.DAYS) {
                        bl = true;
                    } else {
                        timePoint = (PlainDate)plainTimestamp.date.plus(l, this.calendarUnit);
                        boolean bl2 = bl = ((PlainDate)timePoint).compareByTime(plainTimestamp2.date) == 0;
                    }
                    if (bl) {
                        timePoint = plainTimestamp.time;
                        PlainTime plainTime = plainTimestamp2.time;
                        if (l > 0L && ((PlainTime)timePoint).isAfter(plainTime)) {
                            --l;
                        } else if (l < 0L && ((PlainTime)timePoint).isBefore(plainTime)) {
                            ++l;
                        }
                    }
                }
            } else if (plainTimestamp.date.isAfter(plainTimestamp2.date)) {
                l = -this.between(plainTimestamp2, plainTimestamp);
            } else {
                long l2 = plainTimestamp.date.until(plainTimestamp2.date, CalendarUnit.DAYS);
                if (l2 == 0L) {
                    return this.clockUnit.between(plainTimestamp.time, plainTimestamp2.time);
                }
                if (this.clockUnit.compareTo(ClockUnit.SECONDS) <= 0) {
                    l = MathUtils.safeAdd(MathUtils.safeMultiply(l2, 86400L), MathUtils.safeSubtract(((Integer)plainTimestamp2.time.get(PlainTime.SECOND_OF_DAY)).longValue(), ((Integer)plainTimestamp.time.get(PlainTime.SECOND_OF_DAY)).longValue()));
                    if (plainTimestamp.time.getNanosecond() > plainTimestamp2.time.getNanosecond()) {
                        --l;
                    }
                } else {
                    l = MathUtils.safeAdd(MathUtils.safeMultiply(l2, 86400000000000L), MathUtils.safeSubtract((Long)plainTimestamp2.time.get(PlainTime.NANO_OF_DAY), (Long)plainTimestamp.time.get(PlainTime.NANO_OF_DAY)));
                }
                switch (this.clockUnit) {
                    case HOURS: {
                        l /= 3600L;
                        break;
                    }
                    case MINUTES: {
                        l /= 60L;
                        break;
                    }
                    case SECONDS: {
                        break;
                    }
                    case MILLIS: {
                        l /= 1000000L;
                        break;
                    }
                    case MICROS: {
                        l /= 1000L;
                        break;
                    }
                    case NANOS: {
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(this.clockUnit.name());
                    }
                }
            }
            return l;
        }
    }

    private static class DecimalRule
    extends FieldRule<BigDecimal> {
        DecimalRule(ChronoElement<BigDecimal> chronoElement) {
            super(chronoElement);
        }

        @Override
        public boolean isValid(PlainTimestamp plainTimestamp, BigDecimal bigDecimal) {
            if (bigDecimal == null) {
                return false;
            }
            BigDecimal bigDecimal2 = (BigDecimal)((FieldRule)this).element.getDefaultMinimum();
            BigDecimal bigDecimal3 = (BigDecimal)((FieldRule)this).element.getDefaultMaximum();
            return bigDecimal2.compareTo(bigDecimal) <= 0 && bigDecimal.compareTo(bigDecimal3) <= 0;
        }

        @Override
        public PlainTimestamp withValue(PlainTimestamp plainTimestamp, BigDecimal bigDecimal, boolean bl) {
            if (!this.isValid(plainTimestamp, bigDecimal)) {
                throw new IllegalArgumentException("Out of range: " + bigDecimal);
            }
            PlainTime plainTime = (PlainTime)plainTimestamp.time.with(((FieldRule)this).element, bigDecimal);
            return PlainTimestamp.of(plainTimestamp.date, plainTime);
        }
    }

    private static class FieldRule<V>
    implements ElementRule<PlainTimestamp, V> {
        private final ChronoElement<V> element;

        private FieldRule(ChronoElement<V> chronoElement) {
            this.element = chronoElement;
        }

        static <V> FieldRule<V> of(ChronoElement<V> chronoElement) {
            return new FieldRule<V>(chronoElement);
        }

        @Override
        public V getValue(PlainTimestamp plainTimestamp) {
            if (this.element.isDateElement()) {
                return plainTimestamp.date.get(this.element);
            }
            if (this.element.isTimeElement()) {
                return plainTimestamp.time.get(this.element);
            }
            throw new ChronoException("Missing rule for: " + this.element.name());
        }

        @Override
        public V getMinimum(PlainTimestamp plainTimestamp) {
            if (this.element.isDateElement()) {
                return plainTimestamp.date.getMinimum(this.element);
            }
            if (this.element.isTimeElement()) {
                return this.element.getDefaultMinimum();
            }
            throw new ChronoException("Missing rule for: " + this.element.name());
        }

        @Override
        public V getMaximum(PlainTimestamp plainTimestamp) {
            if (this.element.isDateElement()) {
                return plainTimestamp.date.getMaximum(this.element);
            }
            if (this.element.isTimeElement()) {
                return this.element.getDefaultMaximum();
            }
            throw new ChronoException("Missing rule for: " + this.element.name());
        }

        @Override
        public boolean isValid(PlainTimestamp plainTimestamp, V v) {
            if (this.element.isDateElement()) {
                return plainTimestamp.date.isValid(this.element, v);
            }
            if (this.element.isTimeElement()) {
                if (Number.class.isAssignableFrom(this.element.getType())) {
                    if (v == null) {
                        return false;
                    }
                    long l = this.toNumber(this.element.getDefaultMinimum());
                    long l2 = this.toNumber(this.element.getDefaultMaximum());
                    long l3 = this.toNumber(v);
                    return l <= l3 && l2 >= l3;
                }
                if (this.element.equals(PlainTime.WALL_TIME) && PlainTime.MAX.equals(v)) {
                    return false;
                }
                return plainTimestamp.time.isValid(this.element, v);
            }
            throw new ChronoException("Missing rule for: " + this.element.name());
        }

        @Override
        public PlainTimestamp withValue(PlainTimestamp plainTimestamp, V v, boolean bl) {
            if (v.equals(this.getValue(plainTimestamp))) {
                return plainTimestamp;
            }
            if (bl) {
                IsoUnit isoUnit = (IsoUnit)ENGINE.getBaseUnit(this.element);
                long l = this.toNumber(this.getValue(plainTimestamp));
                long l2 = this.toNumber(v);
                long l3 = MathUtils.safeSubtract(l2, l);
                return (PlainTimestamp)plainTimestamp.plus(l3, isoUnit);
            }
            if (this.element.isDateElement()) {
                PlainDate plainDate = (PlainDate)plainTimestamp.date.with(this.element, v);
                return PlainTimestamp.of(plainDate, plainTimestamp.time);
            }
            if (this.element.isTimeElement()) {
                if (Number.class.isAssignableFrom(this.element.getType())) {
                    long l = this.toNumber(this.element.getDefaultMinimum());
                    long l4 = this.toNumber(this.element.getDefaultMaximum());
                    long l5 = this.toNumber(v);
                    if (l > l5 || l4 < l5) {
                        throw new IllegalArgumentException("Out of range: " + v);
                    }
                } else if (this.element.equals(PlainTime.WALL_TIME) && v.equals(PlainTime.MAX)) {
                    throw new IllegalArgumentException("Out of range: " + v);
                }
                PlainTime plainTime = (PlainTime)plainTimestamp.time.with(this.element, v);
                return PlainTimestamp.of(plainTimestamp.date, plainTime);
            }
            throw new ChronoException("Missing rule for: " + this.element.name());
        }

        @Override
        public ChronoElement<?> getChildAtFloor(PlainTimestamp plainTimestamp) {
            return (ChronoElement)CHILDREN.get(this.element);
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(PlainTimestamp plainTimestamp) {
            return (ChronoElement)CHILDREN.get(this.element);
        }

        private long toNumber(V v) {
            return ((Number)Number.class.cast(v)).longValue();
        }
    }

    private static class Merger
    implements ChronoMerger<PlainTimestamp> {
        private Merger() {
        }

        @Override
        public PlainTimestamp createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            Timezone timezone = attributeQuery.contains(Attributes.TIMEZONE_ID) ? Timezone.of(attributeQuery.get(Attributes.TIMEZONE_ID)) : Timezone.ofSystem();
            Object obj = timeSource.currentTime();
            return PlainTimestamp.from(obj, timezone.getOffset((UnixTime)obj));
        }

        @Override
        public PlainTimestamp createFrom(TemporalAccessor temporalAccessor, AttributeQuery attributeQuery) {
            PlainDate plainDate = (PlainDate)PlainDate.axis().createFrom(temporalAccessor, attributeQuery);
            PlainTime plainTime = (PlainTime)PlainTime.axis().createFrom(temporalAccessor, attributeQuery);
            if (plainDate != null && plainTime != null) {
                return PlainTimestamp.of(plainDate, plainTime);
            }
            return null;
        }

        @Override
        public PlainTimestamp createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
            PlainTime plainTime;
            PlainDate plainDate;
            boolean bl2;
            Leniency leniency = attributeQuery.get(Attributes.LENIENCY, Leniency.SMART);
            if (chronoEntity instanceof UnixTime) {
                TZID tZID;
                if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                    tZID = attributeQuery.get(Attributes.TIMEZONE_ID);
                } else if (leniency.isLax()) {
                    tZID = ZonalOffset.UTC;
                } else {
                    throw new IllegalArgumentException("Missing timezone attribute for type conversion.");
                }
                Moment moment = Moment.from((UnixTime)UnixTime.class.cast(chronoEntity));
                return moment.toZonalTimestamp(tZID);
            }
            boolean bl3 = bl2 = bl && chronoEntity.contains(PlainTime.SECOND_OF_MINUTE) && (Integer)chronoEntity.get(PlainTime.SECOND_OF_MINUTE) == 60;
            if (bl2) {
                chronoEntity.with(PlainTime.SECOND_OF_MINUTE, Integer.valueOf(59));
            }
            if ((plainDate = chronoEntity.contains(PlainDate.CALENDAR_DATE) ? chronoEntity.get(PlainDate.CALENDAR_DATE) : (PlainDate)PlainDate.axis().createFrom((ChronoEntity)chronoEntity, attributeQuery, false)) == null) {
                return null;
            }
            if (chronoEntity.contains(PlainTime.WALL_TIME)) {
                plainTime = chronoEntity.get(PlainTime.WALL_TIME);
            } else {
                plainTime = (PlainTime)PlainTime.axis().createFrom((ChronoEntity)chronoEntity, attributeQuery, false);
                if (plainTime == null && leniency.isLax()) {
                    plainTime = PlainTime.MIN;
                }
            }
            if (plainTime == null) {
                return null;
            }
            if (chronoEntity.contains(LongElement.DAY_OVERFLOW)) {
                plainDate = (PlainDate)plainDate.plus(chronoEntity.get(LongElement.DAY_OVERFLOW), CalendarUnit.DAYS);
            }
            if (bl2 && chronoEntity.isValid(LeapsecondElement.INSTANCE, Boolean.TRUE)) {
                chronoEntity.with(LeapsecondElement.INSTANCE, Boolean.TRUE);
            }
            return PlainTimestamp.of(plainDate, plainTime);
        }

        @Override
        public ChronoDisplay preformat(PlainTimestamp plainTimestamp, AttributeQuery attributeQuery) {
            return plainTimestamp;
        }

        @Override
        public Chronology<?> preparser() {
            return null;
        }
    }
}

