/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.util.Locale;
import net.time4j.Quarter;
import net.time4j.base.GregorianDate;
import net.time4j.base.GregorianMath;
import net.time4j.engine.ChronoCondition;
import net.time4j.format.CalendarText;
import net.time4j.format.OutputContext;
import net.time4j.format.TextWidth;

public enum Month implements ChronoCondition<GregorianDate>
{
    JANUARY,
    FEBRUARY,
    MARCH,
    APRIL,
    MAY,
    JUNE,
    JULY,
    AUGUST,
    SEPTEMBER,
    OCTOBER,
    NOVEMBER,
    DECEMBER;

    private static final Month[] ENUMS;

    public static Month valueOf(int n) {
        if (n < 1 || n > 12) {
            throw new IllegalArgumentException("Out of range: " + n);
        }
        return ENUMS[n - 1];
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    public Quarter getQuarterOfYear() {
        switch (this) {
            case JANUARY: 
            case FEBRUARY: 
            case MARCH: {
                return Quarter.Q1;
            }
            case APRIL: 
            case MAY: 
            case JUNE: {
                return Quarter.Q2;
            }
            case JULY: 
            case AUGUST: 
            case SEPTEMBER: {
                return Quarter.Q3;
            }
        }
        return Quarter.Q4;
    }

    public static Month atStartOfQuarterYear(Quarter quarter) {
        switch (quarter) {
            case Q1: {
                return JANUARY;
            }
            case Q2: {
                return APRIL;
            }
            case Q3: {
                return JULY;
            }
        }
        return OCTOBER;
    }

    public static Month atEndOfQuarterYear(Quarter quarter) {
        switch (quarter) {
            case Q1: {
                return MARCH;
            }
            case Q2: {
                return JUNE;
            }
            case Q3: {
                return SEPTEMBER;
            }
        }
        return DECEMBER;
    }

    public int getLength(int n) {
        return GregorianMath.getLengthOfMonth(n, this.getValue());
    }

    public Month next() {
        return this.roll(1);
    }

    public Month previous() {
        return this.roll(-1);
    }

    public Month roll(int n) {
        return Month.valueOf((this.ordinal() + (n % 12 + 12)) % 12 + 1);
    }

    public String getDisplayName(Locale locale) {
        return this.getDisplayName(locale, TextWidth.WIDE, OutputContext.FORMAT);
    }

    public String getDisplayName(Locale locale, TextWidth textWidth, OutputContext outputContext) {
        CalendarText calendarText = CalendarText.getInstance("iso8601", locale);
        return calendarText.getStdMonths(textWidth, outputContext).print(this);
    }

    @Override
    public boolean test(GregorianDate gregorianDate) {
        return gregorianDate.getMonth() == this.getValue();
    }

    static {
        ENUMS = Month.values();
    }
}

