/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import java.io.Serializable;
import net.time4j.base.MathUtils;
import net.time4j.engine.CalendarVariant;
import net.time4j.engine.Calendrical;

public final class CalendarDays
implements Comparable<CalendarDays>,
Serializable {
    public static final CalendarDays ZERO = new CalendarDays(0L);
    public static final CalendarDays ONE = new CalendarDays(1L);
    private final long days;

    private CalendarDays(long l) {
        this.days = l;
    }

    public static CalendarDays of(long l) {
        return l == 0L ? ZERO : (l == 1L ? ONE : new CalendarDays(l));
    }

    public long getAmount() {
        return this.days;
    }

    public boolean isZero() {
        return this.days == 0L;
    }

    public boolean isNegative() {
        return this.days < 0L;
    }

    public static CalendarDays between(CalendarVariant<?> calendarVariant, CalendarVariant<?> calendarVariant2) {
        long l = CalendarVariant.utcDays(calendarVariant);
        long l2 = CalendarVariant.utcDays(calendarVariant2);
        return CalendarDays.of(MathUtils.safeSubtract(l2, l));
    }

    public static CalendarDays between(Calendrical<?, ?> calendrical, Calendrical<?, ?> calendrical2) {
        long l = calendrical.getEpochDays();
        long l2 = calendrical2.getEpochDays();
        return CalendarDays.of(MathUtils.safeSubtract(l2, l));
    }

    public CalendarDays abs() {
        return this.days < 0L ? CalendarDays.of(MathUtils.safeNegate(this.days)) : this;
    }

    public CalendarDays plus(CalendarDays calendarDays) {
        return CalendarDays.of(MathUtils.safeAdd(this.days, calendarDays.days));
    }

    public CalendarDays minus(CalendarDays calendarDays) {
        return CalendarDays.of(MathUtils.safeSubtract(this.days, calendarDays.days));
    }

    @Override
    public int compareTo(CalendarDays calendarDays) {
        return this.days < calendarDays.days ? -1 : (this.days > calendarDays.days ? 1 : 0);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CalendarDays) {
            return this.days == ((CalendarDays)object).days;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.days ^ this.days >>> 32);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.days < 0L) {
            stringBuilder.append('-');
        }
        stringBuilder.append('P');
        stringBuilder.append(Math.abs(this.days));
        stringBuilder.append('D');
        return stringBuilder.toString();
    }
}

