/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.time4j.AdjustableElement;
import net.time4j.AmPmElement;
import net.time4j.ClockUnit;
import net.time4j.DayCycles;
import net.time4j.DecimalTimeElement;
import net.time4j.FormatSupport;
import net.time4j.IntegerTimeElement;
import net.time4j.IsoTimeUnit;
import net.time4j.LongElement;
import net.time4j.Meridiem;
import net.time4j.PlainTimestamp;
import net.time4j.PrecisionElement;
import net.time4j.ProportionalElement;
import net.time4j.SPX;
import net.time4j.TimeElement;
import net.time4j.WallTimeElement;
import net.time4j.ZonalElement;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.base.UnixTime;
import net.time4j.base.WallTime;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.Temporal;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimePoint;
import net.time4j.engine.UnitRule;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.ChronoPattern;
import net.time4j.format.DisplayMode;
import net.time4j.format.Leniency;
import net.time4j.format.TemporalFormatter;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

@CalendarType(value="iso8601")
public final class PlainTime
extends TimePoint<IsoTimeUnit, PlainTime>
implements WallTime,
Temporal<PlainTime> {
    static final char ISO_DECIMAL_SEPARATOR = (char)(Boolean.getBoolean("net.time4j.format.iso.decimal.dot") ? 46 : 44);
    private static final int MRD = 1000000000;
    private static final int MIO = 1000000;
    private static final int KILO = 1000;
    private static final BigDecimal DECIMAL_60 = new BigDecimal(60);
    private static final BigDecimal DECIMAL_3600 = new BigDecimal(3600);
    private static final BigDecimal DECIMAL_MRD = new BigDecimal(1000000000);
    private static final BigDecimal DECIMAL_24_0 = new BigDecimal("24");
    private static final BigDecimal DECIMAL_23_9 = new BigDecimal("23.999999999999999");
    private static final BigDecimal DECIMAL_59_9 = new BigDecimal("59.999999999999999");
    private static final PlainTime[] HOURS = new PlainTime[25];
    private static final long serialVersionUID = 2780881537313863339L;
    static final PlainTime MIN;
    static final PlainTime MAX;
    static final ChronoElement<PlainTime> WALL_TIME;
    public static final WallTimeElement COMPONENT;
    @FormattableElement(format="a")
    public static final ZonalElement<Meridiem> AM_PM_OF_DAY;
    @FormattableElement(format="h")
    public static final AdjustableElement<Integer, PlainTime> CLOCK_HOUR_OF_AMPM;
    @FormattableElement(format="k")
    public static final AdjustableElement<Integer, PlainTime> CLOCK_HOUR_OF_DAY;
    @FormattableElement(format="K")
    public static final ProportionalElement<Integer, PlainTime> DIGITAL_HOUR_OF_AMPM;
    @FormattableElement(format="H")
    public static final ProportionalElement<Integer, PlainTime> DIGITAL_HOUR_OF_DAY;
    public static final ProportionalElement<Integer, PlainTime> ISO_HOUR;
    @FormattableElement(format="m")
    public static final ProportionalElement<Integer, PlainTime> MINUTE_OF_HOUR;
    public static final ProportionalElement<Integer, PlainTime> MINUTE_OF_DAY;
    @FormattableElement(format="s")
    public static final ProportionalElement<Integer, PlainTime> SECOND_OF_MINUTE;
    public static final ProportionalElement<Integer, PlainTime> SECOND_OF_DAY;
    public static final ProportionalElement<Integer, PlainTime> MILLI_OF_SECOND;
    public static final ProportionalElement<Integer, PlainTime> MICRO_OF_SECOND;
    @FormattableElement(format="S")
    public static final ProportionalElement<Integer, PlainTime> NANO_OF_SECOND;
    @FormattableElement(format="A")
    public static final ProportionalElement<Integer, PlainTime> MILLI_OF_DAY;
    public static final ProportionalElement<Long, PlainTime> MICRO_OF_DAY;
    public static final ProportionalElement<Long, PlainTime> NANO_OF_DAY;
    public static final ZonalElement<BigDecimal> DECIMAL_HOUR;
    public static final ZonalElement<BigDecimal> DECIMAL_MINUTE;
    public static final ZonalElement<BigDecimal> DECIMAL_SECOND;
    public static final ChronoElement<ClockUnit> PRECISION;
    private static final Map<String, Object> ELEMENTS;
    private static final ElementRule<PlainTime, BigDecimal> H_DECIMAL_RULE;
    private static final ElementRule<PlainTime, BigDecimal> M_DECIMAL_RULE;
    private static final ElementRule<PlainTime, BigDecimal> S_DECIMAL_RULE;
    private static final TimeAxis<IsoTimeUnit, PlainTime> ENGINE;
    private final transient byte hour;
    private final transient byte minute;
    private final transient byte second;
    private final transient int nano;

    private PlainTime(int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            PlainTime.checkHour(n);
            PlainTime.checkMinute(n2);
            PlainTime.checkSecond(n3);
            PlainTime.checkNano(n4);
            if (n == 24 && (n2 | n3 | n4) != 0) {
                throw new IllegalArgumentException("T24:00:00 exceeded.");
            }
        }
        this.hour = (byte)n;
        this.minute = (byte)n2;
        this.second = (byte)n3;
        this.nano = n4;
    }

    @Override
    public int getHour() {
        return this.hour;
    }

    @Override
    public int getMinute() {
        return this.minute;
    }

    @Override
    public int getSecond() {
        return this.second;
    }

    @Override
    public int getNanosecond() {
        return this.nano;
    }

    public static PlainTime midnightAtStartOfDay() {
        return MIN;
    }

    public static PlainTime midnightAtEndOfDay() {
        return MAX;
    }

    public static PlainTime of(int n) {
        PlainTime.checkHour(n);
        return HOURS[n];
    }

    public static PlainTime of(int n, int n2) {
        if (n2 == 0) {
            return PlainTime.of(n);
        }
        return new PlainTime(n, n2, 0, 0, true);
    }

    public static PlainTime of(int n, int n2, int n3) {
        if ((n2 | n3) == 0) {
            return PlainTime.of(n);
        }
        return new PlainTime(n, n2, n3, 0, true);
    }

    public static PlainTime of(int n, int n2, int n3, int n4) {
        return PlainTime.of(n, n2, n3, n4, true);
    }

    public static PlainTime of(BigDecimal bigDecimal) {
        return H_DECIMAL_RULE.withValue(null, bigDecimal, false);
    }

    public static PlainTime from(WallTime wallTime) {
        if (wallTime instanceof PlainTime) {
            return (PlainTime)wallTime;
        }
        if (wallTime instanceof PlainTimestamp) {
            return ((PlainTimestamp)wallTime).getWallTime();
        }
        return PlainTime.of(wallTime.getHour(), wallTime.getMinute(), wallTime.getSecond(), wallTime.getNanosecond());
    }

    public DayCycles roll(long l, ClockUnit clockUnit) {
        return ClockUnitRule.addToWithOverflow(this, l, clockUnit);
    }

    public static <P extends ChronoPattern<P>> TemporalFormatter<PlainTime> localFormatter(String string, P p) {
        return FormatSupport.createFormatter(PlainTime.class, string, p, Locale.getDefault());
    }

    public static TemporalFormatter<PlainTime> localFormatter(DisplayMode displayMode) {
        return PlainTime.formatter(displayMode, Locale.getDefault());
    }

    public static <P extends ChronoPattern<P>> TemporalFormatter<PlainTime> formatter(String string, P p, Locale locale) {
        return FormatSupport.createFormatter(PlainTime.class, string, p, locale);
    }

    public static TemporalFormatter<PlainTime> formatter(DisplayMode displayMode, Locale locale) {
        int n = FormatSupport.getFormatStyle(displayMode);
        DateFormat dateFormat = DateFormat.getTimeInstance(n, locale);
        String string = PlainTime.removeZones(FormatSupport.getFormatPattern(dateFormat));
        return FormatSupport.createFormatter(PlainTime.class, string, locale);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof PlainTime) {
            PlainTime plainTime = (PlainTime)object;
            return this.hour == plainTime.hour && this.minute == plainTime.minute && this.second == plainTime.second && this.nano == plainTime.nano;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.hour + 60 * this.minute + 3600 * this.second + 37 * this.nano;
    }

    @Override
    public boolean isBefore(PlainTime plainTime) {
        return this.compareTo(plainTime) < 0;
    }

    @Override
    public boolean isAfter(PlainTime plainTime) {
        return this.compareTo(plainTime) > 0;
    }

    @Override
    public boolean isSimultaneous(PlainTime plainTime) {
        return this.compareTo(plainTime) == 0;
    }

    public boolean isMidnight() {
        return this.isFullHour() && this.hour % 24 == 0;
    }

    @Override
    public int compareTo(PlainTime plainTime) {
        int n = this.hour - plainTime.hour;
        if (n == 0 && (n = this.minute - plainTime.minute) == 0 && (n = this.second - plainTime.second) == 0) {
            n = this.nano - plainTime.nano;
        }
        return n < 0 ? -1 : (n == 0 ? 0 : 1);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(19);
        stringBuilder.append('T');
        PlainTime.append2Digits(this.hour, stringBuilder);
        if ((this.minute | this.second | this.nano) != 0) {
            stringBuilder.append(':');
            PlainTime.append2Digits(this.minute, stringBuilder);
            if ((this.second | this.nano) != 0) {
                stringBuilder.append(':');
                PlainTime.append2Digits(this.second, stringBuilder);
                if (this.nano != 0) {
                    int n;
                    stringBuilder.append(ISO_DECIMAL_SEPARATOR);
                    String string = Integer.toString(this.nano);
                    int n2 = this.nano % 1000000 == 0 ? 3 : (this.nano % 1000 == 0 ? 6 : 9);
                    for (n = string.length(); n < 9; ++n) {
                        stringBuilder.append('0');
                    }
                    int n3 = Math.min(n2, string.length());
                    for (n = 0; n < n3; ++n) {
                        stringBuilder.append(string.charAt(n));
                    }
                }
            }
        }
        return stringBuilder.toString();
    }

    public static TimeAxis<IsoTimeUnit, PlainTime> axis() {
        return ENGINE;
    }

    @Override
    protected TimeAxis<IsoTimeUnit, PlainTime> getChronology() {
        return ENGINE;
    }

    @Override
    protected PlainTime getContext() {
        return this;
    }

    static PlainTime from(UnixTime unixTime, ZonalOffset zonalOffset) {
        long l = unixTime.getPosixTime() + (long)zonalOffset.getIntegralAmount();
        int n = unixTime.getNanosecond() + zonalOffset.getFractionalAmount();
        if (n < 0) {
            n += 1000000000;
            --l;
        } else if (n >= 1000000000) {
            n -= 1000000000;
            ++l;
        }
        int n2 = MathUtils.floorModulo(l, 86400);
        int n3 = n2 % 60;
        int n4 = n2 / 60;
        int n5 = n4 % 60;
        int n6 = n4 / 60;
        return PlainTime.of(n6, n5, n3, n);
    }

    static Object lookupElement(String string) {
        return ELEMENTS.get(string);
    }

    boolean hasReducedRange(ChronoElement<?> chronoElement) {
        return chronoElement == MILLI_OF_DAY && this.nano % 1000000 != 0 || chronoElement == ISO_HOUR && !this.isFullHour() || chronoElement == MINUTE_OF_DAY && !this.isFullMinute() || chronoElement == SECOND_OF_DAY && this.nano != 0 || chronoElement == MICRO_OF_DAY && this.nano % 1000 != 0;
    }

    private static PlainTime of(int n, int n2, int n3, int n4, boolean bl) {
        if ((n2 | n3 | n4) == 0) {
            if (bl) {
                return PlainTime.of(n);
            }
            return HOURS[n];
        }
        return new PlainTime(n, n2, n3, n4, bl);
    }

    private static void fill(Map<String, Object> map, ChronoElement<?> chronoElement) {
        map.put(chronoElement.name(), chronoElement);
    }

    private static void append2Digits(int n, StringBuilder stringBuilder) {
        if (n < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n);
    }

    private static void checkHour(long l) {
        if (l < 0L || l > 24L) {
            throw new IllegalArgumentException("HOUR_OF_DAY out of range: " + l);
        }
    }

    private static void checkMinute(long l) {
        if (l < 0L || l > 59L) {
            throw new IllegalArgumentException("MINUTE_OF_HOUR out of range: " + l);
        }
    }

    private static void checkSecond(long l) {
        if (l < 0L || l > 59L) {
            throw new IllegalArgumentException("SECOND_OF_MINUTE out of range: " + l);
        }
    }

    private static void checkNano(int n) {
        if (n < 0 || n >= 1000000000) {
            throw new IllegalArgumentException("NANO_OF_SECOND out of range: " + n);
        }
    }

    private static PlainTime createFromMillis(int n, int n2) {
        int n3 = n % 1000 * 1000000 + n2;
        int n4 = n / 1000;
        int n5 = n4 % 60;
        int n6 = n4 / 60;
        int n7 = n6 % 60;
        int n8 = n6 / 60;
        return PlainTime.of(n8, n7, n5, n3);
    }

    private static PlainTime createFromMicros(long l, int n) {
        int n2 = (int)(l % 1000000L) * 1000 + n;
        int n3 = (int)(l / 1000000L);
        int n4 = n3 % 60;
        int n5 = n3 / 60;
        int n6 = n5 % 60;
        int n7 = n5 / 60;
        return PlainTime.of(n7, n6, n4, n2);
    }

    private static PlainTime createFromNanos(long l) {
        int n = (int)(l % 1000000000L);
        int n2 = (int)(l / 1000000000L);
        int n3 = n2 % 60;
        int n4 = n2 / 60;
        int n5 = n4 % 60;
        int n6 = n4 / 60;
        return PlainTime.of(n6, n5, n3, n);
    }

    private long getNanoOfDay() {
        return (long)this.nano + (long)this.second * 1000000000L + (long)this.minute * 60L * 1000000000L + (long)this.hour * 3600L * 1000000000L;
    }

    private boolean isFullHour() {
        return (this.minute | this.second | this.nano) == 0;
    }

    private boolean isFullMinute() {
        return (this.second | this.nano) == 0;
    }

    private static void registerUnits(TimeAxis.Builder<IsoTimeUnit, PlainTime> builder) {
        EnumSet<ClockUnit> enumSet = EnumSet.allOf(ClockUnit.class);
        for (ClockUnit clockUnit : ClockUnit.values()) {
            builder.appendUnit(clockUnit, new ClockUnitRule(clockUnit), clockUnit.getLength(), enumSet);
        }
    }

    private static long floorMod(long l, long l2) {
        long l3 = l >= 0L ? l / l2 : (l + 1L) / l2 - 1L;
        return l - l2 * l3;
    }

    private static long floorDiv(long l, long l2) {
        if (l >= 0L) {
            return l / l2;
        }
        return (l + 1L) / l2 - 1L;
    }

    private static String removeZones(String string) {
        int n;
        String string2 = string.replace(" z", "");
        if (string2.charAt(string2.length() - 1) == 'z') {
            for (n = string2.length() - 1; n > 0; --n) {
                if (string2.charAt(n - 1) == 'z') continue;
                string2 = string2.substring(0, n).trim();
                break;
            }
        }
        if (string2.charAt(0) == 'z') {
            for (n = 1; n < string2.length(); ++n) {
                if (string2.charAt(n) == 'z') continue;
                string2 = string2.substring(n).trim();
                break;
            }
        }
        return string2;
    }

    private Object writeReplace() {
        return new SPX(this, 2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        for (int i = 0; i <= 24; ++i) {
            PlainTime.HOURS[i] = new PlainTime(i, 0, 0, 0, false);
        }
        MIN = HOURS[0];
        MAX = HOURS[24];
        WALL_TIME = TimeElement.INSTANCE;
        COMPONENT = TimeElement.INSTANCE;
        AM_PM_OF_DAY = AmPmElement.AM_PM_OF_DAY;
        CLOCK_HOUR_OF_AMPM = IntegerTimeElement.createClockElement("CLOCK_HOUR_OF_AMPM", false);
        CLOCK_HOUR_OF_DAY = IntegerTimeElement.createClockElement("CLOCK_HOUR_OF_DAY", true);
        DIGITAL_HOUR_OF_AMPM = IntegerTimeElement.createTimeElement("DIGITAL_HOUR_OF_AMPM", 3, 0, 11, 'K');
        DIGITAL_HOUR_OF_DAY = IntegerTimeElement.createTimeElement("DIGITAL_HOUR_OF_DAY", 4, 0, 23, 'H');
        ISO_HOUR = IntegerTimeElement.createTimeElement("ISO_HOUR", 5, 0, 23, '\u0000');
        MINUTE_OF_HOUR = IntegerTimeElement.createTimeElement("MINUTE_OF_HOUR", 6, 0, 59, 'm');
        MINUTE_OF_DAY = IntegerTimeElement.createTimeElement("MINUTE_OF_DAY", 7, 0, 1439, '\u0000');
        SECOND_OF_MINUTE = IntegerTimeElement.createTimeElement("SECOND_OF_MINUTE", 8, 0, 59, 's');
        SECOND_OF_DAY = IntegerTimeElement.createTimeElement("SECOND_OF_DAY", 9, 0, 86399, '\u0000');
        MILLI_OF_SECOND = IntegerTimeElement.createTimeElement("MILLI_OF_SECOND", 10, 0, 999, '\u0000');
        MICRO_OF_SECOND = IntegerTimeElement.createTimeElement("MICRO_OF_SECOND", 11, 0, 999999, '\u0000');
        NANO_OF_SECOND = IntegerTimeElement.createTimeElement("NANO_OF_SECOND", 12, 0, 999999999, 'S');
        MILLI_OF_DAY = IntegerTimeElement.createTimeElement("MILLI_OF_DAY", 13, 0, 86399999, 'A');
        MICRO_OF_DAY = LongElement.create("MICRO_OF_DAY", 0L, 86399999999L);
        NANO_OF_DAY = LongElement.create("NANO_OF_DAY", 0L, 86399999999999L);
        DECIMAL_HOUR = new DecimalTimeElement("DECIMAL_HOUR", DECIMAL_23_9);
        DECIMAL_MINUTE = new DecimalTimeElement("DECIMAL_MINUTE", DECIMAL_59_9);
        DECIMAL_SECOND = new DecimalTimeElement("DECIMAL_SECOND", DECIMAL_59_9);
        PRECISION = PrecisionElement.PRECISION;
        Object object = new HashMap<String, Object>();
        PlainTime.fill(object, WALL_TIME);
        PlainTime.fill(object, AM_PM_OF_DAY);
        PlainTime.fill(object, CLOCK_HOUR_OF_AMPM);
        PlainTime.fill(object, CLOCK_HOUR_OF_DAY);
        PlainTime.fill(object, DIGITAL_HOUR_OF_AMPM);
        PlainTime.fill(object, DIGITAL_HOUR_OF_DAY);
        PlainTime.fill(object, ISO_HOUR);
        PlainTime.fill(object, MINUTE_OF_HOUR);
        PlainTime.fill(object, MINUTE_OF_DAY);
        PlainTime.fill(object, SECOND_OF_MINUTE);
        PlainTime.fill(object, SECOND_OF_DAY);
        PlainTime.fill(object, MILLI_OF_SECOND);
        PlainTime.fill(object, MICRO_OF_SECOND);
        PlainTime.fill(object, NANO_OF_SECOND);
        PlainTime.fill(object, MILLI_OF_DAY);
        PlainTime.fill(object, MICRO_OF_DAY);
        PlainTime.fill(object, NANO_OF_DAY);
        PlainTime.fill(object, DECIMAL_HOUR);
        PlainTime.fill(object, DECIMAL_MINUTE);
        PlainTime.fill(object, DECIMAL_SECOND);
        PlainTime.fill(object, PRECISION);
        ELEMENTS = Collections.unmodifiableMap(object);
        H_DECIMAL_RULE = new BigDecimalElementRule(DECIMAL_HOUR, DECIMAL_24_0);
        M_DECIMAL_RULE = new BigDecimalElementRule(DECIMAL_MINUTE, DECIMAL_59_9);
        S_DECIMAL_RULE = new BigDecimalElementRule(DECIMAL_SECOND, DECIMAL_59_9);
        object = ((TimeAxis.Builder)((TimeAxis.Builder)((TimeAxis.Builder)((TimeAxis.Builder)((TimeAxis.Builder)TimeAxis.Builder.setUp(IsoTimeUnit.class, PlainTime.class, new Merger(), MIN, MAX).appendElement((ChronoElement)WALL_TIME, (ElementRule)new TimeRule())).appendElement((ChronoElement)AM_PM_OF_DAY, (ElementRule)new MeridiemRule())).appendElement(CLOCK_HOUR_OF_AMPM, new IntegerElementRule(CLOCK_HOUR_OF_AMPM, 1, 12), ClockUnit.HOURS).appendElement(CLOCK_HOUR_OF_DAY, new IntegerElementRule(CLOCK_HOUR_OF_DAY, 1, 24), ClockUnit.HOURS).appendElement(DIGITAL_HOUR_OF_AMPM, new IntegerElementRule(DIGITAL_HOUR_OF_AMPM, 0, 11), ClockUnit.HOURS).appendElement(DIGITAL_HOUR_OF_DAY, new IntegerElementRule(DIGITAL_HOUR_OF_DAY, 0, 23), ClockUnit.HOURS).appendElement(ISO_HOUR, new IntegerElementRule(ISO_HOUR, 0, 24), ClockUnit.HOURS).appendElement(MINUTE_OF_HOUR, new IntegerElementRule(MINUTE_OF_HOUR, 0, 59), ClockUnit.MINUTES).appendElement(MINUTE_OF_DAY, new IntegerElementRule(MINUTE_OF_DAY, 0, 1440), ClockUnit.MINUTES).appendElement(SECOND_OF_MINUTE, new IntegerElementRule(SECOND_OF_MINUTE, 0, 59), ClockUnit.SECONDS).appendElement(SECOND_OF_DAY, new IntegerElementRule(SECOND_OF_DAY, 0, 86400), ClockUnit.SECONDS).appendElement(MILLI_OF_SECOND, new IntegerElementRule(MILLI_OF_SECOND, 0, 999), ClockUnit.MILLIS).appendElement(MICRO_OF_SECOND, new IntegerElementRule(MICRO_OF_SECOND, 0, 999999), ClockUnit.MICROS).appendElement(NANO_OF_SECOND, new IntegerElementRule(NANO_OF_SECOND, 0, 999999999), ClockUnit.NANOS).appendElement(MILLI_OF_DAY, new IntegerElementRule(MILLI_OF_DAY, 0, 86400000), ClockUnit.MILLIS).appendElement(MICRO_OF_DAY, new LongElementRule(MICRO_OF_DAY, 0L, 86400000000L), ClockUnit.MICROS).appendElement(NANO_OF_DAY, new LongElementRule(NANO_OF_DAY, 0L, 86400000000000L), ClockUnit.NANOS).appendElement((ChronoElement)DECIMAL_HOUR, H_DECIMAL_RULE)).appendElement((ChronoElement)DECIMAL_MINUTE, (ElementRule)M_DECIMAL_RULE)).appendElement((ChronoElement)DECIMAL_SECOND, (ElementRule)S_DECIMAL_RULE)).appendElement((ChronoElement)PRECISION, (ElementRule)new PrecisionRule());
        PlainTime.registerUnits((TimeAxis.Builder<IsoTimeUnit, PlainTime>)object);
        ENGINE = ((TimeAxis.Builder)object).build();
    }

    private static class Merger
    implements ChronoMerger<PlainTime> {
        private Merger() {
        }

        @Override
        public PlainTime createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            Timezone timezone;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                timezone = Timezone.of(attributeQuery.get(Attributes.TIMEZONE_ID));
            } else if (attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax()) {
                timezone = Timezone.ofSystem();
            } else {
                return null;
            }
            Object obj = timeSource.currentTime();
            return PlainTime.from(obj, timezone.getOffset((UnixTime)obj));
        }

        @Override
        public PlainTime createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
            int n;
            if (chronoEntity instanceof UnixTime) {
                return ((PlainTimestamp)PlainTimestamp.axis().createFrom((ChronoEntity)chronoEntity, attributeQuery, bl)).getWallTime();
            }
            if (chronoEntity.contains(WALL_TIME)) {
                return chronoEntity.get(WALL_TIME);
            }
            if (chronoEntity.contains(PlainTime.axis().element())) {
                return chronoEntity.get(PlainTime.axis().element());
            }
            if (chronoEntity.contains(DECIMAL_HOUR)) {
                return PlainTime.of(chronoEntity.get(DECIMAL_HOUR));
            }
            Leniency leniency = attributeQuery.get(Attributes.LENIENCY, Leniency.SMART);
            if (chronoEntity.contains(ISO_HOUR)) {
                n = (Integer)chronoEntity.get(ISO_HOUR);
            } else {
                Integer n2 = Merger.readHour(chronoEntity);
                if (n2 == null) {
                    return Merger.readSpecialCases(chronoEntity);
                }
                n = n2;
                if (n == 24 && !leniency.isLax()) {
                    Merger.flagValidationError(chronoEntity, "Time 24:00 not allowed, use lax mode or element ISO_HOUR instead.");
                    return null;
                }
            }
            if (chronoEntity.contains(DECIMAL_MINUTE)) {
                return M_DECIMAL_RULE.withValue(PlainTime.of(n), chronoEntity.get(DECIMAL_MINUTE), false);
            }
            int n3 = 0;
            if (chronoEntity.contains(MINUTE_OF_HOUR)) {
                n3 = (Integer)chronoEntity.get(MINUTE_OF_HOUR);
            }
            if (chronoEntity.contains(DECIMAL_SECOND)) {
                return S_DECIMAL_RULE.withValue(PlainTime.of(n, n3), chronoEntity.get(DECIMAL_SECOND), false);
            }
            int n4 = 0;
            if (chronoEntity.contains(SECOND_OF_MINUTE)) {
                n4 = (Integer)chronoEntity.get(SECOND_OF_MINUTE);
            }
            int n5 = 0;
            if (chronoEntity.contains(NANO_OF_SECOND)) {
                n5 = (Integer)chronoEntity.get(NANO_OF_SECOND);
            } else if (chronoEntity.contains(MICRO_OF_SECOND)) {
                n5 = (Integer)chronoEntity.get(MICRO_OF_SECOND) * 1000;
            } else if (chronoEntity.contains(MILLI_OF_SECOND)) {
                n5 = (Integer)chronoEntity.get(MILLI_OF_SECOND) * 1000000;
            }
            if (leniency.isLax()) {
                long l = MathUtils.safeAdd(MathUtils.safeMultiply(MathUtils.safeAdd(MathUtils.safeAdd(MathUtils.safeMultiply((long)n, 3600L), MathUtils.safeMultiply((long)n3, 60L)), (long)n4), 1000000000L), (long)n5);
                long l2 = PlainTime.floorMod(l, 86400000000000L);
                long l3 = PlainTime.floorDiv(l, 86400000000000L);
                if (l3 != 0L && chronoEntity.isValid(LongElement.DAY_OVERFLOW, l3)) {
                    chronoEntity.with(LongElement.DAY_OVERFLOW, l3);
                }
                if (l2 == 0L && l3 > 0L) {
                    return MAX;
                }
                return PlainTime.createFromNanos(l2);
            }
            if (n >= 0 && n3 >= 0 && n4 >= 0 && n5 >= 0 && n == 24 && (n3 | n4 | n5) == 0 || n < 24 && n3 <= 59 && n4 <= 59 && n5 <= 1000000000) {
                return PlainTime.of(n, n3, n4, n5, false);
            }
            Merger.flagValidationError(chronoEntity, "Time component out of range.");
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static Integer readHour(ChronoEntity<?> chronoEntity) {
            int n;
            if (chronoEntity.contains(DIGITAL_HOUR_OF_DAY)) {
                n = (Integer)chronoEntity.get(DIGITAL_HOUR_OF_DAY);
                return n;
            } else if (chronoEntity.contains(CLOCK_HOUR_OF_DAY)) {
                n = (Integer)chronoEntity.get(CLOCK_HOUR_OF_DAY);
                if (n != 24) return n;
                n = 0;
                return n;
            } else {
                if (!chronoEntity.contains(AM_PM_OF_DAY)) return null;
                Meridiem meridiem = chronoEntity.get(AM_PM_OF_DAY);
                if (chronoEntity.contains(DIGITAL_HOUR_OF_AMPM)) {
                    int n2 = (Integer)chronoEntity.get(DIGITAL_HOUR_OF_AMPM);
                    n = meridiem == Meridiem.AM ? n2 : n2 + 12;
                    return n;
                } else {
                    if (!chronoEntity.contains(CLOCK_HOUR_OF_AMPM)) return null;
                    int n3 = (Integer)chronoEntity.get(CLOCK_HOUR_OF_AMPM);
                    if (n3 == 12) {
                        n3 = 0;
                    }
                    n = meridiem == Meridiem.AM ? n3 : n3 + 12;
                }
            }
            return n;
        }

        private static PlainTime readSpecialCases(ChronoEntity<?> chronoEntity) {
            if (chronoEntity.contains(NANO_OF_DAY)) {
                long l = (Long)chronoEntity.get(NANO_OF_DAY);
                if (l < 0L || l > 86400000000000L) {
                    Merger.flagValidationError(chronoEntity, "NANO_OF_DAY out of range: " + l);
                    return null;
                }
                return PlainTime.createFromNanos(l);
            }
            if (chronoEntity.contains(MICRO_OF_DAY)) {
                int n = 0;
                if (chronoEntity.contains(NANO_OF_SECOND)) {
                    n = (Integer)chronoEntity.get(NANO_OF_SECOND) % 1000;
                }
                return PlainTime.createFromMicros((Long)chronoEntity.get(MICRO_OF_DAY), n);
            }
            if (chronoEntity.contains(MILLI_OF_DAY)) {
                int n;
                int n2 = 0;
                if (chronoEntity.contains(NANO_OF_SECOND)) {
                    n = (Integer)chronoEntity.get(NANO_OF_SECOND);
                    if (n < 0 || n >= 1000000000) {
                        Merger.flagValidationError(chronoEntity, "NANO_OF_SECOND out of range: " + n);
                        return null;
                    }
                    n2 = n % 1000000;
                } else if (chronoEntity.contains(MICRO_OF_SECOND)) {
                    n = (Integer)chronoEntity.get(MICRO_OF_SECOND);
                    if (n < 0 || n >= 1000000) {
                        Merger.flagValidationError(chronoEntity, "MICRO_OF_SECOND out of range: " + n);
                        return null;
                    }
                    n2 = n % 1000;
                }
                n = (Integer)chronoEntity.get(MILLI_OF_DAY);
                if (n < 0 || n > 86400000) {
                    Merger.flagValidationError(chronoEntity, "MILLI_OF_DAY out of range: " + n);
                    return null;
                }
                return PlainTime.createFromMillis(n, n2);
            }
            if (chronoEntity.contains(SECOND_OF_DAY)) {
                int n = 0;
                if (chronoEntity.contains(NANO_OF_SECOND)) {
                    n = (Integer)chronoEntity.get(NANO_OF_SECOND);
                } else if (chronoEntity.contains(MICRO_OF_SECOND)) {
                    n = (Integer)chronoEntity.get(MICRO_OF_SECOND) * 1000;
                } else if (chronoEntity.contains(MILLI_OF_SECOND)) {
                    n = (Integer)chronoEntity.get(MILLI_OF_SECOND) * 1000000;
                }
                return (PlainTime)PlainTime.of(0, 0, 0, n).with(SECOND_OF_DAY, chronoEntity.get(SECOND_OF_DAY));
            }
            if (chronoEntity.contains(MINUTE_OF_DAY)) {
                int n = 0;
                if (chronoEntity.contains(NANO_OF_SECOND)) {
                    n = (Integer)chronoEntity.get(NANO_OF_SECOND);
                } else if (chronoEntity.contains(MICRO_OF_SECOND)) {
                    n = (Integer)chronoEntity.get(MICRO_OF_SECOND) * 1000;
                } else if (chronoEntity.contains(MILLI_OF_SECOND)) {
                    n = (Integer)chronoEntity.get(MILLI_OF_SECOND) * 1000000;
                }
                int n3 = 0;
                if (chronoEntity.contains(SECOND_OF_MINUTE)) {
                    n3 = (Integer)chronoEntity.get(SECOND_OF_MINUTE);
                }
                return (PlainTime)PlainTime.of(0, 0, n3, n).with(MINUTE_OF_DAY, chronoEntity.get(MINUTE_OF_DAY));
            }
            return null;
        }

        private static void flagValidationError(ChronoEntity<?> chronoEntity, String string) {
            if (chronoEntity.isValid(ValidationElement.ERROR_MESSAGE, string)) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, string);
            }
        }

        @Override
        public ChronoDisplay preformat(PlainTime plainTime, AttributeQuery attributeQuery) {
            return plainTime;
        }

        @Override
        public Chronology<?> preparser() {
            return null;
        }
    }

    private static class BigDecimalElementRule
    implements ElementRule<PlainTime, BigDecimal> {
        private final ChronoElement<BigDecimal> element;
        private final BigDecimal max;

        BigDecimalElementRule(ChronoElement<BigDecimal> chronoElement, BigDecimal bigDecimal) {
            this.element = chronoElement;
            this.max = bigDecimal;
        }

        @Override
        public BigDecimal getValue(PlainTime plainTime) {
            BigDecimal bigDecimal;
            if (this.element == DECIMAL_HOUR) {
                if (plainTime.equals(MIN)) {
                    return BigDecimal.ZERO;
                }
                if (plainTime.hour == 24) {
                    return DECIMAL_24_0;
                }
                bigDecimal = BigDecimal.valueOf(plainTime.hour).add(BigDecimalElementRule.div(BigDecimal.valueOf(plainTime.minute), DECIMAL_60)).add(BigDecimalElementRule.div(BigDecimal.valueOf(plainTime.second), DECIMAL_3600)).add(BigDecimalElementRule.div(BigDecimal.valueOf(plainTime.nano), DECIMAL_3600.multiply(DECIMAL_MRD)));
            } else if (this.element == DECIMAL_MINUTE) {
                if (plainTime.isFullHour()) {
                    return BigDecimal.ZERO;
                }
                bigDecimal = BigDecimal.valueOf(plainTime.minute).add(BigDecimalElementRule.div(BigDecimal.valueOf(plainTime.second), DECIMAL_60)).add(BigDecimalElementRule.div(BigDecimal.valueOf(plainTime.nano), DECIMAL_60.multiply(DECIMAL_MRD)));
            } else if (this.element == DECIMAL_SECOND) {
                if (plainTime.isFullMinute()) {
                    return BigDecimal.ZERO;
                }
                bigDecimal = BigDecimal.valueOf(plainTime.second).add(BigDecimalElementRule.div(BigDecimal.valueOf(plainTime.nano), DECIMAL_MRD));
            } else {
                throw new UnsupportedOperationException(this.element.name());
            }
            return bigDecimal.setScale(15, RoundingMode.FLOOR).stripTrailingZeros();
        }

        @Override
        public PlainTime withValue(PlainTime plainTime, BigDecimal bigDecimal, boolean bl) {
            int n;
            int n2;
            int n3;
            int n4;
            long l;
            if (this.element == DECIMAL_HOUR) {
                BigDecimal bigDecimal2 = bigDecimal.setScale(0, RoundingMode.FLOOR);
                BigDecimal bigDecimal3 = bigDecimal.subtract(bigDecimal2).multiply(DECIMAL_60);
                BigDecimal bigDecimal4 = bigDecimal3.setScale(0, RoundingMode.FLOOR);
                BigDecimal bigDecimal5 = bigDecimal3.subtract(bigDecimal4).multiply(DECIMAL_60);
                BigDecimal bigDecimal6 = bigDecimal5.setScale(0, RoundingMode.FLOOR);
                l = bigDecimal2.longValueExact();
                n4 = bigDecimal4.intValue();
                n3 = bigDecimal6.intValue();
                n2 = BigDecimalElementRule.toNano(bigDecimal5.subtract(bigDecimal6));
            } else if (this.element == DECIMAL_MINUTE) {
                BigDecimal bigDecimal7 = bigDecimal.setScale(0, RoundingMode.FLOOR);
                BigDecimal bigDecimal8 = bigDecimal.subtract(bigDecimal7).multiply(DECIMAL_60);
                BigDecimal bigDecimal9 = bigDecimal8.setScale(0, RoundingMode.FLOOR);
                n3 = bigDecimal9.intValue();
                n2 = BigDecimalElementRule.toNano(bigDecimal8.subtract(bigDecimal9));
                long l2 = bigDecimal7.longValueExact();
                l = plainTime.hour;
                if (bl) {
                    l += MathUtils.floorDivide(l2, 60);
                    n4 = MathUtils.floorModulo(l2, 60);
                } else {
                    PlainTime.checkMinute(l2);
                    n4 = (int)l2;
                }
            } else if (this.element == DECIMAL_SECOND) {
                BigDecimal bigDecimal10 = bigDecimal.setScale(0, RoundingMode.FLOOR);
                n2 = BigDecimalElementRule.toNano(bigDecimal.subtract(bigDecimal10));
                long l3 = bigDecimal10.longValueExact();
                l = plainTime.hour;
                n4 = plainTime.minute;
                if (bl) {
                    n3 = MathUtils.floorModulo(l3, 60);
                    long l4 = (long)n4 + MathUtils.floorDivide(l3, 60);
                    l += MathUtils.floorDivide(l4, 60);
                    n4 = MathUtils.floorModulo(l4, 60);
                } else {
                    PlainTime.checkSecond(l3);
                    n3 = (int)l3;
                }
            } else {
                throw new UnsupportedOperationException(this.element.name());
            }
            if (bl) {
                n = MathUtils.floorModulo(l, 24);
                if (l > 0L && (n | n4 | n3 | n2) == 0) {
                    return MAX;
                }
            } else {
                if (l < 0L || l > 24L) {
                    throw new IllegalArgumentException("Value out of range: " + bigDecimal);
                }
                n = (int)l;
            }
            return PlainTime.of(n, n4, n3, n2);
        }

        @Override
        public boolean isValid(PlainTime plainTime, BigDecimal bigDecimal) {
            if (bigDecimal == null) {
                return false;
            }
            if (plainTime.hour == 24 && (this.element == DECIMAL_MINUTE || this.element == DECIMAL_SECOND)) {
                return BigDecimal.ZERO.compareTo(bigDecimal) == 0;
            }
            return BigDecimal.ZERO.compareTo(bigDecimal) <= 0 && this.max.compareTo(bigDecimal) >= 0;
        }

        @Override
        public BigDecimal getMinimum(PlainTime plainTime) {
            return BigDecimal.ZERO;
        }

        @Override
        public BigDecimal getMaximum(PlainTime plainTime) {
            if (plainTime.hour == 24 && (this.element == DECIMAL_MINUTE || this.element == DECIMAL_SECOND)) {
                return BigDecimal.ZERO;
            }
            return this.max;
        }

        @Override
        public ChronoElement<?> getChildAtFloor(PlainTime plainTime) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(PlainTime plainTime) {
            return null;
        }

        private static BigDecimal div(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
            return bigDecimal.divide(bigDecimal2, 16, RoundingMode.FLOOR);
        }

        private static int toNano(BigDecimal bigDecimal) {
            BigDecimal bigDecimal2 = bigDecimal.movePointRight(9).setScale(0, RoundingMode.HALF_UP);
            return Math.min(999999999, bigDecimal2.intValue());
        }
    }

    private static class LongElementRule
    implements ElementRule<PlainTime, Long> {
        private final ChronoElement<Long> element;
        private final long min;
        private final long max;

        LongElementRule(ChronoElement<Long> chronoElement, long l, long l2) {
            this.element = chronoElement;
            this.min = l;
            this.max = l2;
        }

        @Override
        public Long getValue(PlainTime plainTime) {
            long l = this.element == MICRO_OF_DAY ? plainTime.getNanoOfDay() / 1000L : plainTime.getNanoOfDay();
            return l;
        }

        @Override
        public PlainTime withValue(PlainTime plainTime, Long l, boolean bl) {
            if (l == null) {
                throw new NullPointerException("Missing element value.");
            }
            if (bl) {
                return this.withValueInLenientMode(plainTime, l);
            }
            if (!this.isValid(plainTime, l)) {
                throw new IllegalArgumentException("Value out of range: " + l);
            }
            long l2 = l;
            if (this.element == MICRO_OF_DAY) {
                return PlainTime.createFromMicros(l2, plainTime.nano % 1000);
            }
            return PlainTime.createFromNanos(l2);
        }

        @Override
        public boolean isValid(PlainTime plainTime, Long l) {
            if (l == null) {
                return false;
            }
            if (this.element == MICRO_OF_DAY && l == this.max) {
                return plainTime.nano % 1000 == 0;
            }
            return this.min <= l && l <= this.max;
        }

        @Override
        public Long getMinimum(PlainTime plainTime) {
            return this.min;
        }

        @Override
        public Long getMaximum(PlainTime plainTime) {
            if (this.element == MICRO_OF_DAY && plainTime.nano % 1000 != 0) {
                return this.max - 1L;
            }
            return this.max;
        }

        @Override
        public ChronoElement<?> getChildAtFloor(PlainTime plainTime) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(PlainTime plainTime) {
            return null;
        }

        private PlainTime withValueInLenientMode(PlainTime plainTime, long l) {
            if (this.element == MICRO_OF_DAY) {
                long l2 = PlainTime.floorMod(l, 86400000000L);
                int n = plainTime.nano % 1000;
                return l2 == 0L && n == 0 && l > 0L ? MAX : PlainTime.createFromMicros(l2, n);
            }
            long l3 = PlainTime.floorMod(l, 86400000000000L);
            return l3 == 0L && l > 0L ? MAX : PlainTime.createFromNanos(l3);
        }
    }

    private static class IntegerElementRule
    implements ElementRule<PlainTime, Integer> {
        private final ChronoElement<Integer> element;
        private final int index;
        private final int min;
        private final int max;

        IntegerElementRule(ChronoElement<Integer> chronoElement, int n, int n2) {
            this.element = chronoElement;
            this.index = chronoElement instanceof IntegerTimeElement ? ((IntegerTimeElement)chronoElement).getIndex() : -1;
            this.min = n;
            this.max = n2;
        }

        @Override
        public Integer getValue(PlainTime plainTime) {
            int n;
            switch (this.index) {
                case 1: {
                    n = plainTime.hour % 12;
                    if (n != 0) break;
                    n = 12;
                    break;
                }
                case 2: {
                    n = plainTime.hour % 24;
                    if (n != 0) break;
                    n = 24;
                    break;
                }
                case 3: {
                    n = plainTime.hour % 12;
                    break;
                }
                case 4: {
                    n = plainTime.hour % 24;
                    break;
                }
                case 5: {
                    n = plainTime.hour;
                    break;
                }
                case 6: {
                    n = plainTime.minute;
                    break;
                }
                case 7: {
                    n = plainTime.hour * 60 + plainTime.minute;
                    break;
                }
                case 8: {
                    n = plainTime.second;
                    break;
                }
                case 9: {
                    n = plainTime.hour * 3600 + plainTime.minute * 60 + plainTime.second;
                    break;
                }
                case 10: {
                    n = plainTime.nano / 1000000;
                    break;
                }
                case 11: {
                    n = plainTime.nano / 1000;
                    break;
                }
                case 12: {
                    n = plainTime.nano;
                    break;
                }
                case 13: {
                    n = (int)(plainTime.getNanoOfDay() / 1000000L);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this.element.name());
                }
            }
            return n;
        }

        @Override
        public PlainTime withValue(PlainTime plainTime, Integer n, boolean bl) {
            if (n == null) {
                throw new NullPointerException("Missing element value.");
            }
            if (bl) {
                return this.withValueInLenientMode(plainTime, n);
            }
            if (!this.isValid(plainTime, n)) {
                throw new IllegalArgumentException("Value out of range: " + n);
            }
            int n2 = plainTime.hour;
            int n3 = plainTime.minute;
            int n4 = plainTime.second;
            int n5 = plainTime.nano;
            int n6 = n;
            switch (this.index) {
                case 1: {
                    n6 = n6 == 12 ? 0 : n6;
                    n2 = IntegerElementRule.isAM(plainTime) ? n6 : n6 + 12;
                    break;
                }
                case 2: {
                    n2 = n6 == 24 ? 0 : n6;
                    break;
                }
                case 3: {
                    n2 = IntegerElementRule.isAM(plainTime) ? n6 : n6 + 12;
                    break;
                }
                case 4: {
                    n2 = n6;
                    break;
                }
                case 5: {
                    n2 = n6;
                    break;
                }
                case 6: {
                    n3 = n6;
                    break;
                }
                case 7: {
                    n2 = n6 / 60;
                    n3 = n6 % 60;
                    break;
                }
                case 8: {
                    n4 = n6;
                    break;
                }
                case 9: {
                    n2 = n6 / 3600;
                    int n7 = n6 % 3600;
                    n3 = n7 / 60;
                    n4 = n7 % 60;
                    break;
                }
                case 10: {
                    n5 = n6 * 1000000 + plainTime.nano % 1000000;
                    break;
                }
                case 11: {
                    n5 = n6 * 1000 + plainTime.nano % 1000;
                    break;
                }
                case 12: {
                    n5 = n6;
                    break;
                }
                case 13: {
                    return PlainTime.createFromMillis(n6, plainTime.nano % 1000000);
                }
                default: {
                    throw new UnsupportedOperationException(this.element.name());
                }
            }
            return PlainTime.of(n2, n3, n4, n5);
        }

        @Override
        public boolean isValid(PlainTime plainTime, Integer n) {
            if (n == null) {
                return false;
            }
            int n2 = n;
            if (n2 < this.min || n2 > this.max) {
                return false;
            }
            if (n2 == this.max) {
                switch (this.index) {
                    case 5: {
                        return plainTime.isFullHour();
                    }
                    case 7: {
                        return plainTime.isFullMinute();
                    }
                    case 9: {
                        return plainTime.nano == 0;
                    }
                    case 13: {
                        return plainTime.nano % 1000000 == 0;
                    }
                }
            }
            if (plainTime.hour == 24) {
                switch (this.index) {
                    case 6: 
                    case 8: 
                    case 10: 
                    case 11: 
                    case 12: {
                        return n2 == 0;
                    }
                }
            }
            return true;
        }

        @Override
        public Integer getMinimum(PlainTime plainTime) {
            return this.min;
        }

        @Override
        public Integer getMaximum(PlainTime plainTime) {
            if (plainTime.hour == 24) {
                switch (this.index) {
                    case 6: 
                    case 8: 
                    case 10: 
                    case 11: 
                    case 12: {
                        return 0;
                    }
                }
            }
            if (plainTime.hasReducedRange(this.element)) {
                return this.max - 1;
            }
            return this.max;
        }

        @Override
        public ChronoElement<?> getChildAtFloor(PlainTime plainTime) {
            return this.getChild(plainTime);
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(PlainTime plainTime) {
            return this.getChild(plainTime);
        }

        private ChronoElement<?> getChild(PlainTime plainTime) {
            switch (this.index) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return MINUTE_OF_HOUR;
                }
                case 6: 
                case 7: {
                    return SECOND_OF_MINUTE;
                }
                case 8: 
                case 9: {
                    return NANO_OF_SECOND;
                }
            }
            return null;
        }

        private PlainTime withValueInLenientMode(PlainTime plainTime, int n) {
            if (this.element == ISO_HOUR || this.element == DIGITAL_HOUR_OF_DAY || this.element == DIGITAL_HOUR_OF_AMPM) {
                return (PlainTime)plainTime.plus(MathUtils.safeSubtract(n, plainTime.get(this.element)), ClockUnit.HOURS);
            }
            if (this.element == MINUTE_OF_HOUR) {
                return (PlainTime)plainTime.plus(MathUtils.safeSubtract(n, plainTime.minute), ClockUnit.MINUTES);
            }
            if (this.element == SECOND_OF_MINUTE) {
                return (PlainTime)plainTime.plus(MathUtils.safeSubtract(n, plainTime.second), ClockUnit.SECONDS);
            }
            if (this.element == MILLI_OF_SECOND) {
                return (PlainTime)plainTime.plus(MathUtils.safeSubtract(n, (Integer)plainTime.get(MILLI_OF_SECOND)), ClockUnit.MILLIS);
            }
            if (this.element == MICRO_OF_SECOND) {
                return (PlainTime)plainTime.plus(MathUtils.safeSubtract(n, (Integer)plainTime.get(MICRO_OF_SECOND)), ClockUnit.MICROS);
            }
            if (this.element == NANO_OF_SECOND) {
                return (PlainTime)plainTime.plus(MathUtils.safeSubtract(n, plainTime.nano), ClockUnit.NANOS);
            }
            if (this.element == MILLI_OF_DAY) {
                int n2 = MathUtils.floorModulo(n, 86400000);
                int n3 = plainTime.nano % 1000000;
                if (n2 == 0 && n3 == 0) {
                    return n > 0 ? MAX : MIN;
                }
                return PlainTime.createFromMillis(n2, n3);
            }
            if (this.element == MINUTE_OF_DAY) {
                int n4 = MathUtils.floorModulo(n, 1440);
                if (n4 == 0 && plainTime.isFullMinute()) {
                    return n > 0 ? MAX : MIN;
                }
                return this.withValue(plainTime, n4, false);
            }
            if (this.element == SECOND_OF_DAY) {
                int n5 = MathUtils.floorModulo(n, 86400);
                if (n5 == 0 && plainTime.nano == 0) {
                    return n > 0 ? MAX : MIN;
                }
                return this.withValue(plainTime, n5, false);
            }
            throw new UnsupportedOperationException(this.element.name());
        }

        private static boolean isAM(PlainTime plainTime) {
            return plainTime.hour < 12 || plainTime.hour == 24;
        }
    }

    private static class MeridiemRule
    implements ElementRule<PlainTime, Meridiem> {
        private MeridiemRule() {
        }

        @Override
        public Meridiem getValue(PlainTime plainTime) {
            return Meridiem.ofHour(plainTime.hour);
        }

        @Override
        public PlainTime withValue(PlainTime plainTime, Meridiem meridiem, boolean bl) {
            int n;
            int n2 = n = plainTime.hour == 24 ? 0 : plainTime.hour;
            if (meridiem == null) {
                throw new NullPointerException("Missing am/pm-value.");
            }
            if (meridiem == Meridiem.AM) {
                if (n >= 12) {
                    n -= 12;
                }
            } else if (meridiem == Meridiem.PM && n < 12) {
                n += 12;
            }
            return PlainTime.of(n, plainTime.minute, plainTime.second, plainTime.nano);
        }

        @Override
        public boolean isValid(PlainTime plainTime, Meridiem meridiem) {
            return meridiem != null;
        }

        @Override
        public Meridiem getMinimum(PlainTime plainTime) {
            return Meridiem.AM;
        }

        @Override
        public Meridiem getMaximum(PlainTime plainTime) {
            return Meridiem.PM;
        }

        @Override
        public ChronoElement<?> getChildAtFloor(PlainTime plainTime) {
            return DIGITAL_HOUR_OF_AMPM;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(PlainTime plainTime) {
            return DIGITAL_HOUR_OF_AMPM;
        }
    }

    private static class PrecisionRule
    implements ElementRule<PlainTime, ClockUnit> {
        private PrecisionRule() {
        }

        @Override
        public ClockUnit getValue(PlainTime plainTime) {
            if (plainTime.nano != 0) {
                if (plainTime.nano % 1000000 == 0) {
                    return ClockUnit.MILLIS;
                }
                if (plainTime.nano % 1000 == 0) {
                    return ClockUnit.MICROS;
                }
                return ClockUnit.NANOS;
            }
            if (plainTime.second != 0) {
                return ClockUnit.SECONDS;
            }
            if (plainTime.minute != 0) {
                return ClockUnit.MINUTES;
            }
            return ClockUnit.HOURS;
        }

        @Override
        public PlainTime withValue(PlainTime plainTime, ClockUnit clockUnit, boolean bl) {
            int n = clockUnit.ordinal();
            if (n >= this.getValue(plainTime).ordinal()) {
                return plainTime;
            }
            switch (clockUnit) {
                case HOURS: {
                    return PlainTime.of(plainTime.hour);
                }
                case MINUTES: {
                    return PlainTime.of(plainTime.hour, plainTime.minute);
                }
                case SECONDS: {
                    return PlainTime.of(plainTime.hour, plainTime.minute, plainTime.second);
                }
                case MILLIS: {
                    return PlainTime.of(plainTime.hour, plainTime.minute, plainTime.second, plainTime.nano / 1000000 * 1000000);
                }
                case MICROS: {
                    return PlainTime.of(plainTime.hour, plainTime.minute, plainTime.second, plainTime.nano / 1000 * 1000);
                }
                case NANOS: {
                    return plainTime;
                }
            }
            throw new UnsupportedOperationException(clockUnit.name());
        }

        @Override
        public boolean isValid(PlainTime plainTime, ClockUnit clockUnit) {
            return clockUnit != null;
        }

        @Override
        public ClockUnit getMinimum(PlainTime plainTime) {
            return ClockUnit.HOURS;
        }

        @Override
        public ClockUnit getMaximum(PlainTime plainTime) {
            return ClockUnit.NANOS;
        }

        @Override
        public ChronoElement<?> getChildAtFloor(PlainTime plainTime) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(PlainTime plainTime) {
            return null;
        }
    }

    private static class TimeRule
    implements ElementRule<PlainTime, PlainTime> {
        private TimeRule() {
        }

        @Override
        public PlainTime getValue(PlainTime plainTime) {
            return plainTime;
        }

        @Override
        public PlainTime withValue(PlainTime plainTime, PlainTime plainTime2, boolean bl) {
            if (plainTime2 == null) {
                throw new NullPointerException("Missing time value.");
            }
            return plainTime2;
        }

        @Override
        public boolean isValid(PlainTime plainTime, PlainTime plainTime2) {
            return plainTime2 != null;
        }

        @Override
        public PlainTime getMinimum(PlainTime plainTime) {
            return MIN;
        }

        @Override
        public PlainTime getMaximum(PlainTime plainTime) {
            return MAX;
        }

        @Override
        public ChronoElement<?> getChildAtFloor(PlainTime plainTime) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(PlainTime plainTime) {
            return null;
        }
    }

    private static class ClockUnitRule
    implements UnitRule<PlainTime> {
        private final ClockUnit unit;

        private ClockUnitRule(ClockUnit clockUnit) {
            this.unit = clockUnit;
        }

        @Override
        public PlainTime addTo(PlainTime plainTime, long l) {
            if (l == 0L) {
                return plainTime;
            }
            return ClockUnitRule.doAdd(PlainTime.class, this.unit, plainTime, l);
        }

        @Override
        public long between(PlainTime plainTime, PlainTime plainTime2) {
            long l;
            long l2 = plainTime2.getNanoOfDay() - plainTime.getNanoOfDay();
            switch (this.unit) {
                case HOURS: {
                    l = 3600000000000L;
                    break;
                }
                case MINUTES: {
                    l = 60000000000L;
                    break;
                }
                case SECONDS: {
                    l = 1000000000L;
                    break;
                }
                case MILLIS: {
                    l = 1000000L;
                    break;
                }
                case MICROS: {
                    l = 1000L;
                    break;
                }
                case NANOS: {
                    l = 1L;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this.unit.name());
                }
            }
            return l2 / l;
        }

        private static DayCycles addToWithOverflow(PlainTime plainTime, long l, ClockUnit clockUnit) {
            if (l == 0L && plainTime.hour < 24) {
                return new DayCycles(0L, plainTime);
            }
            return ClockUnitRule.doAdd(DayCycles.class, clockUnit, plainTime, l);
        }

        private static <R> R doAdd(Class<R> clazz, ClockUnit clockUnit, PlainTime plainTime, long l) {
            long l2;
            int n = plainTime.minute;
            int n2 = plainTime.second;
            int n3 = plainTime.nano;
            switch (clockUnit) {
                case HOURS: {
                    l2 = MathUtils.safeAdd((long)plainTime.hour, l);
                    break;
                }
                case MINUTES: {
                    long l3 = MathUtils.safeAdd((long)plainTime.minute, l);
                    l2 = MathUtils.safeAdd((long)plainTime.hour, MathUtils.floorDivide(l3, 60));
                    n = MathUtils.floorModulo(l3, 60);
                    break;
                }
                case SECONDS: {
                    long l4 = MathUtils.safeAdd((long)plainTime.second, l);
                    long l5 = MathUtils.safeAdd((long)plainTime.minute, MathUtils.floorDivide(l4, 60));
                    l2 = MathUtils.safeAdd((long)plainTime.hour, MathUtils.floorDivide(l5, 60));
                    n = MathUtils.floorModulo(l5, 60);
                    n2 = MathUtils.floorModulo(l4, 60);
                    break;
                }
                case MILLIS: {
                    return ClockUnitRule.doAdd(clazz, ClockUnit.NANOS, plainTime, MathUtils.safeMultiply(l, 1000000L));
                }
                case MICROS: {
                    return ClockUnitRule.doAdd(clazz, ClockUnit.NANOS, plainTime, MathUtils.safeMultiply(l, 1000L));
                }
                case NANOS: {
                    long l6 = MathUtils.safeAdd((long)plainTime.nano, l);
                    long l7 = MathUtils.safeAdd((long)plainTime.second, MathUtils.floorDivide(l6, 1000000000));
                    long l8 = MathUtils.safeAdd((long)plainTime.minute, MathUtils.floorDivide(l7, 60));
                    l2 = MathUtils.safeAdd((long)plainTime.hour, MathUtils.floorDivide(l8, 60));
                    n = MathUtils.floorModulo(l8, 60);
                    n2 = MathUtils.floorModulo(l7, 60);
                    n3 = MathUtils.floorModulo(l6, 1000000000);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(clockUnit.name());
                }
            }
            int n4 = MathUtils.floorModulo(l2, 24);
            PlainTime plainTime2 = (n4 | n | n2 | n3) == 0 ? (l > 0L && clazz == PlainTime.class ? MAX : MIN) : PlainTime.of(n4, n, n2, n3);
            if (clazz == PlainTime.class) {
                return clazz.cast(plainTime2);
            }
            long l9 = MathUtils.floorDivide(l2, 24);
            return clazz.cast(new DayCycles(l9, plainTime2));
        }
    }
}

