/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import java.io.Serializable;
import net.time4j.base.MathUtils;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.CalendarFamily;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.Temporal;

public abstract class CalendarVariant<D extends CalendarVariant<D>>
extends ChronoEntity<D>
implements Comparable<D>,
Temporal<CalendarVariant<?>>,
Serializable {
    public abstract String getVariant();

    public <T extends Calendrical<?, T>> T transform(Class<T> clazz) {
        String string = clazz.getName();
        Chronology<T> chronology = Chronology.lookup(clazz);
        if (chronology == null) {
            throw new IllegalArgumentException("Cannot find any chronology for given target type: " + string);
        }
        return (T)((Calendrical)this.transform(chronology.getCalendarSystem(), string));
    }

    public <T extends CalendarVariant<T>> T transform(Class<T> clazz, String string) {
        String string2 = clazz.getName();
        Chronology<T> chronology = Chronology.lookup(clazz);
        if (chronology == null) {
            throw new IllegalArgumentException("Cannot find any chronology for given target type: " + string2);
        }
        return (T)((CalendarVariant)this.transform(chronology.getCalendarSystem(string), string2));
    }

    @Override
    public int compareTo(D d) {
        long l;
        long l2 = CalendarVariant.utcDays(this);
        if (l2 < (l = CalendarVariant.utcDays(d))) {
            return -1;
        }
        if (l2 > l) {
            return 1;
        }
        return this.getVariant().compareTo(((CalendarVariant)d).getVariant());
    }

    @Override
    public boolean isAfter(CalendarVariant<?> calendarVariant) {
        long l;
        long l2 = CalendarVariant.utcDays(this);
        return l2 > (l = CalendarVariant.utcDays(calendarVariant));
    }

    @Override
    public boolean isBefore(CalendarVariant<?> calendarVariant) {
        long l;
        long l2 = CalendarVariant.utcDays(this);
        return l2 < (l = CalendarVariant.utcDays(calendarVariant));
    }

    @Override
    public boolean isSimultaneous(CalendarVariant<?> calendarVariant) {
        long l;
        long l2 = CalendarVariant.utcDays(this);
        return l2 == (l = CalendarVariant.utcDays(calendarVariant));
    }

    public D plus(CalendarDays calendarDays) {
        long l = MathUtils.safeAdd(CalendarVariant.utcDays(this), calendarDays.getAmount());
        return (D)((CalendarVariant)this.getCalendarSystem().transform(l));
    }

    public D minus(CalendarDays calendarDays) {
        long l = MathUtils.safeSubtract(CalendarVariant.utcDays(this), calendarDays.getAmount());
        return (D)((CalendarVariant)this.getCalendarSystem().transform(l));
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    @Override
    protected abstract CalendarFamily<D> getChronology();

    static <T extends CalendarVariant<T>> long utcDays(CalendarVariant<T> calendarVariant) {
        return super.getCalendarSystem().transform(calendarVariant.getContext());
    }

    @Override
    <V> ElementRule<D, V> getRule(ChronoElement<V> chronoElement) {
        if (chronoElement instanceof EpochDays) {
            EpochDays epochDays = (EpochDays)EpochDays.class.cast(chronoElement);
            return epochDays.derive(this.getCalendarSystem());
        }
        return super.getRule(chronoElement);
    }

    private CalendarSystem<D> getCalendarSystem() {
        return ((CalendarFamily)this.getChronology()).getCalendarSystem(this.getVariant());
    }

    private <T> T transform(CalendarSystem<T> calendarSystem, String string) {
        long l = CalendarVariant.utcDays(this);
        if (calendarSystem.getMinimumSinceUTC() > l || calendarSystem.getMaximumSinceUTC() < l) {
            throw new ArithmeticException("Cannot transform <" + l + "> to: " + string);
        }
        return calendarSystem.transform(l);
    }
}

