/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import net.time4j.PlainDate;
import net.time4j.PlainTimestamp;
import net.time4j.SystemClock;
import net.time4j.base.TimeSource;
import net.time4j.base.UnixTime;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarFamily;
import net.time4j.engine.CalendarVariant;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.Chronology;
import net.time4j.engine.StartOfDay;
import net.time4j.format.Attributes;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

public final class ZonalClock {
    private static final ZonalClock SYSTEM = new ZonalClock();
    private final TimeSource<?> timeSource;
    private final Timezone timezone;

    public ZonalClock(TimeSource<?> timeSource, TZID tZID) {
        if (timeSource == null) {
            throw new NullPointerException("Missing time source.");
        }
        if (tZID == null) {
            throw new NullPointerException("Missing timezone id.");
        }
        this.timeSource = timeSource;
        this.timezone = Timezone.of(tZID);
    }

    public ZonalClock(TimeSource<?> timeSource, String string) {
        if (timeSource == null) {
            throw new NullPointerException("Missing time source.");
        }
        if (string.isEmpty()) {
            throw new NullPointerException("Timezone id is empty.");
        }
        this.timeSource = timeSource;
        this.timezone = Timezone.of(string);
    }

    private ZonalClock() {
        this.timeSource = SystemClock.INSTANCE;
        this.timezone = null;
    }

    public PlainDate today() {
        Object obj = this.timeSource.currentTime();
        Timezone timezone = this.timezone == null ? Timezone.ofSystem() : this.timezone;
        return PlainDate.from(obj, timezone.getOffset((UnixTime)obj));
    }

    public PlainTimestamp now() {
        Object obj = this.timeSource.currentTime();
        Timezone timezone = this.timezone == null ? Timezone.ofSystem() : this.timezone;
        return PlainTimestamp.from(obj, timezone.getOffset((UnixTime)obj));
    }

    public <T extends ChronoEntity<T>> T now(Chronology<T> chronology) {
        Timezone timezone = this.timezone == null ? Timezone.ofSystem() : this.timezone;
        Attributes attributes = new Attributes.Builder().setTimezone(timezone.getID()).build();
        Object object = chronology.createFrom((TimeSource)this.timeSource, (AttributeQuery)attributes);
        if (object == null) {
            throw new IllegalArgumentException("Calendar variant required: " + chronology.getChronoType().getName());
        }
        return (T)object;
    }

    public <T extends CalendarVariant<T>> T now(CalendarFamily<T> calendarFamily, String string, StartOfDay startOfDay) {
        Timezone timezone = this.timezone == null ? Timezone.ofSystem() : this.timezone;
        Attributes attributes = new Attributes.Builder().setTimezone(timezone.getID()).setCalendarVariant(string).setStartOfDay(startOfDay).build();
        CalendarVariant calendarVariant = (CalendarVariant)calendarFamily.createFrom((TimeSource)this.timeSource, (AttributeQuery)attributes);
        if (calendarVariant == null) {
            throw new IllegalArgumentException("Unknown calendar variant: " + string);
        }
        return (T)calendarVariant;
    }

    public TimeSource<?> getSource() {
        return this.timeSource;
    }

    public TZID getTimezone() {
        Timezone timezone = this.timezone == null ? Timezone.ofSystem() : this.timezone;
        return timezone.getID();
    }

    static ZonalClock ofSystem() {
        return SYSTEM;
    }
}

