/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import net.time4j.base.MathUtils;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.Chronology;
import net.time4j.engine.Temporal;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimePoint;

public abstract class Calendrical<U, D extends Calendrical<U, D>>
extends TimePoint<U, D>
implements Temporal<Calendrical<?, ?>> {
    public <T extends Calendrical<?, T>> T transform(Class<T> clazz) {
        long l = this.getEpochDays();
        Chronology<T> chronology = Chronology.lookup(clazz);
        if (chronology == null) {
            throw new IllegalArgumentException("Cannot find any chronology for given target type: " + clazz.getName());
        }
        CalendarSystem<T> calendarSystem = chronology.getCalendarSystem();
        if (calendarSystem.getMinimumSinceUTC() > l || calendarSystem.getMaximumSinceUTC() < l) {
            throw new ArithmeticException("Cannot transform <" + l + "> to: " + clazz.getName());
        }
        return (T)((Calendrical)calendarSystem.transform(l));
    }

    @Override
    public boolean isBefore(Calendrical<?, ?> calendrical) {
        return this.compareByTime(calendrical) < 0;
    }

    @Override
    public boolean isAfter(Calendrical<?, ?> calendrical) {
        return this.compareByTime(calendrical) > 0;
    }

    @Override
    public boolean isSimultaneous(Calendrical<?, ?> calendrical) {
        return this == calendrical || this.compareByTime(calendrical) == 0;
    }

    @Override
    public int compareTo(D d) {
        Class clazz;
        Class clazz2 = this.getChronology().getChronoType();
        if (clazz2 != (clazz = ((TimePoint)d).getChronology().getChronoType())) {
            throw new ClassCastException("Cannot compare different types of dates, use instance of EpochDays as comparator instead.");
        }
        return this.compareByTime((Calendrical<?, ?>)d);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof Calendrical) {
            Class clazz;
            Calendrical calendrical = (Calendrical)object;
            Class clazz2 = this.getChronology().getChronoType();
            return clazz2 == (clazz = calendrical.getChronology().getChronoType()) && this.getEpochDays() == calendrical.getEpochDays();
        }
        return false;
    }

    @Override
    public int hashCode() {
        long l = this.getEpochDays();
        return (int)(l ^ l >>> 32);
    }

    public D plus(CalendarDays calendarDays) {
        long l = MathUtils.safeAdd(this.getEpochDays(), calendarDays.getAmount());
        return (D)((Calendrical)this.getCalendarSystem().transform(l));
    }

    public D minus(CalendarDays calendarDays) {
        long l = MathUtils.safeSubtract(this.getEpochDays(), calendarDays.getAmount());
        return (D)((Calendrical)this.getCalendarSystem().transform(l));
    }

    protected int compareByTime(Calendrical<?, ?> calendrical) {
        long l;
        long l2 = this.getEpochDays();
        return l2 < (l = calendrical.getEpochDays()) ? -1 : (l2 == l ? 0 : 1);
    }

    long getEpochDays() {
        return this.getCalendarSystem().transform(this.getContext());
    }

    private CalendarSystem<D> getCalendarSystem() {
        return ((TimeAxis)this.getChronology()).getCalendarSystem();
    }
}

