/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import java.io.Serializable;
import net.time4j.base.MathUtils;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.CalendarFamily;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.Temporal;

public abstract class CalendarVariant<T extends CalendarVariant<T>>
extends ChronoEntity<T>
implements Comparable<T>,
Temporal<CalendarVariant<?>>,
Serializable {
    public abstract String getVariant();

    @Override
    public int compareTo(T t) {
        long l;
        long l2 = CalendarVariant.utcDays(this);
        if (l2 < (l = CalendarVariant.utcDays(t))) {
            return -1;
        }
        if (l2 > l) {
            return 1;
        }
        return this.getVariant().compareTo(((CalendarVariant)t).getVariant());
    }

    @Override
    public boolean isAfter(CalendarVariant<?> calendarVariant) {
        long l;
        long l2 = CalendarVariant.utcDays(this);
        return l2 > (l = CalendarVariant.utcDays(calendarVariant));
    }

    @Override
    public boolean isBefore(CalendarVariant<?> calendarVariant) {
        long l;
        long l2 = CalendarVariant.utcDays(this);
        return l2 < (l = CalendarVariant.utcDays(calendarVariant));
    }

    @Override
    public boolean isSimultaneous(CalendarVariant<?> calendarVariant) {
        long l;
        long l2 = CalendarVariant.utcDays(this);
        return l2 == (l = CalendarVariant.utcDays(calendarVariant));
    }

    public T plus(CalendarDays calendarDays) {
        long l = MathUtils.safeAdd(CalendarVariant.utcDays(this), calendarDays.getAmount());
        return (T)((CalendarVariant)this.getCalendarSystem().transform(l));
    }

    public T minus(CalendarDays calendarDays) {
        long l = MathUtils.safeSubtract(CalendarVariant.utcDays(this), calendarDays.getAmount());
        return (T)((CalendarVariant)this.getCalendarSystem().transform(l));
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    @Override
    protected abstract CalendarFamily<T> getChronology();

    static <T extends CalendarVariant<T>> long utcDays(CalendarVariant<T> calendarVariant) {
        return super.getCalendarSystem().transform(calendarVariant.getContext());
    }

    private CalendarSystem<T> getCalendarSystem() {
        return ((CalendarFamily)this.getChronology()).getCalendarSystem(this.getVariant());
    }
}

