/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import net.time4j.ClockUnit;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.SystemClock;
import net.time4j.TemporalType;
import net.time4j.base.WallTime;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionHistory;
import net.time4j.tz.ZonalTransition;

final class OldApiTimezone
extends TimeZone {
    private static final long serialVersionUID = -6919910650419401271L;
    private final Timezone tz;

    OldApiTimezone(Timezone timezone) {
        this.tz = timezone;
        this.setID(timezone.getID().canonical());
        assert (timezone.getHistory() != null);
    }

    @Override
    public int getOffset(long l) {
        return this.tz.getOffset(TemporalType.MILLIS_SINCE_UNIX.translate(l)).getIntegralAmount() * 1000;
    }

    @Override
    public int getOffset(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n6 < 0 || n6 >= 86400000) {
            throw new IllegalArgumentException("Milliseconds out of range: " + n6);
        }
        if (n == 0) {
            n2 = 1 - n2;
        } else {
            if (n != 1) {
                throw new IllegalArgumentException("Unknown era: " + n);
            }
            if (n5 < 1 || n5 >= 7) {
                throw new IllegalArgumentException("Day-of-week out of range: " + n5);
            }
        }
        return this.tz.getOffset(PlainDate.of(n2, n3 + 1, n4), (WallTime)PlainTime.midnightAtStartOfDay().plus(n6, ClockUnit.MILLIS)).getIntegralAmount() * 1000;
    }

    @Override
    public void setRawOffset(int n) {
    }

    @Override
    public int getRawOffset() {
        return this.tz.getStandardOffset(SystemClock.currentMoment()).getIntegralAmount() * 1000;
    }

    @Override
    public int getDSTSavings() {
        TransitionHistory transitionHistory = this.tz.getHistory();
        if (transitionHistory != null) {
            List<ZonalTransition> list = transitionHistory.getStdTransitions();
            int n = 0;
            for (int i = list.size() - 1; i >= 0; --i) {
                ZonalTransition zonalTransition = list.get(i);
                if (!zonalTransition.isDaylightSaving()) continue;
                n = zonalTransition.getDaylightSavingOffset() * 1000;
                break;
            }
            return n;
        }
        return 0;
    }

    @Override
    public boolean useDaylightTime() {
        TransitionHistory transitionHistory;
        if (!this.tz.isFixed() && (transitionHistory = this.tz.getHistory()) != null) {
            List<ZonalTransition> list = transitionHistory.getStdTransitions();
            for (int i = list.size() - 1; i >= 0; --i) {
                if (!list.get(i).isDaylightSaving()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean inDaylightTime(Date date) {
        return this.tz.isDaylightSaving(TemporalType.JAVA_UTIL_DATE.translate(date));
    }

    @Override
    public boolean hasSameRules(TimeZone timeZone) {
        if (this == timeZone) {
            return true;
        }
        if (timeZone instanceof OldApiTimezone) {
            OldApiTimezone oldApiTimezone = (OldApiTimezone)timeZone;
            return this.tz.getHistory().equals(oldApiTimezone.tz.getHistory());
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof OldApiTimezone) {
            OldApiTimezone oldApiTimezone = (OldApiTimezone)object;
            return this.tz.equals(oldApiTimezone.tz);
        }
        return false;
    }

    public int hashCode() {
        return this.tz.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.tz.toString();
    }

    Timezone getDelegate() {
        return this.tz;
    }
}

