/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.time4j.engine.TimeSpan;
import net.time4j.format.NumberType;
import net.time4j.format.PluralCategory;
import net.time4j.format.PluralRules;

public abstract class TimeSpanFormatter<U, S extends TimeSpan<U>> {
    private static final Object SIGN_KEY = new Object();
    private final Class<U> type;
    private final List<FormatItem<U>> items;
    private final String pattern;

    protected TimeSpanFormatter(Class<U> clazz, String string) {
        int n;
        if (clazz == null) {
            throw new NullPointerException("Missing unit type.");
        }
        int n2 = string.length();
        ArrayList<List<FormatItem<U>>> arrayList = new ArrayList<List<FormatItem<U>>>();
        arrayList.add(new ArrayList());
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '#') {
                ++n3;
                continue;
            }
            if (TimeSpanFormatter.isSymbol(c)) {
                n = i++;
                while (i < n2 && string.charAt(i) == c) {
                    ++i;
                }
                this.addSymbol(c, i - n, n3, arrayList);
                n3 = 0;
                --i;
                continue;
            }
            if (n3 > 0) {
                throw new IllegalArgumentException("Char # must be followed by unit symbol.");
            }
            if (c == '\'') {
                n = i++;
                while (i < n2) {
                    if (string.charAt(i) == '\'') {
                        if (i + 1 >= n2 || string.charAt(i + 1) != '\'') break;
                        ++i;
                    }
                    ++i;
                }
                if (i >= n2) {
                    throw new IllegalArgumentException("String literal in pattern not closed: " + string);
                }
                if (n + 1 == i) {
                    this.addLiteral('\'', arrayList);
                    continue;
                }
                String i2 = string.substring(n + 1, i);
                this.addLiteral(i2.replace("''", "'"), arrayList);
                continue;
            }
            if (c == '[') {
                TimeSpanFormatter.startOptionalSection(arrayList);
                continue;
            }
            if (c == ']') {
                TimeSpanFormatter.endOptionalSection(arrayList);
                continue;
            }
            if (c == '.') {
                TimeSpanFormatter.lastOn(arrayList).add(new SeparatorItem('.', ','));
                continue;
            }
            if (c == ',') {
                TimeSpanFormatter.lastOn(arrayList).add(new SeparatorItem(',', '.'));
                continue;
            }
            if (c == '-') {
                TimeSpanFormatter.lastOn(arrayList).add(new SignItem(false));
                continue;
            }
            if (c == '+') {
                TimeSpanFormatter.lastOn(arrayList).add(new SignItem(true));
                continue;
            }
            if (c == '{') {
                n = ++i;
                while (i < n2 && string.charAt(i) != '}') {
                    ++i;
                }
                this.addPluralItem(string.substring(n, i), arrayList);
                continue;
            }
            if (c == '|') {
                TimeSpanFormatter.lastOn(arrayList).add(OrItem.getInstance());
                continue;
            }
            this.addLiteral(c, arrayList);
        }
        if (arrayList.size() > 1) {
            throw new IllegalArgumentException("Open square bracket without closing one.");
        }
        if (arrayList.isEmpty()) {
            throw new IllegalArgumentException("Empty or invalid pattern.");
        }
        List list = (List)arrayList.get(0);
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Missing format pattern.");
        }
        if (list.get(0) == OrItem.INSTANCE || list.get(list.size() - 1) == OrItem.INSTANCE) {
            throw new IllegalArgumentException("Pattern must not start or end with an or-operator.");
        }
        int n4 = list.size();
        n = ((FormatItem)list.get(n4 - 1)).getMinWidth();
        for (int i = n4 - 2; i >= 0; --i) {
            FormatItem formatItem = (FormatItem)list.get(i);
            if (formatItem == OrItem.INSTANCE) {
                n = 0;
                continue;
            }
            list.set(i, formatItem.update(n));
            n += formatItem.getMinWidth();
        }
        this.type = clazz;
        this.items = Collections.unmodifiableList(list);
        this.pattern = string;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Class<U> getType() {
        return this.type;
    }

    public String format(TimeSpan<? super U> timeSpan) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            this.print(timeSpan, stringBuilder);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return stringBuilder.toString();
    }

    public void print(TimeSpan<? super U> timeSpan, Appendable appendable) throws IOException {
        for (FormatItem<? super U> formatItem : this.items) {
            if (formatItem == OrItem.INSTANCE) break;
            formatItem.print(timeSpan, appendable);
        }
    }

    public S parse(CharSequence charSequence) throws ParseException {
        return this.parse(charSequence, 0);
    }

    public S parse(CharSequence charSequence, int n) throws ParseException {
        Object object;
        int n2 = n;
        HashMap<Object, Long> hashMap = new HashMap<Object, Long>();
        int n3 = this.items.size();
        for (int i = 0; i < n3 && (object = this.items.get(i)) != OrItem.INSTANCE; ++i) {
            int n4 = ((FormatItem)object).parse(hashMap, charSequence, n2);
            if (n4 < 0) {
                int n5 = -1;
                for (int j = i + 1; j < n3; ++j) {
                    if (this.items.get(j) != OrItem.INSTANCE) continue;
                    n5 = j;
                    break;
                }
                if (n5 == -1) {
                    throw new ParseException("Cannot parse: " + charSequence, ~n4);
                }
                hashMap.clear();
                i = n5;
                continue;
            }
            n2 = n4;
        }
        Long l = (Long)hashMap.remove(SIGN_KEY);
        n3 = l != null && l < 0L ? 1 : 0;
        object = new HashMap();
        for (Object k : hashMap.keySet()) {
            if (this.type.isInstance(k)) {
                object.put(this.type.cast(k), hashMap.get(k));
                continue;
            }
            throw new ParseException("Duration type mismatched: " + hashMap, n2);
        }
        return this.convert((Map<U, Long>)object, n3 != 0);
    }

    protected abstract S convert(Map<U, Long> var1, boolean var2);

    protected abstract U getUnit(char var1);

    private static boolean isSymbol(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private void addSymbol(char c, int n, int n2, List<List<FormatItem<U>>> list) {
        U u = this.getUnit(c);
        List<FormatItem<U>> list2 = list.get(list.size() - 1);
        if (c == 'f') {
            if (n2 > 0) {
                throw new IllegalArgumentException("Combination of # and f-symbol not allowed.");
            }
            list2.add(new FractionItem(0, n, this.getUnit(c)));
        } else {
            list2.add(new NumberItem(0, n, n + n2, u));
        }
    }

    private void addLiteral(char c, List<List<FormatItem<U>>> list) {
        this.addLiteral(String.valueOf(c), list);
    }

    private void addLiteral(String string, List<List<FormatItem<U>>> list) {
        TimeSpanFormatter.lastOn(list).add(new LiteralItem(string));
    }

    private void addPluralItem(String string, List<List<FormatItem<U>>> list) {
        Locale locale;
        Object object;
        Object object2;
        String[] stringArray = string.split(":");
        if (stringArray.length > 9 || stringArray.length < 4) {
            throw new IllegalArgumentException("Plural information has wrong format: " + string);
        }
        if (stringArray[0].length() != 1) {
            throw new IllegalArgumentException("Plural information has wrong symbol: " + string);
        }
        U u = this.getUnit(stringArray[0].charAt(0));
        String[] stringArray2 = stringArray[2].split("-|_");
        String string2 = stringArray2[0];
        if (stringArray2.length > 1) {
            object2 = stringArray2[1];
            if (stringArray2.length > 2) {
                object = stringArray2[2];
                if (stringArray2.length > 3) {
                    throw new IllegalArgumentException("Plural information has wrong locale: " + string);
                }
                locale = new Locale(string2, (String)object2, (String)object);
            } else {
                locale = new Locale(string2, (String)object2);
            }
        } else {
            locale = new Locale(string2);
        }
        object2 = new EnumMap(PluralCategory.class);
        object = PluralRules.of(locale, NumberType.CARDINALS);
        for (int i = 3; i < stringArray.length; ++i) {
            String[] stringArray3 = stringArray[i].split("=");
            if (stringArray3.length != 2) {
                throw new IllegalArgumentException("Plural information has wrong format: " + string);
            }
            object2.put(PluralCategory.valueOf(stringArray3[0]), stringArray3[1]);
        }
        if (object2.isEmpty()) {
            throw new IllegalArgumentException("Missing plural forms: " + string);
        }
        if (!object2.containsKey((Object)PluralCategory.OTHER)) {
            throw new IllegalArgumentException("Missing plural category OTHER: " + string);
        }
        TimeSpanFormatter.lastOn(list).add(new PluralItem(u, stringArray[1], (PluralRules)object, (Map)object2));
    }

    private static <U> void startOptionalSection(List<List<FormatItem<U>>> list) {
        list.add(new ArrayList());
    }

    private static <U> void endOptionalSection(List<List<FormatItem<U>>> list) {
        int n = list.size() - 1;
        if (n < 1) {
            throw new IllegalArgumentException("Closing square bracket without open one.");
        }
        List<FormatItem<U>> list2 = list.remove(n);
        list.get(n - 1).add(new OptionalSectionItem(list2));
    }

    private static <U> List<FormatItem<U>> lastOn(List<List<FormatItem<U>>> list) {
        return list.get(list.size() - 1);
    }

    private static class OptionalSectionItem<U>
    extends FormatItem<U> {
        private final List<FormatItem<U>> items;

        private OptionalSectionItem(List<FormatItem<U>> list) {
            super(0);
            if (list.isEmpty()) {
                throw new IllegalArgumentException("Optional section is empty.");
            }
            if (list.get(0) == OrItem.INSTANCE || list.get(list.size() - 1) == OrItem.INSTANCE) {
                throw new IllegalArgumentException("Optional section must not start or end with an or-operator.");
            }
            this.items = Collections.unmodifiableList(list);
        }

        @Override
        void print(TimeSpan<? super U> timeSpan, Appendable appendable) throws IOException {
            if (!this.isZero(timeSpan)) {
                for (FormatItem<? super U> formatItem : this.items) {
                    if (formatItem == OrItem.INSTANCE) break;
                    formatItem.print(timeSpan, appendable);
                }
            }
        }

        @Override
        int parse(Map<Object, Long> map, CharSequence charSequence, int n) {
            FormatItem<U> formatItem;
            int n2 = n;
            HashMap<Object, Long> hashMap = new HashMap<Object, Long>();
            int n3 = this.items.size();
            for (int i = 0; i < n3 && (formatItem = this.items.get(i)) != OrItem.INSTANCE; ++i) {
                int n4 = formatItem.parse(hashMap, charSequence, n2);
                if (n4 < 0) {
                    int n5 = -1;
                    for (int j = i + 1; j < n3; ++j) {
                        if (this.items.get(j) != OrItem.INSTANCE) continue;
                        n5 = j;
                        break;
                    }
                    if (n5 == -1) {
                        return n;
                    }
                    hashMap.clear();
                    i = n5;
                    continue;
                }
                n2 = n4;
            }
            map.putAll(hashMap);
            return n2;
        }

        @Override
        int getMinWidth() {
            return 0;
        }

        @Override
        FormatItem<U> update(int n) {
            ArrayList<FormatItem<U>> arrayList = new ArrayList<FormatItem<U>>(this.items);
            int n2 = arrayList.size();
            for (int i = n2 - 1; i >= 0; --i) {
                FormatItem formatItem = (FormatItem)arrayList.get(i);
                arrayList.set(i, formatItem.update(n));
                n += formatItem.getMinWidth();
            }
            return new OptionalSectionItem<U>(arrayList);
        }

        @Override
        boolean isZero(TimeSpan<? super U> timeSpan) {
            for (FormatItem<? super U> formatItem : this.items) {
                if (formatItem.isZero(timeSpan)) continue;
                return false;
            }
            return true;
        }
    }

    private static class SignItem<U>
    extends FormatItem<U> {
        private final boolean always;

        private SignItem(boolean bl) {
            super(0);
            this.always = bl;
        }

        private SignItem(int n, boolean bl) {
            super(n);
            this.always = bl;
        }

        @Override
        void print(TimeSpan<? super U> timeSpan, Appendable appendable) throws IOException {
            if (this.always) {
                appendable.append(timeSpan.isNegative() ? (char)'-' : '+');
            } else if (timeSpan.isNegative()) {
                appendable.append('-');
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        int parse(Map<Object, Long> map, CharSequence charSequence, int n) {
            if (n >= charSequence.length() - this.getReserved()) {
                if (this.always) {
                    return ~n;
                }
                Long l = map.put(SIGN_KEY, 1L);
                if (l == null || l == 1L) return n;
                return ~n;
            }
            char c = charSequence.charAt(n);
            Long l = 1L;
            int n2 = n;
            if (this.always) {
                if (c == '+') {
                    n2 = n + 1;
                } else {
                    if (c != '-') return ~n;
                    l = -1L;
                    n2 = n + 1;
                }
            } else {
                if (c == '+') {
                    return ~n;
                }
                if (c == '-') {
                    l = -1L;
                    n2 = n + 1;
                }
            }
            Long l2 = map.put(SIGN_KEY, l);
            if (l2 == null || l2.longValue() == l.longValue()) return n2;
            return ~n;
        }

        @Override
        int getMinWidth() {
            return this.always ? 1 : 0;
        }

        @Override
        FormatItem<U> update(int n) {
            return new SignItem<U>(n, this.always);
        }
    }

    private static class LiteralItem<U>
    extends FormatItem<U> {
        private final String literal;

        private LiteralItem(String string) {
            this(string, false);
        }

        private LiteralItem(String string, boolean bl) {
            super(0);
            if (!bl && string.isEmpty()) {
                throw new IllegalArgumentException("Literal is empty.");
            }
            this.literal = string;
        }

        private LiteralItem(int n, String string) {
            super(n);
            this.literal = string;
        }

        @Override
        void print(TimeSpan<? super U> timeSpan, Appendable appendable) throws IOException {
            appendable.append(this.literal);
        }

        @Override
        int parse(Map<Object, Long> map, CharSequence charSequence, int n) {
            int n2 = n + this.literal.length();
            if (n2 > charSequence.length() - this.getReserved()) {
                return ~n;
            }
            for (int i = n; i < n2; ++i) {
                if (charSequence.charAt(i) == this.literal.charAt(i - n)) continue;
                return ~n;
            }
            return n2;
        }

        @Override
        int getMinWidth() {
            return this.literal.length();
        }

        @Override
        FormatItem<U> update(int n) {
            return new LiteralItem<U>(n, this.literal);
        }
    }

    private static class OrItem<U>
    extends FormatItem<U> {
        static final OrItem INSTANCE = new OrItem();

        private OrItem() {
            super(0);
        }

        static <U> FormatItem<U> getInstance() {
            return INSTANCE;
        }

        @Override
        void print(TimeSpan<? super U> timeSpan, Appendable appendable) throws IOException {
        }

        @Override
        int parse(Map<Object, Long> map, CharSequence charSequence, int n) {
            return n;
        }

        @Override
        int getMinWidth() {
            return 0;
        }

        @Override
        FormatItem<U> update(int n) {
            return this;
        }
    }

    private static class SeparatorItem<U>
    extends FormatItem<U> {
        private final char separator;
        private final char alt;

        private SeparatorItem(char c, char c2) {
            this(0, c, c2);
        }

        private SeparatorItem(int n, char c, char c2) {
            super(n);
            this.separator = c;
            this.alt = c2;
        }

        @Override
        void print(TimeSpan<? super U> timeSpan, Appendable appendable) throws IOException {
            appendable.append(this.separator);
        }

        @Override
        int parse(Map<Object, Long> map, CharSequence charSequence, int n) {
            if (n >= charSequence.length() - this.getReserved()) {
                return ~n;
            }
            char c = charSequence.charAt(n);
            if (c != this.separator && c != this.alt) {
                return ~n;
            }
            return n + 1;
        }

        @Override
        int getMinWidth() {
            return 1;
        }

        @Override
        FormatItem<U> update(int n) {
            return new SeparatorItem<U>(n, this.separator, this.alt);
        }
    }

    private static class PluralItem<U>
    extends FormatItem<U> {
        private final NumberItem<U> numItem;
        private final FormatItem<U> sepItem;
        private final PluralRules rules;
        private final Map<PluralCategory, String> pluralForms;
        private final int minWidth;

        private PluralItem(U u, String string, PluralRules pluralRules, Map<PluralCategory, String> map) {
            super(0);
            this.numItem = new NumberItem(0, 1, 18, u);
            this.sepItem = new LiteralItem(string, true);
            this.rules = pluralRules;
            this.pluralForms = map;
            int n = Integer.MAX_VALUE;
            for (String string2 : map.values()) {
                if (string2.length() >= n) continue;
                n = string2.length();
            }
            this.minWidth = n;
        }

        private PluralItem(int n, NumberItem<U> numberItem, FormatItem<U> formatItem, PluralRules pluralRules, Map<PluralCategory, String> map, int n2) {
            super(n);
            this.numItem = numberItem;
            this.sepItem = formatItem;
            this.rules = pluralRules;
            this.pluralForms = map;
            this.minWidth = n2;
        }

        @Override
        void print(TimeSpan<? super U> timeSpan, Appendable appendable) throws IOException {
            this.numItem.print(timeSpan, appendable);
            this.sepItem.print(timeSpan, appendable);
            PluralCategory pluralCategory = this.rules.getCategory(this.numItem.getAmount(timeSpan));
            appendable.append(this.pluralForms.get((Object)pluralCategory));
        }

        @Override
        int parse(Map<Object, Long> map, CharSequence charSequence, int n) {
            int n2 = n;
            if ((n = this.numItem.parse(map, charSequence, n)) < 0) {
                return n;
            }
            if ((n = this.sepItem.parse(map, charSequence, n)) < 0) {
                return n;
            }
            long l = map.get(this.numItem.getUnit());
            String string = this.pluralForms.get((Object)this.rules.getCategory(l));
            int n3 = string.length();
            if (n + n3 > charSequence.length() - this.getReserved()) {
                return ~n2;
            }
            for (int i = 0; i < n3; ++i) {
                if (string.charAt(i) == charSequence.charAt(n + i)) continue;
                return ~n2;
            }
            return n + n3;
        }

        @Override
        int getMinWidth() {
            return this.minWidth;
        }

        @Override
        FormatItem<U> update(int n) {
            return new PluralItem<U>(n, this.numItem, this.sepItem, this.rules, this.pluralForms, this.minWidth);
        }

        @Override
        boolean isZero(TimeSpan<? super U> timeSpan) {
            return this.numItem.isZero(timeSpan);
        }
    }

    private static class FractionItem<U>
    extends FormatItem<U> {
        private final int width;
        private final U nanosecond;

        private FractionItem(int n, int n2, U u) {
            super(n);
            if (n2 < 1 || n2 > 9) {
                throw new IllegalArgumentException("Fraction width out of bounds: " + n2);
            }
            this.width = n2;
            this.nanosecond = u;
        }

        @Override
        void print(TimeSpan<? super U> timeSpan, Appendable appendable) throws IOException {
            String string = String.valueOf(timeSpan.getPartialAmount(this.nanosecond));
            int n = string.length();
            if (n > 9) {
                throw new IllegalArgumentException("Too many nanoseconds, consider normalization: " + timeSpan);
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < 9 - n; ++i) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
            appendable.append(stringBuilder.toString().substring(0, this.width));
        }

        @Override
        int parse(Map<Object, Long> map, CharSequence charSequence, int n) {
            char c;
            int n2;
            StringBuilder stringBuilder = new StringBuilder();
            int n3 = n;
            int n4 = Math.min(charSequence.length() - this.getReserved(), n + this.width);
            for (n2 = n; n2 < n4 && (c = charSequence.charAt(n2)) >= '0' && c <= '9'; ++n2) {
                stringBuilder.append(c);
                ++n3;
            }
            if (n3 == n) {
                return ~n;
            }
            n4 = n3 - n;
            for (n2 = 0; n2 < 9 - n4; ++n2) {
                stringBuilder.append('0');
            }
            Long l = Long.parseLong(stringBuilder.toString());
            Long l2 = map.put(this.nanosecond, l);
            if (l2 == null || ((Object)l2).equals(l)) {
                return n3;
            }
            return ~n;
        }

        @Override
        int getMinWidth() {
            return this.width;
        }

        @Override
        FormatItem<U> update(int n) {
            return new FractionItem<U>(n, this.width, this.nanosecond);
        }

        @Override
        boolean isZero(TimeSpan<? super U> timeSpan) {
            return timeSpan.getPartialAmount(this.nanosecond) == 0L;
        }
    }

    private static class NumberItem<U>
    extends FormatItem<U> {
        private final int minWidth;
        private final int maxWidth;
        private final U unit;

        private NumberItem(int n, int n2, int n3, U u) {
            super(n);
            if (n2 < 1 || n2 > 18) {
                throw new IllegalArgumentException("Min width out of bounds: " + n2);
            }
            if (n3 < n2) {
                throw new IllegalArgumentException("Max width smaller than min width.");
            }
            if (n3 > 18) {
                throw new IllegalArgumentException("Max width out of bounds: " + n3);
            }
            if (u == null) {
                throw new NullPointerException("Missing unit.");
            }
            this.minWidth = n2;
            this.maxWidth = n3;
            this.unit = u;
        }

        @Override
        void print(TimeSpan<? super U> timeSpan, Appendable appendable) throws IOException {
            String string = String.valueOf(this.getAmount(timeSpan));
            if (string.length() > this.maxWidth) {
                throw new IllegalArgumentException("Too many digits for: " + this.unit + " [" + timeSpan + "]");
            }
            for (int i = this.minWidth - string.length(); i > 0; --i) {
                appendable.append('0');
            }
            appendable.append(string);
        }

        @Override
        int parse(Map<Object, Long> map, CharSequence charSequence, int n) {
            char c;
            long l = 0L;
            int n2 = n;
            int n3 = charSequence.length() - this.getReserved();
            for (int i = n; i < n3 && (c = charSequence.charAt(i)) >= '0' && c <= '9' && i - n < this.maxWidth; ++i) {
                int n4 = c - 48;
                l = l * 10L + (long)n4;
                ++n2;
            }
            if (n2 == n) {
                return ~n;
            }
            Long l2 = l;
            Long l3 = map.put(this.unit, l2);
            if (l3 == null || ((Object)l3).equals(l2)) {
                return n2;
            }
            return ~n;
        }

        @Override
        int getMinWidth() {
            return this.minWidth;
        }

        @Override
        FormatItem<U> update(int n) {
            return new NumberItem<U>(n, this.minWidth, this.maxWidth, this.unit);
        }

        @Override
        boolean isZero(TimeSpan<? super U> timeSpan) {
            return this.getAmount(timeSpan) == 0L;
        }

        long getAmount(TimeSpan<? super U> timeSpan) {
            return timeSpan.getPartialAmount(this.unit);
        }

        U getUnit() {
            return this.unit;
        }
    }

    private static abstract class FormatItem<U> {
        private final int reserved;

        FormatItem(int n) {
            this.reserved = n;
        }

        boolean isZero(TimeSpan<? super U> timeSpan) {
            return true;
        }

        abstract void print(TimeSpan<? super U> var1, Appendable var2) throws IOException;

        abstract int parse(Map<Object, Long> var1, CharSequence var2, int var3);

        int getReserved() {
            return this.reserved;
        }

        abstract int getMinWidth();

        abstract FormatItem<U> update(int var1);
    }
}

