/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import net.time4j.ElementOperator;
import net.time4j.FractionOperator;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.ValueOperator;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoOperator;
import net.time4j.engine.StdOperator;

final class TimeOperator
extends ElementOperator<PlainTime> {
    private final Object opDelegate;

    TimeOperator(ChronoElement<?> chronoElement, int n) {
        this(chronoElement, n, null);
    }

    TimeOperator(ChronoElement<?> chronoElement, int n, Object object) {
        super(chronoElement, n);
        switch (n) {
            case -1: {
                this.opDelegate = TimeOperator.newValue(chronoElement, object);
                break;
            }
            case 0: {
                this.opDelegate = StdOperator.minimized(chronoElement);
                break;
            }
            case 1: {
                this.opDelegate = StdOperator.maximized(chronoElement);
                break;
            }
            case 2: {
                this.opDelegate = StdOperator.decremented(chronoElement);
                break;
            }
            case 3: {
                this.opDelegate = StdOperator.incremented(chronoElement);
                break;
            }
            case 4: {
                this.opDelegate = TimeOperator.child(chronoElement, false);
                break;
            }
            case 5: {
                this.opDelegate = TimeOperator.child(chronoElement, true);
                break;
            }
            case 6: {
                this.opDelegate = TimeOperator.lenient(chronoElement, object);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown: " + this.getType()));
            }
        }
    }

    @Override
    public PlainTime apply(PlainTime plainTime) {
        ChronoOperator chronoOperator = (ChronoOperator)this.opDelegate;
        return chronoOperator.apply(plainTime);
    }

    @Override
    ChronoOperator<PlainTimestamp> onTimestamp() {
        return (ChronoOperator)this.opDelegate;
    }

    private static <V> Object newValue(ChronoElement<V> chronoElement, Object object) {
        V v = chronoElement.getType().cast(object);
        return ValueOperator.of(StdOperator.newValue(v, chronoElement), object);
    }

    private static <V> Object lenient(ChronoElement<V> chronoElement, Object object) {
        V v = chronoElement.getType().cast(object);
        return ValueOperator.of(StdOperator.setLenient(v, chronoElement), object);
    }

    private static <V, T extends ChronoEntity<T>> ChronoOperator<T> child(ChronoElement<V> chronoElement, boolean bl) {
        String string = chronoElement.name();
        if (string.equals("MILLI_OF_SECOND") || string.equals("MILLI_OF_DAY")) {
            return new FractionOperator('3', bl);
        }
        if (string.equals("MICRO_OF_SECOND") || string.equals("MICRO_OF_DAY")) {
            return new FractionOperator('6', bl);
        }
        if (string.equals("NANO_OF_SECOND") || string.equals("NANO_OF_DAY")) {
            return new FractionOperator('9', bl);
        }
        if (bl) {
            return StdOperator.atCeiling(chronoElement);
        }
        return StdOperator.atFloor(chronoElement);
    }
}

