/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.time4j.format.NumberSystem;

public interface NumberSymbolProvider {
    public static final NumberSymbolProvider DEFAULT = new NumberSymbolProvider(){

        @Override
        public Locale[] getAvailableLocales() {
            return DecimalFormatSymbols.getAvailableLocales();
        }

        @Override
        public char getZeroDigit(Locale locale) {
            return this.getSymbols(locale).getZeroDigit();
        }

        @Override
        public char getDecimalSeparator(Locale locale) {
            return this.getSymbols(locale).getDecimalSeparator();
        }

        @Override
        public String getPlusSign(Locale locale) {
            if (locale.getLanguage().equals("ar")) {
                return "\u200f+";
            }
            return String.valueOf('+');
        }

        @Override
        public String getMinusSign(Locale locale) {
            if (locale.getLanguage().equals("ar")) {
                return "\u200f-";
            }
            return String.valueOf(this.getSymbols(locale).getMinusSign());
        }

        @Override
        public NumberSystem getDefaultNumberSystem(Locale locale) {
            return NumberSystem.ARABIC;
        }

        private DecimalFormatSymbols getSymbols(Locale locale) {
            return DecimalFormatSymbols.getInstance(locale);
        }
    };

    public Locale[] getAvailableLocales();

    public char getZeroDigit(Locale var1);

    public char getDecimalSeparator(Locale var1);

    public String getPlusSign(Locale var1);

    public String getMinusSign(Locale var1);

    public NumberSystem getDefaultNumberSystem(Locale var1);
}

