/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import java.util.List;
import java.util.Locale;
import net.time4j.base.TimeSource;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.Chronology;
import net.time4j.engine.Converter;
import net.time4j.engine.DisplayStyle;
import net.time4j.engine.StartOfDay;

public final class BridgeChronology<S, T extends ChronoEntity<T>>
extends Chronology<S> {
    private final Converter<S, T> converter;
    private final Chronology<T> delegate;

    public BridgeChronology(Converter<S, T> converter, Chronology<T> chronology) {
        super(converter.getSourceType());
        if (!ChronoEntity.class.isAssignableFrom(chronology.getChronoType())) {
            throw new IllegalArgumentException("Target chronology not compatible with ChronoEntity.");
        }
        this.converter = converter;
        this.delegate = chronology;
    }

    @Override
    public S createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
        ChronoEntity chronoEntity = (ChronoEntity)this.delegate.createFrom(timeSource, attributeQuery);
        return chronoEntity == null ? null : (S)this.converter.from(chronoEntity);
    }

    @Override
    @Deprecated
    public S createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
        ChronoEntity chronoEntity2 = (ChronoEntity)this.delegate.createFrom(chronoEntity, attributeQuery, bl);
        return chronoEntity2 == null ? null : (S)this.converter.from(chronoEntity2);
    }

    @Override
    public S createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
        ChronoEntity chronoEntity2 = this.delegate.getChronoType().isInstance(chronoEntity) ? (ChronoEntity)this.delegate.getChronoType().cast(chronoEntity) : (ChronoEntity)this.delegate.createFrom(chronoEntity, attributeQuery, bl, bl2);
        return chronoEntity2 == null ? null : (S)this.converter.from(chronoEntity2);
    }

    @Override
    public ChronoDisplay preformat(S s, AttributeQuery attributeQuery) {
        ChronoEntity chronoEntity = (ChronoEntity)this.converter.translate(s);
        return this.delegate.preformat(chronoEntity, attributeQuery);
    }

    @Override
    public Chronology<?> preparser() {
        return this.delegate;
    }

    @Override
    public String getFormatPattern(DisplayStyle displayStyle, Locale locale) {
        throw new UnsupportedOperationException("Localized format patterns are not available for foreign types.");
    }

    @Override
    public StartOfDay getDefaultStartOfDay() {
        return this.delegate.getDefaultStartOfDay();
    }

    @Override
    public boolean hasCalendarSystem() {
        return this.delegate.hasCalendarSystem();
    }

    @Override
    public CalendarSystem<S> getCalendarSystem() {
        CalendarSystem<T> calendarSystem = this.delegate.getCalendarSystem();
        return new CalendarSystemProxy<S, T>(this.converter, calendarSystem);
    }

    @Override
    public CalendarSystem<S> getCalendarSystem(String string) {
        CalendarSystem<T> calendarSystem = this.delegate.getCalendarSystem(string);
        return new CalendarSystemProxy<S, T>(this.converter, calendarSystem);
    }

    private static class CalendarSystemProxy<S, T>
    implements CalendarSystem<S> {
        private final Converter<S, T> converter;
        private final CalendarSystem<T> calsys;

        CalendarSystemProxy(Converter<S, T> converter, CalendarSystem<T> calendarSystem) {
            this.converter = converter;
            this.calsys = calendarSystem;
        }

        @Override
        public S transform(long l) {
            return this.converter.from(this.calsys.transform(l));
        }

        @Override
        public long transform(S s) {
            return this.calsys.transform(this.converter.translate(s));
        }

        @Override
        public long getMinimumSinceUTC() {
            return this.calsys.getMinimumSinceUTC();
        }

        @Override
        public long getMaximumSinceUTC() {
            return this.calsys.getMaximumSinceUTC();
        }

        @Override
        public List<CalendarEra> getEras() {
            return this.calsys.getEras();
        }
    }
}

