/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.IOException;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import net.time4j.Meridiem;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.TemporalType;
import net.time4j.ZonalDateTime;
import net.time4j.ZonalElement;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.Chronology;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.RawValues;
import net.time4j.format.TemporalFormatter;
import net.time4j.tz.NameStyle;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

final class SystemTemporalFormatter<T>
implements TemporalFormatter<T> {
    private static final String RFC_1123_WIDE = "EEE, d MMM yyyy HH:mm:ss Z";
    private static final String RFC_1123_SHORT = "d MMM yyyy HH:mm:ss Z";
    private static final Date PROLEPTIC_GREGORIAN = new Date(Long.MIN_VALUE);
    private static final PlainDate UNIX_EPOCH_DATE = PlainDate.of(1970, 1, 1);
    private static final Map<Class<?>, Chronology<?>> SUPPORTED_TYPES;
    private final Class<T> type;
    private final String pattern;
    private final Locale locale;
    private final Leniency leniency;
    private final String tzid;

    SystemTemporalFormatter(Class<T> clazz, String string, Locale locale, Leniency leniency, String string2) {
        if (clazz == null) {
            throw new NullPointerException("Missing chronological type");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Format pattern is empty.");
        }
        if (locale == null) {
            throw new NullPointerException("Locale is not specified.");
        }
        if (leniency == null) {
            throw new NullPointerException("Missing leniency.");
        }
        this.type = clazz;
        this.pattern = string;
        this.locale = locale;
        this.leniency = leniency;
        this.tzid = string2;
    }

    @Override
    public String format(T t) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            this.formatToBuffer(t, stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    @Override
    public void formatToBuffer(T t, Appendable appendable) throws IOException {
        String string;
        if (this.type.equals(PlainDate.class)) {
            PlainDate plainDate = (PlainDate)PlainDate.class.cast(t);
            Date date = TemporalType.JAVA_UTIL_DATE.from(plainDate.atStartOfDay().atUTC());
            string = this.setUpLocal().format(date);
        } else if (this.type.equals(PlainTime.class)) {
            PlainTime plainTime = (PlainTime)PlainTime.class.cast(t);
            Date date = TemporalType.JAVA_UTIL_DATE.from(UNIX_EPOCH_DATE.at(plainTime).atUTC());
            string = this.setUpLocal().format(date);
        } else if (this.type.equals(PlainTimestamp.class)) {
            PlainTimestamp plainTimestamp = (PlainTimestamp)PlainTimestamp.class.cast(t);
            Date date = TemporalType.JAVA_UTIL_DATE.from(plainTimestamp.atUTC());
            string = this.setUpLocal().format(date);
        } else if (this.type.equals(Moment.class)) {
            Moment moment = (Moment)Moment.class.cast(t);
            if (this.tzid == null) {
                throw new IllegalArgumentException("Cannot print moment without timezone.");
            }
            String string2 = this.pattern;
            if (string2.equals("<RFC-1123>")) {
                string2 = RFC_1123_WIDE;
            }
            SystemTemporalFormatter<ZonalDateTime> systemTemporalFormatter = new SystemTemporalFormatter<ZonalDateTime>(ZonalDateTime.class, string2, this.locale, this.leniency, this.tzid);
            string = systemTemporalFormatter.format(moment.inZonalView(this.tzid));
        } else if (this.type.equals(ZonalDateTime.class)) {
            ZonalDateTime zonalDateTime = (ZonalDateTime)ZonalDateTime.class.cast(t);
            Moment moment = zonalDateTime.toMoment();
            Date date = TemporalType.JAVA_UTIL_DATE.from(moment);
            String string3 = this.tzid == null ? zonalDateTime.getTimezone().canonical() : this.tzid;
            Timezone timezone = Timezone.of(string3);
            String string4 = "GMT" + timezone.getOffset(moment).toString();
            XCalendar xCalendar = new XCalendar(TimeZone.getTimeZone(string4), this.locale);
            SimpleDateFormat simpleDateFormat = SystemTemporalFormatter.setUp(this.pattern, this.locale, xCalendar, !this.leniency.isStrict());
            FieldPosition fieldPosition = new FieldPosition(17);
            StringBuffer stringBuffer = new StringBuffer();
            string = simpleDateFormat.format(date, stringBuffer, fieldPosition).toString();
            int n = fieldPosition.getBeginIndex();
            int n2 = fieldPosition.getEndIndex();
            if (n2 > n && n > 0 && !(timezone.getID() instanceof ZonalOffset) && this.hasTimezoneField()) {
                boolean bl;
                boolean bl2 = timezone.isDaylightSaving(moment);
                boolean bl3 = bl = !this.pattern.contains("zzzz");
                NameStyle nameStyle = bl ? (bl2 ? NameStyle.SHORT_DAYLIGHT_TIME : NameStyle.SHORT_STANDARD_TIME) : (bl2 ? NameStyle.LONG_DAYLIGHT_TIME : NameStyle.LONG_STANDARD_TIME);
                String string5 = timezone.getDisplayName(nameStyle, this.locale);
                string = string.substring(0, n) + string5 + string.substring(n2);
            }
        } else {
            throw new IllegalArgumentException("Not formattable: " + t);
        }
        appendable.append(string);
    }

    @Override
    public T parse(CharSequence charSequence) throws ParseException {
        T t;
        ParsePosition parsePosition = new ParsePosition(0);
        try {
            t = this.parseInternal(charSequence, parsePosition, true, null);
            if (t == null || parsePosition.getErrorIndex() > -1) {
                throw new ParseException("Cannot parse: " + charSequence, parsePosition.getErrorIndex());
            }
        }
        catch (RuntimeException runtimeException) {
            ParseException parseException = new ParseException(runtimeException.getMessage(), parsePosition.getErrorIndex());
            parseException.initCause(runtimeException);
            throw parseException;
        }
        return t;
    }

    @Override
    public T parse(CharSequence charSequence, ParsePosition parsePosition) {
        return this.parseInternal(charSequence, parsePosition, false, null);
    }

    @Override
    public T parse(CharSequence charSequence, ParsePosition parsePosition, RawValues rawValues) {
        if (rawValues == null) {
            throw new NullPointerException("Missing raw values.");
        }
        return this.parseInternal(charSequence, parsePosition, false, rawValues);
    }

    @Override
    public TemporalFormatter<T> withTimezone(TZID tZID) {
        return this.withTimezone(tZID.canonical());
    }

    @Override
    public TemporalFormatter<T> withTimezone(String string) {
        return new SystemTemporalFormatter<T>(this.type, this.pattern, this.locale, this.leniency, string);
    }

    @Override
    public TemporalFormatter<T> with(Locale locale) {
        return new SystemTemporalFormatter<T>(this.type, this.pattern, locale, this.leniency, this.tzid);
    }

    @Override
    public TemporalFormatter<T> with(Leniency leniency) {
        return new SystemTemporalFormatter<T>(this.type, this.pattern, this.locale, leniency, this.tzid);
    }

    @Override
    public AttributeQuery getAttributes() {
        Chronology<?> chronology = SUPPORTED_TYPES.get(this.type);
        Attributes.Builder builder = chronology == null ? new Attributes.Builder() : new Attributes.Builder(chronology);
        builder.setLanguage(this.locale);
        builder.set(Attributes.LENIENCY, this.leniency);
        if (this.tzid != null) {
            builder.setTimezone(this.tzid);
        }
        return builder.build();
    }

    private boolean hasTimezoneField() {
        boolean bl = false;
        for (int i = this.pattern.length() - 1; i >= 0; --i) {
            char c = this.pattern.charAt(i);
            if (c == '\'') {
                bl = !bl;
                continue;
            }
            if (bl || c != 'z') continue;
            return true;
        }
        return false;
    }

    private static void updateRawValues(RawValues rawValues, SimpleDateFormat simpleDateFormat) {
        if (rawValues != null) {
            rawValues.accept(new Parsed((XCalendar)XCalendar.class.cast(simpleDateFormat.getCalendar())));
        }
    }

    private SimpleDateFormat setUpLocal() {
        XCalendar xCalendar = new XCalendar(TimeZone.getTimeZone("GMT"), this.locale);
        return SystemTemporalFormatter.setUp(this.pattern, this.locale, xCalendar, !this.leniency.isStrict());
    }

    private static SimpleDateFormat setUp(String string, Locale locale, XCalendar xCalendar, boolean bl) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, locale);
        simpleDateFormat.setCalendar(xCalendar);
        simpleDateFormat.setLenient(bl);
        return simpleDateFormat;
    }

    private T parseInternal(CharSequence charSequence, ParsePosition parsePosition, boolean bl, RawValues rawValues) {
        ChronoDisplay chronoDisplay;
        String string = charSequence.toString();
        if (this.type.equals(PlainDate.class)) {
            SimpleDateFormat simpleDateFormat = this.setUpLocal();
            Date date = simpleDateFormat.parse(string, parsePosition);
            PlainTimestamp plainTimestamp = TemporalType.JAVA_UTIL_DATE.translate(date).toZonalTimestamp(ZonalOffset.UTC);
            chronoDisplay = plainTimestamp.getCalendarDate();
            SystemTemporalFormatter.updateRawValues(rawValues, simpleDateFormat);
        } else if (this.type.equals(PlainTime.class)) {
            SimpleDateFormat simpleDateFormat = this.setUpLocal();
            Date date = simpleDateFormat.parse(string, parsePosition);
            PlainTimestamp plainTimestamp = TemporalType.JAVA_UTIL_DATE.translate(date).toZonalTimestamp(ZonalOffset.UTC);
            chronoDisplay = plainTimestamp.getWallTime();
            SystemTemporalFormatter.updateRawValues(rawValues, simpleDateFormat);
        } else if (this.type.equals(PlainTimestamp.class)) {
            SimpleDateFormat simpleDateFormat = this.setUpLocal();
            Date date = simpleDateFormat.parse(string, parsePosition);
            chronoDisplay = TemporalType.JAVA_UTIL_DATE.translate(date).toZonalTimestamp(ZonalOffset.UTC);
            SystemTemporalFormatter.updateRawValues(rawValues, simpleDateFormat);
        } else if (this.type.equals(Moment.class)) {
            ZonalDateTime zonalDateTime;
            Object object;
            String string2 = this.pattern;
            if (string2.equals("<RFC-1123>")) {
                object = string.substring(parsePosition.getIndex());
                string2 = ((String)object).length() >= 4 && ((String)object).charAt(3) == ',' ? RFC_1123_WIDE : RFC_1123_SHORT;
                int n = 0;
                for (int i = ((String)object).length() - 1; i >= 0 && n < 2; --i) {
                    if (((String)object).charAt(i) != ':') continue;
                    ++n;
                }
                if (n >= 2) {
                    string2 = string2.replace(":ss", "");
                }
            }
            chronoDisplay = (zonalDateTime = (ZonalDateTime)super.parseInternal(charSequence, parsePosition, bl, rawValues)) == null ? null : zonalDateTime.toMoment();
        } else if (this.type.equals(ZonalDateTime.class)) {
            TZID tZID;
            String string3 = this.tzid == null ? "GMT-18:00" : this.tzid.replace("UTC", "GMT");
            XCalendar xCalendar = new XCalendar(TimeZone.getTimeZone(string3), this.locale);
            SimpleDateFormat simpleDateFormat = SystemTemporalFormatter.setUp(this.pattern, this.locale, xCalendar, !this.leniency.isStrict());
            Date date = simpleDateFormat.parse(string, parsePosition);
            if (date == null || parsePosition.getErrorIndex() >= 0) {
                return null;
            }
            Parsed parsed = new Parsed(xCalendar);
            int n = xCalendar.get(15) + xCalendar.get(16);
            if (n == -1080) {
                parsePosition.setErrorIndex(parsePosition.getIndex());
                if (bl) {
                    throw new IllegalArgumentException("Cannot parse text without timezone: " + string);
                }
                return null;
            }
            if (!xCalendar.getTimeZone().getID().equals(string3)) {
                string3 = xCalendar.getTimeZone().getID();
            } else {
                tZID = ZonalOffset.ofTotalSeconds(n / 1000);
                string3 = this.tzid != null && xCalendar.getTimeZone().getOffset(date.getTime()) == n ? this.tzid : ((ZonalOffset)tZID).canonical();
            }
            tZID = Timezone.of(string3).getID();
            parsed.setTimezone(tZID);
            PlainTimestamp plainTimestamp = (PlainTimestamp)PlainTimestamp.axis().createFrom((ChronoEntity)parsed, this.getAttributes(), false);
            chronoDisplay = plainTimestamp == null ? null : plainTimestamp.inTimezone(tZID).inZonalView(tZID);
            if (rawValues != null) {
                rawValues.accept(parsed);
            }
        } else {
            chronoDisplay = null;
        }
        return this.type.cast(chronoDisplay);
    }

    static {
        HashMap hashMap = new HashMap();
        hashMap.put(PlainDate.class, PlainDate.axis());
        hashMap.put(PlainTime.class, PlainTime.axis());
        hashMap.put(PlainTimestamp.class, PlainTimestamp.axis());
        hashMap.put(Moment.class, Moment.axis());
        SUPPORTED_TYPES = Collections.unmodifiableMap(hashMap);
    }

    private static class XCalendar
    extends GregorianCalendar {
        XCalendar(TimeZone timeZone, Locale locale) {
            super(timeZone, locale);
            this.setGregorianChange(PROLEPTIC_GREGORIAN);
        }

        int getRawValue(int n) {
            return super.internalGet(n);
        }
    }

    private static class Parsed
    extends ChronoEntity<Parsed> {
        private final Map<ChronoElement<?>, Object> values;
        private TZID tzid = null;

        Parsed(XCalendar xCalendar) {
            HashMap<ZonalElement<Meridiem>, Object> hashMap = new HashMap<ZonalElement<Meridiem>, Object>();
            if (xCalendar.isSet(1)) {
                hashMap.put(PlainDate.YEAR, xCalendar.getRawValue(1));
            }
            if (xCalendar.isSet(2)) {
                hashMap.put(PlainDate.MONTH_AS_NUMBER, xCalendar.getRawValue(2) + 1);
            }
            if (xCalendar.isSet(6)) {
                hashMap.put(PlainDate.DAY_OF_YEAR, xCalendar.getRawValue(6));
            }
            if (xCalendar.isSet(5)) {
                hashMap.put(PlainDate.DAY_OF_MONTH, xCalendar.getRawValue(5));
            }
            if (xCalendar.isSet(9)) {
                hashMap.put(PlainTime.AM_PM_OF_DAY, Meridiem.values()[xCalendar.getRawValue(9)]);
            }
            if (xCalendar.isSet(10)) {
                hashMap.put(PlainTime.DIGITAL_HOUR_OF_AMPM, xCalendar.getRawValue(10));
            }
            if (xCalendar.isSet(11)) {
                hashMap.put(PlainTime.DIGITAL_HOUR_OF_DAY, xCalendar.getRawValue(11));
            }
            if (xCalendar.isSet(12)) {
                hashMap.put(PlainTime.MINUTE_OF_HOUR, xCalendar.getRawValue(12));
            }
            if (xCalendar.isSet(13)) {
                hashMap.put(PlainTime.SECOND_OF_MINUTE, xCalendar.getRawValue(13));
            }
            if (xCalendar.isSet(14)) {
                hashMap.put(PlainTime.MILLI_OF_SECOND, xCalendar.getRawValue(14));
            }
            this.values = Collections.unmodifiableMap(hashMap);
        }

        @Override
        public boolean contains(ChronoElement<?> chronoElement) {
            return this.values.containsKey(chronoElement);
        }

        @Override
        public <V> V get(ChronoElement<V> chronoElement) {
            this.check(chronoElement);
            return chronoElement.getType().cast(this.values.get(chronoElement));
        }

        @Override
        public <V> V getMinimum(ChronoElement<V> chronoElement) {
            this.check(chronoElement);
            return chronoElement.getDefaultMinimum();
        }

        @Override
        public <V> V getMaximum(ChronoElement<V> chronoElement) {
            this.check(chronoElement);
            return chronoElement.getDefaultMaximum();
        }

        @Override
        public <V> boolean isValid(ChronoElement<V> chronoElement, V v) {
            return chronoElement != null;
        }

        @Override
        public <V> Parsed with(ChronoElement<V> chronoElement, V v) {
            if (chronoElement == null) {
                throw new NullPointerException();
            }
            if (v == null) {
                this.values.remove(chronoElement);
            } else {
                this.values.put(chronoElement, v);
            }
            return this;
        }

        @Override
        public boolean hasTimezone() {
            return this.tzid != null;
        }

        @Override
        public TZID getTimezone() {
            if (this.tzid == null) {
                throw new ChronoException("Timezone was not parsed.");
            }
            return this.tzid;
        }

        void setTimezone(TZID tZID) {
            this.tzid = tZID;
        }

        @Override
        public Set<ChronoElement<?>> getRegisteredElements() {
            return Collections.unmodifiableSet(this.values.keySet());
        }

        @Override
        protected Chronology<Parsed> getChronology() {
            throw new UnsupportedOperationException("Parsed values do not have any chronology.");
        }

        private void check(ChronoElement<?> chronoElement) {
            if (!this.values.containsKey(chronoElement)) {
                throw new ChronoException("Element not supported: " + chronoElement.name());
            }
        }
    }
}

