/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.ServiceLoader;
import net.time4j.Platform;
import net.time4j.engine.ChronoEntity;
import net.time4j.format.ChronoPattern;
import net.time4j.format.DisplayMode;
import net.time4j.format.FormatEngine;
import net.time4j.format.TemporalFormatter;
import net.time4j.tz.TZID;

class FormatSupport {
    private static final FormatEngine<?> DEFAULT_FORMAT_ENGINE;

    private FormatSupport() {
    }

    static <T extends ChronoEntity<T>, P extends ChronoPattern<P>> TemporalFormatter<T> createFormatter(Class<T> clazz, String string, P p, Locale locale) {
        FormatEngine<P> formatEngine = p.getFormatEngine();
        return formatEngine.create(clazz, string, p, locale);
    }

    static <T extends ChronoEntity<T>, P extends ChronoPattern<P>> TemporalFormatter<T> createFormatter(Class<T> clazz, String string, P p, Locale locale, TZID tZID) {
        return FormatSupport.createFormatter(clazz, string, p, locale).withTimezone(tZID);
    }

    static <T extends ChronoEntity<T>> TemporalFormatter<T> createFormatter(Class<T> clazz, String string, Locale locale) {
        return FormatSupport.createFormatter(clazz, DEFAULT_FORMAT_ENGINE, string, locale);
    }

    static <T extends ChronoEntity<T>> TemporalFormatter<T> createFormatter(Class<T> clazz, String string, Locale locale, TZID tZID) {
        return FormatSupport.createFormatter(clazz, DEFAULT_FORMAT_ENGINE, string, locale).withTimezone(tZID);
    }

    static int getFormatStyle(DisplayMode displayMode) {
        switch (displayMode) {
            case FULL: {
                return 0;
            }
            case LONG: {
                return 1;
            }
            case MEDIUM: {
                return 2;
            }
            case SHORT: {
                return 3;
            }
        }
        throw new UnsupportedOperationException("Unknown: " + (Object)((Object)displayMode));
    }

    static String getFormatPattern(DateFormat dateFormat) {
        if (dateFormat instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)SimpleDateFormat.class.cast(dateFormat)).toPattern();
        }
        throw new IllegalStateException("Cannot retrieve format pattern.");
    }

    static FormatEngine<?> getDefaultFormatEngine() {
        return DEFAULT_FORMAT_ENGINE;
    }

    private static <T extends ChronoEntity<T>, P extends ChronoPattern<P>> TemporalFormatter<T> createFormatter(Class<T> clazz, FormatEngine<P> formatEngine, String string, Locale locale) {
        return formatEngine.create(clazz, string, formatEngine.getDefaultPatternType(), locale);
    }

    static {
        FormatEngine formatEngine = null;
        FormatEngine formatEngine2 = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = FormatEngine.class.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        for (FormatEngine formatEngine3 : ServiceLoader.load(FormatEngine.class, classLoader)) {
            if (formatEngine3.isSupported(ChronoEntity.class)) {
                formatEngine2 = formatEngine3;
                break;
            }
            formatEngine = formatEngine3;
        }
        if (formatEngine2 == null) {
            formatEngine2 = formatEngine == null ? Platform.PATTERN.getFormatEngine() : formatEngine;
        }
        DEFAULT_FORMAT_ENGINE = formatEngine2;
    }
}

