/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.Platform;
import net.time4j.SystemTemporalFormatter;
import net.time4j.ZonalDateTime;
import net.time4j.format.FormatEngine;
import net.time4j.format.Leniency;
import net.time4j.format.TemporalFormatter;
import net.time4j.scale.UniversalTime;

class SystemFormatEngine
implements FormatEngine<Platform> {
    static final FormatEngine<Platform> INSTANCE = new SystemFormatEngine();
    static final String RFC_1123_PATTERN = "<RFC-1123>";
    private static final Set<Class<?>> SUPPORTED_TYPES;

    private SystemFormatEngine() {
    }

    @Override
    public <T> TemporalFormatter<T> create(Class<T> clazz, String string, Platform platform, Locale locale) {
        if (platform == null) {
            throw new NullPointerException("Missing pattern type.");
        }
        if (!this.isSupported(clazz)) {
            throw new IllegalArgumentException("Not formattable: " + clazz);
        }
        return new SystemTemporalFormatter<T>(clazz, string, locale, Leniency.SMART, null);
    }

    @Override
    public TemporalFormatter<? extends UniversalTime> createRFC1123() {
        return new SystemTemporalFormatter<Moment>(Moment.class, RFC_1123_PATTERN, Locale.ENGLISH, Leniency.SMART, "GMT");
    }

    @Override
    public Platform getDefaultPatternType() {
        return Platform.PATTERN;
    }

    @Override
    public boolean isSupported(Class<?> clazz) {
        return SUPPORTED_TYPES.contains(clazz);
    }

    static {
        HashSet<Class<ZonalDateTime>> hashSet = new HashSet<Class<ZonalDateTime>>();
        hashSet.add(PlainDate.class);
        hashSet.add(PlainTime.class);
        hashSet.add(PlainTimestamp.class);
        hashSet.add(Moment.class);
        hashSet.add(ZonalDateTime.class);
        SUPPORTED_TYPES = Collections.unmodifiableSet(hashSet);
    }
}

