/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.ElementPosition;
import net.time4j.format.FormatProcessor;
import net.time4j.format.FormatStep;
import net.time4j.format.ParseLog;

final class LookupProcessor<V extends Enum<V>>
implements FormatProcessor<V> {
    private final ChronoElement<V> element;
    private final Map<V, String> resources;

    LookupProcessor(ChronoElement<V> chronoElement, Map<V, String> map) {
        EnumMap<String, String> enumMap = new EnumMap<String, String>(chronoElement.getType());
        enumMap.putAll(map);
        this.element = chronoElement;
        this.resources = Collections.unmodifiableMap(enumMap);
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, FormatStep formatStep) throws IOException {
        if (appendable instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)((Object)appendable);
            int n = charSequence.length();
            this.print(chronoDisplay, appendable);
            if (set != null) {
                set.add(new ElementPosition(this.element, n, charSequence.length()));
            }
        } else {
            this.print(chronoDisplay, appendable);
        }
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, Map<ChronoElement<?>, Object> map, FormatStep formatStep) {
        int n = parseLog.getPosition();
        int n2 = charSequence.length();
        int n3 = formatStep.getAttribute(Attributes.PROTECTED_CHARACTERS, attributeQuery, 0);
        if (n3 > 0) {
            n2 -= n3;
        }
        if (n >= n2) {
            parseLog.setError(n, "Missing chars for: " + this.element.name());
            parseLog.setWarning();
            return;
        }
        Class<V> clazz = this.element.getType();
        AttributeQuery attributeQuery2 = formatStep.getQuery(attributeQuery);
        boolean bl = attributeQuery2.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE);
        Locale locale = attributeQuery2.get(Attributes.LOCALE, Locale.getDefault());
        int n4 = n2 - n;
        for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
            CharSequence charSequence2;
            String string = this.getString(enum_);
            if (bl) {
                String string2;
                String string3 = string.toUpperCase(locale);
                int n5 = string.length();
                if (n5 > n4 || !string3.equals(string2 = charSequence.subSequence(n, n + n5).toString().toUpperCase(locale))) continue;
                map.put(this.element, enum_);
                parseLog.setPosition(n + n5);
                return;
            }
            int n6 = string.length();
            if (n6 > n4 || !string.equals((charSequence2 = charSequence.subSequence(n, n + n6)).toString())) continue;
            map.put(this.element, enum_);
            parseLog.setPosition(n + n6);
            return;
        }
        parseLog.setError(n, "Enum value could not be parsed.");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LookupProcessor) {
            LookupProcessor lookupProcessor = (LookupProcessor)object;
            return this.element.equals(lookupProcessor.element) && this.resources.equals(lookupProcessor.resources);
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.element.hashCode() + 31 * this.resources.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(512);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[element=");
        stringBuilder.append(this.element.name());
        stringBuilder.append(", resources=");
        stringBuilder.append(this.resources);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<V> getElement() {
        return this.element;
    }

    @Override
    public FormatProcessor<V> withElement(ChronoElement<V> chronoElement) {
        if (this.element == chronoElement) {
            return this;
        }
        return new LookupProcessor<V>(chronoElement, this.resources);
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    private void print(ChronoDisplay chronoDisplay, Appendable appendable) throws IOException {
        Enum enum_ = (Enum)chronoDisplay.get(this.element);
        appendable.append(this.getString(enum_));
    }

    private String getString(V v) {
        String string = this.resources.get(v);
        if (string == null) {
            string = ((Enum)v).toString();
        }
        return string;
    }
}

