/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoCondition;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.DecimalProcessor;
import net.time4j.format.ElementPosition;
import net.time4j.format.FormatProcessor;
import net.time4j.format.FractionProcessor;
import net.time4j.format.Leniency;
import net.time4j.format.ParseLog;

final class FormatStep {
    private final FormatProcessor<?> processor;
    private final int level;
    private final int section;
    private final Attributes sectionalAttrs;
    private final int reserved;
    private final int padLeft;
    private final int padRight;

    FormatStep(FormatProcessor<?> formatProcessor, int n, int n2, Attributes attributes) {
        this(formatProcessor, n, n2, attributes, 0, 0, 0);
    }

    private FormatStep(FormatProcessor<?> formatProcessor, int n, int n2, Attributes attributes, int n3, int n4, int n5) {
        if (formatProcessor == null) {
            throw new NullPointerException("Missing format processor.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Invalid level: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid section: " + n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Reserved chars must not be negative: " + n3);
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("Invalid pad-width: " + n4);
        }
        if (n5 < 0) {
            throw new IllegalArgumentException("Invalid pad-width: " + n5);
        }
        this.processor = formatProcessor;
        this.level = n;
        this.section = n2;
        this.sectionalAttrs = attributes;
        this.reserved = n3;
        this.padLeft = n4;
        this.padRight = n5;
    }

    void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set) throws IOException {
        block14: {
            int n;
            int n2;
            char c;
            boolean bl;
            LinkedHashSet<ElementPosition> linkedHashSet;
            int n3;
            StringBuilder stringBuilder;
            block13: {
                if (!this.isPrinting(chronoDisplay)) {
                    return;
                }
                if (this.padLeft == 0 && this.padRight == 0) {
                    this.processor.print(chronoDisplay, appendable, attributeQuery, set, this);
                    return;
                }
                stringBuilder = new StringBuilder();
                n3 = -1;
                linkedHashSet = null;
                if (appendable instanceof CharSequence && set != null) {
                    n3 = ((CharSequence)((Object)appendable)).length();
                    linkedHashSet = new LinkedHashSet<ElementPosition>();
                }
                bl = this.isStrict(attributeQuery);
                c = this.getPadChar(attributeQuery);
                this.processor.print(chronoDisplay, stringBuilder, attributeQuery, linkedHashSet, this);
                if (this.padLeft <= 0) break block13;
                if (bl && n2 > this.padLeft) {
                    throw new IllegalArgumentException(this.padExceeded());
                }
                for (n = n2 = stringBuilder.length(); n < this.padLeft; ++n) {
                    appendable.append(c);
                }
                appendable.append(stringBuilder);
                if (n3 != -1) {
                    for (ElementPosition elementPosition : linkedHashSet) {
                        set.add(new ElementPosition(elementPosition.getElement(), n3 + elementPosition.getStartIndex(), n3 + elementPosition.getEndIndex()));
                    }
                }
                if (this.padRight <= 0) break block14;
                if (bl && n2 > this.padRight) {
                    throw new IllegalArgumentException(this.padExceeded());
                }
                while (n2 < this.padRight) {
                    appendable.append(c);
                    ++n2;
                }
                break block14;
            }
            if (bl && n2 > this.padRight) {
                throw new IllegalArgumentException(this.padExceeded());
            }
            appendable.append(stringBuilder);
            while (n < this.padRight) {
                appendable.append(c);
                ++n;
            }
            if (n3 != -1) {
                for (ElementPosition elementPosition : linkedHashSet) {
                    set.add(new ElementPosition(elementPosition.getElement(), n3 + elementPosition.getStartIndex(), n3 + elementPosition.getEndIndex()));
                }
            }
        }
    }

    void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, Map<ChronoElement<?>, Object> map) {
        int n;
        if (this.padLeft == 0 && this.padRight == 0) {
            this.doParse(charSequence, parseLog, attributeQuery, map);
            return;
        }
        boolean bl = this.isStrict(attributeQuery);
        char c = this.getPadChar(attributeQuery);
        int n2 = parseLog.getPosition();
        int n3 = charSequence.length();
        for (n = n2; n < n3 && charSequence.charAt(n) == c; ++n) {
        }
        int n4 = n - n2;
        if (bl && n4 > this.padLeft) {
            parseLog.setError(n2, this.padExceeded());
            return;
        }
        parseLog.setPosition(n);
        this.doParse(charSequence, parseLog, attributeQuery, map);
        if (parseLog.isError()) {
            return;
        }
        n = parseLog.getPosition();
        int n5 = n - n2 - n4;
        if (bl && this.padLeft > 0 && n5 + n4 != this.padLeft) {
            parseLog.setError(n2, this.padMismatched());
            return;
        }
        int n6 = 0;
        while (!(n >= n3 || bl && n5 + n6 >= this.padRight || charSequence.charAt(n) != c)) {
            ++n;
            ++n6;
        }
        if (bl && this.padRight > 0 && n5 + n6 != this.padRight) {
            parseLog.setError(n - n6, this.padMismatched());
            return;
        }
        parseLog.setPosition(n);
    }

    int getLevel() {
        return this.level;
    }

    int getSection() {
        return this.section;
    }

    boolean isDecimal() {
        return this.processor instanceof FractionProcessor || this.processor instanceof DecimalProcessor;
    }

    boolean isNumerical() {
        return this.processor.isNumerical();
    }

    int getReserved() {
        return this.reserved;
    }

    FormatProcessor<?> getProcessor() {
        return this.processor;
    }

    FormatStep updateElement(ChronoElement<?> chronoElement) {
        FormatProcessor<?> formatProcessor = FormatStep.update(this.processor, chronoElement);
        if (this.processor == formatProcessor) {
            return this;
        }
        return new FormatStep(formatProcessor, this.level, this.section, this.sectionalAttrs, this.reserved, this.padLeft, this.padRight);
    }

    FormatStep reserve(int n) {
        return new FormatStep(this.processor, this.level, this.section, this.sectionalAttrs, this.reserved + n, this.padLeft, this.padRight);
    }

    FormatStep pad(int n, int n2) {
        return new FormatStep(this.processor, this.level, this.section, this.sectionalAttrs, this.reserved, this.padLeft + n, this.padRight + n2);
    }

    <A> A getAttribute(AttributeKey<A> attributeKey, AttributeQuery attributeQuery, A a) {
        AttributeQuery attributeQuery2 = this.sectionalAttrs;
        if (this.sectionalAttrs == null || !this.sectionalAttrs.contains(attributeKey)) {
            attributeQuery2 = attributeQuery;
        }
        if (attributeQuery2.contains(attributeKey)) {
            return attributeQuery2.get(attributeKey);
        }
        if (a == null) {
            throw new IllegalArgumentException(attributeKey.name());
        }
        return a;
    }

    AttributeQuery getQuery(final AttributeQuery attributeQuery) {
        if (this.sectionalAttrs == null) {
            return attributeQuery;
        }
        return new AttributeQuery(){

            @Override
            public boolean contains(AttributeKey<?> attributeKey) {
                return this.getQuery(attributeKey).contains(attributeKey);
            }

            @Override
            public <A> A get(AttributeKey<A> attributeKey) {
                return this.getQuery(attributeKey).get(attributeKey);
            }

            @Override
            public <A> A get(AttributeKey<A> attributeKey, A a) {
                return this.getQuery(attributeKey).get(attributeKey, a);
            }

            private AttributeQuery getQuery(AttributeKey<?> attributeKey) {
                AttributeQuery attributeQuery2 = FormatStep.this.sectionalAttrs;
                if (!attributeQuery2.contains(attributeKey)) {
                    attributeQuery2 = attributeQuery;
                }
                return attributeQuery2;
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof FormatStep) {
            FormatStep formatStep = (FormatStep)object;
            return this.processor.equals(formatStep.processor) && this.level == formatStep.level && this.section == formatStep.section && FormatStep.isEqual(this.sectionalAttrs, formatStep.sectionalAttrs) && this.reserved == formatStep.reserved && this.padLeft == formatStep.padLeft && this.padRight == formatStep.padRight;
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.processor.hashCode() + 31 * (this.sectionalAttrs == null ? 0 : this.sectionalAttrs.hashCode());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[processor=");
        stringBuilder.append(this.processor);
        stringBuilder.append(", level=");
        stringBuilder.append(this.level);
        stringBuilder.append(", section=");
        stringBuilder.append(this.section);
        if (this.sectionalAttrs != null) {
            stringBuilder.append(", attributes=");
            stringBuilder.append(this.sectionalAttrs);
        }
        stringBuilder.append(", reserved=");
        stringBuilder.append(this.reserved);
        stringBuilder.append(", pad-left=");
        stringBuilder.append(this.padLeft);
        stringBuilder.append(", pad-right=");
        stringBuilder.append(this.padRight);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private static <V> FormatProcessor<V> update(FormatProcessor<V> formatProcessor, ChronoElement<?> chronoElement) {
        if (formatProcessor.getElement() == null) {
            return formatProcessor;
        }
        if (formatProcessor.getElement().getType() != chronoElement.getType()) {
            throw new IllegalArgumentException("Cannot change element value type: " + chronoElement.name());
        }
        return formatProcessor.withElement(chronoElement);
    }

    private static boolean isEqual(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private void doParse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, Map<ChronoElement<?>, Object> map) {
        int n = parseLog.getPosition();
        try {
            this.processor.parse(charSequence, parseLog, attributeQuery, map, this);
        }
        catch (RuntimeException runtimeException) {
            parseLog.setError(n, runtimeException.getMessage());
        }
    }

    private boolean isStrict(AttributeQuery attributeQuery) {
        return this.getAttribute(Attributes.LENIENCY, attributeQuery, Leniency.SMART).isStrict();
    }

    private char getPadChar(AttributeQuery attributeQuery) {
        return this.getAttribute(Attributes.PAD_CHAR, attributeQuery, Character.valueOf(' ')).charValue();
    }

    private String padExceeded() {
        return "Pad width exceeded: " + this.getProcessor().getElement().name();
    }

    private String padMismatched() {
        return "Pad width mismatched: " + this.getProcessor().getElement().name();
    }

    private boolean isPrinting(ChronoDisplay chronoDisplay) {
        if (this.sectionalAttrs == null) {
            return true;
        }
        ChronoCondition<ChronoDisplay> chronoCondition = this.sectionalAttrs.getCondition();
        return chronoCondition == null || chronoCondition.test(chronoDisplay);
    }
}

