/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.scale;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import net.time4j.base.GregorianDate;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.scale.ExtendedLSE;
import net.time4j.scale.LeapSecondEvent;
import net.time4j.scale.LeapSecondProvider;

public final class LeapSeconds
implements Iterable<LeapSecondEvent> {
    public static final boolean SUPPRESS_UTC_LEAPSECONDS = Boolean.getBoolean("net.time4j.scale.leapseconds.suppressed");
    public static final boolean FINAL_UTC_LEAPSECONDS = Boolean.getBoolean("net.time4j.scale.leapseconds.final");
    public static final String PATH_TO_LEAPSECONDS = System.getProperty("net.time4j.scale.leapseconds.path", "data/leapseconds.data");
    private static final ExtendedLSE[] EMPTY_ARRAY = new ExtendedLSE[0];
    private static final LeapSeconds INSTANCE = new LeapSeconds();
    private static final long UNIX_OFFSET = 63072000L;
    private static final long MJD_OFFSET = 40587L;
    private final String provider;
    private final List<ExtendedLSE> list;
    private final ExtendedLSE[] reverseFinal;
    private volatile ExtendedLSE[] reverseVolatile;
    private final boolean supportsNegativeLS;

    /*
     * WARNING - void declaration
     */
    private LeapSeconds() {
        if (SUPPRESS_UTC_LEAPSECONDS) {
            this.provider = "<none>";
            this.list = Collections.emptyList();
            this.reverseFinal = EMPTY_ARRAY;
            this.reverseVolatile = EMPTY_ARRAY;
            this.supportsNegativeLS = false;
        } else {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = LeapSecondProvider.class.getClassLoader();
            }
            ServiceLoader<LeapSecondProvider> serviceLoader = ServiceLoader.load(LeapSecondProvider.class, classLoader);
            LeapSecondProvider leapSecondProvider = new DefaultLeapSecondService();
            int n = leapSecondProvider.getLeapSecondTable().size();
            for (LeapSecondProvider object : serviceLoader) {
                int bl2 = object.getLeapSecondTable().size();
                if (bl2 <= n) continue;
                leapSecondProvider = object;
                n = bl2;
            }
            TreeSet<ExtendedLSE> treeSet = new TreeSet<ExtendedLSE>(new EventComparator());
            for (Map.Entry<GregorianDate, Integer> entry : leapSecondProvider.getLeapSecondTable().entrySet()) {
                GregorianDate gregorianDate = entry.getKey();
                long l = LeapSeconds.toPosix(gregorianDate);
                treeSet.add(new SimpleLeapSecondEvent(gregorianDate, l + -62985600L - 1L, entry.getValue()));
            }
            LeapSeconds.extend((SortedSet<ExtendedLSE>)treeSet);
            this.list = FINAL_UTC_LEAPSECONDS ? Collections.unmodifiableList(new ArrayList(treeSet)) : new CopyOnWriteArrayList<ExtendedLSE>(treeSet);
            this.reverseFinal = this.initReverse();
            this.reverseVolatile = this.reverseFinal;
            this.provider = leapSecondProvider.toString();
            if (FINAL_UTC_LEAPSECONDS) {
                void var6_9;
                boolean bl = leapSecondProvider.supportsNegativeLS();
                if (bl) {
                    boolean bl2;
                    boolean bl3 = false;
                    for (ExtendedLSE extendedLSE : this.list) {
                        if (extendedLSE.getShift() >= 0) continue;
                        bl2 = true;
                        break;
                    }
                    var6_9 = bl2;
                }
                this.supportsNegativeLS = var6_9;
            } else {
                this.supportsNegativeLS = true;
            }
        }
    }

    public static LeapSeconds getInstance() {
        return INSTANCE;
    }

    public boolean isEnabled() {
        return !this.list.isEmpty();
    }

    public boolean isExtensible() {
        return !FINAL_UTC_LEAPSECONDS && this.isEnabled();
    }

    public int getCount() {
        return this.getEventsInDescendingOrder().length;
    }

    public void registerPositiveLS(int n, int n2, int n3) {
        this.register(n, n2, n3, false);
    }

    public void registerNegativeLS(int n, int n2, int n3) {
        this.register(n, n2, n3, true);
    }

    public boolean supportsNegativeLS() {
        return this.supportsNegativeLS;
    }

    @Override
    public Iterator<LeapSecondEvent> iterator() {
        final LeapSecondEvent[] leapSecondEventArray = this.getEventsInDescendingOrder();
        return new Iterator<LeapSecondEvent>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < leapSecondEventArray.length;
            }

            @Override
            public LeapSecondEvent next() {
                if (this.index >= leapSecondEventArray.length) {
                    throw new NoSuchElementException();
                }
                LeapSecondEvent leapSecondEvent = leapSecondEventArray[this.index];
                ++this.index;
                return leapSecondEvent;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int getShift(GregorianDate gregorianDate) {
        int n = gregorianDate.getYear();
        if (n >= 1972) {
            ExtendedLSE[] extendedLSEArray = this.getEventsInDescendingOrder();
            for (int i = 0; i < extendedLSEArray.length; ++i) {
                ExtendedLSE extendedLSE = extendedLSEArray[i];
                GregorianDate gregorianDate2 = extendedLSE.getDate();
                if (n != gregorianDate2.getYear() || gregorianDate.getMonth() != gregorianDate2.getMonth() || gregorianDate.getDayOfMonth() != gregorianDate2.getDayOfMonth()) continue;
                return extendedLSE.getShift();
            }
        }
        return 0;
    }

    public int getShift(long l) {
        if (l <= 0L) {
            return 0;
        }
        ExtendedLSE[] extendedLSEArray = this.getEventsInDescendingOrder();
        for (int i = 0; i < extendedLSEArray.length; ++i) {
            ExtendedLSE extendedLSE = extendedLSEArray[i];
            if (l > extendedLSE.utc()) {
                return 0;
            }
            long l2 = extendedLSE.utc() - (long)extendedLSE.getShift();
            if (l <= l2) continue;
            return (int)(l - l2);
        }
        return 0;
    }

    public LeapSecondEvent getNextEvent(long l) {
        ExtendedLSE extendedLSE;
        ExtendedLSE[] extendedLSEArray = this.getEventsInDescendingOrder();
        ExtendedLSE extendedLSE2 = null;
        for (int i = 0; i < extendedLSEArray.length && l < (extendedLSE = extendedLSEArray[i]).utc(); ++i) {
            extendedLSE2 = extendedLSE;
        }
        return extendedLSE2;
    }

    public long enhance(long l) {
        long l2 = l - 63072000L;
        if (l <= 0L) {
            return l;
        }
        ExtendedLSE[] extendedLSEArray = this.getEventsInDescendingOrder();
        for (int i = 0; i < extendedLSEArray.length; ++i) {
            ExtendedLSE extendedLSE = extendedLSEArray[i];
            if (extendedLSE.raw() >= l2) continue;
            return MathUtils.safeAdd(l2, extendedLSE.utc() - extendedLSE.raw());
        }
        return l2;
    }

    public long strip(long l) {
        if (l <= 0L) {
            return l + 63072000L;
        }
        ExtendedLSE[] extendedLSEArray = this.getEventsInDescendingOrder();
        boolean bl = this.supportsNegativeLS;
        for (int i = 0; i < extendedLSEArray.length; ++i) {
            ExtendedLSE extendedLSE = extendedLSEArray[i];
            if (extendedLSE.utc() - (long)extendedLSE.getShift() >= l && (!bl || extendedLSE.getShift() >= 0 || extendedLSE.utc() >= l)) continue;
            l = MathUtils.safeAdd(l, extendedLSE.raw() - extendedLSE.utc());
            break;
        }
        return l + 63072000L;
    }

    public boolean isPositiveLS(long l) {
        if (l <= 0L) {
            return false;
        }
        ExtendedLSE[] extendedLSEArray = this.getEventsInDescendingOrder();
        for (int i = 0; i < extendedLSEArray.length; ++i) {
            long l2 = extendedLSEArray[i].utc();
            if (l2 == l) {
                return extendedLSEArray[i].getShift() == 1;
            }
            if (l2 < l) break;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(2048);
        stringBuilder.append("[PROVIDER=");
        stringBuilder.append(this.provider);
        stringBuilder.append(",EVENTS=[");
        if (this.isEnabled()) {
            boolean bl = true;
            for (ExtendedLSE extendedLSE : this.list) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append('|');
                }
                stringBuilder.append(extendedLSE);
            }
        } else {
            stringBuilder.append("NOT SUPPORTED");
        }
        return stringBuilder.append("]]").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(int n, int n2, int n3, boolean bl) {
        if (FINAL_UTC_LEAPSECONDS) {
            throw new IllegalStateException("Leap seconds are final, change requires edit of system property \"time4j.utc.leapseconds.final\" and reboot of JVM.");
        }
        if (SUPPRESS_UTC_LEAPSECONDS) {
            throw new IllegalStateException("Leap seconds are not supported, change requires edit of system property \"time4j.utc.leapseconds.suppressed\" and reboot of JVM.");
        }
        LeapSeconds leapSeconds = this;
        synchronized (leapSeconds) {
            GregorianMath.checkDate(n, n2, n3);
            if (!this.isEnabled()) {
                throw new IllegalStateException("Leap seconds not activated.");
            }
            ExtendedLSE extendedLSE = this.reverseVolatile[0];
            GregorianDate gregorianDate = extendedLSE.getDate();
            boolean bl2 = false;
            if (n > gregorianDate.getYear()) {
                bl2 = true;
            } else if (n == gregorianDate.getYear()) {
                if (n2 > gregorianDate.getMonth()) {
                    bl2 = true;
                } else if (n2 == gregorianDate.getMonth() && n3 > gregorianDate.getDayOfMonth()) {
                    bl2 = true;
                }
            }
            if (!bl2) {
                throw new IllegalArgumentException("New leap second must be after last leap second.");
            }
            IsoDate isoDate = new IsoDate(n, n2, n3);
            int n4 = bl ? -1 : 1;
            this.list.add(LeapSeconds.createLSE(isoDate, n4, extendedLSE));
            this.reverseVolatile = this.initReverse();
        }
    }

    private ExtendedLSE[] getEventsInDescendingOrder() {
        if (SUPPRESS_UTC_LEAPSECONDS || FINAL_UTC_LEAPSECONDS) {
            return this.reverseFinal;
        }
        return this.reverseVolatile;
    }

    private static void extend(SortedSet<ExtendedLSE> sortedSet) {
        ArrayList<ExtendedLSE> arrayList = new ArrayList<ExtendedLSE>(sortedSet.size());
        int n = 0;
        for (ExtendedLSE extendedLSE : sortedSet) {
            if (extendedLSE.utc() == Long.MIN_VALUE) {
                arrayList.add(new SimpleLeapSecondEvent(extendedLSE, n += extendedLSE.getShift()));
                continue;
            }
            arrayList.add(extendedLSE);
        }
        sortedSet.clear();
        sortedSet.addAll(arrayList);
    }

    private static ExtendedLSE createLSE(final GregorianDate gregorianDate, final int n, ExtendedLSE extendedLSE) {
        ExtendedLSE extendedLSE2 = new ExtendedLSE(){

            @Override
            public GregorianDate getDate() {
                return gregorianDate;
            }

            @Override
            public int getShift() {
                return n;
            }

            @Override
            public long utc() {
                return Long.MIN_VALUE;
            }

            @Override
            public long raw() {
                return LeapSeconds.toPosix(gregorianDate) + -62985600L - 1L;
            }
        };
        int n2 = (int)(extendedLSE.utc() - extendedLSE.raw() + (long)n);
        return new SimpleLeapSecondEvent(extendedLSE2, n2);
    }

    private static long toPosix(GregorianDate gregorianDate) {
        return MathUtils.safeMultiply(MathUtils.safeSubtract(GregorianMath.toMJD(gregorianDate), 40587L), 86400L);
    }

    private ExtendedLSE[] initReverse() {
        ArrayList<ExtendedLSE> arrayList = new ArrayList<ExtendedLSE>(this.list.size());
        arrayList.addAll(this.list);
        Collections.reverse(arrayList);
        return arrayList.toArray(new ExtendedLSE[arrayList.size()]);
    }

    private static class EventComparator
    implements Comparator<ExtendedLSE> {
        private EventComparator() {
        }

        @Override
        public int compare(ExtendedLSE extendedLSE, ExtendedLSE extendedLSE2) {
            int n;
            int n2;
            int n3;
            GregorianDate gregorianDate = extendedLSE.getDate();
            GregorianDate gregorianDate2 = extendedLSE2.getDate();
            int n4 = gregorianDate.getYear();
            if (n4 < (n3 = gregorianDate2.getYear())) {
                return -1;
            }
            if (n4 > n3) {
                return 1;
            }
            int n5 = gregorianDate.getMonth();
            if (n5 < (n2 = gregorianDate2.getMonth())) {
                return -1;
            }
            if (n5 > n2) {
                return 1;
            }
            int n6 = gregorianDate.getDayOfMonth();
            return n6 < (n = gregorianDate2.getDayOfMonth()) ? -1 : (n6 == n ? 0 : 1);
        }
    }

    private static class DefaultLeapSecondService
    implements LeapSecondProvider {
        private final String source;
        private final Map<GregorianDate, Integer> table = new LinkedHashMap<GregorianDate, Integer>(50);

        DefaultLeapSecondService() {
            InputStream inputStream = null;
            String string = PATH_TO_LEAPSECONDS;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                inputStream = classLoader.getResourceAsStream(string);
            }
            if (inputStream == null) {
                classLoader = LeapSecondProvider.class.getClassLoader();
                inputStream = classLoader.getResourceAsStream(string);
            }
            if (inputStream != null) {
                this.source = classLoader.getResource(string).toString();
                try {
                    String string2;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "US-ASCII"));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        int n;
                        int n2;
                        Integer n3;
                        int n4;
                        String string3;
                        if (string2.startsWith("#")) continue;
                        int n5 = string2.indexOf(44);
                        Boolean bl = null;
                        if (n5 == -1) {
                            string3 = string2.trim();
                            bl = Boolean.TRUE;
                        } else {
                            string3 = string2.substring(0, n5).trim();
                            String string4 = string2.substring(n5 + 1).trim();
                            if (string4.length() == 1) {
                                n4 = string4.charAt(0);
                                if (n4 == 43) {
                                    bl = Boolean.TRUE;
                                } else if (n4 == 45) {
                                    bl = Boolean.FALSE;
                                }
                            }
                            if (bl == null) {
                                throw new IllegalStateException("Missing leap second sign.");
                            }
                        }
                        if ((n3 = this.table.put(new IsoDate(n2 = Integer.parseInt(string3.substring(0, 4)), n4 = Integer.parseInt(string3.substring(5, 7)), n = Integer.parseInt(string3.substring(8, 10))), bl != false ? 1 : -1)) == null) continue;
                        throw new IllegalStateException("Duplicate leap second event found.");
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new AssertionError((Object)unsupportedEncodingException);
                }
                catch (IllegalStateException illegalStateException) {
                    throw illegalStateException;
                }
                catch (Exception exception) {
                    throw new IllegalStateException(exception);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace(System.err);
                    }
                }
            }
            this.source = "";
            System.out.println("Warning: File \"" + string + "\" not found.");
        }

        @Override
        public Map<GregorianDate, Integer> getLeapSecondTable() {
            return Collections.unmodifiableMap(this.table);
        }

        @Override
        public boolean supportsNegativeLS() {
            return true;
        }

        public String toString() {
            return this.source;
        }
    }

    private static class SimpleLeapSecondEvent
    implements ExtendedLSE,
    Serializable {
        private static final long serialVersionUID = 5986185471610524587L;
        private final GregorianDate date;
        private final int shift;
        private final long _utc;
        private final long _raw;

        SimpleLeapSecondEvent(GregorianDate gregorianDate, long l, int n) {
            this.date = new IsoDate(gregorianDate.getYear(), gregorianDate.getMonth(), gregorianDate.getDayOfMonth());
            this.shift = n;
            this._utc = Long.MIN_VALUE;
            this._raw = l;
        }

        SimpleLeapSecondEvent(ExtendedLSE extendedLSE, int n) {
            this.date = extendedLSE.getDate();
            this.shift = extendedLSE.getShift();
            this._utc = extendedLSE.raw() + (long)n;
            this._raw = extendedLSE.raw();
        }

        @Override
        public GregorianDate getDate() {
            return this.date;
        }

        @Override
        public int getShift() {
            return this.shift;
        }

        @Override
        public long utc() {
            return this._utc;
        }

        @Override
        public long raw() {
            return this._raw;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append(LeapSecondEvent.class.getName());
            stringBuilder.append('[');
            stringBuilder.append(this.date);
            stringBuilder.append(": utc=");
            stringBuilder.append(this._utc);
            stringBuilder.append(", raw=");
            stringBuilder.append(this._raw);
            stringBuilder.append(" (shift=");
            stringBuilder.append(this.shift);
            stringBuilder.append(")]");
            return stringBuilder.toString();
        }
    }

    private static class IsoDate
    implements GregorianDate,
    Serializable {
        private static final long serialVersionUID = 786391662682108754L;
        private final int year;
        private final int month;
        private final int dayOfMonth;

        IsoDate(int n, int n2, int n3) {
            GregorianMath.checkDate(n, n2, n3);
            this.year = n;
            this.month = n2;
            this.dayOfMonth = n3;
        }

        @Override
        public int getYear() {
            return this.year;
        }

        @Override
        public int getMonth() {
            return this.month;
        }

        @Override
        public int getDayOfMonth() {
            return this.dayOfMonth;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof IsoDate) {
                IsoDate isoDate = (IsoDate)object;
                return this.dayOfMonth == isoDate.dayOfMonth && this.month == isoDate.month && this.year == isoDate.year;
            }
            return false;
        }

        public int hashCode() {
            return this.year + 31 * this.month + 37 * this.dayOfMonth;
        }

        @Override
        public String toString() {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            if (this.year < 0) {
                stringBuilder.append('-');
            }
            if ((n = Math.abs(this.year)) < 1000) {
                stringBuilder.append('0');
                if (n < 100) {
                    stringBuilder.append('0');
                    if (n < 10) {
                        stringBuilder.append('0');
                    }
                }
            }
            stringBuilder.append(n);
            stringBuilder.append('-');
            if (this.month < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(this.month);
            stringBuilder.append('-');
            if (this.dayOfMonth < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(this.dayOfMonth);
            return stringBuilder.toString();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            int n = this.year;
            int n2 = this.month;
            int n3 = this.dayOfMonth;
            if (!GregorianMath.isValid(n, n2, n3)) {
                throw new InvalidObjectException("Corrupt date.");
            }
        }
    }
}

