/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.Weekmodel;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.EpochDays;
import net.time4j.format.Attributes;
import net.time4j.format.ChronoFormatter;
import net.time4j.format.ChronoPattern;
import net.time4j.format.DisplayMode;
import net.time4j.format.OutputContext;
import net.time4j.format.SignPolicy;
import net.time4j.format.TextWidth;

public enum PatternType implements ChronoPattern
{
    CLDR,
    SIMPLE_DATE_FORMAT;


    @Override
    public Set<ChronoElement<?>> registerSymbol(ChronoFormatter.Builder<?> builder, Locale locale, char c, int n) {
        switch (this) {
            case CLDR: {
                return this.cldr(builder, locale, c, n, false);
            }
            case SIMPLE_DATE_FORMAT: {
                return this.sdf(builder, locale, c, n);
            }
        }
        throw new UnsupportedOperationException(this.name());
    }

    static int getFormatStyle(DisplayMode displayMode) {
        switch (displayMode) {
            case FULL: {
                return 0;
            }
            case LONG: {
                return 1;
            }
            case MEDIUM: {
                return 2;
            }
            case SHORT: {
                return 3;
            }
        }
        throw new UnsupportedOperationException("Unknown: " + (Object)((Object)displayMode));
    }

    static String getFormatPattern(DateFormat dateFormat) {
        if (dateFormat instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)SimpleDateFormat.class.cast(dateFormat)).toPattern();
        }
        throw new IllegalStateException("Cannot retrieve format pattern.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ChronoElement<?>> cldr(ChronoFormatter.Builder<?> builder, Locale locale, char c, int n, boolean bl) {
        switch (c) {
            case 'G': {
                TextWidth textWidth;
                if (n <= 3) {
                    textWidth = TextWidth.ABBREVIATED;
                } else if (n == 4 || bl) {
                    textWidth = TextWidth.WIDE;
                } else if (n == 5) {
                    textWidth = TextWidth.NARROW;
                } else {
                    throw new IllegalArgumentException("Too many pattern letters: " + n);
                }
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                builder.addText(PlainDate.ERA);
                builder.endSection();
                break;
            }
            case 'y': {
                if (n == 2) {
                    builder.addTwoDigitYear(PlainDate.YEAR_OF_ERA);
                    break;
                }
                builder.addInteger(PlainDate.YEAR_OF_ERA, n, 9);
                break;
            }
            case 'Y': {
                if (n == 2) {
                    builder.addTwoDigitYear(PlainDate.YEAR_OF_WEEKDATE);
                    break;
                }
                if (n < 4) {
                    builder.addInteger(PlainDate.YEAR_OF_WEEKDATE, n, 9, SignPolicy.SHOW_WHEN_NEGATIVE);
                    break;
                }
                builder.addInteger(PlainDate.YEAR_OF_WEEKDATE, n, 9, SignPolicy.SHOW_WHEN_BIG_NUMBER);
                break;
            }
            case 'u': {
                if (n < 4) {
                    builder.addInteger(PlainDate.YEAR, n, 9, SignPolicy.SHOW_WHEN_NEGATIVE);
                    break;
                }
                builder.addInteger(PlainDate.YEAR, n, 9, SignPolicy.SHOW_WHEN_BIG_NUMBER);
                break;
            }
            case 'Q': {
                PatternType.addQuarterOfYear(builder, n);
                break;
            }
            case 'q': {
                builder.startSection(Attributes.OUTPUT_CONTEXT, OutputContext.STANDALONE);
                try {
                    PatternType.addQuarterOfYear(builder, n);
                    break;
                }
                finally {
                    builder.endSection();
                }
            }
            case 'M': {
                PatternType.addMonth(builder, Math.min(n, bl ? 4 : n));
                break;
            }
            case 'L': {
                builder.startSection(Attributes.OUTPUT_CONTEXT, OutputContext.STANDALONE);
                try {
                    PatternType.addMonth(builder, n);
                    break;
                }
                finally {
                    builder.endSection();
                }
            }
            case 'w': {
                PatternType.addNumber(Weekmodel.of(locale).weekOfYear(), builder, n, bl);
                break;
            }
            case 'W': {
                if (n == 1) {
                    builder.addFixedInteger(Weekmodel.of(locale).weekOfMonth(), 1);
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters: " + n);
            }
            case 'd': {
                PatternType.addNumber(PlainDate.DAY_OF_MONTH, builder, n, bl);
                break;
            }
            case 'D': {
                if (n < 3) {
                    builder.addInteger(PlainDate.DAY_OF_YEAR, n, 3);
                    break;
                }
                if (n == 3 || bl) {
                    builder.addFixedInteger(PlainDate.DAY_OF_YEAR, n);
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters: " + n);
            }
            case 'F': {
                if (n == 1 || bl) {
                    builder.addFixedInteger(PlainDate.WEEKDAY_IN_MONTH, n);
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters: " + n);
            }
            case 'g': {
                builder.addLongNumber(EpochDays.MODIFIED_JULIAN_DATE, n, 18, SignPolicy.SHOW_WHEN_NEGATIVE);
                break;
            }
            case 'E': {
                TextWidth textWidth;
                if (n <= 3) {
                    textWidth = TextWidth.ABBREVIATED;
                } else if (n == 4 || bl) {
                    textWidth = TextWidth.WIDE;
                } else if (n == 5) {
                    textWidth = TextWidth.NARROW;
                } else if (n == 6) {
                    textWidth = TextWidth.SHORT;
                } else {
                    throw new IllegalArgumentException("Too many pattern letters: " + n);
                }
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                builder.addText(PlainDate.DAY_OF_WEEK);
                builder.endSection();
                break;
            }
            case 'e': {
                if (n <= 2) {
                    builder.addFixedNumerical(Weekmodel.of(locale).localDayOfWeek(), n);
                    break;
                }
                this.cldr(builder, locale, 'E', n, bl);
                break;
            }
            case 'c': {
                if (n == 2) {
                    throw new IllegalArgumentException("Invalid pattern count of 2 for symbol 'c'.");
                }
                builder.startSection(Attributes.OUTPUT_CONTEXT, OutputContext.STANDALONE);
                try {
                    if (n == 1) {
                        builder.addFixedNumerical(Weekmodel.of(locale).localDayOfWeek(), 1);
                        break;
                    }
                    this.cldr(builder, locale, 'E', n, bl);
                    break;
                }
                finally {
                    builder.endSection();
                }
            }
            case 'a': {
                if (n == 1 || bl) {
                    builder.addText(PlainTime.AM_PM_OF_DAY);
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters: " + n);
            }
            case 'h': {
                PatternType.addNumber(PlainTime.CLOCK_HOUR_OF_AMPM, builder, n, bl);
                break;
            }
            case 'H': {
                PatternType.addNumber(PlainTime.DIGITAL_HOUR_OF_DAY, builder, n, bl);
                break;
            }
            case 'K': {
                PatternType.addNumber(PlainTime.DIGITAL_HOUR_OF_AMPM, builder, n, bl);
                break;
            }
            case 'k': {
                PatternType.addNumber(PlainTime.CLOCK_HOUR_OF_DAY, builder, n, bl);
                break;
            }
            case 'm': {
                PatternType.addNumber(PlainTime.MINUTE_OF_HOUR, builder, n, bl);
                break;
            }
            case 's': {
                PatternType.addNumber(PlainTime.SECOND_OF_MINUTE, builder, n, bl);
                break;
            }
            case 'S': {
                builder.addFraction(PlainTime.NANO_OF_SECOND, n, n, false);
                break;
            }
            case 'A': {
                builder.addInteger(PlainTime.MILLI_OF_DAY, n, 9);
                break;
            }
            case 'z': {
                if (n < 4) {
                    builder.addShortTimezoneName();
                    break;
                }
                if (n == 4 || bl) {
                    builder.addLongTimezoneName();
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters: " + n);
            }
            case 'Z': {
                if (n < 4) {
                    builder.addTimezoneOffset(DisplayMode.LONG, false, Collections.singletonList("+0000"));
                    break;
                }
                if (n == 4) {
                    builder.addLongLocalizedOffset();
                    break;
                }
                if (n == 5) {
                    builder.addTimezoneOffset(DisplayMode.LONG, true, Collections.singletonList("Z"));
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters: " + n);
            }
            case 'O': {
                if (n == 1) {
                    builder.addShortLocalizedOffset();
                    break;
                }
                if (n == 4) {
                    builder.addLongLocalizedOffset();
                    break;
                }
                throw new IllegalArgumentException("Count of pattern letters is not 1 or 4: " + n);
            }
            case 'V': {
                if (n == 2) {
                    try {
                        builder.addTimezoneID();
                        break;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw new IllegalArgumentException(illegalStateException.getMessage());
                    }
                }
                throw new IllegalArgumentException("Count of pattern letters is not 2: " + n);
            }
            case 'X': {
                PatternType.addOffset(builder, n, true);
                break;
            }
            case 'x': {
                PatternType.addOffset(builder, n, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported pattern symbol: " + c);
            }
        }
        return Collections.emptySet();
    }

    private Set<ChronoElement<?>> sdf(ChronoFormatter.Builder<?> builder, Locale locale, char c, int n) {
        switch (c) {
            case 'W': {
                builder.addFixedInteger(Weekmodel.of(locale).boundedWeekOfMonth(), n);
                break;
            }
            case 'u': {
                builder.addFixedNumerical(PlainDate.DAY_OF_WEEK, n);
                break;
            }
            case 'S': {
                builder.addFixedInteger(PlainTime.MILLI_OF_SECOND, n);
                break;
            }
            case 'Z': {
                PatternType.addOffset(builder, 2, false);
                break;
            }
            case 'L': 
            case 'O': 
            case 'Q': 
            case 'V': 
            case 'c': 
            case 'e': 
            case 'g': 
            case 'q': 
            case 'x': {
                throw new IllegalArgumentException("CLDR pattern symbol not supported in SimpleDateFormat-style: " + c);
            }
            case 'X': {
                if (n >= 4) {
                    throw new IllegalArgumentException("Too many pattern letters: " + n);
                }
                return this.cldr(builder, locale, 'X', n, true);
            }
            default: {
                return this.cldr(builder, locale, c, n, true);
            }
        }
        return Collections.emptySet();
    }

    private static void addOffset(ChronoFormatter.Builder<?> builder, int n, boolean bl) {
        switch (n) {
            case 1: {
                builder.addTimezoneOffset(DisplayMode.SHORT, false, Collections.singletonList(bl ? "Z" : "+00"));
                break;
            }
            case 2: {
                builder.addTimezoneOffset(DisplayMode.MEDIUM, false, Collections.singletonList(bl ? "Z" : "+0000"));
                break;
            }
            case 3: {
                builder.addTimezoneOffset(DisplayMode.MEDIUM, true, Collections.singletonList(bl ? "Z" : "+00:00"));
                break;
            }
            case 4: {
                builder.addTimezoneOffset(DisplayMode.LONG, false, Collections.singletonList(bl ? "Z" : "+0000"));
                break;
            }
            case 5: {
                builder.addTimezoneOffset(DisplayMode.LONG, true, Collections.singletonList(bl ? "Z" : "+00:00"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Too many pattern letters: " + n);
            }
        }
    }

    private static void addNumber(ChronoElement<Integer> chronoElement, ChronoFormatter.Builder<?> builder, int n, boolean bl) {
        if (n == 1) {
            builder.addInteger(chronoElement, 1, 2);
        } else if (n == 2 || bl) {
            builder.addFixedInteger(chronoElement, n);
        } else {
            throw new IllegalArgumentException("Too many pattern letters: " + n);
        }
    }

    private static void addMonth(ChronoFormatter.Builder<?> builder, int n) {
        switch (n) {
            case 1: {
                builder.addInteger(PlainDate.MONTH_AS_NUMBER, 1, 2);
                break;
            }
            case 2: {
                builder.addFixedInteger(PlainDate.MONTH_AS_NUMBER, 2);
                break;
            }
            case 3: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.ABBREVIATED);
                builder.addText(PlainDate.MONTH_OF_YEAR);
                builder.endSection();
                break;
            }
            case 4: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.WIDE);
                builder.addText(PlainDate.MONTH_OF_YEAR);
                builder.endSection();
                break;
            }
            case 5: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.NARROW);
                builder.addText(PlainDate.MONTH_OF_YEAR);
                builder.endSection();
                break;
            }
            default: {
                throw new IllegalArgumentException("Too many pattern letters: " + n);
            }
        }
    }

    private static void addQuarterOfYear(ChronoFormatter.Builder<?> builder, int n) {
        switch (n) {
            case 1: 
            case 2: {
                builder.addFixedNumerical(PlainDate.QUARTER_OF_YEAR, n);
                break;
            }
            case 3: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.ABBREVIATED);
                builder.addText(PlainDate.QUARTER_OF_YEAR);
                builder.endSection();
                break;
            }
            case 4: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.WIDE);
                builder.addText(PlainDate.QUARTER_OF_YEAR);
                builder.endSection();
                break;
            }
            default: {
                throw new IllegalArgumentException("Too many pattern letters: " + n);
            }
        }
    }
}

