/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import net.time4j.Duration;
import net.time4j.IsoUnit;
import net.time4j.MachineTime;
import net.time4j.Moment;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.engine.TimeSpan;
import net.time4j.scale.TimeScale;

final class SPX
implements Externalizable {
    static final int DATE_TYPE = 1;
    static final int TIME_TYPE = 2;
    static final int WEEKMODEL_TYPE = 3;
    static final int MOMENT_TYPE = 4;
    static final int TIMESTAMP_TYPE = 5;
    static final int DURATION_TYPE = 6;
    static final int MACHINE_TIME_TYPE = 7;
    private static final long serialVersionUID = 1L;
    private transient Object obj;
    private transient int type;

    public SPX() {
    }

    SPX(Object object, int n) {
        this.obj = object;
        this.type = n;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        switch (this.type) {
            case 1: {
                this.writeDate(objectOutput);
                break;
            }
            case 2: {
                this.writeTime(objectOutput);
                break;
            }
            case 3: {
                this.writeWeekmodel(objectOutput);
                break;
            }
            case 4: {
                this.writeMoment(objectOutput);
                break;
            }
            case 5: {
                this.writeTimestamp(objectOutput);
                break;
            }
            case 6: {
                this.writeDuration(objectOutput);
                break;
            }
            case 7: {
                this.writeMachineTime(objectOutput);
                break;
            }
            default: {
                throw new InvalidClassException("Unknown serialized type.");
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        switch (by >> 4) {
            case 1: {
                this.obj = this.readDate(objectInput, by);
                break;
            }
            case 2: {
                this.obj = this.readTime(objectInput);
                break;
            }
            case 3: {
                this.obj = this.readWeekmodel(objectInput, by);
                break;
            }
            case 4: {
                this.obj = this.readMoment(objectInput, by);
                break;
            }
            case 5: {
                this.obj = this.readTimestamp(objectInput);
                break;
            }
            case 6: {
                this.obj = this.readDuration(objectInput, by);
                break;
            }
            case 7: {
                this.obj = this.readMachineTime(objectInput, by);
                break;
            }
            default: {
                throw new StreamCorruptedException("Unknown serialized type.");
            }
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return this.obj;
    }

    private void writeDate(ObjectOutput objectOutput) throws IOException {
        PlainDate plainDate = (PlainDate)this.obj;
        int n = plainDate.getYear();
        int n2 = n >= 1850 && n <= 2100 ? 1 : (Math.abs(n) < 10000 ? 2 : 3);
        int n3 = 1;
        n3 <<= 4;
        objectOutput.writeByte(n3 |= plainDate.getMonth());
        int n4 = n2;
        n4 <<= 5;
        objectOutput.writeByte(n4 |= plainDate.getDayOfMonth());
        if (n2 == 1) {
            objectOutput.writeByte(n - 1850 - 128);
        } else if (n2 == 2) {
            objectOutput.writeShort(n);
        } else {
            objectOutput.writeInt(n);
        }
    }

    private Object readDate(ObjectInput objectInput, byte by) throws IOException {
        int n;
        int n2 = by & 0xF;
        byte by2 = objectInput.readByte();
        int n3 = by2 >> 5 & 3;
        int n4 = by2 & 0x1F;
        switch (n3) {
            case 1: {
                n = objectInput.readByte() + 1850 + 128;
                break;
            }
            case 2: {
                n = objectInput.readShort();
                break;
            }
            case 3: {
                n = objectInput.readInt();
                break;
            }
            default: {
                throw new StreamCorruptedException("Unknown year range.");
            }
        }
        return PlainDate.of(n, Month.valueOf(n2), n4);
    }

    private void writeTime(ObjectOutput objectOutput) throws IOException {
        PlainTime plainTime = (PlainTime)this.obj;
        objectOutput.writeByte(32);
        if (plainTime.getNanosecond() == 0) {
            if (plainTime.getSecond() == 0) {
                if (plainTime.getMinute() == 0) {
                    objectOutput.writeByte(~plainTime.getHour());
                } else {
                    objectOutput.writeByte(plainTime.getHour());
                    objectOutput.writeByte(~plainTime.getMinute());
                }
            } else {
                objectOutput.writeByte(plainTime.getHour());
                objectOutput.writeByte(plainTime.getMinute());
                objectOutput.writeByte(~plainTime.getSecond());
            }
        } else {
            objectOutput.writeByte(plainTime.getHour());
            objectOutput.writeByte(plainTime.getMinute());
            objectOutput.writeByte(plainTime.getSecond());
            objectOutput.writeInt(plainTime.getNanosecond());
        }
    }

    private Object readTime(ObjectInput objectInput) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        byte by = objectInput.readByte();
        if (by < 0) {
            return PlainTime.of(~by);
        }
        n = objectInput.readByte();
        if (n < 0) {
            n ^= 0xFFFFFFFF;
        } else {
            n2 = objectInput.readByte();
            if (n2 < 0) {
                n2 ^= 0xFFFFFFFF;
            } else {
                n3 = objectInput.readInt();
            }
        }
        return PlainTime.of(by, n, n2, n3);
    }

    private void writeWeekmodel(ObjectOutput objectOutput) throws IOException {
        Weekmodel weekmodel = (Weekmodel)this.obj;
        boolean bl = weekmodel.getStartOfWeekend() == Weekday.SATURDAY && weekmodel.getEndOfWeekend() == Weekday.SUNDAY;
        int n = 3;
        n <<= 4;
        if (!bl) {
            n |= 1;
        }
        objectOutput.writeByte(n);
        int n2 = weekmodel.getFirstDayOfWeek().getValue();
        n2 <<= 4;
        objectOutput.writeByte(n2 |= weekmodel.getMinimalDaysInFirstWeek());
        if (!bl) {
            n2 = weekmodel.getStartOfWeekend().getValue();
            n2 <<= 4;
            objectOutput.writeByte(n2 |= weekmodel.getEndOfWeekend().getValue());
        }
    }

    private Object readWeekmodel(ObjectInput objectInput, byte by) throws IOException {
        byte by2 = objectInput.readByte();
        Weekday weekday = Weekday.valueOf(by2 >> 4);
        int n = by2 & 0xF;
        Weekday weekday2 = Weekday.SATURDAY;
        Weekday weekday3 = Weekday.SUNDAY;
        if ((by & 0xF) == 1) {
            by2 = objectInput.readByte();
            weekday2 = Weekday.valueOf(by2 >> 4);
            weekday3 = Weekday.valueOf(by2 & 0xF);
        }
        return Weekmodel.of(weekday, n, weekday2, weekday3);
    }

    private void writeMoment(ObjectOutput objectOutput) throws IOException {
        Moment moment = (Moment)this.obj;
        moment.writeTimestamp(objectOutput);
    }

    private Object readMoment(ObjectInput objectInput, byte by) throws IOException {
        int n = by & 1;
        int n2 = (by & 2) >>> 1;
        boolean bl = n != 0;
        boolean bl2 = n2 != 0;
        return Moment.readTimestamp(objectInput, bl, bl2);
    }

    private void writeTimestamp(ObjectOutput objectOutput) throws IOException {
        PlainTimestamp plainTimestamp = (PlainTimestamp)this.obj;
        objectOutput.writeByte(80);
        objectOutput.writeObject(plainTimestamp.getCalendarDate());
        objectOutput.writeObject(plainTimestamp.getWallTime());
    }

    private Object readTimestamp(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object = objectInput.readObject();
        Object object2 = objectInput.readObject();
        if (object instanceof PlainDate && object2 instanceof PlainTime) {
            return PlainTimestamp.of((PlainDate)object, (PlainTime)object2);
        }
        throw new InvalidObjectException("Missing date or time object.");
    }

    private void writeDuration(ObjectOutput objectOutput) throws IOException {
        int n;
        Duration duration = (Duration)Duration.class.cast(this.obj);
        int n2 = duration.getTotalLength().size();
        boolean bl = false;
        int n3 = Math.min(n2, 6);
        for (n = 0; n < n3; ++n) {
            if (duration.getTotalLength().get(n).getAmount() < 1000L) continue;
            bl = true;
            break;
        }
        n = 6;
        n <<= 4;
        if (bl) {
            n |= 1;
        }
        objectOutput.writeByte(n);
        objectOutput.writeInt(n2);
        for (n3 = 0; n3 < n2; ++n3) {
            TimeSpan.Item item = duration.getTotalLength().get(n3);
            if (bl) {
                objectOutput.writeLong(item.getAmount());
            } else {
                objectOutput.writeInt((int)item.getAmount());
            }
            objectOutput.writeObject(item.getUnit());
        }
        if (n2 > 0) {
            objectOutput.writeBoolean(duration.isNegative());
        }
    }

    private Object readDuration(ObjectInput objectInput, byte by) throws IOException, ClassNotFoundException {
        int n;
        boolean bl = (by & 0xF) == 1;
        int n2 = objectInput.readInt();
        if (n2 == 0) {
            return Duration.ofZero();
        }
        ArrayList arrayList = new ArrayList(n2);
        for (n = 0; n < n2; ++n) {
            long l = bl ? objectInput.readLong() : (long)objectInput.readInt();
            IsoUnit isoUnit = (IsoUnit)objectInput.readObject();
            arrayList.add(TimeSpan.Item.of(l, isoUnit));
        }
        n = objectInput.readBoolean() ? 1 : 0;
        return new Duration(arrayList, n != 0);
    }

    private void writeMachineTime(ObjectOutput objectOutput) throws IOException {
        MachineTime machineTime = (MachineTime)MachineTime.class.cast(this.obj);
        int n = 7;
        n <<= 4;
        if (machineTime.getScale() == TimeScale.UTC) {
            n |= 1;
        }
        if (machineTime.getFraction() == 0) {
            objectOutput.writeByte(n);
            objectOutput.writeLong(machineTime.getSeconds());
        } else {
            objectOutput.writeByte(n |= 2);
            objectOutput.writeLong(machineTime.getSeconds());
            objectOutput.writeInt(machineTime.getFraction());
        }
    }

    private Object readMachineTime(ObjectInput objectInput, byte by) throws IOException, ClassNotFoundException {
        int n;
        TimeScale timeScale = (by & 1) == 1 ? TimeScale.UTC : TimeScale.POSIX;
        long l = objectInput.readLong();
        int n2 = n = (by & 2) == 2 ? objectInput.readInt() : 0;
        if (timeScale == TimeScale.UTC) {
            return MachineTime.ofSIUnits(l, n);
        }
        return MachineTime.ofPosixUnits(l, n);
    }
}

