/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.ElementPosition;
import net.time4j.format.FormatProcessor;
import net.time4j.format.FormatStep;
import net.time4j.format.ParseLog;
import net.time4j.format.PredefinedKey;

final class LiteralProcessor
implements FormatProcessor<Void> {
    private final char single;
    private final String multi;
    private final String attribute;
    private final AttributeKey<Character> akey;

    LiteralProcessor(String string) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Missing literal.");
        }
        this.single = string.charAt(0);
        this.attribute = null;
        this.akey = null;
        String string2 = this.multi = string.length() == 1 ? null : string;
        if (this.single < ' ') {
            throw new IllegalArgumentException("Literal must not start with non-printable char.");
        }
    }

    LiteralProcessor(AttributeKey<Character> attributeKey) {
        this.single = '\u0000';
        this.attribute = attributeKey.name();
        this.akey = PredefinedKey.valueOf(this.attribute, Character.class);
        this.multi = null;
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, FormatStep formatStep) throws IOException {
        if (this.attribute != null) {
            char c = ((Character)formatStep.getAttribute(this.akey, attributeQuery, null)).charValue();
            appendable.append(c);
        } else if (this.multi == null) {
            appendable.append(this.single);
        } else {
            appendable.append(this.multi);
        }
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, Map<ChronoElement<?>, Object> map, FormatStep formatStep) {
        if (this.multi == null) {
            this.parseChar(charSequence, parseLog, attributeQuery, formatStep);
        } else {
            this.parseMulti(charSequence, parseLog, attributeQuery, formatStep);
        }
    }

    private void parseChar(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, FormatStep formatStep) {
        int n = parseLog.getPosition();
        boolean bl = false;
        char c = '\u0000';
        char c2 = this.single;
        if (this.attribute != null) {
            c2 = formatStep.getAttribute(this.akey, attributeQuery, Character.valueOf('\u0000')).charValue();
        }
        if (n >= charSequence.length() || c2 == '\u0000') {
            bl = true;
        } else {
            boolean bl2;
            c = charSequence.charAt(n);
            char c3 = c2;
            if (Attributes.DECIMAL_SEPARATOR.name().equals(this.attribute) && Locale.ROOT.equals(attributeQuery.get(Attributes.LOCALE, Locale.ROOT))) {
                char c4 = c2 == ',' ? (char)'.' : (c3 = c2 == '.' ? (char)',' : c2);
            }
            if (bl2 = formatStep.getAttribute(Attributes.PARSE_CASE_INSENSITIVE, attributeQuery, Boolean.TRUE).booleanValue()) {
                if (!LiteralProcessor.charEqualsIgnoreCase(c, c2) && !LiteralProcessor.charEqualsIgnoreCase(c, c3)) {
                    bl = true;
                }
            } else {
                boolean bl3 = bl = c != c2 && c != c3;
            }
        }
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder("Expected: [");
            stringBuilder.append(c2);
            stringBuilder.append("], found: [");
            if (c != '\u0000') {
                stringBuilder.append(c);
            }
            stringBuilder.append(']');
            parseLog.setError(n, stringBuilder.toString());
        } else {
            parseLog.setPosition(n + 1);
        }
    }

    private void parseMulti(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, FormatStep formatStep) {
        String string;
        int n;
        boolean bl;
        int n2;
        block6: {
            block7: {
                n2 = parseLog.getPosition();
                bl = false;
                n = this.multi.length();
                string = "";
                if (n2 >= charSequence.length()) {
                    bl = true;
                } else if (n2 + n > charSequence.length()) {
                    bl = true;
                    string = charSequence.subSequence(n2, charSequence.length()).toString();
                }
                if (bl) break block6;
                boolean bl2 = formatStep.getAttribute(Attributes.PARSE_CASE_INSENSITIVE, attributeQuery, Boolean.TRUE);
                if (!bl2) break block7;
                if (LiteralProcessor.subSequenceEqualsIgnoreCase(charSequence, n2, this.multi, 0, n)) break block6;
                bl = true;
                string = charSequence.subSequence(n2, n2 + n).toString();
                break block6;
            }
            for (int i = 0; i < n; ++i) {
                if (this.multi.charAt(i) == charSequence.charAt(i + n2)) continue;
                bl = true;
                string = charSequence.subSequence(n2, n2 + n).toString();
                break;
            }
        }
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder("Expected: [");
            stringBuilder.append(this.multi);
            stringBuilder.append("], found: [");
            stringBuilder.append(string);
            stringBuilder.append(']');
            parseLog.setError(n2, stringBuilder.toString());
        } else {
            parseLog.setPosition(n2 + n);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LiteralProcessor) {
            LiteralProcessor literalProcessor = (LiteralProcessor)object;
            if (this.attribute != null) {
                return this.attribute.equals(literalProcessor.attribute);
            }
            if (this.multi == null) {
                return literalProcessor.multi == null && this.single == literalProcessor.single;
            }
            return this.multi.equals(literalProcessor.multi);
        }
        return false;
    }

    public int hashCode() {
        String string = this.attribute == null ? (this.multi == null ? "" : this.multi) : this.attribute;
        return this.single ^ string.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[literal=");
        if (this.attribute != null) {
            stringBuilder.append('{');
            stringBuilder.append(this.attribute);
            stringBuilder.append('}');
        } else if (this.multi == null) {
            stringBuilder.append(this.single);
        } else {
            stringBuilder.append(this.multi);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<Void> getElement() {
        return null;
    }

    @Override
    public FormatProcessor<Void> withElement(ChronoElement<Void> chronoElement) {
        return this;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    private static boolean charEqualsIgnoreCase(char c, char c2) {
        return c == c2 || Character.toUpperCase(c) == Character.toUpperCase(c2) || Character.toLowerCase(c) == Character.toLowerCase(c2);
    }

    private static boolean subSequenceEqualsIgnoreCase(CharSequence charSequence, int n, CharSequence charSequence2, int n2, int n3) {
        int n4 = charSequence.length();
        int n5 = charSequence2.length();
        for (int i = 0; i < n3; ++i) {
            char c;
            if (i + n >= n4) {
                return i + n2 >= n5;
            }
            if (i + n2 >= n5) {
                return false;
            }
            char c2 = charSequence.charAt(i + n);
            if (LiteralProcessor.charEqualsIgnoreCase(c2, c = charSequence2.charAt(i + n2))) continue;
            return false;
        }
        return true;
    }
}

