/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import net.time4j.engine.ChronoEntity;
import net.time4j.format.ParsedValues;

public class ParseLog {
    private int position;
    private int errorIndex;
    private String errorMessage;
    private ParsedValues rawValues;
    private Boolean daylightSaving;
    private boolean warning;

    public ParseLog() {
        this(0);
    }

    public ParseLog(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Undefined: " + n);
        }
        this.position = n;
        this.errorIndex = -1;
        this.errorMessage = "";
        this.rawValues = null;
        this.daylightSaving = null;
        this.warning = false;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean isError() {
        return this.errorIndex != -1;
    }

    public int getErrorIndex() {
        return this.errorIndex;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public ChronoEntity<?> getRawValues() {
        if (this.rawValues == null) {
            this.rawValues = new ParsedValues();
        }
        return this.rawValues;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("[position=");
        stringBuilder.append(this.position);
        stringBuilder.append(", error-index=");
        stringBuilder.append(this.errorIndex);
        stringBuilder.append(", error-message=\"");
        stringBuilder.append(this.errorMessage);
        stringBuilder.append('\"');
        if (this.warning) {
            stringBuilder.append(", warning-active");
        }
        if (this.rawValues != null) {
            stringBuilder.append(", raw-values=");
            stringBuilder.append(this.rawValues);
        }
        if (this.daylightSaving != null) {
            stringBuilder.append(", daylight-saving=");
            stringBuilder.append(this.daylightSaving);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public void setPosition(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Undefined: " + n);
        }
        this.position = n;
    }

    public void setError(int n, String string) {
        if (n < 0) {
            throw new IllegalArgumentException("Undefined: " + n);
        }
        this.errorMessage = string == null || string.isEmpty() ? "Error occurred at position: " + n : string;
        this.errorIndex = n;
    }

    public void setWarning() {
        if (!this.isError()) {
            this.errorMessage = "Warning state active.";
            this.errorIndex = this.getPosition();
        }
        this.warning = true;
    }

    public void reset() {
        this.position = 0;
        this.clearError();
        this.clearWarning();
        this.rawValues = null;
        this.daylightSaving = null;
    }

    ParsedValues getRawValues0() {
        return this.rawValues;
    }

    void clearError() {
        this.errorIndex = -1;
        this.errorMessage = "";
    }

    void setRawValues(ParsedValues parsedValues) {
        this.rawValues = parsedValues;
    }

    void setDaylightSaving(boolean bl) {
        this.daylightSaving = bl;
    }

    Boolean getDSTInfo() {
        return this.daylightSaving;
    }

    boolean isWarning() {
        return this.warning;
    }

    void clearWarning() {
        this.warning = false;
    }
}

