/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import net.time4j.PlainTime;
import net.time4j.engine.BasicElement;
import net.time4j.engine.ChronoDisplay;
import net.time4j.format.NumericalElement;

final class DecimalTimeElement
extends BasicElement<BigDecimal>
implements NumericalElement<BigDecimal> {
    private static final long serialVersionUID = -4837430960549551204L;
    private final transient BigDecimal defaultMax;

    DecimalTimeElement(String string, BigDecimal bigDecimal) {
        super(string);
        this.defaultMax = bigDecimal;
    }

    @Override
    public Class<BigDecimal> getType() {
        return BigDecimal.class;
    }

    @Override
    public int numerical(BigDecimal bigDecimal) {
        return bigDecimal.setScale(9, RoundingMode.FLOOR).intValue();
    }

    @Override
    public BigDecimal getDefaultMinimum() {
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getDefaultMaximum() {
        return this.defaultMax;
    }

    @Override
    public boolean isDateElement() {
        return false;
    }

    @Override
    public boolean isTimeElement() {
        return true;
    }

    @Override
    public int compare(ChronoDisplay chronoDisplay, ChronoDisplay chronoDisplay2) {
        return chronoDisplay.get(this).compareTo(chronoDisplay2.get(this));
    }

    private Object readResolve() throws ObjectStreamException {
        Object object = PlainTime.lookupElement(this.name());
        if (object == null) {
            throw new InvalidObjectException(this.name());
        }
        return object;
    }
}

