/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import java.io.Serializable;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;

public abstract class BasicElement<V>
implements ChronoElement<V>,
Serializable {
    private final String name;

    protected BasicElement(String string) {
        if (string.trim().isEmpty()) {
            throw new IllegalArgumentException("Element name is empty or contains only white space.");
        }
        this.name = string;
    }

    @Override
    public final String name() {
        return this.name;
    }

    @Override
    public char getSymbol() {
        return '\u0000';
    }

    @Override
    public boolean isLenient() {
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() == object.getClass()) {
            return this.name.equals(((BasicElement)object).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        String string = this.getClass().getName();
        StringBuilder stringBuilder = new StringBuilder(string.length() + 32);
        stringBuilder.append(string);
        stringBuilder.append('@');
        stringBuilder.append(this.name);
        return stringBuilder.toString();
    }

    protected <T extends ChronoEntity<T>> ElementRule<T, V> derive(Chronology<T> chronology) {
        return null;
    }

    protected ChronoElement<?> getParent() {
        return null;
    }

    protected String getVeto(Chronology<?> chronology) {
        return null;
    }
}

