/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.ObjectStreamException;
import net.time4j.CalendarDateElement;
import net.time4j.CalendarOperator;
import net.time4j.ElementOperator;
import net.time4j.PlainDate;
import net.time4j.base.UnixTime;
import net.time4j.engine.BasicElement;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.Chronology;

final class DateElement
extends BasicElement<PlainDate>
implements CalendarDateElement {
    static final DateElement INSTANCE = new DateElement();
    private static final long serialVersionUID = -6519899440006935829L;

    private DateElement() {
        super("CALENDAR_DATE");
    }

    @Override
    public Class<PlainDate> getType() {
        return PlainDate.class;
    }

    @Override
    public PlainDate getDefaultMinimum() {
        return PlainDate.MIN;
    }

    @Override
    public PlainDate getDefaultMaximum() {
        return PlainDate.MAX;
    }

    @Override
    public int compare(ChronoEntity<?> chronoEntity, ChronoEntity<?> chronoEntity2) {
        return chronoEntity.get(this).compareTo((Calendrical)chronoEntity2.get(this));
    }

    @Override
    public boolean isDateElement() {
        return true;
    }

    @Override
    public boolean isTimeElement() {
        return false;
    }

    @Override
    public ElementOperator<PlainDate> firstDayOfNextMonth() {
        return CalendarOperator.FIRST_DAY_OF_NEXT_MONTH;
    }

    @Override
    public ElementOperator<PlainDate> firstDayOfNextQuarter() {
        return CalendarOperator.FIRST_DAY_OF_NEXT_QUARTER;
    }

    @Override
    public ElementOperator<PlainDate> firstDayOfNextYear() {
        return CalendarOperator.FIRST_DAY_OF_NEXT_YEAR;
    }

    @Override
    public ElementOperator<PlainDate> lastDayOfPreviousMonth() {
        return CalendarOperator.LAST_DAY_OF_PREVIOUS_MONTH;
    }

    @Override
    public ElementOperator<PlainDate> lastDayOfPreviousQuarter() {
        return CalendarOperator.LAST_DAY_OF_PREVIOUS_QUARTER;
    }

    @Override
    public ElementOperator<PlainDate> lastDayOfPreviousYear() {
        return CalendarOperator.LAST_DAY_OF_PREVIOUS_YEAR;
    }

    @Override
    protected String getVeto(Chronology<?> chronology) {
        if (UnixTime.class.isAssignableFrom(chronology.getChronoType())) {
            return "Accessing the calendar date component from a global type requires a timezone. Try to first convert the global type to a PlainTimestamp: \"moment.inZonalView(...)\".";
        }
        return null;
    }

    private Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }
}

