/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.EpochDays;
import net.time4j.format.Attributes;
import net.time4j.format.ElementPosition;
import net.time4j.format.FormatProcessor;
import net.time4j.format.FormatStep;
import net.time4j.format.Leniency;
import net.time4j.format.ParseLog;

final class TwoDigitYearProcessor
implements FormatProcessor<Integer> {
    private static final Integer DEFAULT_PIVOT_YEAR;
    private final ChronoElement<Integer> element;

    TwoDigitYearProcessor(ChronoElement<Integer> chronoElement) {
        if (!chronoElement.name().startsWith("YEAR")) {
            throw new IllegalArgumentException("Year element required: " + chronoElement);
        }
        this.element = chronoElement;
    }

    @Override
    public void print(ChronoEntity<?> chronoEntity, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, FormatStep formatStep) throws IOException {
        int n;
        int n2 = chronoEntity.get(this.element);
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative year cannot be printed as two-digit-year: " + n2);
        }
        int n3 = MathUtils.floorModulo(n2, 100);
        String string = Integer.toString(n3);
        char c = formatStep.getAttribute(Attributes.ZERO_DIGIT, attributeQuery, Character.valueOf('0')).charValue();
        if (c != '0') {
            n = c - 48;
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = (char)(cArray[i] + n);
            }
            string = new String(cArray);
        }
        n = -1;
        int n4 = 0;
        if (appendable instanceof CharSequence) {
            n = ((CharSequence)((Object)appendable)).length();
        }
        if (n3 < 10) {
            appendable.append(c);
            ++n4;
        }
        appendable.append(string);
        if (n != -1 && (n4 += string.length()) > 0 && set != null) {
            set.add(new ElementPosition(this.element, n, n + n4));
        }
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, Map<ChronoElement<?>, Object> map, FormatStep formatStep) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = charSequence.length();
        int n8 = parseLog.getPosition();
        if (n8 >= n7) {
            parseLog.setError(n8, "Missing digits for: " + this.element.name());
            return;
        }
        Leniency leniency = formatStep.getAttribute(Attributes.LENIENCY, attributeQuery, Leniency.SMART);
        char c = formatStep.getAttribute(Attributes.ZERO_DIGIT, attributeQuery, Character.valueOf('0')).charValue();
        int n9 = formatStep.getReserved();
        int n10 = n6 = leniency.isStrict() ? 2 : 9;
        if (n9 > 0) {
            n5 = 0;
            for (n4 = n8; n4 < n7 && (n3 = charSequence.charAt(n4) - c) >= 0 && n3 <= 9; ++n4) {
                ++n5;
            }
            n6 = Math.min(n6, n5 - n9);
        }
        n5 = n8 + 2;
        n4 = Math.min(n7, n8 + n6);
        n3 = 0;
        boolean bl = true;
        for (n2 = n8; n2 < n4; ++n2) {
            n = charSequence.charAt(n2) - c;
            if (n >= 0 && n <= 9) {
                n3 = n3 * 10 + n;
                bl = false;
                continue;
            }
            if (!bl) break;
            parseLog.setError(n8, "Digit expected.");
            return;
        }
        if (n2 < n5) {
            parseLog.setError(n8, "Not enough digits found for: " + this.element.name());
            return;
        }
        if (n2 == n8 + 2) {
            int n11 = formatStep.getAttribute(Attributes.PIVOT_YEAR, attributeQuery, DEFAULT_PIVOT_YEAR);
            assert (n3 >= 0 && n3 <= 99);
            n = TwoDigitYearProcessor.toYear(n3, n11);
        } else {
            n = n3;
        }
        map.put(this.element, n);
        parseLog.setPosition(n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TwoDigitYearProcessor) {
            TwoDigitYearProcessor twoDigitYearProcessor = (TwoDigitYearProcessor)object;
            return this.element.equals(twoDigitYearProcessor.element);
        }
        return false;
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[element=");
        stringBuilder.append(this.element.name());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<Integer> getElement() {
        return this.element;
    }

    @Override
    public FormatProcessor<Integer> withElement(ChronoElement<Integer> chronoElement) {
        if (this.element == chronoElement) {
            return this;
        }
        return new TwoDigitYearProcessor(chronoElement);
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    private static int toYear(int n, int n2) {
        int n3 = n >= n2 % 100 ? (n2 / 100 - 1) * 100 : n2 / 100 * 100;
        return n3 + n;
    }

    static {
        long l = EpochDays.MODIFIED_JULIAN_DATE.transform(MathUtils.floorDivide(System.currentTimeMillis(), 86400000), EpochDays.UNIX);
        DEFAULT_PIVOT_YEAR = GregorianMath.readYear(GregorianMath.toPackedDate(l)) + 20;
    }
}

