/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.format.ElementPosition;
import net.time4j.format.FormatProcessor;
import net.time4j.format.FormatStep;
import net.time4j.format.ParseLog;
import net.time4j.format.TextElement;

final class TextProcessor<V>
implements FormatProcessor<V> {
    private final TextElement<V> element;

    private TextProcessor(TextElement<V> textElement) {
        if (textElement == null) {
            throw new NullPointerException("Missing element.");
        }
        this.element = textElement;
    }

    static <V> TextProcessor<V> create(TextElement<V> textElement) {
        return new TextProcessor<V>(textElement);
    }

    @Override
    public void print(ChronoEntity<?> chronoEntity, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, FormatStep formatStep) throws IOException {
        if (appendable instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)((Object)appendable);
            int n = charSequence.length();
            this.element.print(chronoEntity, appendable, formatStep.getQuery(attributeQuery));
            if (set != null) {
                set.add(new ElementPosition(this.element, n, charSequence.length()));
            }
        } else {
            this.element.print(chronoEntity, appendable, formatStep.getQuery(attributeQuery));
        }
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, Map<ChronoElement<?>, Object> map, FormatStep formatStep) {
        int n = parseLog.getPosition();
        if (n >= charSequence.length()) {
            parseLog.setError(n, "Missing chars for: " + this.element.name());
            return;
        }
        TextElement textElement = (TextElement)TextElement.class.cast(this.element);
        Object v = textElement.parse(charSequence, parseLog, formatStep.getQuery(attributeQuery));
        if (!parseLog.isError()) {
            if (v == null) {
                parseLog.setError(n, "No interpretable value.");
            } else {
                map.put(this.element, v);
            }
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TextProcessor) {
            TextProcessor textProcessor = (TextProcessor)object;
            return this.element.equals(textProcessor.element);
        }
        return false;
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[element=");
        stringBuilder.append(this.element.name());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<V> getElement() {
        return this.element;
    }

    @Override
    public FormatProcessor<V> withElement(ChronoElement<V> chronoElement) {
        if (this.element == chronoElement) {
            return this;
        }
        if (chronoElement instanceof TextElement) {
            return TextProcessor.create((TextElement)chronoElement);
        }
        throw new IllegalArgumentException("Text element required: " + chronoElement.getClass().getName());
    }

    @Override
    public boolean isNumerical() {
        return false;
    }
}

