/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import net.time4j.ElementOperator;
import net.time4j.FractionOperator;
import net.time4j.LenientOperator;
import net.time4j.Moment;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.engine.AdvancedElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoOperator;

final class TimeOperator
extends ElementOperator<PlainTime> {
    private final ChronoOperator<PlainTime> opCache;
    private final ChronoOperator<PlainTimestamp> tsCache;
    private final ChronoOperator<Moment> moCache;

    TimeOperator(AdvancedElement<?> advancedElement, int n) {
        this(advancedElement, n, null);
    }

    TimeOperator(AdvancedElement<?> advancedElement, int n, Object object) {
        super(advancedElement, n);
        switch (n) {
            case 0: {
                this.opCache = advancedElement.minimized(PlainTime.class);
                this.tsCache = advancedElement.minimized(PlainTimestamp.class);
                break;
            }
            case 1: {
                this.opCache = advancedElement.maximized(PlainTime.class);
                this.tsCache = advancedElement.maximized(PlainTimestamp.class);
                break;
            }
            case 2: {
                this.opCache = advancedElement.decremented(PlainTime.class);
                this.tsCache = advancedElement.decremented(PlainTimestamp.class);
                break;
            }
            case 3: {
                this.opCache = advancedElement.incremented(PlainTime.class);
                this.tsCache = advancedElement.incremented(PlainTimestamp.class);
                break;
            }
            case 4: {
                this.opCache = TimeOperator.child(advancedElement, false, PlainTime.class);
                this.tsCache = TimeOperator.child(advancedElement, false, PlainTimestamp.class);
                break;
            }
            case 5: {
                this.opCache = TimeOperator.child(advancedElement, true, PlainTime.class);
                this.tsCache = TimeOperator.child(advancedElement, true, PlainTimestamp.class);
                break;
            }
            case 6: {
                this.opCache = TimeOperator.lenient(advancedElement, object);
                this.tsCache = TimeOperator.lenientTS(advancedElement, object);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown: " + this.getType()));
            }
        }
        this.moCache = new Moment.Operator(this.tsCache, advancedElement, n);
    }

    @Override
    public PlainTime apply(PlainTime plainTime) {
        return this.opCache.apply(plainTime);
    }

    @Override
    public ChronoOperator<Moment> inStdTimezone() {
        return this.moCache;
    }

    @Override
    ChronoOperator<PlainTimestamp> onTimestamp() {
        return this.tsCache;
    }

    private static <V extends Comparable<V>, T extends ChronoEntity<T>> ChronoOperator<T> child(AdvancedElement<V> advancedElement, boolean bl, Class<T> clazz) {
        String string = advancedElement.name();
        if (string.equals("MILLI_OF_SECOND") || string.equals("MILLI_OF_DAY")) {
            return new FractionOperator('3', bl);
        }
        if (string.equals("MICRO_OF_SECOND") || string.equals("MICRO_OF_DAY")) {
            return new FractionOperator('6', bl);
        }
        if (string.equals("NANO_OF_SECOND") || string.equals("NANO_OF_DAY")) {
            return new FractionOperator('9', bl);
        }
        if (bl) {
            return advancedElement.atCeiling(clazz);
        }
        return advancedElement.atFloor(clazz);
    }

    private static <V extends Comparable<V>> ChronoOperator<PlainTime> lenient(AdvancedElement<V> advancedElement, Object object) {
        return advancedElement.setLenient((Comparable)advancedElement.getType().cast(object), PlainTime.class);
    }

    private static <V extends Comparable<V>> ChronoOperator<PlainTimestamp> lenientTS(AdvancedElement<V> advancedElement, Object object) {
        return new LenientOperator(advancedElement.setLenient((Comparable)advancedElement.getType().cast(object), PlainTimestamp.class), Number.class.cast(object));
    }
}

