/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import net.time4j.ClockUnit;
import net.time4j.Duration;
import net.time4j.engine.Normalizer;
import net.time4j.engine.TimeSpan;

final class OnlyNormalizer
implements Normalizer<ClockUnit> {
    private static final Map<ClockUnit, OnlyNormalizer> MAP;
    private final ClockUnit unit;

    private OnlyNormalizer(ClockUnit clockUnit) {
        this.unit = clockUnit;
    }

    static OnlyNormalizer of(ClockUnit clockUnit) {
        OnlyNormalizer onlyNormalizer = MAP.get(clockUnit);
        if (onlyNormalizer == null) {
            throw new IllegalArgumentException(clockUnit.name());
        }
        return onlyNormalizer;
    }

    @Override
    public Duration<ClockUnit> normalize(TimeSpan<? extends ClockUnit> timeSpan) {
        return Duration.of(this.unit.convert(timeSpan), this.unit);
    }

    static {
        EnumMap<ClockUnit, OnlyNormalizer> enumMap = new EnumMap<ClockUnit, OnlyNormalizer>(ClockUnit.class);
        for (ClockUnit clockUnit : ClockUnit.values()) {
            enumMap.put(clockUnit, new OnlyNormalizer(clockUnit));
        }
        MAP = Collections.unmodifiableMap(enumMap);
    }
}

