/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.time4j.LeapsecondElement;
import net.time4j.LenientOperator;
import net.time4j.PatternType;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.SI;
import net.time4j.SPX;
import net.time4j.ZonalTimestamp;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.base.UnixTime;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.ChronoOperator;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.Temporal;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimePoint;
import net.time4j.engine.UnitRule;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.ChronoFormatter;
import net.time4j.format.ChronoPattern;
import net.time4j.format.DisplayMode;
import net.time4j.format.Leniency;
import net.time4j.format.TextWidth;
import net.time4j.scale.LeapSeconds;
import net.time4j.scale.TimeScale;
import net.time4j.scale.UniversalTime;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionStrategy;
import net.time4j.tz.ZonalOffset;

@CalendarType(value="iso8601")
public final class Moment
extends TimePoint<TimeUnit, Moment>
implements UniversalTime,
Temporal<UniversalTime> {
    private static final long UTC_GPS_DELTA = 252892809L;
    private static final long POSIX_UTC_DELTA = 63072000L;
    private static final long POSIX_GPS_DELTA = 315964800L;
    private static final int MIO = 1000000;
    private static final int MRD = 1000000000;
    private static final int POSITIVE_LEAP_MASK = 0x40000000;
    private static final long MIN_LIMIT;
    private static final long MAX_LIMIT;
    private static final Moment MIN;
    private static final Moment MAX;
    public static final Moment UNIX_EPOCH;
    private static final ChronoFormatter<Moment> FORMATTER_RFC_1123;
    private static final Moment START_LS_CHECK;
    private static final Set<ChronoElement<?>> HIGH_TIME_ELEMENTS;
    private static final Map<ChronoElement<?>, Integer> LOW_TIME_ELEMENTS;
    private static final Map<TimeUnit, Double> UNIT_LENGTHS;
    private static final TimeAxis<TimeUnit, Moment> ENGINE;
    private static final long serialVersionUID = -3192884724477742274L;
    private final transient long posixTime;
    private final transient int fraction;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Moment(long l, int n, TimeScale timeScale) {
        if (timeScale == TimeScale.POSIX) {
            this.posixTime = l;
            this.fraction = n;
        } else {
            long l2;
            LeapSeconds leapSeconds = LeapSeconds.getInstance();
            if (!leapSeconds.isEnabled()) throw new IllegalStateException("Leap seconds are not supported by configuration.");
            if (timeScale == TimeScale.UTC) {
                l2 = l;
            } else if (timeScale == TimeScale.TAI) {
                l2 = MathUtils.safeSubtract(l, 10L);
                if (l2 < 0L) {
                    throw new IllegalArgumentException("TAI not supported before 1972-01-01: " + l);
                }
            } else {
                if (timeScale != TimeScale.GPS) throw new UnsupportedOperationException("Not yet implemented: " + timeScale.name());
                l2 = MathUtils.safeAdd(l, 252892809L);
                if (l2 < 252892809L) {
                    throw new IllegalArgumentException("GPS not supported before 1980-01-06: " + l);
                }
            }
            long l3 = leapSeconds.strip(l2);
            long l4 = l2 - leapSeconds.enhance(l3);
            this.posixTime = l3;
            if (l4 == 0L || l3 == MAX_LIMIT) {
                this.fraction = n;
            } else {
                if (l4 != 1L) throw new IllegalStateException("Cannot handle leap shift of " + l + ".");
                this.fraction = n | 0x40000000;
            }
        }
        Moment.checkUnixTime(this.posixTime);
        Moment.checkFraction(n);
    }

    private Moment(int n, long l) {
        Moment.checkUnixTime(l);
        this.posixTime = l;
        this.fraction = n;
    }

    public static Moment of(long l, TimeScale timeScale) {
        return Moment.of(l, 0, timeScale);
    }

    public static Moment of(long l, int n, TimeScale timeScale) {
        if (l == 0L && n == 0 && timeScale == TimeScale.POSIX) {
            return UNIX_EPOCH;
        }
        return new Moment(l, n, timeScale);
    }

    public static Moment from(UnixTime unixTime) {
        if (unixTime instanceof Moment) {
            return (Moment)Moment.class.cast(unixTime);
        }
        if (unixTime instanceof UniversalTime && LeapSeconds.getInstance().isEnabled()) {
            UniversalTime universalTime = (UniversalTime)UniversalTime.class.cast(unixTime);
            return Moment.of(universalTime.getElapsedTime(TimeScale.UTC), universalTime.getNanosecond(TimeScale.UTC), TimeScale.UTC);
        }
        return Moment.of(unixTime.getPosixTime(), unixTime.getNanosecond(), TimeScale.POSIX);
    }

    @Override
    public long getPosixTime() {
        return this.posixTime;
    }

    @Override
    public long getElapsedTime(TimeScale timeScale) {
        if (timeScale == TimeScale.POSIX) {
            return this.posixTime;
        }
        long l = this.getEpochTime();
        switch (timeScale) {
            case UTC: {
                return l;
            }
            case TAI: {
                if (l < 0L) {
                    throw new IllegalArgumentException("TAI not supported before 1972-01-01: " + this);
                }
                return l + 10L;
            }
            case GPS: {
                if (LeapSeconds.getInstance().strip(l) < 315964800L) {
                    throw new IllegalArgumentException("GPS not supported before 1980-01-06: " + this);
                }
                long l2 = LeapSeconds.getInstance().isEnabled() ? l : l + 9L;
                return l2 - 252892809L;
            }
        }
        throw new UnsupportedOperationException("Not yet implemented: " + (Object)((Object)timeScale));
    }

    @Override
    public int getNanosecond() {
        return this.fraction & 0xBFFFFFFF;
    }

    @Override
    public int getNanosecond(TimeScale timeScale) {
        switch (timeScale) {
            case UTC: 
            case POSIX: {
                return this.getNanosecond();
            }
            case TAI: {
                if (this.posixTime < 63072000L) {
                    throw new IllegalArgumentException("TAI not supported before 1972-01-01: " + this);
                }
                return this.getNanosecond();
            }
            case GPS: {
                long l = this.getEpochTime();
                if (LeapSeconds.getInstance().strip(l) < 315964800L) {
                    throw new IllegalArgumentException("GPS not supported before 1980-01-06: " + this);
                }
                return this.getNanosecond();
            }
        }
        throw new UnsupportedOperationException("Not yet implemented: " + (Object)((Object)timeScale));
    }

    @Override
    public boolean isLeapSecond() {
        return this.isPositiveLS() && LeapSeconds.getInstance().isEnabled();
    }

    public BigDecimal transform(TimeScale timeScale) {
        BigDecimal bigDecimal = new BigDecimal(this.getElapsedTime(timeScale)).setScale(9);
        BigDecimal bigDecimal2 = new BigDecimal(this.getNanosecond(timeScale));
        return bigDecimal.add(bigDecimal2.movePointLeft(9));
    }

    @Override
    public boolean isAfter(UniversalTime universalTime) {
        Moment moment = Moment.from(universalTime);
        return this.compareTo(moment) > 0;
    }

    @Override
    public boolean isBefore(UniversalTime universalTime) {
        Moment moment = Moment.from(universalTime);
        return this.compareTo(moment) < 0;
    }

    @Override
    public boolean isSimultaneous(UniversalTime universalTime) {
        Moment moment = Moment.from(universalTime);
        return this.compareTo(moment) == 0;
    }

    public PlainTimestamp toLocalTimestamp() {
        return this.in(Timezone.ofSystem());
    }

    public PlainTimestamp toZonalTimestamp(TZID tZID) {
        return this.in(Timezone.of(tZID));
    }

    public PlainTimestamp toZonalTimestamp(String string) {
        return this.in(Timezone.of(string));
    }

    @Deprecated
    public PlainTimestamp inLocalView() {
        return this.toLocalTimestamp();
    }

    @Deprecated
    public PlainTimestamp inZonalView(TZID tZID) {
        return this.toZonalTimestamp(tZID);
    }

    @Deprecated
    public PlainTimestamp inZonalView(String string) {
        return this.toZonalTimestamp(string);
    }

    @Override
    public Moment plus(long l, SI sI) {
        Moment moment;
        if (l == 0L) {
            return this;
        }
        if (l > 0L) {
            Moment.check1972(this);
        }
        switch (sI) {
            case SECONDS: {
                if (LeapSeconds.getInstance().isEnabled()) {
                    moment = new Moment(MathUtils.safeAdd(this.getEpochTime(), l), this.getNanosecond(), TimeScale.UTC);
                    break;
                }
                moment = Moment.of(MathUtils.safeAdd(this.posixTime, l), this.getNanosecond(), TimeScale.POSIX);
                break;
            }
            case NANOSECONDS: {
                long l2 = MathUtils.safeAdd((long)this.getNanosecond(), l);
                int n = MathUtils.floorModulo(l2, 1000000000);
                long l3 = MathUtils.floorDivide(l2, 1000000000);
                if (LeapSeconds.getInstance().isEnabled()) {
                    moment = new Moment(MathUtils.safeAdd(this.getEpochTime(), l3), n, TimeScale.UTC);
                    break;
                }
                moment = Moment.of(MathUtils.safeAdd(this.posixTime, l3), n, TimeScale.POSIX);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (l < 0L) {
            Moment.check1972(moment);
        }
        return moment;
    }

    @Override
    public Moment minus(long l, SI sI) {
        return this.plus(MathUtils.safeNegate(l), sI);
    }

    @Override
    public long until(Moment moment, SI sI) {
        return sI.between(this, moment);
    }

    public static ChronoFormatter<Moment> localFormatter(String string, ChronoPattern chronoPattern) {
        return ChronoFormatter.setUp(Moment.class, Locale.getDefault()).addPattern(string, chronoPattern).build().withStdTimezone();
    }

    public static ChronoFormatter<Moment> localFormatter(DisplayMode displayMode) {
        int n = PatternType.getFormatStyle(displayMode);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(n, n);
        String string = PatternType.getFormatPattern(dateFormat);
        return ChronoFormatter.setUp(Moment.class, Locale.getDefault()).addPattern(string, PatternType.SIMPLE_DATE_FORMAT).build().withStdTimezone();
    }

    public static ChronoFormatter<Moment> formatter(String string, ChronoPattern chronoPattern, Locale locale) {
        return ChronoFormatter.setUp(Moment.class, locale).addPattern(string, chronoPattern).build();
    }

    public static ChronoFormatter<Moment> formatter(DisplayMode displayMode, Locale locale) {
        int n = PatternType.getFormatStyle(displayMode);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(n, n, locale);
        String string = PatternType.getFormatPattern(dateFormat);
        return ChronoFormatter.setUp(Moment.class, locale).addPattern(string, PatternType.SIMPLE_DATE_FORMAT).build();
    }

    public static ChronoFormatter<Moment> formatterRFC1123() {
        return FORMATTER_RFC_1123;
    }

    @Override
    public int compareTo(Moment moment) {
        long l;
        long l2 = this.getEpochTime();
        if (l2 < (l = moment.getEpochTime())) {
            return -1;
        }
        if (l2 > l) {
            return 1;
        }
        int n = this.getNanosecond() - moment.getNanosecond();
        return n > 0 ? 1 : (n < 0 ? -1 : 0);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Moment) {
            Moment moment = (Moment)object;
            if (this.posixTime != moment.posixTime) {
                return false;
            }
            if (LeapSeconds.getInstance().isEnabled()) {
                return this.fraction == moment.fraction;
            }
            return this.getNanosecond() == moment.getNanosecond();
        }
        return false;
    }

    @Override
    public int hashCode() {
        long l = this.posixTime ^ this.posixTime >>> 32;
        return 19 * (int)l + 37 * this.getNanosecond();
    }

    @Override
    public String toString() {
        PlainDate plainDate = this.getDateUTC();
        int n = Moment.getTimeOfDay(this);
        int n2 = n / 60;
        int n3 = n2 / 60;
        int n4 = n2 % 60;
        int n5 = n % 60;
        n5 += LeapSeconds.getInstance().getShift(this.getEpochTime());
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append(plainDate);
        stringBuilder.append('T');
        Moment.format(n3, 2, stringBuilder);
        stringBuilder.append(':');
        Moment.format(n4, 2, stringBuilder);
        stringBuilder.append(':');
        Moment.format(n5, 2, stringBuilder);
        stringBuilder.append(',');
        Moment.format(this.getNanosecond(), 9, stringBuilder);
        stringBuilder.append('Z');
        return stringBuilder.toString();
    }

    public String toString(TimeScale timeScale) {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append(timeScale.name());
        stringBuilder.append('-');
        switch (timeScale) {
            case POSIX: {
                stringBuilder.append(PlainTimestamp.from(this, ZonalOffset.UTC));
                stringBuilder.append('Z');
                break;
            }
            case UTC: {
                stringBuilder.append(this.toString());
                break;
            }
            case TAI: {
                Moment moment = new Moment(this.getNanosecond(), MathUtils.safeAdd(this.getElapsedTime(TimeScale.TAI), 63072000L));
                stringBuilder.append(PlainTimestamp.from(moment, ZonalOffset.UTC));
                stringBuilder.append('Z');
                break;
            }
            case GPS: {
                Moment moment = new Moment(this.getNanosecond(), MathUtils.safeAdd(this.getElapsedTime(TimeScale.GPS), 315964800L));
                stringBuilder.append(PlainTimestamp.from(moment, ZonalOffset.UTC));
                stringBuilder.append('Z');
                break;
            }
            default: {
                throw new UnsupportedOperationException(timeScale.name());
            }
        }
        return stringBuilder.toString();
    }

    public static TimeAxis<TimeUnit, Moment> axis() {
        return ENGINE;
    }

    @Override
    public boolean hasTimezone() {
        return true;
    }

    @Override
    public TZID getTimezone() {
        return ZonalOffset.UTC;
    }

    @Override
    protected TimeAxis<TimeUnit, Moment> getChronology() {
        return ENGINE;
    }

    @Override
    protected Moment getContext() {
        return this;
    }

    static void checkNegativeLS(long l, PlainTimestamp plainTimestamp) {
        LeapSeconds leapSeconds = LeapSeconds.getInstance();
        if (leapSeconds.supportsNegativeLS() && leapSeconds.strip(leapSeconds.enhance(l)) > l) {
            throw new ChronoException("Illegal local timestamp due to negative leap second: " + plainTimestamp);
        }
    }

    static void check1972(Moment moment) {
        if (moment.posixTime < 63072000L) {
            throw new UnsupportedOperationException("Cannot calculate SI-duration before 1972-01-01.");
        }
    }

    private long getEpochTime() {
        if (LeapSeconds.getInstance().isEnabled()) {
            long l = LeapSeconds.getInstance().enhance(this.posixTime);
            return this.isPositiveLS() ? l + 1L : l;
        }
        return this.posixTime - 63072000L;
    }

    private PlainDate getDateUTC() {
        return PlainDate.of(MathUtils.floorDivide(this.posixTime, 86400), EpochDays.UNIX);
    }

    private PlainTime getTimeUTC() {
        int n = Moment.getTimeOfDay(this);
        int n2 = n / 60;
        int n3 = n2 / 60;
        int n4 = n2 % 60;
        int n5 = n % 60;
        int n6 = this.getNanosecond();
        return PlainTime.of(n3, n4, n5, n6);
    }

    private boolean isPositiveLS() {
        return this.fraction >>> 30 != 0;
    }

    private boolean isNegativeLS() {
        LeapSeconds leapSeconds = LeapSeconds.getInstance();
        if (leapSeconds.supportsNegativeLS()) {
            long l = this.posixTime;
            return leapSeconds.strip(leapSeconds.enhance(l)) > l;
        }
        return false;
    }

    private static void checkUnixTime(long l) {
        if (l > MAX_LIMIT || l < MIN_LIMIT) {
            throw new IllegalArgumentException("UNIX time (UT1) out of supported range: " + l);
        }
    }

    private static void checkFraction(int n) {
        if (n >= 1000000000 || n < 0) {
            throw new IllegalArgumentException("Nanosecond out of range: " + n);
        }
    }

    private static void format(int n, int n2, StringBuilder stringBuilder) {
        int n3 = 1;
        for (int i = 0; i < n2 - 1; ++i) {
            n3 *= 10;
        }
        while (n < n3 && n3 >= 10) {
            stringBuilder.append('0');
            n3 /= 10;
        }
        stringBuilder.append(String.valueOf(n));
    }

    private static int getTimeOfDay(Moment moment) {
        return MathUtils.floorModulo(moment.posixTime, 86400);
    }

    private static Moment moveEventuallyToLS(Moment moment) {
        PlainDate plainDate = moment.getDateUTC();
        PlainTime plainTime = moment.getTimeUTC();
        if (LeapSeconds.getInstance().getShift(plainDate) == 1 && plainTime.getHour() == 23 && plainTime.getMinute() == 59 && plainTime.getSecond() == 59) {
            return moment.plus(1L, SI.SECONDS);
        }
        return moment;
    }

    private PlainTimestamp in(Timezone timezone) {
        return PlainTimestamp.from(this, timezone.getOffset(this));
    }

    private static <V> void doAppend(TimeAxis.Builder<TimeUnit, Moment> builder, ChronoElement<V> chronoElement) {
        builder.appendElement((ChronoElement)chronoElement, (ElementRule)FieldRule.of(chronoElement));
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SPX(this, 4);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void writeTimestamp(ObjectOutput objectOutput) throws IOException {
        int n;
        int n2 = 4;
        n2 <<= 4;
        if (this.isPositiveLS()) {
            n2 |= 1;
        }
        if ((n = this.getNanosecond()) > 0) {
            n2 |= 2;
        }
        objectOutput.writeByte(n2);
        objectOutput.writeLong(this.posixTime);
        if (n > 0) {
            objectOutput.writeInt(n);
        }
    }

    static Moment readTimestamp(ObjectInput objectInput, boolean bl, boolean bl2) throws IOException {
        int n;
        long l = objectInput.readLong();
        int n2 = n = bl2 ? objectInput.readInt() : 0;
        if (l == 0L) {
            if (bl) {
                throw new InvalidObjectException("UTC epoch is no leap second.");
            }
            if (n == 0) {
                return UNIX_EPOCH;
            }
        }
        if (l == MIN_LIMIT && n == 0) {
            if (bl) {
                throw new InvalidObjectException("Minimum is no leap second.");
            }
            return MIN;
        }
        if (l == MAX_LIMIT && n == 999999999) {
            if (bl) {
                throw new InvalidObjectException("Maximum is no leap second.");
            }
            return MAX;
        }
        Moment.checkFraction(n);
        if (bl) {
            LeapSeconds leapSeconds = LeapSeconds.getInstance();
            if (!leapSeconds.isEnabled() || leapSeconds.isPositiveLS(leapSeconds.enhance(l) + 1L)) {
                n |= 0x40000000;
            } else {
                long l2 = GregorianMath.toPackedDate(l);
                int n3 = GregorianMath.readMonth(l2);
                int n4 = GregorianMath.readDayOfMonth(l2);
                throw new InvalidObjectException("Not registered as leap second event: " + GregorianMath.readYear(l2) + "-" + (n3 < 10 ? "0" : "") + n3 + (n4 < 10 ? "0" : "") + n4 + " [Please check leap second configurations " + "either of emitter vm or this target vm]");
            }
        }
        return new Moment(n, l);
    }

    static {
        long l = GregorianMath.toMJD(-999999999, 1, 1);
        long l2 = GregorianMath.toMJD(999999999, 12, 31);
        MIN_LIMIT = EpochDays.UNIX.transform(l, EpochDays.MODIFIED_JULIAN_DATE) * 86400L;
        MAX_LIMIT = EpochDays.UNIX.transform(l2, EpochDays.MODIFIED_JULIAN_DATE) * 86400L + 86399L;
        MIN = new Moment(MIN_LIMIT, 0, TimeScale.POSIX);
        MAX = new Moment(MAX_LIMIT, 999999999, TimeScale.POSIX);
        UNIX_EPOCH = new Moment(0L, 0, TimeScale.POSIX);
        START_LS_CHECK = new Moment(63158400L, 0, TimeScale.POSIX);
        Object object = new HashSet<ChronoElement<Object>>();
        object.add(PlainTime.ISO_HOUR);
        object.add(PlainTime.DIGITAL_HOUR_OF_DAY);
        object.add(PlainTime.DIGITAL_HOUR_OF_AMPM);
        object.add(PlainTime.CLOCK_HOUR_OF_DAY);
        object.add(PlainTime.CLOCK_HOUR_OF_AMPM);
        object.add(PlainTime.AM_PM_OF_DAY);
        object.add(PlainTime.MINUTE_OF_HOUR);
        object.add(PlainTime.MINUTE_OF_DAY);
        HIGH_TIME_ELEMENTS = Collections.unmodifiableSet(object);
        Object object2 = new HashMap();
        object2.put(PlainTime.SECOND_OF_MINUTE, 1);
        object2.put(PlainTime.SECOND_OF_DAY, 1);
        object2.put(PlainTime.MILLI_OF_SECOND, 1000);
        object2.put(PlainTime.MILLI_OF_DAY, 1000);
        object2.put(PlainTime.MICRO_OF_SECOND, 1000000);
        object2.put(PlainTime.MICRO_OF_DAY, 1000000);
        object2.put(PlainTime.NANO_OF_SECOND, 1000000000);
        object2.put(PlainTime.NANO_OF_DAY, 1000000000);
        LOW_TIME_ELEMENTS = Collections.unmodifiableMap(object2);
        EnumMap<TimeUnit, Double> enumMap = new EnumMap<TimeUnit, Double>(TimeUnit.class);
        enumMap.put(TimeUnit.DAYS, 86400.0);
        enumMap.put(TimeUnit.HOURS, 3600.0);
        enumMap.put(TimeUnit.MINUTES, 60.0);
        enumMap.put(TimeUnit.SECONDS, 1.0);
        enumMap.put(TimeUnit.MILLISECONDS, 0.001);
        enumMap.put(TimeUnit.MICROSECONDS, 1.0E-6);
        enumMap.put(TimeUnit.NANOSECONDS, 1.0E-9);
        UNIT_LENGTHS = Collections.unmodifiableMap(enumMap);
        object = TimeAxis.Builder.setUp(TimeUnit.class, Moment.class, new Merger(), MIN, MAX);
        for (TimeUnit object3 : TimeUnit.values()) {
            ((TimeAxis.Builder)object).appendUnit(object3, new TimeUnitRule(object3), UNIT_LENGTHS.get((Object)object3), UNIT_LENGTHS.keySet());
        }
        object2 = Chronology.lookup(PlainDate.class).getRegisteredElements();
        Object object4 = object2.iterator();
        while (object4.hasNext()) {
            ChronoElement chronoElement = (ChronoElement)object4.next();
            if (chronoElement.name().equals("CALENDAR_DATE")) continue;
            Moment.doAppend((TimeAxis.Builder<TimeUnit, Moment>)object, chronoElement);
        }
        object4 = Chronology.lookup(PlainTime.class).getRegisteredElements();
        Iterator iterator = object4.iterator();
        while (iterator.hasNext()) {
            ChronoElement chronoElement = (ChronoElement)iterator.next();
            if (chronoElement.name().startsWith("DECIMAL") || chronoElement.name().equals("PRECISION") || chronoElement.name().equals("WALL_TIME")) continue;
            Moment.doAppend((TimeAxis.Builder<TimeUnit, Moment>)object, chronoElement);
        }
        ENGINE = ((TimeAxis.Builder)object).build();
        FORMATTER_RFC_1123 = ChronoFormatter.setUp(Moment.class, Locale.ENGLISH).startSection(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE.booleanValue()).startOptionalSection().startSection(Attributes.TEXT_WIDTH, TextWidth.ABBREVIATED).addText(PlainDate.DAY_OF_WEEK).endSection().addLiteral(", ").endSection().addInteger(PlainDate.DAY_OF_MONTH, 1, 2).addLiteral(' ').startSection(Attributes.TEXT_WIDTH, TextWidth.ABBREVIATED).addText(PlainDate.MONTH_OF_YEAR).endSection().addLiteral(' ').addFixedInteger(PlainDate.YEAR, 4).addLiteral(' ').addFixedInteger(PlainTime.DIGITAL_HOUR_OF_DAY, 2).addLiteral(':').addFixedInteger(PlainTime.MINUTE_OF_HOUR, 2).startOptionalSection().addLiteral(':').addFixedInteger(PlainTime.SECOND_OF_MINUTE, 2).endSection().addLiteral(' ').addTimezoneOffset(DisplayMode.MEDIUM, false, Arrays.asList("GMT", "UT", "Z")).endSection().build();
    }

    private static class Merger
    implements ChronoMerger<Moment> {
        private Merger() {
        }

        @Override
        public Moment createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            return Moment.from(timeSource.currentTime());
        }

        @Override
        public Moment createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
            Object object;
            ChronoElement<PlainTimestamp> chronoElement;
            if (chronoEntity instanceof UnixTime) {
                return Moment.from((UnixTime)UnixTime.class.cast(chronoEntity));
            }
            Moment moment = null;
            PlainTimestamp plainTimestamp = null;
            boolean bl2 = false;
            if (chronoEntity.contains(LeapsecondElement.INSTANCE)) {
                bl2 = true;
                chronoEntity.with(PlainTime.SECOND_OF_MINUTE, Integer.valueOf(60));
            }
            if ((plainTimestamp = chronoEntity.contains(chronoElement = PlainTimestamp.axis().element()) ? chronoEntity.get(chronoElement) : (PlainTimestamp)PlainTimestamp.axis().createFrom((ChronoEntity)chronoEntity, attributeQuery, bl)) == null) {
                return null;
            }
            TZID tZID = null;
            if (chronoEntity.hasTimezone()) {
                tZID = chronoEntity.getTimezone();
            }
            if (tZID == null && attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                tZID = attributeQuery.get(Attributes.TIMEZONE_ID);
            }
            if (tZID != null) {
                if (attributeQuery.contains(Attributes.TRANSITION_STRATEGY)) {
                    object = attributeQuery.get(Attributes.TRANSITION_STRATEGY);
                    moment = plainTimestamp.in(Timezone.of(tZID).with((TransitionStrategy)object));
                } else {
                    moment = plainTimestamp.inTimezone(tZID);
                }
            } else {
                object = attributeQuery.get(Attributes.LENIENCY, Leniency.SMART);
                if (object.isLax()) {
                    moment = plainTimestamp.inStdTimezone();
                    tZID = Timezone.ofSystem().getID();
                }
            }
            if (bl2 && moment != null) {
                object = tZID instanceof ZonalOffset ? (ZonalOffset)tZID : Timezone.of(tZID).getOffset(moment);
                if (((ZonalOffset)object).getFractionalAmount() != 0 || ((ZonalOffset)object).getAbsoluteSeconds() % 60 != 0) {
                    throw new IllegalArgumentException("Leap second is only allowed  with timezone-offset in full minutes: " + (Object)object);
                }
                Moment moment2 = moment.getDateUTC().getYear() >= 1972 ? moment.plus(1L, SI.SECONDS) : new Moment(moment.getNanosecond(), moment.getPosixTime() + 1L);
                Leniency leniency = attributeQuery.get(Attributes.LENIENCY, Leniency.SMART);
                if (leniency.isLax()) {
                    moment = moment2;
                } else if (LeapSeconds.getInstance().isEnabled()) {
                    if (moment2.isPositiveLS()) {
                        moment = moment2;
                    } else {
                        throw new IllegalArgumentException("SECOND_OF_MINUTE parsed as invalid leapsecond: " + moment2);
                    }
                }
            }
            return moment;
        }

        @Override
        public ChronoEntity<?> preformat(Moment moment, AttributeQuery attributeQuery) {
            TZID tZID;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID) && (tZID = attributeQuery.get(Attributes.TIMEZONE_ID)) != ZonalOffset.UTC) {
                return new ZonalTimestamp(moment, tZID);
            }
            return moment;
        }

        @Override
        public Chronology<?> preparser() {
            return PlainTimestamp.axis();
        }
    }

    private static class FieldRule<V>
    implements ElementRule<Moment, V> {
        private final ChronoElement<V> element;

        private FieldRule(ChronoElement<V> chronoElement) {
            this.element = chronoElement;
        }

        static <V> FieldRule<V> of(ChronoElement<V> chronoElement) {
            return new FieldRule<V>(chronoElement);
        }

        @Override
        public V getValue(Moment moment) {
            Integer n = null;
            if (this.element.isDateElement()) {
                return moment.getDateUTC().get(this.element);
            }
            if (this.element == PlainTime.SECOND_OF_MINUTE) {
                n = moment.isLeapSecond() ? 60 : Moment.getTimeOfDay(moment) % 60;
            } else if (this.element.isTimeElement()) {
                return moment.getTimeUTC().get(this.element);
            }
            assert (n != null);
            return this.element.getType().cast(n);
        }

        @Override
        public V getMinimum(Moment moment) {
            if (this.element.isDateElement()) {
                return moment.getDateUTC().getMinimum(this.element);
            }
            if (this.element.isTimeElement()) {
                return this.element.getDefaultMinimum();
            }
            throw new ChronoException("Missing rule for: " + this.element.name());
        }

        @Override
        public V getMaximum(Moment moment) {
            if (this.element.isDateElement()) {
                return moment.getDateUTC().getMaximum(this.element);
            }
            Integer n = null;
            if (this.element == PlainTime.SECOND_OF_MINUTE) {
                n = FieldRule.getMaxSecondOfMinute(moment);
            } else if (this.element.isTimeElement()) {
                return this.element.getDefaultMaximum();
            }
            assert (n != null);
            return this.element.getType().cast(n);
        }

        @Override
        public boolean isValid(Moment moment, V v) {
            if (this.element.isDateElement()) {
                return moment.getDateUTC().isValid(this.element, v);
            }
            if (this.element.isTimeElement()) {
                if (Number.class.isAssignableFrom(this.element.getType())) {
                    if (v == null) {
                        return false;
                    }
                    long l = ((Number)Number.class.cast(this.getMinimum(moment))).longValue();
                    long l2 = ((Number)Number.class.cast(this.getMaximum(moment))).longValue();
                    long l3 = ((Number)Number.class.cast(v)).longValue();
                    return l <= l3 && l2 >= l3;
                }
                return moment.getTimeUTC().isValid(this.element, v);
            }
            throw new ChronoException("Missing rule for: " + this.element.name());
        }

        @Override
        public Moment withValue(Moment moment, V v, boolean bl) {
            assert (!bl);
            if (v == null) {
                throw new NullPointerException("Missing value.");
            }
            if (!this.isValid(moment, v)) {
                throw new IllegalArgumentException(v + " invalid on [" + this.element.name() + "] in context: " + moment);
            }
            if (LOW_TIME_ELEMENTS.containsKey(this.element) && moment.isAfter(START_LS_CHECK)) {
                long l = MathUtils.safeSubtract(((Number)Number.class.cast(v)).longValue(), ((Number)Number.class.cast(this.getValue(moment))).longValue());
                int n = (Integer)LOW_TIME_ELEMENTS.get(this.element);
                switch (n) {
                    case 1: {
                        return moment.plus(l, SI.SECONDS);
                    }
                    case 1000: {
                        return moment.plus(l * 1000000L, SI.NANOSECONDS);
                    }
                    case 1000000: {
                        return moment.plus(l * 1000L, SI.NANOSECONDS);
                    }
                    case 1000000000: {
                        return moment.plus(l, SI.NANOSECONDS);
                    }
                }
                throw new AssertionError();
            }
            PlainTimestamp plainTimestamp = moment.toZonalTimestamp(ZonalOffset.UTC);
            plainTimestamp = (PlainTimestamp)plainTimestamp.with(this.element, v);
            Moment moment2 = plainTimestamp.inTimezone(ZonalOffset.UTC);
            if ((this.element.isDateElement() || HIGH_TIME_ELEMENTS.contains(this.element)) && moment.isLeapSecond()) {
                return Moment.moveEventuallyToLS(moment2);
            }
            return moment2;
        }

        @Override
        public ChronoElement<?> getChildAtFloor(Moment moment) {
            throw new AssertionError((Object)"Should never be called.");
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(Moment moment) {
            throw new AssertionError((Object)"Should never be called.");
        }

        private static int getMaxSecondOfMinute(Moment moment) {
            int n = Moment.getTimeOfDay(moment) / 60;
            int n2 = 59;
            if (n / 60 == 23 && n % 60 == 59) {
                PlainDate plainDate = moment.getDateUTC();
                n2 += LeapSeconds.getInstance().getShift(plainDate);
            }
            return n2;
        }
    }

    private static class TimeUnitRule
    implements UnitRule<Moment> {
        private final TimeUnit unit;

        TimeUnitRule(TimeUnit timeUnit) {
            this.unit = timeUnit;
        }

        @Override
        public Moment addTo(Moment moment, long l) {
            if (this.unit.compareTo(TimeUnit.SECONDS) >= 0) {
                long l2 = MathUtils.safeMultiply(l, this.unit.toSeconds(1L));
                return Moment.of(MathUtils.safeAdd(moment.getPosixTime(), l2), moment.getNanosecond(), TimeScale.POSIX);
            }
            long l3 = MathUtils.safeMultiply(l, this.unit.toNanos(1L));
            long l4 = MathUtils.safeAdd((long)moment.getNanosecond(), l3);
            int n = MathUtils.floorModulo(l4, 1000000000);
            long l5 = MathUtils.floorDivide(l4, 1000000000);
            return Moment.of(MathUtils.safeAdd(moment.getPosixTime(), l5), n, TimeScale.POSIX);
        }

        @Override
        public long between(Moment moment, Moment moment2) {
            long l = 0L;
            if (this.unit.compareTo(TimeUnit.SECONDS) >= 0) {
                l = moment2.getPosixTime() - moment.getPosixTime();
                if (l < 0L) {
                    if (moment2.getNanosecond() > moment.getNanosecond()) {
                        ++l;
                    }
                } else if (l > 0L && moment2.getNanosecond() < moment.getNanosecond()) {
                    --l;
                }
            } else {
                l = MathUtils.safeAdd(MathUtils.safeMultiply(MathUtils.safeSubtract(moment2.getPosixTime(), moment.getPosixTime()), 1000000000L), (long)(moment2.getNanosecond() - moment.getNanosecond()));
            }
            switch (this.unit) {
                case DAYS: {
                    l /= 86400L;
                    break;
                }
                case HOURS: {
                    l /= 3600L;
                    break;
                }
                case MINUTES: {
                    l /= 60L;
                    break;
                }
                case SECONDS: {
                    break;
                }
                case MILLISECONDS: {
                    l /= 1000000L;
                    break;
                }
                case MICROSECONDS: {
                    l /= 1000L;
                    break;
                }
                case NANOSECONDS: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this.unit.name());
                }
            }
            return l;
        }
    }

    static final class Operator
    implements ChronoOperator<Moment> {
        private final ChronoOperator<PlainTimestamp> delegate;
        private final ChronoElement<?> element;
        private final int type;
        private final Timezone tz;

        Operator(ChronoOperator<PlainTimestamp> chronoOperator, ChronoElement<?> chronoElement, int n) {
            this.delegate = chronoOperator;
            this.element = chronoElement;
            this.type = n;
            this.tz = null;
        }

        Operator(ChronoOperator<PlainTimestamp> chronoOperator, ChronoElement<?> chronoElement, int n, Timezone timezone) {
            this.delegate = chronoOperator;
            this.element = chronoElement;
            this.type = n;
            this.tz = timezone;
        }

        @Override
        public Moment apply(Moment moment) {
            if (LOW_TIME_ELEMENTS.containsKey(this.element) && moment.isAfter(START_LS_CHECK) && (this.type == 2 || this.type == 3 || this.type == 6)) {
                int n = (Integer)LOW_TIME_ELEMENTS.get(this.element);
                long l = 1L;
                if (this.type == 2) {
                    l = -1L;
                } else if (this.type == 6) {
                    long l2 = ((Number)Number.class.cast(moment.get(this.element))).longValue();
                    long l3 = ((LenientOperator)LenientOperator.class.cast(this.delegate)).getValue();
                    l = MathUtils.safeSubtract(l3, l2);
                }
                switch (n) {
                    case 1: {
                        return moment.plus(l, SI.SECONDS);
                    }
                    case 1000: {
                        return moment.plus(MathUtils.safeMultiply(1000000L, l), SI.NANOSECONDS);
                    }
                    case 1000000: {
                        return moment.plus(MathUtils.safeMultiply(1000L, l), SI.NANOSECONDS);
                    }
                    case 1000000000: {
                        return moment.plus(l, SI.NANOSECONDS);
                    }
                }
                throw new AssertionError();
            }
            Timezone timezone = this.tz == null ? Timezone.ofSystem() : this.tz;
            PlainTimestamp plainTimestamp = moment.in(timezone).with(this.delegate);
            Moment moment2 = plainTimestamp.in(timezone);
            if (this.type == 4) {
                return moment2;
            }
            if (moment2.isNegativeLS()) {
                if (this.tz.getStrategy() == Timezone.STRICT_MODE) {
                    throw new ChronoException("Illegal local timestamp due to negative leap second: " + plainTimestamp);
                }
                return moment2;
            }
            if (this.element.isDateElement() || HIGH_TIME_ELEMENTS.contains(this.element)) {
                if (moment.isLeapSecond() || this.type == 5) {
                    return Moment.moveEventuallyToLS(moment2);
                }
            } else if (this.element == PlainTime.SECOND_OF_MINUTE) {
                if (this.type == 1 || this.type == 5) {
                    return Moment.moveEventuallyToLS(moment2);
                }
            } else if (this.element == PlainTime.MILLI_OF_SECOND || this.element == PlainTime.MICRO_OF_SECOND || this.element == PlainTime.NANO_OF_SECOND) {
                switch (this.type) {
                    case 0: 
                    case 1: 
                    case 5: {
                        if (!moment.isLeapSecond()) break;
                        moment2 = moment2.plus(1L, SI.SECONDS);
                        break;
                    }
                }
            }
            return moment2;
        }
    }
}

