/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.time4j.AdjustableElement;
import net.time4j.DateOperator;
import net.time4j.ElementOperator;
import net.time4j.PlainDate;
import net.time4j.engine.AdvancedElement;

abstract class AbstractDateElement<V extends Comparable<V>>
extends AdvancedElement<V>
implements AdjustableElement<V, PlainDate> {
    private final transient Map<Integer, ElementOperator<PlainDate>> cache;

    AbstractDateElement(String string) {
        super(string);
        HashMap<Integer, DateOperator> hashMap = new HashMap<Integer, DateOperator>();
        hashMap.put(0, new DateOperator(this, 0));
        hashMap.put(1, new DateOperator(this, 1));
        hashMap.put(2, new DateOperator(this, 2));
        hashMap.put(3, new DateOperator(this, 3));
        hashMap.put(4, new DateOperator(this, 4));
        hashMap.put(5, new DateOperator(this, 5));
        this.cache = Collections.unmodifiableMap(hashMap);
    }

    @Override
    public ElementOperator<PlainDate> minimized() {
        return this.cache.get(0);
    }

    @Override
    public ElementOperator<PlainDate> maximized() {
        return this.cache.get(1);
    }

    @Override
    public ElementOperator<PlainDate> decremented() {
        return this.cache.get(2);
    }

    @Override
    public ElementOperator<PlainDate> incremented() {
        return this.cache.get(3);
    }

    @Override
    public ElementOperator<PlainDate> atFloor() {
        return this.cache.get(4);
    }

    @Override
    public ElementOperator<PlainDate> atCeiling() {
        return this.cache.get(5);
    }

    public ElementOperator<PlainDate> setLenient(V v) {
        return new DateOperator(this, 6, v);
    }
}

