/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormatSymbols;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.Chronology;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.OutputContext;
import net.time4j.format.ParseLog;
import net.time4j.format.TextWidth;

public final class CalendarText {
    public static final String ISO_CALENDAR_TYPE = "iso8601";
    private static final ConcurrentMap<String, CalendarText> CACHE = new ConcurrentHashMap<String, CalendarText>();
    private final String provider;
    private final Map<TextWidth, Map<OutputContext, Accessor>> stdMonths;
    private final Map<TextWidth, Map<OutputContext, Accessor>> leapMonths;
    private final Map<TextWidth, Map<OutputContext, Accessor>> quarters;
    private final Map<TextWidth, Map<OutputContext, Accessor>> weekdays;
    private final Map<TextWidth, Accessor> eras;
    private final Map<TextWidth, Accessor> meridiems;
    private final ResourceBundle textForms;
    private final MissingResourceException mre;

    /*
     * WARNING - void declaration
     */
    private CalendarText(String string, Locale locale, Provider provider) {
        void var13_29;
        void var12_21;
        this.provider = provider.toString();
        ResourceBundle resourceBundle = null;
        MissingResourceException missingResourceException = null;
        try {
            resourceBundle = ResourceBundle.getBundle("data/" + string, locale, new PropertiesControl());
        }
        catch (MissingResourceException missingResourceException2) {
            missingResourceException = missingResourceException2;
        }
        this.textForms = resourceBundle;
        this.mre = missingResourceException;
        this.stdMonths = Collections.unmodifiableMap(CalendarText.getMonths(string, locale, provider, false));
        Map<TextWidth, Map<OutputContext, Accessor>> map = CalendarText.getMonths(string, locale, provider, true);
        this.leapMonths = map == null ? this.stdMonths : Collections.unmodifiableMap(map);
        EnumMap enumMap = new EnumMap(TextWidth.class);
        for (TextWidth textWidth : TextWidth.values()) {
            EnumMap<OutputContext, Accessor> object = new EnumMap<OutputContext, Accessor>(OutputContext.class);
            for (OutputContext outputContext : OutputContext.values()) {
                object.put(outputContext, new Accessor(provider.quarters(string, locale, textWidth, outputContext), locale));
            }
            enumMap.put(textWidth, object);
        }
        this.quarters = Collections.unmodifiableMap(enumMap);
        EnumMap enumMap2 = new EnumMap(TextWidth.class);
        for (TextWidth textWidth : TextWidth.values()) {
            EnumMap<OutputContext, Accessor> enumMap3 = new EnumMap<OutputContext, Accessor>(OutputContext.class);
            for (OutputContext outputContext : OutputContext.values()) {
                enumMap3.put(outputContext, new Accessor(provider.weekdays(string, locale, textWidth, outputContext), locale));
            }
            enumMap2.put(textWidth, enumMap3);
        }
        this.weekdays = Collections.unmodifiableMap(enumMap2);
        EnumMap enumMap3 = new EnumMap(TextWidth.class);
        Object enumMap4 = TextWidth.values();
        int n = ((TextWidth[])enumMap4).length;
        boolean bl = false;
        while (var12_21 < n) {
            TextWidth textWidth = enumMap4[var12_21];
            enumMap3.put(textWidth, new Accessor(provider.eras(string, locale, textWidth), locale));
            ++var12_21;
        }
        this.eras = Collections.unmodifiableMap(enumMap3);
        enumMap4 = new EnumMap(TextWidth.class);
        TextWidth[] textWidthArray = TextWidth.values();
        int n2 = textWidthArray.length;
        boolean bl2 = false;
        while (var13_29 < n2) {
            TextWidth textWidth = textWidthArray[var13_29];
            enumMap4.put(textWidth, new Accessor(provider.meridiems(string, locale, textWidth), locale));
            ++var13_29;
        }
        this.meridiems = Collections.unmodifiableMap(enumMap4);
    }

    public static CalendarText getInstance(Chronology<?> chronology, Locale locale) {
        return CalendarText.getInstance(CalendarText.extractCalendarType(chronology), locale);
    }

    public static CalendarText getInstance(String string, Locale locale) {
        if (string == null) {
            throw new NullPointerException("Missing calendar type.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(':');
        stringBuilder.append(locale.getLanguage());
        stringBuilder.append('-');
        stringBuilder.append(locale.getCountry());
        String string2 = stringBuilder.toString();
        Object object = (CalendarText)CACHE.get(string2);
        if (object == null) {
            Object object2 = null;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = Provider.class.getClassLoader();
            }
            Object object3 = ServiceLoader.load(Provider.class, classLoader).iterator();
            while (object3.hasNext()) {
                Provider provider = object3.next();
                if (!CalendarText.isCalendarTypeSupported(provider, string) || !CalendarText.isLocaleSupported(provider, locale)) continue;
                object2 = provider;
                break;
            }
            if (object2 == null) {
                object3 = new OldJdkProvider();
                if (CalendarText.isCalendarTypeSupported((Provider)object3, string) && CalendarText.isLocaleSupported((Provider)object3, locale)) {
                    object2 = object3;
                }
                if (object2 == null) {
                    object2 = new FallbackProvider();
                }
            }
            if ((object3 = CACHE.putIfAbsent(string2, (CalendarText)(object = new CalendarText(string, locale, (Provider)object2)))) != null) {
                object = object3;
            }
        }
        return object;
    }

    public Accessor getStdMonths(TextWidth textWidth, OutputContext outputContext) {
        return this.getMonths(textWidth, outputContext, false);
    }

    public Accessor getLeapMonths(TextWidth textWidth, OutputContext outputContext) {
        return this.getMonths(textWidth, outputContext, true);
    }

    public Accessor getQuarters(TextWidth textWidth, OutputContext outputContext) {
        return this.quarters.get((Object)textWidth).get((Object)outputContext);
    }

    public Accessor getWeekdays(TextWidth textWidth, OutputContext outputContext) {
        return this.weekdays.get((Object)textWidth).get((Object)outputContext);
    }

    public Accessor getEras(TextWidth textWidth) {
        return this.eras.get((Object)textWidth);
    }

    public Accessor getMeridiems(TextWidth textWidth) {
        return this.meridiems.get((Object)textWidth);
    }

    public <V extends Enum<V>> Accessor getTextForms(ChronoElement<V> chronoElement, String ... stringArray) {
        int n;
        if (this.textForms == null) {
            throw new MissingResourceException(this.mre.getMessage(), this.mre.getClassName(), this.mre.getKey());
        }
        Enum[] enumArray = (Enum[])chronoElement.getType().getEnumConstants();
        int n2 = enumArray.length;
        String[] stringArray2 = new String[n2];
        String string = chronoElement.name();
        StringBuilder stringBuilder = new StringBuilder(string);
        if (stringArray != null && stringArray.length > 0) {
            boolean bl = true;
            for (n = 0; n < stringArray.length; ++n) {
                if (bl) {
                    stringBuilder.append('(');
                } else {
                    stringBuilder.append('|');
                }
                stringBuilder.append(stringArray[n]);
            }
            stringBuilder.append(')');
        }
        String string2 = stringBuilder.toString();
        for (n = 0; n < n2; ++n) {
            StringBuilder stringBuilder2 = new StringBuilder(string2);
            stringBuilder2.append('_');
            stringBuilder2.append(n + 1);
            String string3 = stringBuilder2.toString();
            stringArray2[n] = this.textForms.containsKey(string3) ? this.textForms.getString(string3) : (this.textForms.containsKey(string) ? this.textForms.getString(string) : enumArray[n].name());
        }
        return new Accessor(stringArray2, this.textForms.getLocale());
    }

    public static String getGMTPrefix(Locale locale) {
        CalendarText calendarText = CalendarText.getInstance(ISO_CALENDAR_TYPE, locale);
        if (calendarText.textForms == null) {
            return "GMT";
        }
        return calendarText.textForms.getString("prefixGMTOffset");
    }

    public String toString() {
        return this.provider;
    }

    public static void clearCache() {
        CACHE.clear();
    }

    static String extractCalendarType(Chronology<?> chronology) {
        CalendarType calendarType = chronology.getChronoType().getAnnotation(CalendarType.class);
        return calendarType == null ? ISO_CALENDAR_TYPE : calendarType.value();
    }

    private Accessor getMonths(TextWidth textWidth, OutputContext outputContext, boolean bl) {
        if (bl) {
            return this.leapMonths.get((Object)textWidth).get((Object)outputContext);
        }
        return this.stdMonths.get((Object)textWidth).get((Object)outputContext);
    }

    private static Map<TextWidth, Map<OutputContext, Accessor>> getMonths(String string, Locale locale, Provider provider, boolean bl) {
        EnumMap<TextWidth, Map<OutputContext, Accessor>> enumMap = new EnumMap<TextWidth, Map<OutputContext, Accessor>>(TextWidth.class);
        boolean bl2 = false;
        for (TextWidth textWidth : TextWidth.values()) {
            EnumMap<OutputContext, Accessor> enumMap2 = new EnumMap<OutputContext, Accessor>(OutputContext.class);
            for (OutputContext outputContext : OutputContext.values()) {
                Object[] objectArray = provider.months(string, locale, textWidth, outputContext, bl);
                if (bl && !bl2) {
                    Object[] objectArray2 = provider.months(string, locale, textWidth, outputContext, false);
                    bl2 = !Arrays.equals(objectArray2, objectArray);
                }
                enumMap2.put(outputContext, new Accessor((String[])objectArray, locale));
            }
            enumMap.put(textWidth, enumMap2);
        }
        return !bl || bl2 ? enumMap : null;
    }

    private static boolean isCalendarTypeSupported(Provider provider, String string) {
        for (String string2 : provider.getSupportedCalendarTypes()) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private static boolean isLocaleSupported(Provider provider, Locale locale) {
        for (Locale locale2 : provider.getAvailableLocales()) {
            String string = locale.getLanguage();
            String string2 = locale.getCountry();
            if (!string.equals(locale2.getLanguage()) || !string2.isEmpty() && !string2.equals(locale2.getCountry())) continue;
            return true;
        }
        return false;
    }

    private static class PropertiesControl
    extends ResourceBundle.Control {
        private PropertiesControl() {
        }

        @Override
        public List<String> getFormats(String string) {
            return ResourceBundle.Control.FORMAT_PROPERTIES;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String string, Locale locale, String string2, ClassLoader classLoader, boolean bl) throws IllegalAccessException, InstantiationException, IOException {
            if (string2.equals("java.properties")) {
                Object object;
                PropertyResourceBundle propertyResourceBundle = null;
                InputStream inputStream = null;
                String string3 = this.toBundleName(string, locale);
                String string4 = this.toResourceName(string3, "properties");
                if (bl) {
                    object = classLoader.getResource(string4);
                    if (object != null) {
                        URLConnection uRLConnection = ((URL)object).openConnection();
                        uRLConnection.setUseCaches(false);
                        inputStream = uRLConnection.getInputStream();
                    }
                } else {
                    inputStream = classLoader.getResourceAsStream(string4);
                }
                if (inputStream != null) {
                    object = null;
                    try {
                        object = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                        propertyResourceBundle = new PropertyResourceBundle((Reader)object);
                    }
                    finally {
                        if (object != null) {
                            ((Reader)object).close();
                        }
                    }
                }
                return propertyResourceBundle;
            }
            throw new UnsupportedOperationException("Unknown resource bundle format: " + string2);
        }
    }

    private static class FallbackProvider
    implements Provider {
        private FallbackProvider() {
        }

        @Override
        public String[] getSupportedCalendarTypes() {
            throw new UnsupportedOperationException("Never called.");
        }

        @Override
        public Locale[] getAvailableLocales() {
            throw new UnsupportedOperationException("Never called.");
        }

        @Override
        public String[] months(String string, Locale locale, TextWidth textWidth, OutputContext outputContext, boolean bl) {
            if (textWidth == TextWidth.WIDE) {
                return new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13"};
            }
            return new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13"};
        }

        @Override
        public String[] quarters(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
            if (textWidth == TextWidth.NARROW) {
                return new String[]{"1", "2", "3", "4"};
            }
            return new String[]{"Q1", "Q2", "Q3", "Q4"};
        }

        @Override
        public String[] weekdays(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
            return new String[]{"1", "2", "3", "4", "5", "6", "7"};
        }

        @Override
        public String[] eras(String string, Locale locale, TextWidth textWidth) {
            if (textWidth == TextWidth.NARROW) {
                return new String[]{"B", "A"};
            }
            return new String[]{"BC", "AD"};
        }

        @Override
        public String[] meridiems(String string, Locale locale, TextWidth textWidth) {
            if (textWidth == TextWidth.NARROW) {
                return new String[]{"A", "P"};
            }
            return new String[]{"AM", "PM"};
        }
    }

    private static class OldJdkProvider
    implements Provider {
        private OldJdkProvider() {
        }

        @Override
        public String[] getSupportedCalendarTypes() {
            return new String[]{CalendarText.ISO_CALENDAR_TYPE};
        }

        @Override
        public Locale[] getAvailableLocales() {
            return DateFormatSymbols.getAvailableLocales();
        }

        @Override
        public String[] months(String string, Locale locale, TextWidth textWidth, OutputContext outputContext, boolean bl) {
            Object object;
            try {
                object = OldJdkProvider.getBundle(locale);
                if (object != null && outputContext == OutputContext.STANDALONE && "true".equals(((ResourceBundle)object).getObject("enableStandalone"))) {
                    String[] stringArray = new String[12];
                    for (int i = 0; i < 12; ++i) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("MONTH_OF_YEAR(");
                        stringBuilder.append((Object)textWidth);
                        stringBuilder.append('|');
                        stringBuilder.append((Object)outputContext);
                        stringBuilder.append(")_");
                        stringBuilder.append(i + 1);
                        stringArray[i] = ((ResourceBundle)object).getString(stringBuilder.toString());
                    }
                    return stringArray;
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            object = DateFormatSymbols.getInstance(locale);
            switch (textWidth) {
                case WIDE: {
                    return ((DateFormatSymbols)object).getMonths();
                }
                case ABBREVIATED: 
                case SHORT: {
                    return ((DateFormatSymbols)object).getShortMonths();
                }
                case NARROW: {
                    String[] stringArray = ((DateFormatSymbols)object).getShortMonths();
                    String[] stringArray2 = new String[stringArray.length];
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        stringArray2[i] = !stringArray[i].isEmpty() ? OldJdkProvider.toLatinLetter(stringArray[i]) : String.valueOf(i + 1);
                    }
                    return stringArray2;
                }
            }
            throw new UnsupportedOperationException(textWidth.name());
        }

        @Override
        public String[] quarters(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
            ResourceBundle resourceBundle = OldJdkProvider.getBundle(locale);
            if (resourceBundle != null) {
                if (outputContext == OutputContext.STANDALONE && !"true".equals(resourceBundle.getObject("enableStandalone"))) {
                    return this.quarters(string, locale, textWidth, OutputContext.FORMAT);
                }
                String[] stringArray = new String[4];
                boolean bl = false;
                for (int i = 0; i < 4; ++i) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("QUARTER_OF_YEAR(");
                    stringBuilder.append((Object)textWidth);
                    if (outputContext == OutputContext.STANDALONE) {
                        stringBuilder.append('|');
                        stringBuilder.append((Object)outputContext);
                    }
                    stringBuilder.append(")_");
                    stringBuilder.append(i + 1);
                    try {
                        stringArray[i] = resourceBundle.getString(stringBuilder.toString());
                        continue;
                    }
                    catch (MissingResourceException missingResourceException) {
                        bl = true;
                        break;
                    }
                }
                if (!bl) {
                    return stringArray;
                }
            }
            return new String[]{"Q1", "Q2", "Q3", "Q4"};
        }

        @Override
        public String[] weekdays(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
            int n;
            Object object;
            String[] stringArray;
            ResourceBundle resourceBundle = OldJdkProvider.getBundle(locale);
            try {
                if (resourceBundle != null && outputContext == OutputContext.STANDALONE && "true".equals(resourceBundle.getObject("enableStandalone"))) {
                    String[] stringArray2 = new String[7];
                    for (int i = 0; i < 7; ++i) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("DAY_OF_WEEK(");
                        stringBuilder.append((Object)textWidth);
                        stringBuilder.append('|');
                        stringBuilder.append((Object)outputContext);
                        stringBuilder.append(")_");
                        stringBuilder.append(i + 1);
                        stringArray2[i] = resourceBundle.getString(stringBuilder.toString());
                    }
                    return stringArray2;
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale);
            switch (textWidth) {
                case WIDE: {
                    stringArray = dateFormatSymbols.getWeekdays();
                    break;
                }
                case ABBREVIATED: {
                    stringArray = dateFormatSymbols.getShortWeekdays();
                    break;
                }
                case SHORT: {
                    stringArray = dateFormatSymbols.getShortWeekdays();
                    if (resourceBundle == null) break;
                    try {
                        object = new String[7];
                        for (n = 0; n < 7; ++n) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("DAY_OF_WEEK(SHORT)_");
                            stringBuilder.append(n + 1);
                            object[n] = resourceBundle.getString(stringBuilder.toString());
                        }
                        stringArray = object;
                    }
                    catch (MissingResourceException missingResourceException) {}
                    break;
                }
                case NARROW: {
                    object = dateFormatSymbols.getShortWeekdays();
                    String[] stringArray3 = new String[((String[])object).length];
                    for (int i = 1; i < ((String[])object).length; ++i) {
                        stringArray3[i] = !object[i].isEmpty() ? OldJdkProvider.toLatinLetter(object[i]) : String.valueOf(i);
                    }
                    stringArray = stringArray3;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown text width: " + (Object)((Object)textWidth));
                }
            }
            if (stringArray.length == 8) {
                object = stringArray[1];
                for (n = 2; n < 8; ++n) {
                    stringArray[n - 2] = stringArray[n];
                }
                stringArray[6] = object;
            }
            return stringArray;
        }

        @Override
        public String[] eras(String string, Locale locale, TextWidth textWidth) {
            DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale);
            if (textWidth == TextWidth.NARROW) {
                String[] stringArray = dateFormatSymbols.getEras();
                String[] stringArray2 = new String[stringArray.length];
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    stringArray2[i] = !stringArray[i].isEmpty() ? OldJdkProvider.toLatinLetter(stringArray[i]) : (i == 0 && stringArray.length == 2 ? "B" : (i == 1 && stringArray.length == 2 ? "A" : String.valueOf(i)));
                }
                return stringArray2;
            }
            return dateFormatSymbols.getEras();
        }

        @Override
        public String[] meridiems(String string, Locale locale, TextWidth textWidth) {
            DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale);
            if (textWidth == TextWidth.NARROW) {
                return new String[]{"A", "P"};
            }
            return dateFormatSymbols.getAmPmStrings();
        }

        private static String toLatinLetter(String string) {
            char c = Normalizer.normalize(string, Normalizer.Form.NFD).charAt(0);
            if (c >= 'A' && c <= 'Z') {
                return String.valueOf(c);
            }
            if (c >= 'a' && c <= 'z') {
                c = (char)(c - 32);
                return String.valueOf(c);
            }
            return string;
        }

        private static ResourceBundle getBundle(Locale locale) {
            try {
                return ResourceBundle.getBundle("data/iso8601", locale, new PropertiesControl());
            }
            catch (MissingResourceException missingResourceException) {
                return null;
            }
        }
    }

    public static final class Accessor {
        private final List<String> textForms;
        private final Locale locale;

        private Accessor(String[] stringArray, Locale locale) {
            this.textForms = Collections.unmodifiableList(Arrays.asList(stringArray));
            this.locale = locale;
        }

        public String print(Enum<?> enum_) {
            int n = enum_.ordinal();
            if (this.textForms.size() <= n) {
                return enum_.name();
            }
            return this.textForms.get(n);
        }

        public <V extends Enum<V>> V parse(CharSequence charSequence, ParseLog parseLog, Class<V> clazz) {
            return this.parse(charSequence, parseLog, clazz, true, false);
        }

        public <V extends Enum<V>> V parse(CharSequence charSequence, ParseLog parseLog, Class<V> clazz, AttributeQuery attributeQuery) {
            boolean bl = attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE);
            boolean bl2 = attributeQuery.get(Attributes.PARSE_PARTIAL_COMPARE, Boolean.FALSE);
            return this.parse(charSequence, parseLog, clazz, bl, bl2);
        }

        public String toString() {
            int n = this.textForms.size();
            StringBuilder stringBuilder = new StringBuilder(n * 16 + 2);
            stringBuilder.append('{');
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(',');
                }
                stringBuilder.append(this.textForms.get(i));
            }
            stringBuilder.append('}');
            return stringBuilder.toString();
        }

        private <V extends Enum<V>> V parse(CharSequence charSequence, ParseLog parseLog, Class<V> clazz, boolean bl, boolean bl2) {
            Enum[] enumArray = (Enum[])clazz.getEnumConstants();
            int n = this.textForms.size();
            int n2 = parseLog.getPosition();
            int n3 = charSequence.length();
            int n4 = 0;
            Enum enum_ = null;
            for (int i = 0; i < enumArray.length; ++i) {
                String string = i >= n ? enumArray[i].name() : this.textForms.get(i);
                int n5 = n2;
                int n6 = string.length();
                boolean bl3 = true;
                for (int j = 0; bl3 && j < n6; ++j) {
                    if (n2 + j >= n3) {
                        bl3 = false;
                        continue;
                    }
                    char c = charSequence.charAt(n2 + j);
                    char c2 = string.charAt(j);
                    if (bl) {
                        bl3 = this.compareIgnoreCase(c, c2);
                    } else {
                        boolean bl4 = bl3 = c == c2;
                    }
                    if (!bl3) continue;
                    ++n5;
                }
                if (bl3) {
                    assert (n5 == n2 + n6);
                    parseLog.setPosition(n5);
                    return (V)enumArray[i];
                }
                if (!bl2 || n4 >= n5 - n2) continue;
                n4 = n5 - n2;
                enum_ = enumArray[i];
            }
            if (enum_ == null) {
                parseLog.setError(n2);
            } else {
                parseLog.setPosition(n2 + n4);
            }
            return (V)enum_;
        }

        private boolean compareIgnoreCase(char c, char c2) {
            if (c >= 'a' && c <= 'z') {
                c = (char)(c - 97 + 65);
            }
            if (c2 >= 'a' && c2 <= 'z') {
                c2 = (char)(c2 - 97 + 65);
            }
            if (c >= 'A' && c <= 'Z') {
                return c == c2;
            }
            String string = String.valueOf(c).toUpperCase(this.locale);
            String string2 = String.valueOf(c2).toUpperCase(this.locale);
            return string.equals(string2);
        }
    }

    public static interface Provider {
        public String[] getSupportedCalendarTypes();

        public Locale[] getAvailableLocales();

        public String[] months(String var1, Locale var2, TextWidth var3, OutputContext var4, boolean var5);

        public String[] quarters(String var1, Locale var2, TextWidth var3, OutputContext var4);

        public String[] weekdays(String var1, Locale var2, TextWidth var3, OutputContext var4);

        public String[] eras(String var1, Locale var2, TextWidth var3);

        public String[] meridiems(String var1, Locale var2, TextWidth var3);
    }
}

