/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.util.Locale;
import net.time4j.AbstractDateElement;
import net.time4j.ElementOperator;
import net.time4j.NavigableElement;
import net.time4j.NavigationOperator;
import net.time4j.PlainDate;
import net.time4j.SimpleEra;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.NumericalElement;
import net.time4j.format.OutputContext;
import net.time4j.format.ParseLog;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;

final class EnumElement<V extends Enum<V>>
extends AbstractDateElement<V>
implements NavigableElement<V>,
NumericalElement<V>,
TextElement<V> {
    static final int MONTH = 101;
    static final int DAY_OF_WEEK = 102;
    static final int QUARTER_OF_YEAR = 103;
    static final int ERA = 104;
    private static final long serialVersionUID = 2055272540517425102L;
    private final transient Class<V> type;
    private final transient V dmin;
    private final transient V dmax;
    private final transient int index;
    private final transient char symbol;

    EnumElement(String string, Class<V> clazz, V v, V v2, int n, char c) {
        super(string);
        this.type = clazz;
        this.dmin = v;
        this.dmax = v2;
        this.index = n;
        this.symbol = c;
    }

    @Override
    public Class<V> getType() {
        return this.type;
    }

    @Override
    public char getSymbol() {
        return this.symbol;
    }

    @Override
    public V getDefaultMinimum() {
        return this.dmin;
    }

    @Override
    public V getDefaultMaximum() {
        return this.dmax;
    }

    @Override
    public boolean isDateElement() {
        return true;
    }

    @Override
    public boolean isTimeElement() {
        return false;
    }

    @Override
    public ElementOperator<PlainDate> setToNext(V v) {
        return new NavigationOperator<V>(this, 9, v);
    }

    @Override
    public ElementOperator<PlainDate> setToPrevious(V v) {
        return new NavigationOperator<V>(this, 10, v);
    }

    @Override
    public ElementOperator<PlainDate> setToNextOrSame(V v) {
        return new NavigationOperator<V>(this, 11, v);
    }

    @Override
    public ElementOperator<PlainDate> setToPreviousOrSame(V v) {
        return new NavigationOperator<V>(this, 12, v);
    }

    @Override
    public int numerical(V v) {
        if (this.index == 104) {
            return ((Enum)v).ordinal();
        }
        return ((Enum)v).ordinal() + 1;
    }

    @Override
    public void print(ChronoEntity<?> chronoEntity, Appendable appendable, AttributeQuery attributeQuery) throws IOException {
        appendable.append(this.accessor(attributeQuery).print((Enum)chronoEntity.get(this)));
    }

    @Override
    public V parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery) {
        return this.accessor(attributeQuery).parse(charSequence, parseLog, this.getType(), attributeQuery);
    }

    @Override
    protected <T extends ChronoEntity<T>> ElementRule<T, V> derive(Chronology<T> chronology) {
        if (this.index == 104 && chronology.isRegistered(PlainDate.CALENDAR_DATE)) {
            SimpleEra.Rule rule = new SimpleEra.Rule();
            return rule;
        }
        return null;
    }

    int getIndex() {
        return this.index;
    }

    private CalendarText.Accessor accessor(AttributeQuery attributeQuery) {
        CalendarText calendarText = CalendarText.getInstance(attributeQuery.get(Attributes.CALENDAR_TYPE, "iso8601"), attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT));
        TextWidth textWidth = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
        switch (this.index) {
            case 101: {
                return calendarText.getStdMonths(textWidth, attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT));
            }
            case 102: {
                return calendarText.getWeekdays(textWidth, attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT));
            }
            case 103: {
                return calendarText.getQuarters(textWidth, attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT));
            }
            case 104: {
                return calendarText.getEras(textWidth);
            }
        }
        throw new UnsupportedOperationException(this.name());
    }

    private Object readResolve() throws ObjectStreamException {
        Object object = PlainDate.lookupElement(this.name());
        if (object == null) {
            throw new InvalidObjectException(this.name());
        }
        return object;
    }
}

