/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.time4j.CalendarUnit;
import net.time4j.ClockUnit;
import net.time4j.IsoUnit;
import net.time4j.Moment;
import net.time4j.PlainTimestamp;
import net.time4j.SPX;
import net.time4j.base.MathUtils;
import net.time4j.engine.AbstractDuration;
import net.time4j.engine.AbstractMetric;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoOperator;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.Normalizer;
import net.time4j.engine.TimeMetric;
import net.time4j.engine.TimePoint;
import net.time4j.engine.TimeSpan;
import net.time4j.tz.Timezone;

public final class Duration<U extends IsoUnit>
extends AbstractDuration<U>
implements Serializable {
    private static final char ISO_DECIMAL_SEPARATOR = (char)(Boolean.getBoolean("net.time4j.format.iso.decimal.dot") ? 46 : 44);
    private static final long MRD = 1000000000L;
    private static final long MIO = 1000000L;
    private static final Duration ZERO = new Duration();
    private static final Comparator<TimeSpan.Item<? extends ChronoUnit>> ITEM_COMPARATOR = new Comparator<TimeSpan.Item<? extends ChronoUnit>>(){

        @Override
        public int compare(TimeSpan.Item<? extends ChronoUnit> item, TimeSpan.Item<? extends ChronoUnit> item2) {
            return Duration.compare(item.getUnit(), item2.getUnit());
        }
    };
    public static Normalizer<IsoUnit> STD_PERIOD = new TimestampNormalizer();
    public static Normalizer<CalendarUnit> STD_CALENDAR_PERIOD = new DateNormalizer();
    public static Normalizer<ClockUnit> STD_CLOCK_PERIOD = new TimeNormalizer();
    private static final int PRINT_STYLE_NORMAL = 0;
    private static final int PRINT_STYLE_ISO = 1;
    private static final int PRINT_STYLE_XML = 2;
    private static final long serialVersionUID = -6321211763598951499L;
    private static final TimeMetric<CalendarUnit, Duration<CalendarUnit>> YMD_METRIC = Duration.in((IsoUnit[])new CalendarUnit[]{CalendarUnit.YEARS, CalendarUnit.MONTHS, CalendarUnit.DAYS});
    private static final TimeMetric<ClockUnit, Duration<ClockUnit>> CLOCK_METRIC = Duration.in((IsoUnit[])new ClockUnit[]{ClockUnit.HOURS, ClockUnit.MINUTES, ClockUnit.SECONDS, ClockUnit.NANOS});
    private final transient List<TimeSpan.Item<U>> items;
    private final transient boolean negative;

    Duration(List<TimeSpan.Item<U>> list, boolean bl) {
        boolean bl2 = list.isEmpty();
        if (bl2) {
            this.items = Collections.emptyList();
        } else {
            Collections.sort(list, ITEM_COMPARATOR);
            this.items = Collections.unmodifiableList(list);
        }
        this.negative = bl2 ? false : bl;
    }

    private Duration(Duration<U> duration, boolean bl) {
        this.items = duration.items;
        this.negative = bl ? !duration.negative : duration.negative;
    }

    private Duration() {
        this.items = Collections.emptyList();
        this.negative = false;
    }

    public static <U extends IsoUnit> Duration<U> ofZero() {
        return ZERO;
    }

    public static <U extends IsoUnit> Duration<U> of(long l, U u) {
        if (l == 0L) {
            return Duration.ofZero();
        }
        ArrayList<TimeSpan.Item<U>> arrayList = new ArrayList<TimeSpan.Item<U>>(1);
        arrayList.add(TimeSpan.Item.of(l < 0L ? MathUtils.safeNegate(l) : l, u));
        return new Duration<U>(arrayList, l < 0L);
    }

    public static Builder ofPositive() {
        return new Builder(false);
    }

    public static Builder ofNegative() {
        return new Builder(true);
    }

    public static Duration<CalendarUnit> ofCalendarUnits(int n, int n2, int n3) {
        return Duration.ofCalendarUnits(n, n2, n3, false);
    }

    public static Duration<ClockUnit> ofClockUnits(int n, int n2, int n3) {
        return Duration.ofClockUnits(n, n2, n3, 0L, false);
    }

    public static <U extends IsoUnit> TimeMetric<U, Duration<U>> in(U ... UArray) {
        return new Metric((IsoUnit[])UArray);
    }

    public static TimeMetric<CalendarUnit, Duration<CalendarUnit>> inYearsMonthsDays() {
        return YMD_METRIC;
    }

    public static TimeMetric<ClockUnit, Duration<ClockUnit>> inClockUnits() {
        return CLOCK_METRIC;
    }

    @Override
    public List<TimeSpan.Item<U>> getTotalLength() {
        return this.items;
    }

    @Override
    public boolean isNegative() {
        return this.negative;
    }

    @Override
    public boolean contains(U u) {
        if (u instanceof IsoUnit) {
            U u2 = u;
            boolean bl = this.isFractionUnit((IsoUnit)u2);
            int n = this.items.size();
            for (int i = 0; i < n; ++i) {
                TimeSpan.Item<U> item = this.items.get(i);
                IsoUnit isoUnit = (IsoUnit)item.getUnit();
                if (!isoUnit.equals(u) && (!bl || !this.isFractionUnit(isoUnit))) continue;
                return item.getAmount() > 0L;
            }
        }
        return false;
    }

    @Override
    public long getPartialAmount(U u) {
        if (u instanceof IsoUnit) {
            U u2 = u;
            boolean bl = this.isFractionUnit((IsoUnit)u2);
            int n = this.items.size();
            for (int i = 0; i < n; ++i) {
                TimeSpan.Item<U> item = this.items.get(i);
                IsoUnit isoUnit = (IsoUnit)item.getUnit();
                if (isoUnit.equals(u)) {
                    return item.getAmount();
                }
                if (!bl || !this.isFractionUnit(isoUnit)) continue;
                int n2 = isoUnit.getSymbol() - 48;
                int n3 = u2.getSymbol() - 48;
                int n4 = 1;
                int n5 = Math.abs(n2 - n3);
                for (int j = 0; j < n5; ++j) {
                    n4 *= 10;
                }
                if (n2 >= n3) {
                    return item.getAmount() / (long)n4;
                }
                return item.getAmount() * (long)n4;
            }
        }
        return 0L;
    }

    public static <U extends IsoUnit, T extends TimePoint<? super U, T>> Comparator<Duration<U>> comparator(T t) {
        return new LengthComparator(t, null);
    }

    public Duration<U> plus(long l, U object) {
        if (object == null) {
            throw new NullPointerException("Missing chronological unit.");
        }
        long l2 = l;
        U u = object;
        boolean bl = false;
        if (l == 0L) {
            return this;
        }
        if (l < 0L) {
            l = MathUtils.safeNegate(l);
            bl = true;
        }
        ArrayList<TimeSpan.Item<U>> arrayList = new ArrayList<TimeSpan.Item<U>>(this.getTotalLength());
        TimeSpan.Item<U> item = Duration.replaceFraction(l, object);
        if (item != null) {
            l = item.getAmount();
            object = (IsoUnit)item.getUnit();
        }
        if (this.isEmpty()) {
            arrayList.add(item == null ? TimeSpan.Item.of(l, object) : item);
            return new Duration<U>(arrayList, bl);
        }
        int n = this.getIndex((ChronoUnit)object);
        boolean bl2 = this.isNegative();
        if (n < 0) {
            if (this.isNegative() == bl) {
                arrayList.add(TimeSpan.Item.of(l, object));
            } else {
                this.throwMixedSignsException(l2, (ChronoUnit)u);
            }
        } else {
            long l3 = MathUtils.safeAdd(MathUtils.safeMultiply(((TimeSpan.Item)arrayList.get(n)).getAmount(), (long)(this.isNegative() ? -1 : 1)), MathUtils.safeMultiply(l, (long)(bl ? -1 : 1)));
            if (l3 == 0L) {
                arrayList.remove(n);
            } else if (this.count() == 1 || this.isNegative() == l3 < 0L) {
                long l4 = l3 < 0L ? MathUtils.safeNegate(l3) : l3;
                arrayList.set(n, TimeSpan.Item.of(l4, object));
                bl2 = l3 < 0L;
            } else {
                this.throwMixedSignsException(l2, (ChronoUnit)u);
            }
        }
        return new Duration<U>(arrayList, bl2);
    }

    public Duration<U> minus(long l, U u) {
        return this.plus(MathUtils.safeNegate(l), u);
    }

    public Duration<U> plus(TimeSpan<? extends U> timeSpan) {
        return Duration.add(this, timeSpan, false);
    }

    public Duration<U> minus(TimeSpan<? extends U> timeSpan) {
        return Duration.add(this, timeSpan, true);
    }

    public Duration<U> with(long l, U object) {
        long l2 = l < 0L ? MathUtils.safeNegate(l) : l;
        TimeSpan.Item<U> item = Duration.replaceFraction(l2, object);
        if (item != null) {
            l2 = item.getAmount();
            object = (IsoUnit)item.getUnit();
        }
        long l3 = this.getPartialAmount((U)object);
        return this.plus(MathUtils.safeSubtract(MathUtils.safeMultiply(l2, l < 0L ? -1L : 1L), MathUtils.safeMultiply(l3, this.isNegative() ? -1L : 1L)), object);
    }

    public Duration<U> abs() {
        if (this.isNegative()) {
            return this.inverse();
        }
        return this;
    }

    @Override
    public Duration<U> inverse() {
        return this.multipliedBy(-1);
    }

    public Duration<U> multipliedBy(int n) {
        if (this.isEmpty() || n == 1) {
            return this;
        }
        if (n == 0) {
            return Duration.ofZero();
        }
        if (n == -1) {
            return new Duration<U>(this, true);
        }
        ArrayList<TimeSpan.Item<U>> arrayList = new ArrayList<TimeSpan.Item<U>>(this.count());
        int n2 = Math.abs(n);
        int n3 = this.count();
        for (int i = 0; i < n3; ++i) {
            TimeSpan.Item<U> item = this.getTotalLength().get(i);
            arrayList.add(TimeSpan.Item.of(MathUtils.safeMultiply(item.getAmount(), (long)n2), item.getUnit()));
        }
        return new Duration<U>(arrayList, n < 0 ? !this.isNegative() : this.isNegative());
    }

    public Duration<IsoUnit> union(TimeSpan<? extends IsoUnit> timeSpan) {
        Duration<U> duration = Duration.ofZero();
        return duration.plus(this).plus(timeSpan);
    }

    public Duration<U> with(Normalizer<U> normalizer) {
        return Duration.convert(normalizer.normalize(this));
    }

    public ChronoOperator<Moment> earlier(final Timezone timezone) {
        return new ChronoOperator<Moment>(){

            @Override
            public Moment apply(Moment moment) {
                PlainTimestamp plainTimestamp = PlainTimestamp.from(moment, timezone.getOffset(moment));
                plainTimestamp = (PlainTimestamp)plainTimestamp.minus(Duration.this);
                return plainTimestamp.at(timezone);
            }
        };
    }

    public ChronoOperator<Moment> later(final Timezone timezone) {
        return new ChronoOperator<Moment>(){

            @Override
            public Moment apply(Moment moment) {
                PlainTimestamp plainTimestamp = PlainTimestamp.from(moment, timezone.getOffset(moment));
                plainTimestamp = (PlainTimestamp)plainTimestamp.plus(Duration.this);
                return plainTimestamp.at(timezone);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Duration) {
            Duration duration = (Duration)Duration.class.cast(object);
            return this.negative == duration.negative && this.getTotalLength().equals(duration.getTotalLength());
        }
        return false;
    }

    public int hashCode() {
        int n = this.getTotalLength().hashCode();
        if (this.negative) {
            n ^= n;
        }
        return n;
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    public String toStringISO() {
        return this.toString(1);
    }

    public String toStringXML() {
        return this.toString(2);
    }

    public static Duration<IsoUnit> parse(String string) throws ParseException {
        return Duration.parse(string, IsoUnit.class);
    }

    public static Duration<CalendarUnit> parseCalendarPeriod(String string) throws ParseException {
        return Duration.parse(string, CalendarUnit.class);
    }

    public static Duration<ClockUnit> parseClockPeriod(String string) throws ParseException {
        return Duration.parse(string, ClockUnit.class);
    }

    private String toString(int n) {
        if (n == 1 && this.isNegative()) {
            throw new ChronoException("Negative sign not allowed in ISO-8601.");
        }
        if (this.isEmpty()) {
            return "PT0S";
        }
        boolean bl = n == 2;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isNegative()) {
            stringBuilder.append('-');
        }
        stringBuilder.append('P');
        boolean bl2 = false;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n2 = this.getTotalLength().size();
        block9: for (int i = 0; i < n2; ++i) {
            TimeSpan.Item<U> item = this.getTotalLength().get(i);
            IsoUnit isoUnit = (IsoUnit)item.getUnit();
            if (!bl2 && !isoUnit.isCalendrical()) {
                stringBuilder.append('T');
                bl2 = true;
            }
            long l4 = item.getAmount();
            int n3 = isoUnit.getSymbol();
            if (n3 > 48 && n3 <= 57) {
                assert (n3 == 57);
                l = l4;
                continue;
            }
            if (n3 == 83) {
                l2 = l4;
                continue;
            }
            if (bl || n == 1) {
                switch (n3) {
                    case 68: {
                        if (l3 != 0L) {
                            l4 = MathUtils.safeAdd(l4, l3);
                            l3 = 0L;
                        }
                        stringBuilder.append(l4);
                        break;
                    }
                    case 72: 
                    case 77: 
                    case 89: {
                        stringBuilder.append(l4);
                        break;
                    }
                    case 87: {
                        if (n2 == 1) {
                            if (bl) {
                                stringBuilder.append(MathUtils.safeMultiply(l4, 7L));
                                n3 = 68;
                                break;
                            }
                            stringBuilder.append(l4);
                            break;
                        }
                        l3 = MathUtils.safeMultiply(l4, 7L);
                        if (this.getIndex(CalendarUnit.DAYS) >= 0) continue block9;
                        stringBuilder.append(l3);
                        l3 = 0L;
                        n3 = 68;
                        break;
                    }
                    case 81: {
                        stringBuilder.append(MathUtils.safeMultiply(l4, 3L));
                        n3 = 77;
                        break;
                    }
                    case 69: {
                        stringBuilder.append(MathUtils.safeMultiply(l4, 10L));
                        n3 = 89;
                        break;
                    }
                    case 67: {
                        stringBuilder.append(MathUtils.safeMultiply(l4, 100L));
                        n3 = 89;
                        break;
                    }
                    case 73: {
                        stringBuilder.append(MathUtils.safeMultiply(l4, 1000L));
                        n3 = 89;
                        break;
                    }
                    default: {
                        String string = bl ? "XML" : "ISO";
                        throw new ChronoException("Special units cannot be output in " + string + "-mode: " + this.toString(0));
                    }
                }
            } else {
                stringBuilder.append(l4);
            }
            if (n3 == 0) {
                stringBuilder.append('{');
                stringBuilder.append(isoUnit);
                stringBuilder.append('}');
                continue;
            }
            stringBuilder.append((char)n3);
        }
        if (l != 0L) {
            l2 = MathUtils.safeAdd(l2, l / 1000000000L);
            stringBuilder.append(l2);
            stringBuilder.append(bl ? (char)'.' : (char)ISO_DECIMAL_SEPARATOR);
            String string = String.valueOf(l % 1000000000L);
            int n4 = 9 - string.length();
            for (n2 = 0; n2 < n4; ++n2) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
            stringBuilder.append('S');
        } else if (l2 != 0L) {
            stringBuilder.append(l2);
            stringBuilder.append('S');
        }
        return stringBuilder.toString();
    }

    private int count() {
        return this.getTotalLength().size();
    }

    private static <U> boolean isEmpty(TimeSpan<U> timeSpan) {
        List<TimeSpan.Item<U>> list = timeSpan.getTotalLength();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (list.get(i).getAmount() <= 0L) continue;
            return false;
        }
        return true;
    }

    private static <U extends IsoUnit> Duration<U> add(Duration<U> duration, TimeSpan<? extends U> timeSpan, boolean bl) {
        int n;
        if (duration.isEmpty()) {
            if (Duration.isEmpty(timeSpan)) {
                return duration;
            }
            if (timeSpan instanceof Duration) {
                Duration duration2 = (Duration)Duration.cast(timeSpan);
                return bl ? duration2.inverse() : duration2;
            }
        }
        HashMap<Object, Long> hashMap = new HashMap<Object, Long>();
        int n2 = super.count();
        for (n = 0; n < n2; ++n) {
            TimeSpan.Item<U> item = duration.getTotalLength().get(n);
            hashMap.put(item.getUnit(), MathUtils.safeMultiply(item.getAmount(), (long)(duration.isNegative() ? -1 : 1)));
        }
        n = timeSpan.isNegative() ? 1 : 0;
        if (bl) {
            n = n == 0 ? 1 : 0;
        }
        int n3 = timeSpan.getTotalLength().size();
        for (n2 = 0; n2 < n3; ++n2) {
            Map.Entry entry = timeSpan.getTotalLength().get(n2);
            IsoUnit isoUnit = (IsoUnit)((TimeSpan.Item)((Object)entry)).getUnit();
            long l = ((TimeSpan.Item)((Object)entry)).getAmount();
            TimeSpan.Item<IsoUnit> item = Duration.replaceFraction(l, isoUnit);
            if (item != null) {
                l = item.getAmount();
                isoUnit = item.getUnit();
            }
            if (hashMap.containsKey(isoUnit)) {
                hashMap.put(isoUnit, MathUtils.safeAdd((Long)hashMap.get(isoUnit), MathUtils.safeMultiply(l, (long)(n != 0 ? -1 : 1))));
                continue;
            }
            hashMap.put(isoUnit, MathUtils.safeMultiply(l, (long)(n != 0 ? -1 : 1)));
        }
        Boolean bl2 = null;
        if (duration.isNegative() == n) {
            bl2 = duration.isNegative();
        } else {
            for (Map.Entry entry : hashMap.entrySet()) {
                boolean bl3;
                boolean bl4 = bl3 = (Long)entry.getValue() < 0L;
                if (bl2 == null) {
                    bl2 = bl3;
                    continue;
                }
                if (bl2 == bl3) continue;
                throw new IllegalStateException("Mixed signs in result time span not allowed: " + duration + " UNION " + (bl ? "-" : "") + timeSpan);
            }
        }
        if (bl2.booleanValue()) {
            for (Map.Entry entry : hashMap.entrySet()) {
                long l = (Long)entry.getValue();
                hashMap.put(entry.getKey(), l < 0L ? MathUtils.safeNegate(l) : l);
            }
        }
        return Duration.create(hashMap, bl2);
    }

    private static Duration<CalendarUnit> ofCalendarUnits(long l, long l2, long l3, boolean bl) {
        ArrayList arrayList = new ArrayList(3);
        if (l != 0L) {
            arrayList.add(TimeSpan.Item.of(l, CalendarUnit.YEARS));
        }
        if (l2 != 0L) {
            arrayList.add(TimeSpan.Item.of(l2, CalendarUnit.MONTHS));
        }
        if (l3 != 0L) {
            arrayList.add(TimeSpan.Item.of(l3, CalendarUnit.DAYS));
        }
        return new Duration<CalendarUnit>(arrayList, bl);
    }

    private static Duration<ClockUnit> ofClockUnits(long l, long l2, long l3, long l4, boolean bl) {
        ArrayList arrayList = new ArrayList(4);
        if (l != 0L) {
            arrayList.add(TimeSpan.Item.of(l, ClockUnit.HOURS));
        }
        if (l2 != 0L) {
            arrayList.add(TimeSpan.Item.of(l2, ClockUnit.MINUTES));
        }
        if (l3 != 0L) {
            arrayList.add(TimeSpan.Item.of(l3, ClockUnit.SECONDS));
        }
        if (l4 != 0L) {
            arrayList.add(TimeSpan.Item.of(l4, ClockUnit.NANOS));
        }
        return new Duration<ClockUnit>(arrayList, bl);
    }

    private static <U extends IsoUnit> Duration<U> create(Map<U, Long> map, boolean bl) {
        if (map.isEmpty()) {
            return Duration.ofZero();
        }
        ArrayList<TimeSpan.Item<U>> arrayList = new ArrayList<TimeSpan.Item<U>>(map.size());
        long l = 0L;
        for (Map.Entry<U, Long> entry : map.entrySet()) {
            long l2 = entry.getValue();
            IsoUnit isoUnit = (IsoUnit)entry.getKey();
            if (l2 == 0L) continue;
            if (isoUnit == ClockUnit.MILLIS) {
                l = MathUtils.safeAdd(l, MathUtils.safeMultiply(l2, 1000000L));
                continue;
            }
            if (isoUnit == ClockUnit.MICROS) {
                l = MathUtils.safeAdd(l, MathUtils.safeMultiply(l2, 1000L));
                continue;
            }
            if (isoUnit == ClockUnit.NANOS) {
                l = MathUtils.safeAdd(l, l2);
                continue;
            }
            arrayList.add(TimeSpan.Item.of(l2, isoUnit));
        }
        if (l != 0L) {
            IsoUnit isoUnit = (IsoUnit)Duration.cast(ClockUnit.NANOS);
            arrayList.add(TimeSpan.Item.of(l, isoUnit));
        }
        return new Duration<U>(arrayList, bl);
    }

    private int getIndex(ChronoUnit chronoUnit) {
        return Duration.getIndex(chronoUnit, this.getTotalLength());
    }

    private static <U extends ChronoUnit> int getIndex(ChronoUnit chronoUnit, List<TimeSpan.Item<U>> list) {
        int n = 0;
        int n2 = list.size() - 1;
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            ChronoUnit chronoUnit2 = (ChronoUnit)list.get(n3).getUnit();
            int n4 = Duration.compare(chronoUnit2, chronoUnit);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -1;
    }

    private static int compare(ChronoUnit chronoUnit, ChronoUnit chronoUnit2) {
        return Double.compare(chronoUnit2.getLength(), chronoUnit.getLength());
    }

    private static <U extends IsoUnit> TimeSpan.Item<U> replaceFraction(long l, U object) {
        if (object.equals(ClockUnit.MILLIS)) {
            l = MathUtils.safeMultiply(l, 1000000L);
            object = (IsoUnit)Duration.cast(ClockUnit.NANOS);
        } else if (object.equals(ClockUnit.MICROS)) {
            l = MathUtils.safeMultiply(l, 1000L);
            object = (IsoUnit)Duration.cast(ClockUnit.NANOS);
        } else {
            return null;
        }
        return TimeSpan.Item.of(l, object);
    }

    private void throwMixedSignsException(long l, ChronoUnit chronoUnit) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("Mixed signs in result time span not allowed: ");
        stringBuilder.append(this);
        stringBuilder.append(" + (");
        stringBuilder.append(l);
        stringBuilder.append(' ');
        stringBuilder.append(chronoUnit);
        stringBuilder.append(')');
        throw new IllegalStateException(stringBuilder.toString());
    }

    private static <U extends IsoUnit> Duration<U> convert(TimeSpan<U> timeSpan) {
        if (timeSpan instanceof Duration) {
            return (Duration)Duration.cast(timeSpan);
        }
        Duration<U> duration = Duration.ofZero();
        return duration.plus(timeSpan);
    }

    private boolean isFractionUnit(IsoUnit isoUnit) {
        char c = isoUnit.getSymbol();
        return c >= '1' && c <= '9';
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }

    private static <U extends IsoUnit> Duration<U> parse(String string, Class<U> clazz) throws ParseException {
        int n = 0;
        boolean bl = false;
        if (string.length() == 0) {
            throw new ParseException("Empty duration string.", n);
        }
        if (string.charAt(0) == '-') {
            bl = true;
            n = 1;
        }
        try {
            int n2;
            boolean bl2;
            if (string.charAt(n) != 'P') {
                throw new ParseException("Format symbol 'P' expected: " + string, n);
            }
            ArrayList<TimeSpan.Item<U>> arrayList = new ArrayList<TimeSpan.Item<U>>();
            boolean bl3 = bl2 = (n2 = string.indexOf(84, ++n)) == -1;
            if (bl2) {
                if (clazz == ClockUnit.class) {
                    throw new ParseException("Format symbol 'T' expected: " + string, n);
                }
                Duration.parseItems(string, n, string.length(), true, arrayList);
            } else {
                if (n2 > n) {
                    if (clazz == ClockUnit.class) {
                        throw new ParseException("Unexpected date component found: " + string, n);
                    }
                    Duration.parseItems(string, n, n2, true, arrayList);
                }
                if (clazz == CalendarUnit.class) {
                    throw new ParseException("Unexpected time component found: " + string, n2);
                }
                Duration.parseItems(string, n2 + 1, string.length(), false, arrayList);
            }
            return new Duration<U>(arrayList, bl);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ParseException parseException = new ParseException("Unexpected termination of duration: " + string, n);
            parseException.initCause(indexOutOfBoundsException);
            throw parseException;
        }
    }

    private static <U extends ChronoUnit> void parseItems(String string, int n, int n2, boolean bl, List<TimeSpan.Item<U>> list) throws ParseException {
        if (n == n2) {
            throw new ParseException(string, n);
        }
        StringBuilder stringBuilder = null;
        boolean bl2 = false;
        ChronoUnit chronoUnit = null;
        int n3 = n;
        boolean bl3 = false;
        for (int i = n; i < n2; ++i) {
            ChronoUnit chronoUnit2;
            long l;
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                    bl2 = false;
                    n3 = i;
                }
                stringBuilder.append(c);
                continue;
            }
            if (c == ',' || c == '.') {
                if (stringBuilder == null || bl) {
                    throw new ParseException("Decimal separator misplaced: " + string, i);
                }
                bl2 = true;
                l = Duration.parseAmount(string, stringBuilder.toString(), n3);
                chronoUnit2 = ClockUnit.SECONDS;
                chronoUnit = Duration.addParsedItem(chronoUnit2, chronoUnit, l, string, i, list);
                stringBuilder = null;
                bl3 = true;
                continue;
            }
            if (bl2) {
                throw new ParseException("Unexpected char '" + c + "' found: " + string, i);
            }
            if (bl3) {
                if (c != 'S') {
                    throw new ParseException("Second symbol expected: " + string, i);
                }
                if (stringBuilder == null) {
                    throw new ParseException("Decimal separator misplaced: " + string, i - 1);
                }
                if (stringBuilder.length() > 9) {
                    stringBuilder.delete(9, stringBuilder.length());
                }
                for (int j = stringBuilder.length(); j < 9; ++j) {
                    stringBuilder.append('0');
                }
                bl2 = true;
                l = Duration.parseAmount(string, stringBuilder.toString(), n3);
                chronoUnit2 = ClockUnit.NANOS;
                stringBuilder = null;
                chronoUnit = Duration.addParsedItem(chronoUnit2, chronoUnit, l, string, i, list);
                continue;
            }
            bl2 = true;
            l = Duration.parseAmount(string, stringBuilder == null ? String.valueOf(c) : stringBuilder.toString(), n3);
            stringBuilder = null;
            chronoUnit2 = (ChronoUnit)((Object)(bl ? Duration.parseDateSymbol(c, string, i) : Duration.parseTimeSymbol(c, string, i)));
            chronoUnit = Duration.addParsedItem(chronoUnit2, chronoUnit, l, string, i, list);
        }
        if (!bl2) {
            throw new ParseException("Unit symbol expected: " + string, n2);
        }
    }

    private static CalendarUnit parseDateSymbol(char c, String string, int n) throws ParseException {
        switch (c) {
            case 'I': {
                return CalendarUnit.MILLENNIA;
            }
            case 'C': {
                return CalendarUnit.CENTURIES;
            }
            case 'E': {
                return CalendarUnit.DECADES;
            }
            case 'Y': {
                return CalendarUnit.YEARS;
            }
            case 'Q': {
                return CalendarUnit.QUARTERS;
            }
            case 'M': {
                return CalendarUnit.MONTHS;
            }
            case 'W': {
                return CalendarUnit.WEEKS;
            }
            case 'D': {
                return CalendarUnit.DAYS;
            }
        }
        throw new ParseException("Symbol '" + c + "' not supported: " + string, n);
    }

    private static ClockUnit parseTimeSymbol(char c, String string, int n) throws ParseException {
        switch (c) {
            case 'H': {
                return ClockUnit.HOURS;
            }
            case 'M': {
                return ClockUnit.MINUTES;
            }
            case 'S': {
                return ClockUnit.SECONDS;
            }
        }
        throw new ParseException("Symbol '" + c + "' not supported: " + string, n);
    }

    private static <U extends ChronoUnit> ChronoUnit addParsedItem(ChronoUnit chronoUnit, ChronoUnit chronoUnit2, long l, String string, int n, List<TimeSpan.Item<U>> list) throws ParseException {
        if (chronoUnit2 == null || Double.compare(chronoUnit.getLength(), chronoUnit2.getLength()) < 0) {
            if (l != 0L) {
                ChronoUnit chronoUnit3 = (ChronoUnit)Duration.cast(chronoUnit);
                list.add(TimeSpan.Item.of(l, chronoUnit3));
            }
            return chronoUnit;
        }
        if (chronoUnit.getLength() == chronoUnit2.getLength()) {
            throw new ParseException("Duplicate unit items: " + string, n);
        }
        throw new ParseException("Wrong order of unit items: " + string, n);
    }

    private static long parseAmount(String string, String string2, int n) throws ParseException {
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            ParseException parseException = new ParseException(string, n);
            parseException.initCause(numberFormatException);
            throw parseException;
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SPX(this, 6);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    private static class LengthComparator<U extends IsoUnit, T extends TimePoint<? super U, T>>
    implements Comparator<Duration<U>> {
        private final T base;

        private LengthComparator(T t) {
            if (t == null) {
                throw new NullPointerException("Missing base time point.");
            }
            this.base = t;
        }

        @Override
        public int compare(Duration<U> duration, Duration<U> duration2) {
            boolean bl = duration.isNegative();
            boolean bl2 = duration2.isNegative();
            if (bl && !bl2) {
                return -1;
            }
            if (!bl && bl2) {
                return 1;
            }
            if (duration.isEmpty() && duration2.isEmpty()) {
                return 0;
            }
            return ((TimePoint)((TimePoint)this.base).plus(duration)).compareTo(((TimePoint)this.base).plus(duration2));
        }

        /* synthetic */ LengthComparator(TimePoint timePoint, 1 var2_2) {
            this(timePoint);
        }
    }

    private static class Metric<U extends IsoUnit>
    extends AbstractMetric<U, Duration<U>> {
        private Metric(U ... UArray) {
            super(UArray.length > 1, UArray);
        }

        @Override
        protected Duration<U> createEmptyTimeSpan() {
            return Duration.ofZero();
        }

        @Override
        protected Duration<U> createTimeSpan(List<TimeSpan.Item<U>> list, boolean bl) {
            return new Duration<U>(list, bl);
        }
    }

    private static class TimeNormalizer
    implements Normalizer<ClockUnit> {
        private TimeNormalizer() {
        }

        @Override
        public Duration<ClockUnit> normalize(TimeSpan<? extends ClockUnit> timeSpan) {
            long l;
            int n = timeSpan.getTotalLength().size();
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            block8: for (int i = 0; i < n; ++i) {
                TimeSpan.Item<? extends ClockUnit> item = timeSpan.getTotalLength().get(i);
                l = item.getAmount();
                ClockUnit clockUnit = item.getUnit();
                switch (clockUnit) {
                    case HOURS: {
                        l2 = l;
                        continue block8;
                    }
                    case MINUTES: {
                        l3 = l;
                        continue block8;
                    }
                    case SECONDS: {
                        l4 = l;
                        continue block8;
                    }
                    case MILLIS: {
                        l5 = MathUtils.safeAdd(MathUtils.safeMultiply(l, 1000000L), l5);
                        continue block8;
                    }
                    case MICROS: {
                        l5 = MathUtils.safeAdd(MathUtils.safeMultiply(l, 1000L), l5);
                        continue block8;
                    }
                    case NANOS: {
                        l5 = MathUtils.safeAdd(l, l5);
                        continue block8;
                    }
                    default: {
                        throw new UnsupportedOperationException(clockUnit.name());
                    }
                }
            }
            long l6 = 0L;
            l = 0L;
            long l7 = 0L;
            long l8 = 0L;
            if ((l2 | l3 | l4 | l5) != 0L) {
                l6 = l5 % 1000000000L;
                l4 = MathUtils.safeAdd(l4, l5 / 1000000000L);
                l = l4 % 60L;
                l3 = MathUtils.safeAdd(l3, l4 / 60L);
                l7 = l3 % 60L;
                l8 = l2 = MathUtils.safeAdd(l2, l3 / 60L);
            }
            return Duration.ofClockUnits(l8, l7, l, l6, timeSpan.isNegative());
        }
    }

    private static class DateNormalizer
    implements Normalizer<CalendarUnit> {
        private DateNormalizer() {
        }

        @Override
        public Duration<CalendarUnit> normalize(TimeSpan<? extends CalendarUnit> timeSpan) {
            int n;
            int n2 = timeSpan.getTotalLength().size();
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            block10: for (n = 0; n < n2; n += 1) {
                TimeSpan.Item<? extends CalendarUnit> item = timeSpan.getTotalLength().get(n);
                long l5 = item.getAmount();
                CalendarUnit calendarUnit = item.getUnit();
                switch (calendarUnit) {
                    case MILLENNIA: {
                        l = MathUtils.safeAdd(MathUtils.safeMultiply(l5, 1000L), l);
                        continue block10;
                    }
                    case CENTURIES: {
                        l = MathUtils.safeAdd(MathUtils.safeMultiply(l5, 100L), l);
                        continue block10;
                    }
                    case DECADES: {
                        l = MathUtils.safeAdd(MathUtils.safeMultiply(l5, 10L), l);
                        continue block10;
                    }
                    case YEARS: {
                        l = MathUtils.safeAdd(l5, l);
                        continue block10;
                    }
                    case QUARTERS: {
                        l2 = MathUtils.safeAdd(MathUtils.safeMultiply(l5, 3L), l2);
                        continue block10;
                    }
                    case MONTHS: {
                        l2 = MathUtils.safeAdd(l5, l2);
                        continue block10;
                    }
                    case WEEKS: {
                        l3 = l5;
                        continue block10;
                    }
                    case DAYS: {
                        l4 = l5;
                        continue block10;
                    }
                    default: {
                        throw new UnsupportedOperationException(calendarUnit.toString());
                    }
                }
            }
            n = timeSpan.isNegative() ? 1 : 0;
            if ((l | l2 | l4) != 0L) {
                long l6 = MathUtils.safeAdd(l, l2 / 12L);
                long l7 = l2 % 12L;
                long l8 = MathUtils.safeAdd(MathUtils.safeMultiply(l3, 7L), l4);
                return Duration.ofCalendarUnits(l6, l7, l8, n != 0);
            }
            if (l3 != 0L) {
                if (n) {
                    l3 = MathUtils.safeNegate(l3);
                }
                return Duration.of(l3, CalendarUnit.WEEKS);
            }
            return Duration.of(0L, CalendarUnit.DAYS);
        }
    }

    private static class TimestampNormalizer
    implements Normalizer<IsoUnit> {
        private TimestampNormalizer() {
        }

        @Override
        public Duration<IsoUnit> normalize(TimeSpan<? extends IsoUnit> timeSpan) {
            Enum enum_;
            long l;
            int n = timeSpan.getTotalLength().size();
            ArrayList arrayList = new ArrayList(n);
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            long l6 = 0L;
            long l7 = 0L;
            long l8 = 0L;
            long l9 = 0L;
            block18: for (int i = 0; i < n; ++i) {
                TimeSpan.Item<? extends IsoUnit> item = timeSpan.getTotalLength().get(i);
                l = item.getAmount();
                IsoUnit isoUnit = item.getUnit();
                if (isoUnit instanceof CalendarUnit) {
                    switch ((CalendarUnit)CalendarUnit.class.cast(isoUnit)) {
                        case MILLENNIA: {
                            l2 = MathUtils.safeAdd(MathUtils.safeMultiply(l, 1000L), l2);
                            continue block18;
                        }
                        case CENTURIES: {
                            l2 = MathUtils.safeAdd(MathUtils.safeMultiply(l, 100L), l2);
                            continue block18;
                        }
                        case DECADES: {
                            l2 = MathUtils.safeAdd(MathUtils.safeMultiply(l, 10L), l2);
                            continue block18;
                        }
                        case YEARS: {
                            l2 = MathUtils.safeAdd(l, l2);
                            continue block18;
                        }
                        case QUARTERS: {
                            l3 = MathUtils.safeAdd(MathUtils.safeMultiply(l, 3L), l3);
                            continue block18;
                        }
                        case MONTHS: {
                            l3 = MathUtils.safeAdd(l, l3);
                            continue block18;
                        }
                        case WEEKS: {
                            l4 = l;
                            continue block18;
                        }
                        case DAYS: {
                            l5 = l;
                            continue block18;
                        }
                        default: {
                            throw new UnsupportedOperationException(isoUnit.toString());
                        }
                    }
                }
                if (isoUnit instanceof ClockUnit) {
                    switch ((ClockUnit)ClockUnit.class.cast(isoUnit)) {
                        case HOURS: {
                            l6 = l;
                            continue block18;
                        }
                        case MINUTES: {
                            l7 = l;
                            continue block18;
                        }
                        case SECONDS: {
                            l8 = l;
                            continue block18;
                        }
                        case MILLIS: {
                            l9 = MathUtils.safeAdd(MathUtils.safeMultiply(l, 1000000L), l9);
                            continue block18;
                        }
                        case MICROS: {
                            l9 = MathUtils.safeAdd(MathUtils.safeMultiply(l, 1000L), l9);
                            continue block18;
                        }
                        case NANOS: {
                            l9 = MathUtils.safeAdd(l, l9);
                            continue block18;
                        }
                        default: {
                            throw new UnsupportedOperationException(isoUnit.toString());
                        }
                    }
                }
                arrayList.add(TimeSpan.Item.of(l, isoUnit));
            }
            long l10 = 0L;
            l = 0L;
            long l11 = 0L;
            long l12 = 0L;
            if ((l6 | l7 | l8 | l9) != 0L) {
                l10 = l9 % 1000000000L;
                l8 = MathUtils.safeAdd(l8, l9 / 1000000000L);
                l = l8 % 60L;
                l7 = MathUtils.safeAdd(l7, l8 / 60L);
                l11 = l7 % 60L;
                l6 = MathUtils.safeAdd(l6, l7 / 60L);
                l12 = l6 % 24L;
                l5 = MathUtils.safeAdd(l5, l6 / 24L);
            }
            if ((l2 | l3 | l5) != 0L) {
                long l13 = MathUtils.safeAdd(l2, l3 / 12L);
                long l14 = l3 % 12L;
                long l15 = MathUtils.safeAdd(MathUtils.safeMultiply(l4, 7L), l5);
                if (l13 != 0L) {
                    enum_ = CalendarUnit.YEARS;
                    arrayList.add(TimeSpan.Item.of(l13, enum_));
                }
                if (l14 != 0L) {
                    enum_ = CalendarUnit.MONTHS;
                    arrayList.add(TimeSpan.Item.of(l14, enum_));
                }
                if (l15 != 0L) {
                    enum_ = CalendarUnit.DAYS;
                    arrayList.add(TimeSpan.Item.of(l15, enum_));
                }
            } else if (l4 != 0L) {
                enum_ = CalendarUnit.WEEKS;
                arrayList.add(TimeSpan.Item.of(l4, enum_));
            }
            if (l12 != 0L) {
                enum_ = ClockUnit.HOURS;
                arrayList.add(TimeSpan.Item.of(l12, enum_));
            }
            if (l11 != 0L) {
                enum_ = ClockUnit.MINUTES;
                arrayList.add(TimeSpan.Item.of(l11, enum_));
            }
            if (l != 0L) {
                enum_ = ClockUnit.SECONDS;
                arrayList.add(TimeSpan.Item.of(l, enum_));
            }
            if (l10 != 0L) {
                enum_ = ClockUnit.NANOS;
                arrayList.add(TimeSpan.Item.of(l10, enum_));
            }
            return new Duration<IsoUnit>(arrayList, timeSpan.isNegative());
        }
    }

    public static class Builder {
        private final List<TimeSpan.Item<IsoUnit>> items = new ArrayList<TimeSpan.Item<IsoUnit>>(10);
        private final boolean negative;
        private boolean millisSet = false;
        private boolean microsSet = false;
        private boolean nanosSet = false;

        Builder(boolean bl) {
            this.negative = bl;
        }

        public Builder years(int n) {
            this.set(n, CalendarUnit.YEARS);
            return this;
        }

        public Builder months(int n) {
            this.set(n, CalendarUnit.MONTHS);
            return this;
        }

        public Builder days(int n) {
            this.set(n, CalendarUnit.DAYS);
            return this;
        }

        public Builder hours(int n) {
            this.set(n, ClockUnit.HOURS);
            return this;
        }

        public Builder minutes(int n) {
            this.set(n, ClockUnit.MINUTES);
            return this;
        }

        public Builder seconds(int n) {
            this.set(n, ClockUnit.SECONDS);
            return this;
        }

        public Builder millis(int n) {
            this.millisCalled();
            this.update(n, 1000000L);
            return this;
        }

        public Builder micros(int n) {
            this.microsCalled();
            this.update(n, 1000L);
            return this;
        }

        public Builder nanos(int n) {
            this.nanosCalled();
            this.update(n, 1L);
            return this;
        }

        public Duration<IsoUnit> build() {
            if (this.items.isEmpty()) {
                throw new IllegalStateException("Not set any amount and unit.");
            }
            return new Duration<IsoUnit>(this.items, this.negative);
        }

        private Builder set(long l, IsoUnit isoUnit) {
            int n = this.items.size();
            for (int i = 0; i < n; ++i) {
                if (this.items.get(i).getUnit() != isoUnit) continue;
                throw new IllegalStateException("Already registered: " + isoUnit);
            }
            if (l != 0L) {
                TimeSpan.Item<IsoUnit> item = TimeSpan.Item.of(l, isoUnit);
                this.items.add(item);
            }
            return this;
        }

        private void update(long l, long l2) {
            if (l >= 0L) {
                ClockUnit clockUnit = ClockUnit.NANOS;
                for (int i = this.items.size() - 1; i >= 0; --i) {
                    TimeSpan.Item<IsoUnit> item = this.items.get(i);
                    if (!item.getUnit().equals(ClockUnit.NANOS)) continue;
                    this.items.set(i, TimeSpan.Item.of(MathUtils.safeAdd(MathUtils.safeMultiply(l, l2), item.getAmount()), clockUnit));
                    return;
                }
                if (l != 0L) {
                    this.items.add(TimeSpan.Item.of(MathUtils.safeMultiply(l, l2), clockUnit));
                }
            } else {
                throw new IllegalArgumentException("Illegal negative amount: " + l);
            }
        }

        private void millisCalled() {
            if (this.millisSet) {
                throw new IllegalStateException("Called twice for: " + ClockUnit.MILLIS.name());
            }
            this.millisSet = true;
        }

        private void microsCalled() {
            if (this.microsSet) {
                throw new IllegalStateException("Called twice for: " + ClockUnit.MICROS.name());
            }
            this.microsSet = true;
        }

        private void nanosCalled() {
            if (this.nanosSet) {
                throw new IllegalStateException("Called twice for: " + ClockUnit.NANOS.name());
            }
            this.nanosSet = true;
        }
    }
}

