/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import net.time4j.IsoTimeUnit;
import net.time4j.base.MathUtils;
import net.time4j.engine.TimePoint;

public enum ClockUnit implements IsoTimeUnit
{
    HOURS{

        @Override
        public char getSymbol() {
            return 'H';
        }

        @Override
        public double getLength() {
            return 3600.0;
        }
    }
    ,
    MINUTES{

        @Override
        public char getSymbol() {
            return 'M';
        }

        @Override
        public double getLength() {
            return 60.0;
        }
    }
    ,
    SECONDS{

        @Override
        public char getSymbol() {
            return 'S';
        }

        @Override
        public double getLength() {
            return 1.0;
        }
    }
    ,
    MILLIS{

        @Override
        public char getSymbol() {
            return '3';
        }

        @Override
        public double getLength() {
            return 0.001;
        }
    }
    ,
    MICROS{

        @Override
        public char getSymbol() {
            return '6';
        }

        @Override
        public double getLength() {
            return 1.0E-6;
        }
    }
    ,
    NANOS{

        @Override
        public char getSymbol() {
            return '9';
        }

        @Override
        public double getLength() {
            return 1.0E-9;
        }
    };

    private static final long[] FACTORS;

    public <T extends TimePoint<? super ClockUnit, T>> long between(T t, T t2) {
        return t.until(t2, (ClockUnit)this);
    }

    public long convert(long l, ClockUnit clockUnit) {
        int n;
        if (l == 0L) {
            return 0L;
        }
        int n2 = this.ordinal();
        if (n2 == (n = clockUnit.ordinal())) {
            return l;
        }
        if (n2 > n) {
            return MathUtils.safeMultiply(l, FACTORS[n2 - n]);
        }
        return l / FACTORS[n - n2];
    }

    @Override
    public boolean isCalendrical() {
        return false;
    }

    static {
        FACTORS = new long[]{1L, 60L, 3600L, 3600000L, 3600000000L, 3600000000000L};
    }
}

