/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.service;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import net.time4j.calendar.StdCalendarElement;
import net.time4j.engine.BasicElement;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoOperator;
import net.time4j.engine.Chronology;
import net.time4j.engine.EpochDays;
import net.time4j.engine.StdOperator;

public abstract class StdDateElement<V extends Comparable<V>, T extends ChronoEntity<T>>
extends BasicElement<V>
implements StdCalendarElement<V, T> {
    private final Class<T> chrono;
    private final transient char symbol;
    private final transient boolean daywise;

    public StdDateElement(String string, Class<T> clazz, char c, boolean bl) {
        super(string);
        this.chrono = clazz;
        this.symbol = c;
        this.daywise = bl;
    }

    public char getSymbol() {
        return this.symbol;
    }

    public boolean isDateElement() {
        return true;
    }

    public boolean isTimeElement() {
        return false;
    }

    @Override
    public ChronoOperator<T> minimized() {
        return StdOperator.minimized((ChronoElement)this);
    }

    @Override
    public ChronoOperator<T> maximized() {
        return StdOperator.maximized((ChronoElement)this);
    }

    @Override
    public ChronoOperator<T> decremented() {
        if (this.daywise) {
            return new DayOperator(true);
        }
        return StdOperator.decremented((ChronoElement)this);
    }

    @Override
    public ChronoOperator<T> incremented() {
        if (this.daywise) {
            return new DayOperator(false);
        }
        return StdOperator.incremented((ChronoElement)this);
    }

    @Override
    public ChronoOperator<T> atFloor() {
        return StdOperator.atFloor((ChronoElement)this);
    }

    @Override
    public ChronoOperator<T> atCeiling() {
        return StdOperator.atCeiling((ChronoElement)this);
    }

    protected boolean doEquals(BasicElement<?> basicElement) {
        StdDateElement stdDateElement = (StdDateElement)basicElement;
        return this.chrono == stdDateElement.chrono;
    }

    protected Object readResolve() throws ObjectStreamException {
        String string = this.name();
        for (ChronoElement chronoElement : Chronology.lookup(this.chrono).getRegisteredElements()) {
            if (!chronoElement.name().equals(string)) continue;
            return chronoElement;
        }
        throw new InvalidObjectException(string);
    }

    private static class DayOperator<T extends ChronoEntity<T>>
    implements ChronoOperator<T> {
        private final boolean backwards;

        DayOperator(boolean bl) {
            this.backwards = bl;
        }

        public T apply(T t) {
            long l = (Long)t.get((ChronoElement)EpochDays.UTC);
            l = this.backwards ? --l : ++l;
            return (T)t.with((ChronoElement)EpochDays.UTC, l);
        }
    }
}

